<?php

	class ET_DisplayHelper{
		
		public static $translationsEn = NULL;
		public static $translationsDe = NULL;
		
		public static function addSuccessLine($message, $phpFileName) {
			self::addMessageLine($message, $phpFileName, INFO_TYPE_SUCCESS);
		}
		
		public static function addErrorLine($message, $phpFileName) {

			self::addMessageLine($message, $phpFileName, INFO_TYPE_ERROR);
		}
		
		public static function addWarningLine($message, $phpFileName) {
			self::addMessageLine($message, $phpFileName, INFO_TYPE_WARNING);
		}
		
		protected static function addMessageLine($message, $phpFileName, $type = INFO_TYPE_SUCCESS) {
			if (!isset($_SESSION[$phpFileName])) {
				$_SESSION[$phpFileName] = "";
			}
			$currentMessage = $_SESSION[$phpFileName];
			if ($currentMessage != '') {
				$currentMessage .= "<br>";
			}
			$className = "success";
			if ($type == INFO_TYPE_ERROR)
				$className = "error";
			if ($type == INFO_TYPE_WARNING)
				$className = "warning";
						
			$currentMessage.="<span class=\"$className\">" . $message . "</span>";
			$_SESSION[$phpFileName] = $currentMessage;
		}
		//TODO make it with ET_HTML classes
		public static function printMessageBox($phpFileName, $fromLogin = false) {
			$messages 	= $_SESSION[$phpFileName];
			$here  		= dirname(__FILE__);		
			$src 		= NIOTA_ROOT_DIR . "/" . "etixpert/images/close.png";
			$pageType 	= self::detectPageType($phpFileName);			
			
			if (!empty($messages)) {
					print("<div class=\"textbox\" id='message'>");
					print("<img src=\"$src\" class='float-right pointer'onclick=\"javascript:close_message()\" title=\"" . self::localize("CLOSE", null, $pageType) . "\">");
					print("<div class='margin-top-20px'>" . $messages . "</div>");
					print("</div><br>");
			}			
			$_SESSION[$phpFileName] = "";
		}
				
		public static function localize($phrase, $variables = array(), $pageType = PAGE_TYPE_SYSTEM, $fromLogin = false) {
								
			$user 				= ET_NiotaUser::getNiotaUserFromSession();
			$language			= "";
			$here 				= dirname(__FILE__);
			$localizedPhrase 	= "";
			$translationToUse	= "";
			
			if ($fromLogin) {
				//$language = SYSTEM_LANGUAGE;
				$language = GRID_AREA_LANGUAGE;
			} else {
				if (ET_DisplayHelper::is_blank($user)) {				
					$language = SYSTEM_LANGUAGE;
				}else {
					$gridLanguage 	= $user->getGridLanguage();
					$sysLanguage	= $user->getSystemLanguage();
					$language 		= $pageType == PAGE_TYPE_GRID ? $gridLanguage : $sysLanguage;
				}
			}
		
			//now we have only 2 langugages to choose and 'en' is the default
			//if we have more this block must be changed!							
			if ($language == LANGUAGE_DE) {				
				if (is_null(self::$translationsDe)) {
					$langFileContentDe 		= self::redLanguageFile(LANGUAGE_DE);
					self::$translationsDe 	= self::json_clean_decode($langFileContentDe, true);
				} else {					
					//file is already loaded
				}
				$translationToUse = self::$translationsDe;									
			} else {			
				if (is_null(self::$translationsEn)) {			
					$langFileContentEn 		= self::redLanguageFile(LANGUAGE_EN);											
					self::$translationsEn 	= self::json_clean_decode($langFileContentEn, true);
				} else {
					//file is already loaded			
				}
				$translationToUse = self::$translationsEn;				
			}			
			return self::findPhrase($phrase, $variables, $translationToUse);			
		}
		
		protected static function findPhrase ($phrase, $variables, $translations) {
			
			//here we check variables
			if (!isset($translations[$phrase]))
				return $phrase;
				
			$localizedPhrase = $translations[$phrase];
			$count = 0;
			$pos = 0;
			$pattern = '/\{\d\}/';
			
			while(strpos($localizedPhrase, "{", $pos) !== false && $count < 10){
				$firstBracket = strpos($localizedPhrase, "{");
				$pos = $firstBracket;
				$value = substr($localizedPhrase, $firstBracket, 3);
				
				if(preg_match($pattern, $value)){
					
					$index = intval(substr($value, 1, 1));
					
					if ($index < count($variables)) {
						$variableToReplace = "";
						
						if(is_array($variables[$index])){
							
							for($i = 0; $i < count($variables[$index]); $i++){
								$variableToReplace .= $variables[$index][$i] . " ";
							}
						}else{
							$variableToReplace = $variables[$index];
						}
						
						$pos += strlen($variableToReplace);
						$localizedPhrase = str_replace($value, $variableToReplace, $localizedPhrase);
					}
				}
				$count ++;
			}
			return $localizedPhrase;				
		}
		
		protected static function redLanguageFile ($lang) {
			$langFile 			= ET_PathHelper::getAbsolutePath("/etixpert/lang") . $lang .".txt";
			return  file_get_contents($langFile);
		}
		
		public static function getCatalogPattern($user) {
			$userSettings = $user->get_userSettings();
			if (isset($userSettings[USER_PARAM_CATALOG_DISPLAY_TEXT_PATTERN]))
				return $userSettings[USER_PARAM_CATALOG_DISPLAY_TEXT_PATTERN];
			return DEFAULT_CATALOG_DISPLAY_TEXT_PATTERN;
					
		}
		
		public static function getCatalogItemDisplayText($catalogArray, $pattern) {
			$catalogId 			= $catalogArray['catalog_id'];
			$instanceName		= $catalogArray['instance_name'];
			$instanceDescr		= $catalogArray['instance_descr'];
			$connName		 	= $catalogArray['conn_name'];
			$connNameDisplay 	= $catalogArray['conn_name_display'];
			$object				= $catalogArray['object']; 
			$description		= $catalogArray['description'];
			$objectCategory		= $catalogArray['objectcategory'];
			
			//	%cat_id% 			: catalog id
			//	%inst_name% 		: instance name
			//	%conn_name% 		: connection name
			//	%conn_disp_name% 	: connection display name
			//  %obj%				: the catalog object name (table or view name)
			//	%desc%				: description (not recommended, can be too long)
			//  %obj_cat%			: object category
			//TODO ---------------
			// 	%inst_desc			: instance description
			
			$ret = $pattern;
			$pattern = str_replace('%cat_id%', 			$catalogId, $pattern);
			$pattern = str_replace('%inst_name%', 		$instanceName, $pattern);
			$pattern = str_replace('%inst_descr%', 		$instanceDescr, $pattern);
			$pattern = str_replace('%conn_name%', 		$connName, $pattern);
			$pattern = str_replace('%conn_disp_name%', 	$connNameDisplay, $pattern);
			$pattern = str_replace('%obj%', 			$object, $pattern);
			$pattern = str_replace('%desc%',			$description, $pattern);
			$pattern = str_replace('%obj_cat%',			$objectCategory, $pattern);
		
			return $pattern;
		}
		
		protected static function json_clean_decode($json, $assoc = false, $depth = 512, $options = 0) {
			// search and remove comments like /* */ and //
			$json = preg_replace("#(/\*([^*]|[\r\n]|(\*+([^*/]|[\r\n])))*\*+/)|([\s\t]//.*)|(^//.*)#", '', $json);
		
			if(version_compare(phpversion(), '5.4.0', '>=')) {
				$json = json_decode($json, $assoc, $depth, $options);
			}
			elseif(version_compare(phpversion(), '5.3.0', '>=')) {
				$json = json_decode($json, $assoc, $depth);
			}
			else {
				$json = json_decode($json, $assoc);
			}
		
			return $json;
		}
		
		
		public static function printAccessibleMenuItems($userRights, $gridName, $isThereAnyCallableObjects, $userSettings, $isThereAnyFilterMappings, $filteringInstanceId,
				$useAdvancedFiltering = false, $selectionTable = false, $isThereAnyLookups, $isThereAnyConstraints, $filterMappings) {						
					
					$inputSaveDefaultInstance 	= new HTMLInput();
					$formSaveDefaultInstance 	= new HTMLForm();
					$inputHiddenSaveDeafult 	= new HTMLInput();						
						
					$resultStr 			= "";
					$defaultCatalogSet 	= isset($userSettings[USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID]);
						
					$popupCoordinates 		= "";
					$importPopupHeaderTitle = "";
					$importPopupLabelTitle 	= "";
										
					$inputSaveDefaultInstance->set_type("image")->set_src("images/save_path.png")->set_alt("submit")->set_title(self::localize("SAVE_CURRENT_TABLE_AS_DEFAULT", null, PAGE_TYPE_GRID))->set_onclick("javascript: this.form.submit");
					$formSaveDefaultInstance->set_action("niota.php")->set_method("post")->set_name("form_default_instance");
					$inputHiddenSaveDeafult->set_name("save_default_catalog_instance")->set_value(USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID)->set_type("hidden");
						
					if ($userRights['allow_import']) {
												
						if (isset($userSettings[USER_PARAM_POPUP_POSITION_UPLOAD])) {
							$popupCoordinates = $userSettings[USER_PARAM_POPUP_POSITION_UPLOAD];					
						}
						
						$imgImport =  self::setExcelImportIconParams(EXCEL_UPLOAD_REPLACE, $popupCoordinates);
						$imgImport->printOpeningTag();
						$imgImport->printClosingTag();
		
					}
					
					if ($userRights['allow_import_partial']) {
						
						if (isset($userSettings[USER_PARAM_POPUP_POSITION_UPLOAD])) {
							$popupCoordinates = $userSettings[USER_PARAM_POPUP_POSITION_UPLOAD];
						}
						
						$imgImport = self::setExcelImportIconParams(EXCEL_UPLOAD_REPLACE_PARTIAL, $popupCoordinates);
						$imgImport->printOpeningTag();
						$imgImport->printClosingTag();
					}
					
					if ($userRights['allow_export']) {
						$aExport 	= new HTMLa();
						$imgExport 	= new HTMLImage();
						
						$aExport->set_href("#");
						$aExport->set_onclick("javascript:window.location=export_excel(\"$gridName\")");
						$imgExport->set_src('images/export.png')->set_title(self::localize("EXPORT_TABLE", null, PAGE_TYPE_GRID))->set_style("margin-top: 10px");
		
						$aExport->printOpeningTag();
						$imgExport->printOpeningTag();
						$aExport->printClosingTag();
					}
					
					if ($isThereAnyCallableObjects) {
					
						self::printCallableObjecstMenuItem($userSettings);						
					}
						
					if (!$useAdvancedFiltering) {
						$formSaveDefaultInstance->printOpeningTag();
						$inputHiddenSaveDeafult->printOpeningTag();
						$inputSaveDefaultInstance->printOpeningTag();
						$formSaveDefaultInstance->printClosingTag();
					}
						
					if ($defaultCatalogSet && !$useAdvancedFiltering) {
						$metadataConnector 			= ET_MetaDataConnector::getInstance();
						$defaultCatalogInstanceId 	= $userSettings[USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID];
						$tmpArr 					= explode(".", $defaultCatalogInstanceId);
						$catalogInstanceInfo 		= $metadataConnector->getCatalogInstanceInfo($tmpArr[0], $tmpArr[1]);
						$defObjectInstanceName			= $catalogInstanceInfo['object'] . "." . $tmpArr[1];
		
						$inputResetDefaultTable 	= new HTMLInput();
						$inputHiddenResetDeafult	= new HTMLInput();
						$formResetDefaultInstance 	= new HTMLForm();
		
						$inputResetDefaultTable->set_type("image")->set_src("images/reset_path.png")->set_alt("submit")->set_title(self::localize("RESET_DEFAULT_TABLE", array($defObjectInstanceName), PAGE_TYPE_GRID))->set_onclick("javascript: this.form.submit");
						$formResetDefaultInstance->set_action("niota.php")->set_method("post")->set_name("form_default_instance");
						$inputHiddenResetDeafult->set_name("reset_default_catalog_instance")->set_value(USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID)->set_type("hidden");
		
						$formResetDefaultInstance->printOpeningTag();
						$inputResetDefaultTable->printOpeningTag();
						$inputHiddenResetDeafult->printOpeningTag();
						$formResetDefaultInstance->printClosingTag();
					}
						
					if ($isThereAnyFilterMappings && !$selectionTable) {
						
						$logicalLinkPrev = "";
						
						for ($i = 0; $i < count($filterMappings); $i++) {
							
							//$filteringInstanceId = $filterMappings[$i]['catalog_id_master'] . "." . $filterMappings[$i]['instance_name_master'];
							
							$actSetting = $filterMappings[$i];
							
							if ($logicalLinkPrev == $actSetting['logical_link']) {
								continue;
							} else {
								$logicalLinkPrev = $actSetting['logical_link'];
							}
							
							$filteringInstanceId = $actSetting['catalog_id_master'] . "." . $actSetting['instance_name_master'];
							
							$inputShowAdvancedFilter 		= new HTMLInput();
							$formShowAdvancedFilter 		= new HTMLForm();
							$inputHiddenShowAdvancedFilter 	= new HTMLInput();
							$inputHiddenSelectedInstance 	= new HTMLInput();
							$inputHiddenLogicalLink		 	= new HTMLInput();
							
							$icon							= self::is_blank($actSetting['icon']) ? "search.png" : $actSetting['icon'];
							$iconPath						= "";
							$tooltip						= self::is_blank($actSetting['description']) ? $actSetting['logical_link'] : $actSetting['description'];
								
							$tmp = "";
							
							if (isset( $_SESSION[SESS_CLIENT_FOLDER_PATH])) {
								$tmp = $_SESSION[SESS_CLIENT_FOLDER_PATH] . "/formattings/images/$icon";
							}			
							
							if (!self::is_blank($actSetting['icon']) && file_exists($tmp)) {								
								$iconPath = ET_PathHelper::getCustomerImagePathForHTMLSource($icon);
							} else {
								$iconPath = ET_PathHelper::getSystemImagePathForHTMLSource($icon);
							}							
							
							$inputShowAdvancedFilter->set_type("image")->set_src($iconPath)->set_alt("submit")->set_title($tooltip)->set_onclick("javascript: this.form.submit");
							$formShowAdvancedFilter->set_action("niota.php")->set_method("post")->set_name("form_advanced_filter");
							$inputHiddenShowAdvancedFilter->set_name("popup_filter")->set_value("yes")->set_type("hidden");
							
							//we have to introduce the 'filter_instance' property becaue of transaction settings.
							$inputHiddenSelectedInstance->set_name("filter_instance")->set_value($filteringInstanceId)->set_type("hidden");
							$inputHiddenLogicalLink->set_name("logical_link")->set_value($actSetting['logical_link'])->set_type("hidden");
							
							$formShowAdvancedFilter->printOpeningTag();
							$inputShowAdvancedFilter->printOpeningTag();
							$inputHiddenShowAdvancedFilter->printOpeningTag();
							$inputHiddenSelectedInstance->printOpeningTag();
							$inputHiddenLogicalLink->printOpeningTag();
							$formShowAdvancedFilter->printClosingTag();
							
						}
						
					}
					if (!empty($isThereAnyLookups) || !empty($isThereAnyConstraints)) {
						
						
						$imgCheck 	= new HTMLImage();
						//TODO: set translated title
						$imgCheck->set_src("images/grid_validation.png")
								->set_onclick("handleGridValidation(\"" . ET_PathHelper::getRelativePath("etixpert/images") . "\")")
								->set_title("run grid validation")
								->set_style("margin-top: 10px")
								->set_width("48px")
								->set_class("pointer");
						$imgCheck->printOpeningTag();
					} else {
						//do nothing
					}		
					
					
		}
		
		private static function setExcelImportIconParams ($importType, $popupCoordinates) {
			
			$imgImport 				= new HTMLImage();
			$imgSrc 				= "";
			$imgTitle				= "";
			$importPopupHeaderTitle = "";
			$importPopupLabelTitle 	= "";			
			$detailsByType 			= array();			
			
			if ($importType == EXCEL_UPLOAD_REPLACE) {
				
				$importPopupHeaderTitle = self::localize("EXCEL_IMPORT_HEADER", ["upload"], PAGE_TYPE_GRID);
				$importPopupLabelTitle 	= "&nbsp;" . self::localize("CLICK_HERE_TO_IMPORT", null, PAGE_TYPE_GRID);				
				
				$imgSrc = 'images/import.png';				
				$imgTitle = self::localize('IMPORT_DATA', null, PAGE_TYPE_GRID);
				
				//$hiddenIntputForUploadType->set_value("30");				
			} elseif ($importType == EXCEL_UPLOAD_REPLACE_PARTIAL) {
				
				$importPopupHeaderTitle = self::localize("EXCEL_IMPORT_HEADER_PARTIAL", null, PAGE_TYPE_GRID);
				$importPopupLabelTitle 	= "&nbsp;" . self::localize("EXCEL_CLICK_HERE_TO_IMPORT_PARTIAL", null, PAGE_TYPE_GRID);
				
				$imgSrc = 'images/excel_import_partial.png';
				$imgTitle = self::localize('IMPORT_DATA_PARTIAL', null, PAGE_TYPE_GRID);
				
				//$hiddenIntputForUploadType->set_value("40");				
			} else if ($importType == EXCEL_UPLOAD_UPDATE) {
				
				$importPopupHeaderTitle = self::localize("EXCEL_UPDATE_HEADER", null, PAGE_TYPE_GRID);
				$importPopupLabelTitle 	= "&nbsp;" . self::localize("EXCEL_CLICK_HERE_TO_UPDATE", null, PAGE_TYPE_GRID);
				
				$imgSrc 				= 'images/excel_update.png';
				$imgTitle				= $importPopupHeaderTitle;
				
				//$hiddenIntputForUploadType->set_value("50");
			}
			
			//$hiddenIntputStr = $hiddenIntputForUploadType->printOpeningTag(true);
			$detailsByType = ["headerTitle" => $importPopupHeaderTitle, "labelTitle" => $importPopupLabelTitle];
			$imgImport->set_src($imgSrc)
						->set_onclick("javascript:display_menu_features(\"upload\", \"$popupCoordinates\", \"$importType\"," . json_encode($detailsByType) . ")")
						->set_title($imgTitle)
						->set_class("pointer");
			
			return $imgImport;
		}
		
		public static function printCallableObjecstMenuItem ($userSettings) {
			
			$imgCO 				= new HTMLImage();
			$popupCoordinates 	= "";
			
			if (isset($userSettings[USER_PARAM_POPUP_POSITION_CALLABLES])) {
				$popupCoordinates = $userSettings[USER_PARAM_POPUP_POSITION_CALLABLES];
			}
			
			$imgCO->set_src(NIOTA_ROOT_DIR . '/etixpert/images/display_sp.png')->set_title(self::localize("CALLABLE_OBJECTS", null, PAGE_TYPE_GRID))->set_class("pointer")->set_onclick("display_menu_features(\"callables\", \"$popupCoordinates\")");
			$imgCO->printOpeningTag();
		}
		
		public static function printExcelImportPopup($userRights) {		
			
			$allowImport 		= $userRights['allow_import'];
			$allowImportPartial	= $userRights['allow_import_partial'];
			$popupWindow 		= new ET_PopupWindow();
			
			$popupWindow->setDivImport(["class" => "import-conatiner",	
											"id" => "upload"
											]);
		
			$popupWindow->setFormUpload(["action" => "excel_import_status.php",
										"id" => "form_excel_upload",
										"enctype" => "multipart/form-data",
										"method" => "post",
										"onsubmit" => "return checkFileUpload(\"upload\");"						
									]);
			$popupWindow->setInputUpload(["type" => "file",
										"name" => "file_path",
										"accept" => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel",
										"id" => "test",
										"class"=> "margin-bottom-10px"
										]);
			$popupWindow->setInputHidden(["type" => "hidden",
											"name" => "import_xlsx",
											"value" => "30"
											]);
			$popupWindow->setInputHiddenEditable(["id" => "hidden_editable",
												"type" => "hidden",
												"name" => "import_type",
												"value" => "must_be_filled"
												]);
			$popupWindow->setInputImage(["type" => "image",
										"id" => "import_id",
										"src" => "images/excel_import.png"
										]);
			$popupWindow->setLabelImport(["for" => "import_id",
										"id" => "import_data_text",
										"class" => "pointer"
										]);
			$popupWindow->setSpanForLabel(["class" => "bold",
					"display_text" =>  self::localize("CLICK_HERE_TO_IMPORT", null, PAGE_TYPE_GRID)
											]);
			$popupWindow->setPopupHeader("upload_header", ET_DisplayHelper::localize("EXCEL_IMPORT_HEADER", null, PAGE_TYPE_GRID), "upload");
				
			if ($allowImportPartial) {
				$popupWindow->setFormUpload(["onsubmit" => "return checkFileUpload(\"upload-partial\");"]);
				$popupWindow->setInputHiddenEditable(["value" => "upload-partial"]);
				$popupWindow->setInputImage(["src" => "images/import_partial.png"]);
				$popupWindow->setSpanForLabel(["display_text" =>  self::localize("EXCEL_CLICK_HERE_TO_IMPORT_PARTIAL", null, PAGE_TYPE_GRID)]);
			}
			
			$popupWindow->printPopupWindow();
		}
	
		public static function printCallableObjectPopup($callableObjectsTable, $callableObjectsLine,  $optionKey = "", $fileName = ""){
			
			$divCallable 		= new HTMLDiv();			
			$divCallable->set_class("import-conatiner")->set_id("callables");
			$header				= new ET_PopupHeader("callables_header", self::localize("CALLABLE_OBJECTS", null, PAGE_TYPE_GRID), "callables");
			
			$divCallable->printOpeningTag();
				$header->printHeader();
				ET_PrintCallables::printCallableObjectTables($callableObjectsTable, $callableObjectsLine, $optionKey, $fileName);
			$divCallable->printClosingTag();
			
		}
		
		public static function printFileUploadAndProcessPopup() {
						
					
				$popupWindow = new ET_PopupWindow();
				
				$popupWindow->setDivImport(["class" => "import-conatiner",
						"id" => "uploadandruncallable"
				]);
				$popupWindow->setFormUpload(["action" => "",
						"id" => "form_upload_usual",
						"enctype" => "multipart/form-data",
						"method" => "post"
						/*"onsubmit" => "handleCOFileProcess()"*/
				]);
				$popupWindow->setInputUpload(["type" => "file",
						"name" => "file_path",
						"id"	=> "test_file_upload",
						"class"	=> "margin-bottom-10px"
				]);
				$popupWindow->setInputHiddenEditable(["type" => "hidden",
						"name" => "callable_to_pass",
						"id" => "callable_to_pass",
						"value" => ""
				]);
				$popupWindow->setInputHidden(["type" => "hidden",
						"name" => "upload_and_process",
						"value" => "yes"
				]);
				
				$popupWindow->setImageForUploadOnclick([
						"src" => "images/excel_import.png",
						"onclick" => "handleCOFileProcess()",
						"class" => "pointer"
				]);
				
				$popupWindow->setSpanForLabel([ "class" => "bold pointer",
						"display_text" => "&nbsp;" . self::localize("CLICK_HERE_TO_UPLOAD", null, PAGE_TYPE_GRID),
						"onclick" => "handleCOFileProcess()"
				]);
				$popupWindow->setPopupHeader("upload_header", "upload and process file", "uploadandruncallable");
				$popupWindow->printPopupWindow();
				
				$_SESSION[SESS_UPLOAD_POPUP_PRINTED] = true;
			
		}
	
		public static function printtCallableObjectFeedbackWindow() {
			
			$divDynamicMenuFeedback 		= new HTMLDiv();
			$divDynamicMenuFeedbackHeader	= new HTMLDiv();
			$divDynamicMenuFeedbackContent 	= new HTMLDiv();
			$imgDynamicMenuClose			= new HTMLImage();
			
			$divDynamicMenuFeedback->set_class("modal")->set_id("dynamic_menu_feedback");
			$divDynamicMenuFeedbackHeader->set_id("dynamic_menu_feedback_header");
			$divDynamicMenuFeedbackContent->set_id("dynamic_menu_feedback_content");
			$imgDynamicMenuClose->set_src(NIOTA_ROOT_DIR . "/etixpert/images/close.png")->set_onclick("closeDefault(\"dynamic_menu_feedback\")")->set_class("pointer float-right");
			
			$divDynamicMenuFeedback->printOpeningTag();
				$imgDynamicMenuClose->printOpeningTag();
				$divDynamicMenuFeedbackHeader->printOpeningTag();
				$divDynamicMenuFeedbackHeader->printClosingTag();
				$divDynamicMenuFeedbackContent->printOpeningTag();
				$divDynamicMenuFeedbackContent->printClosingTag();
			$divDynamicMenuFeedback->printClosingTag();
			
		}
		
		public static function printPersonalModal ($firstname, $lastname, $email, $phone, $fromAdminPage, $currentFileName, $targetMenuItem, $languageSetting) {
			
			$divModalMain		= new HTMLDiv();
			$divContent 		= new HTMLDiv();
			$divHeader			= new HTMLDiv();
			$divUserData 		= new HTMLDiv();
			$divPassword 		= new HTMLDiv();
			$divFeedbackPw		= new HTMLDiv();
			$divFeedbackPers	= new HTMLDiv();
			$imgClose			= new HTMLImage();
			$imgPersonal		= new HTMLImage();
			$spanHeader			= new HTMLSpan();
			
			$formUserData		= new HTMLForm();
			$inputFirstname 	= new HTMLInput();
			$inputLastName 		= new HTMLInput();
			$inputEmail 		= new HTMLInput();
			$inputPhone 		= new HTMLInput();
			$imgSavePersonal	= new HTMLImage();
			$spanFirstName		= new HTMLSpan();
			$spanLastName		= new HTMLSpan();
			$spanEmail			= new HTMLSpan();
			$spanPhone			= new HTMLSpan();
			
			$formPassword		= new HTMLForm();
			$inputPassword	 	= new HTMLInput();
			$inputPasswordNew 	= new HTMLInput();
			$inputPasswordNewRe = new HTMLInput();
			$imgShowPssword		= new HTMLImage();
			$imgSavePassword	= new HTMLImage();
			$spanPassword		= new HTMLSpan();
			$spanPasswordNew	= new HTMLSpan();
			$spanPasswordNewRe	= new HTMLSpan();
			
			$formBlank			= new HTMLForm();
			$inputBlank	 		= new HTMLInput();
			
			$aShowHidePasswd	= new HTMLa();
			$imgLock 			= new HTMLImage();
			
			//TODO - find new place of select generating functions			
			$spanLanguage		= new HTMLSpan();
			$divLanguage		= new HTMLDiv();
			$selectLanguage		= new HTMLSelect();
			$selectLanguage->set_name("lang_grid")->set_id("lang_grid");
			$selectLanguage->set_class("margin-left-20px margin-bottom-10px bgcolor-white")->set_style("width:8em");
			
			$languageSelectData	= self::generateLanguageSelectData($languageSetting);
			
			$pageType = self::detectPageType($fromAdminPage);			
			$spanLanguage->set_display_text(ET_DisplayHelper::localize("SELECT_LANGUAGE", null, $pageType) . ": ");			
			$personalPostDataJSCall = $fromAdminPage ? "personal_post(true, true, \"$currentFileName\")" : "personal_post(true, false, \"$currentFileName\")";
			$personalPostPwJSCall 	= $fromAdminPage ? "personal_post(false, true, \"$currentFileName\")" : "personal_post(false, false, \"$currentFileName\")";
			$formBlankAction 		= $currentFileName . ".php";
			$imgLockTitle			= self::localize("PERSONAL_SHOW_PW", null, $pageType);
			$operationKey 			= isset($_GET["ok"]) ? $_GET["ok"] : "";
			$targetMenuItem			= isset($_GET["target"]) ? $_GET["target"] : "";			
			
			if (!empty($operationKey)) {
				if (!empty($targetMenuItem))
					$formBlankAction .= "?target=$targetMenuItem" . "&ok=$operationKey";
				else 
					$formBlankAction .= "?ok=$operationKey";
			}
			
			$divModalMain->set_class("modal_personal")->set_id("modal_main");
			$divContent->set_class("modal_personal_content");
			$divHeader->set_class("modal_personal_header");
			$divUserData->set_class("modal_personal_form_wrapper");
			$divPassword->set_class("modal_personal_form_wrapper");
			$divFeedbackPers->set_id("personal_feedback_pers_container")->set_class("margin-left-20px");
			$divFeedbackPw->set_id("personal_feedback_pw_container")->set_class("margin-left-20px");
			
			$imgClose->set_class("float-right pointer")->set_onclick("closeDefault(\"modal_main\")")->set_src(NIOTA_ROOT_DIR. '/etixpert/images/close.png')->set_title(self::localize("CLOSE", null, $pageType));
			$imgPersonal->set_src(NIOTA_ROOT_DIR . '/etixpert/images/s/user.png')->set_class("element-inline");
			$spanHeader->set_display_text(self::localize("MANAGE_PERSONAL", null, $pageType))->set_class("font-l bold");
			
			$formUserData->set_name("update_userdata")->set_action("niota.php")->set_method("post");
			$inputFirstname->set_type("text")->set_name(POST_PERSONAL_FIRSTNAME)->set_value($firstname)->set_id("firstname");
			$inputLastName->set_type("text")->set_name(POST_PERSONAL_LASTNAME)->set_value($lastname)->set_id("lastname");
			$inputEmail->set_type("text")->set_name(POST_PERSONAL_EMAIL)->set_value($email)->set_id("email");
			$inputPhone->set_type("text")->set_name(POST_PERSONAL_PHONE)->set_value($phone)->set_id("phone");
			$spanFirstName->set_display_text(self::localize("FIRSTNAME", null, $pageType));
			$spanLastName->set_display_text(self::localize("LASTNAME", null, $pageType));
			$spanEmail->set_display_text(self::localize("EMAIL", null, $pageType));
			$spanPhone->set_display_text(self::localize("PHONE", null, $pageType));
			
			$imgSavePersonal->set_src(NIOTA_ROOT_DIR . '/etixpert/images/save.png')->set_onclick($personalPostDataJSCall)->set_title(self::localize("PERSONAL_SAVE_DATA", null, $pageType))->set_class("pointer");
			
			$formPassword->set_name("update_password")->set_action("niota.php")->set_method("post");
			$inputPassword->set_type("password")->set_name(POST_PERSONAL_PASSWORD)->set_id("password");
			$inputPasswordNew->set_type("password")->set_name(POST_PERSONAL_PASSWORD_NEW)->set_id("password_new");
			$inputPasswordNewRe->set_type("password")->set_name(POST_PERSONAL_PASSWORD_NEW_RE)->set_id("password_new_re");
			$spanPassword->set_display_text(self::localize("PASSWORD_PERSONAL", null, $pageType));
			$spanPasswordNew->set_display_text(self::localize("NEW_PASSWORD", null, $pageType));
			$spanPasswordNewRe->set_display_text(self::localize("NEW_PASSWORD_RE", null, $pageType));
			
			$imgSavePassword->set_src(NIOTA_ROOT_DIR . '/etixpert/images/save.png')->set_onclick($personalPostPwJSCall)->set_title(self::localize("PERSONAL_SAVE_PW", null, $pageType))->set_class("pointer");
				
			$formBlank->set_name("personal_blank")->set_method("post")->set_action($formBlankAction)->set_id("personal_blank");
			$inputBlank->set_type("hidden")->set_name("personal_blank_hidden")->set_value("yes");
		
			$aShowHidePasswd->set_href("#")->set_onclick("toggle_password(" . json_encode($fromAdminPage) . ", \"$imgLockTitle\")")->set_id("showhidepasswd")->set_status("hidden");
			$imgLock->set_src(NIOTA_ROOT_DIR . '/etixpert/images/open_lock.png')->set_title($imgLockTitle);
			
			$divModalMain->printOpeningTag();
				$divContent->printOpeningTag();
					$divHeader->printOpeningTag();
						$imgClose->printOpeningTag();
						$spanHeader->printOpeningTag();
						$spanHeader->printDisplayText();
						$spanHeader->printClosingTag();
					$divHeader->printClosingTag();
					$divUserData->printOpeningTag();
						$formUserData->printOpeningTag();
							$spanFirstName->printOpeningTag();$spanFirstName->printDisplayText();$spanFirstName->printClosingTag();$spanFirstName->printBr();
							$inputFirstname->printOpeningTag();
							$inputFirstname->printBr();
							$spanLastName->printOpeningTag();$spanLastName->printDisplayText();$spanLastName->printClosingTag();$spanFirstName->printBr();
							$inputLastName->printOpeningTag();
							$inputLastName->printBr();
							$spanEmail->printOpeningTag();$spanEmail->printDisplayText();$spanEmail->printClosingTag();$spanFirstName->printBr();
							$inputEmail->printOpeningTag();
							$inputEmail->printBr();
							$spanPhone->printOpeningTag();$spanPhone->printDisplayText();$spanPhone->printClosingTag();$spanFirstName->printBr();
							$inputPhone->printOpeningTag();
							$inputPhone->printBr();
							//TODO - here comes the language select
							$spanLanguage->printOpeningTag();$spanLanguage->printDisplayText();$spanLanguage->printClosingTag();
							//$divLanguage->printOpeningTag();
							$selectLanguage->generateWholeSelect($languageSelectData);
							//$divLanguage->printClosingTag();
							$imgPersonal->printBr();
							$imgSavePersonal->printOpeningTag();
						$formUserData->printClosingTag();
						$divFeedbackPers->printOpeningTag();$divFeedbackPers->printClosingTag();
					$divUserData->printClosingTag();
					$divPassword->printOpeningTag();
						$formPassword->printOpeningTag();
							$spanPassword->printOpeningTag();$spanPassword->printDisplayText();$spanPassword->printClosingTag();
							$aShowHidePasswd->printOpeningTag();$imgLock->printOpeningTag();$aShowHidePasswd->printClosingTag();
							$inputPassword->printOpeningTag();
							$inputPassword->printBr();
							$spanPasswordNew->printOpeningTag();$spanPasswordNew->printDisplayText();$spanPasswordNew->printClosingTag();$spanPasswordNew->printBr();
							$inputPasswordNew->printOpeningTag();
							$inputPasswordNew->printBr();
							$spanPasswordNewRe->printOpeningTag();$spanPasswordNewRe->printDisplayText();$spanPasswordNewRe->printClosingTag();$spanPasswordNewRe->printBr();
							$inputPasswordNewRe->printOpeningTag();
							$inputPasswordNewRe->printBr();
							$imgSavePassword->printOpeningTag();
						$formPassword->printClosingTag();
						$divFeedbackPw->printOpeningTag();$divFeedbackPw->printClosingTag();
					$divPassword->printClosingTag();
				$divContent->printClosingTag();
				$formBlank->printOpeningTag();
					$inputBlank->printOpeningTag();
				$formBlank->printClosingTag();
			$divModalMain->printClosingTag();
		}
			
		public static function generateNiotaStyleSheet(){
			
			$light 		 = "";
			$mid 		 = "";
			$deep		 = "";
			$deepRgba	 = "";
			$here 		 = (dirname(__FILE__));
			$fileName 	 = "";
			$fileContent = null;
			
			
			foreach (THEME_SETTINGS as $key => $val){
				if ($key == COLOR_THEME || $key == COLOR_THEME_ADMIN) {
					$light 				= THEME_SETTINGS[$key]['light'];
					$mid 				= THEME_SETTINGS[$key]['mid'];
					$deep 				= THEME_SETTINGS[$key]['deep'];
					$deepRgba 			= THEME_SETTINGS[$key]['deepRgba'];
					$lightRgba 			= THEME_SETTINGS[$key]['lightRgba'];
					$gridBackground 	= THEME_SETTINGS[$key]['gridBackground'];
					$loginBackground	= THEME_SETTINGS[$key]['loginBackground'];
					$registerBackground	= THEME_SETTINGS[$key]['registerBackground'];
					$adminBackground	= THEME_SETTINGS[$key]['adminBackground'];
					$fileName 			= THEME_SETTINGS[$key]['fileName'];
						
					//backgroundGridPath
					$fileContent = file_get_contents("$here/../css/" . ROOT_CSS_FILE_NAME);
					$fileContent = str_replace("||light||", " " . $light, $fileContent);
					$fileContent = str_replace("||mid||", " " . $mid, $fileContent);
					$fileContent = str_replace("||deep||", " " . $deep, $fileContent);
					$fileContent = str_replace("||deep_rgba||", " " . $deepRgba, $fileContent);
					$fileContent = str_replace("||light_rgba||", " " . $lightRgba, $fileContent);
					$fileContent = str_replace("||gridBackgroundPath||", self::getBackgroundImagePath($gridBackground), $fileContent);
					$fileContent = str_replace("||loginBackgroundPath||", self::getBackgroundImagePath($loginBackground), $fileContent);
					$fileContent = str_replace("||registerBackgroundPath||", self::getBackgroundImagePath($registerBackground), $fileContent);
					$fileContent = str_replace("||adminBackgroundPath||", self::getBackgroundImagePath($adminBackground), $fileContent);
					
					file_put_contents("$here/../css/$fileName", $fileContent);
					
				}
			}
			
		}
		
		protected static function generateLanguageSelectData($languageSetting) {
			
			$ret 			= array();
			$languageValues = ET_MetaDataConnector::getInstance()->getLanguageOptions();
			
			//array(["name"=>"en", "value=>en", "displayText"=>"en"], ["name"=>"de", "value=>de", "displayText"=>"de"]
			$selected 		= false;
			
			for ($i = 0; $i < count($languageValues); $i++) {
				
				$row = $languageValues[$i];
				foreach ($row as $key => $val) {					
					//echo $key . ": $val<br>";
					$ret[$i] = ["name" => $key,
							"value" =>  $key,
							"displayText" =>  $val
							
					];
					
					if ($key == $languageSetting)
						$ret[$i]["selected"] = "selected";
				}
			}
			
			return $ret;
			
		}		
		
		protected static function getBackgroundImagePath ($fileName) {
			
			$here 			= (dirname(__FILE__));	
			$customerPath 	= ET_PathHelper::getClientConfSubFolderAbsolutePath(CLIENT_FOLDER_FORMATTING) . "/images/$fileName";
			
			if (file_exists($customerPath)) {				
				//path has to be relative for the css file!
				$clientFolderName = $_SESSION[SESS_CLIENT_FOLDER_NAME];
				
				return NIOTA_ROOT_DIR_BASE . CLIENT_MAIN_CONF_FOLDER . "/$clientFolderName/formattings/images/" . $fileName;
			} else {
				//use default image
				return 	"../images/$fileName";
			}
		}
		//TODO correct this function:
		public static function getLogoPath ($file) {
			
			$here 		 = (dirname(__FILE__));		
			//$customerPath = "$here/../../conf/formattings/images/" . COMPANY_LOGO;
			$customerPath 		= isset($_SESSION[SESS_CLIENT_FOLDER_PATH]) ? $_SESSION[SESS_CLIENT_FOLDER_PATH] . "/formattings/images/" . COMPANY_LOGO : "";
			$customerFolderName = isset($_SESSION[SESS_CLIENT_FOLDER_NAME]) ? $_SESSION[SESS_CLIENT_FOLDER_NAME] : "";
			
			if ($file == "niota") {
				//return file_exists($customerPath) ? "../../conf/$customerFolderName/formattings/images/" . COMPANY_LOGO : "images/" . COMPANY_LOGO;
				return file_exists($customerPath) ? NIOTA_ROOT_DIR_BASE . CLIENT_MAIN_CONF_FOLDER . "/$customerFolderName/formattings/images/" . COMPANY_LOGO : "images/" . COMPANY_LOGO;
			}			
			else if ($file == "admin_header") {
				return file_exists($customerPath) ? 
						"../../../conf/$customerFolderName/formattings/images/" . COMPANY_LOGO : "../images/" . COMPANY_LOGO;
			}
			else if ($file == "tools.php") {
				return file_exists($customerPath) ? 
						NIOTA_ROOT_DIR_BASE . CLIENT_MAIN_CONF_FOLDER . "/$customerFolderName/formattings/images/" . COMPANY_LOGO : 
						"etixpert/images/" . COMPANY_LOGO;
			}
			
			return false;
		}
		
		public  static function getNiotaColorTheme($loggedIn = true, $admin = false){
			$ret 		= "";
			$hrefStart 	= $admin ? "href=\"../css" : "href=\"css"; 
			$pageType 	= self::detectPageType($admin);
			$styleDef	= "<link rel=\"StyleSheet\" ";
			
			if (defined('COLOR_THEME') && defined(COLOR_THEME)) {
				
				if($loggedIn) {
					
					if ($admin) {
						$styleDef .= $hrefStart;
						
						if (defined('COLOR_THEME_ADMIN') && self::validateGridThemeDef(COLOR_THEME_ADMIN))  {							
							$styleDef .= '/'. constant(COLOR_THEME_ADMIN)  . '"';
						} else {	
							//if admin color theme is wrong we use grid theme
							$styleDef .= '/' . constant(COLOR_THEME) . '"';
							$ret = self::localize("ERROR_COLOR_THEME_WRONG", null, $pageType);
							throw new Exception(self::localize("COLOR_THEME_ADMIN_NOT_DEFINED", null, $pageType));
						}
					} else {	
						
						$styleDef .= $hrefStart;
						if (self::validateGridThemeDef(COLOR_THEME)) {
							$styleDef .= '/'. constant(COLOR_THEME) . '"';
						} else {							
							$styleDef .= '/base"';
						}						
					}				
				} else {
					$styleDef .= "href=\"etixpert/css/" . constant(COLOR_THEME) . '"';					
				}					
			}
			else if (!defined('COLOR_THEME')) {
				if($loggedIn){
					$styleDef .= "$hrefStart/base.css\"";
					$ret = self::localize("ERROR_COLOR_THEME_WRONG", null, $pageType);
				}
				else {
					$styleDef .= 'href="etixpert/css/base.css"';
				}	
			}
			else {
				if($loggedIn) {					
					$styleDef .= "$hrefStart/base.css\"";
				} else {
					$ret = self::localize("ERROR_COLOR_THEME_WRONG_VALUE", array(COLOR_THEME), $pageType);					
					$styleDef .= 'href="etixpert/css/base.css"';
				}					
			} 
			
			print ($styleDef . ' type="text/css" />');
			return $ret;
		}
		
		public  static function getNiotaColorTheme_old($loggedIn = true, $admin = false){
			$ret = "";
			$hrefStart = $admin ? "href=\"../css" : "href=\"css";
			if (defined('COLOR_THEME') && defined(COLOR_THEME)) {
				
				if($loggedIn) {
					if ($admin) {
						if (defined('COLOR_THEME_ADMIN'))
							print("<link rel=\"StyleSheet\" $hrefStart/" . constant(COLOR_THEME_ADMIN) . "\" type=\"text/css\" />");
					}
					else {
						print("<link rel=\"StyleSheet\" $hrefStart/" . constant(COLOR_THEME) . "\" type=\"text/css\" />");
					}
				}
				else
					print("<link rel=\"StyleSheet\" href=\"etixpert/css/" . constant(COLOR_THEME) . "\" type=\"text/css\" />");
			}
			else if (!defined('COLOR_THEME')) {
				if($loggedIn){
					$ret = self::localize("ERROR_COLOR_THEME_WRONG");
					print("<link rel=\"StyleSheet\" $hrefStart/base.css\" type=\"text/css\" />");
				}
				else
					print("<link rel=\"StyleSheet\" href=\"etixpert/css/base.css\" type=\"text/css\" />");
			}
			else {
				if($loggedIn)
					print("<link rel=\"StyleSheet\" $hrefStart/base.css\" type=\"text/css\" />");
					else{
						$ret = self::localize("ERROR_COLOR_THEME_WRONG_VALUE", array(COLOR_THEME));
						print("<link rel=\"StyleSheet\" href=\"etixpert/css/base.css\" type=\"text/css\" />");
					}
					
			}
			return $ret;
		}
		
		public static function printViewModeCorrector($fullTableName){
			
			$correctedFullTableName = str_replace(".", "_", $fullTableName);
			
			echo "	<style>
						#viewmod$correctedFullTableName{
							width:800px !important
						}
					</style>";
			
		}
		
		public static function setAndPrintPinIcon($imgPinSidebar) {
			
			//$imgPinSidebar			= new HTMLImage();
			$imgPinSidebar->set_class("pin")->set_title(ET_DisplayHelper::localize("PINNING_MENU", null, PAGE_TYPE_GRID))->set_id("pin_id");
			
			if (isset($_SESSION[USER_PARAM_MENU_PIN_STATUS])) {
				if ($_SESSION[USER_PARAM_MENU_PIN_STATUS] == "unpinned") {
					$imgPinSidebar->set_src("images/pin.png");
				}
				else if ($_SESSION[USER_PARAM_MENU_PIN_STATUS] == "pinned") {
					$imgPinSidebar->set_src("images/pin_filled.png");
				}
			}
			else {
				$imgPinSidebar->set_src("images/pin.png");
			}
			$imgPinSidebar->printOpeningTag();
		}
		
		public static function loadLoginHelpContent ($register = false, $registerInfo = false) {
			
			//$dirPath			= "conf/formattings/webhelp/";
			$filePathDefault	= "conf/formattings/webhelp/login_help.html";
			$clientFolderPath 	= $_SESSION[SESS_CLIENT] != CLIENT_SYSTEM ? ET_PathHelper::getClientConfSubFolderAbsolutePath("formattings")
			: "conf/formattings/";
			$dirPath			= $clientFolderPath . "webhelp/";
			$fileLoginOrRegisterPart = ($register == true) ? REGISTRATION_HELP :
			( $registerInfo == true ? REGISTRATION_FORM_HELP : "login_help");
			
			
			if (CUSTOM_HELP_FILE_SPLIT_BY_LANGUAGE) {
				
				$filePathLang 		= $dirPath . "$fileLoginOrRegisterPart" . "_" . GRID_AREA_LANGUAGE. ".html";
				
				if (defined('GRID_AREA_LANGUAGE') && file_exists($filePathLang)) {
					echo(file_get_contents($filePathLang));
				}
				else {
					echo ET_DisplayHelper::localize("ERR_LOGIN_HELP_LOAD", array($dirPath));
					echo(file_get_contents($filePathDefault));
				}
				
			}
			elseif (CUSTOM_WEB_DOCS_IN_LANG_FOLDER) {
				$dirPath .= GRID_AREA_LANGUAGE . "/";
				$loginHelpFile = $dirPath . $fileLoginOrRegisterPart . ".html";
				
				if (defined('GRID_AREA_LANGUAGE') && file_exists($loginHelpFile))
					echo(file_get_contents($loginHelpFile));
					else
						echo(file_get_contents($filePathDefault));
			}
			else {
				echo(file_get_contents($filePathDefault));
			}
			
		}
		
		public static function vardumpHighlighPretty ($data) {
			echo highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");
		}
		
		
		public static function setHelpLink($type, $page) {
			
			$pathTmp 	= "";
			$ret 		= "";
						
			if ($type == HELP_ICON_TYPE_ADMIN_SYSTEM || $type == HELP_ICON_TYPE_USER_SYSTEM ) {
				$pathTmp = self::getSystemHelpLinkPath($type);
			} else {
				$pathTmp = self::getCustomHelpLinkPathByType($type);
			}

			if (!empty($pathTmp)) {
				$ret = self::resolvePathSubstitutiontVariables($pathTmp);
			} else {
				return false;
			}

			return $ret;
		}
		
		/***
		 * substitutions:
		 * 			$documentRoot
		 * 			$niotaRoot
		 * 			$customFormatFolder
		 * 			$languageCode
		 * 			$tableName
	 	 * 			$adminPage	--> only for 'HELP_CUSTOM_FILE_ADMIN'
		 * 
		 * @param string $inputStr
		 */
		public static function resolvePathSubstitutiontVariables($inputStr) {
						
			$ret			 	= "";
			$documentRoot 		= self::getDocumentroot();			
			$niotaRootDir		= NIOTA_ROOT_DIR_BASE;
			$userName			= $_SESSION[SESS_USERNAME];
			$installation		= INSTALLATION_NAME;
			$confFolder			= CLIENT_MAIN_CONF_FOLDER;
			$clientFolderName 	= isset($_SESSION[SESS_CLIENT_FOLDER_NAME]) ? $_SESSION[SESS_CLIENT_FOLDER_NAME] : "";
			
			/*
			 * at those cases we have to cut the leading slash to avoid duplicated slahses and link crash
			 * in other code parts we usethe leading "/"
			 * */
			/*
			if (strpos($inputStr, '$documentRoot/$niotaRoot') !== false || strpos($inputStr, '$documentRoot\$niotaRoot') !== false ) {
				$niotaRootDir = substr(NIOTA_ROOT_DIR_BASE, 1);
			}
			*/
			
			$ret = str_replace('$documentRoot', $documentRoot, $inputStr);
			$ret = str_replace('$niotaRoot', $niotaRootDir, $ret);
			$ret = str_replace('$customFormatFolder', CUSTOM_FORMAT_FOLDER, $ret);
			$ret = str_replace('$languageCode', GRID_AREA_LANGUAGE, $ret);
			$ret = str_replace('$userName', $userName, $ret);
			$ret = str_replace('$installation', $installation, $ret);
			$ret = str_replace('$confFolder', $confFolder, $ret);
			$ret = str_replace('$clientFolder', $clientFolderName, $ret);
			
			$ret = self::resolveTableNameInHelpPath($ret);
			$ret = self::resolveAdminPageInHelpPath($ret);
			
			if (strpos($ret, "//") !== false && !ET_StringCheck::startsWith($ret, "http")) {
				$ret = str_replace("//", "/", $ret);
			}
			
			return $ret;
		}
		
		protected static function getCustomHelpLinkPathByType($type) {
			
			$ret  = "";
			
			switch ($type) {
				
				case HELP_ICON_TYPE_ADMIN_CUSTOM:
					$ret = HELP_CUSTOM_FILE_ADMIN;
					break;
				case HELP_ICON_TYPE_USER_CUSTOM:
					$ret = HELP_CUSTOM_FILE_GRID;
					break;
			}
			return $ret;
		}
		
		protected static function getSystemHelpLinkPath($type) {
			
			$ret 		= "";		
			$pathStart 	= '/etixpert/admin/formatting/webhelp/';
			
			if (HELP_SYSTEM_FOLDER_SPLIT_BY_LANGUAGE) {
				$pathStart .= '$languageCode/';
			}
			
			if ($type == HELP_ICON_TYPE_ADMIN_SYSTEM) {
				
				if (ET_PathHelper::getPathMemeberCount(HELP_SYSTEM_FILE_ADMIN) === 1) {
					$ret = ET_PathHelper::getRelativePath($pathStart . HELP_SYSTEM_FILE_ADMIN);
				} else {
					$ret = HELP_SYSTEM_FILE_ADMIN;
				}
				
			} else if ($type == HELP_ICON_TYPE_USER_SYSTEM) {
				
				if (ET_PathHelper::getPathMemeberCount(HELP_SYSTEM_FILE_GRID) === 1) {
					$ret = ET_PathHelper::getRelativePath($pathStart . HELP_SYSTEM_FILE_GRID);
				} else {
					$ret = HELP_SYSTEM_FILE_GRID;
				}
			}  
			return $ret;
		}
			
		private static function isLinkExternal($link) {
			
			if (strpos($link, "https://") === 0 || strpos($link, "http://") === 0) {
				return true;
			} else {
				return false;
			}
		}
		
		public static function getDocumentRoot() {
			
			$documentRoot 	= $_SERVER['DOCUMENT_ROOT'];
			
			$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" :
					"http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
			
			$pos 			= strpos($actual_link, "//");
			$pos2 			= strpos($actual_link, "/", $pos + 2);
			$linkRoot 		= substr($actual_link, 0, $pos2);
			
			return $linkRoot;
		} 
		
		private static function resolveAdminPageInHelpPath($path) {
			
			$adminPage = isset($_GET['ok']) ? $_GET['ok'] : "";
			return str_replace('$adminPage', $adminPage, $path);
			
		}
		
		private static function resolveTableNameInHelpPath($path) {
			
			$tableNameSimple = null;
			
			if (!isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]) || empty($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]))
				$tableNameSimple = "";
			else {
				$catalogInstaceId	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
				$browsingStore		= ET_BrowsingStore::getBrowsingStore();
				$tableName			= $browsingStore->get_fullTableName($catalogInstaceId);
				
				$tableNameSimple 	= ET_CatalogInstance::getTableNameFromFullyQualifiedForm($tableName);
			}			
			return str_replace('$tableName', $tableNameSimple, $path);
		}
			
		public static function validateGridThemeDef($themeDef) {
			
			$validThemes = array();
			$validThemes = GRID_THEME[1];
			
			if (in_array(strtolower($themeDef), $validThemes)) {
				return true; 
			} else {
				return false;
			}
			
		}
		
		public static function generateNotifyStylingJS(){
			
			$here 		 = (dirname(__FILE__));
			$fileContent = null;
			
			if(!file_exists("$here/../js/notify-styling-root.js")){
				self::addErrorLine("Feedback message style file is missing!", "niota");			
				return;
			}
			else {				
				$fileContent = file_get_contents("$here/../js/notify-styling-root.js");
				$fileContent = str_replace("||hide-delay||", FEEDBACK_MSG_DELAY, $fileContent);
			}
						
			file_put_contents("$here/../js/notify-styling.js", $fileContent);			
		}
		
		public static function generateAndPrintTabIconTag($pageName) {
			
			$linkSchortcutIcon		= new HTMLLink();
			if ($pageName == "login") {
				$linkSchortcutIcon->set_href('etixpert/images/te_icon.ico');
			}
			else if ($pageName == "grid") {
				$linkSchortcutIcon->set_href('../etixpert/images/te_icon.ico');
			}
			else if ($pageName == "admin") {
				$linkSchortcutIcon->set_href('../../etixpert/images/te_icon.ico');
			}
			$linkSchortcutIcon->set_rel('shortcut icon');
			$linkSchortcutIcon->printOpeningTag();
		}
		
		public static function is_blank($value) {
			return empty($value) && !is_numeric($value);
		}
		
		/***
		 * Detectes page type for the localize function.
		 * Could not find a better place.
		 * @param unknown $input - can be bool -> $isAdminGrid or string -> niota.php, panel_callable_object.php, ...
		 * @return string - PAGE_TYPE_SYSTEM or PAGE_TYPE_GRID
		 */
		public static function detectPageType ($input) {
			
			$inputType = gettype($input);
			
			switch ($inputType) {
				case "string":
					return (strpos($input, 'niota') !== false ||
					strpos($input, 'register') !== false ||
					strpos($input, 'login') !== false) ? PAGE_TYPE_GRID : PAGE_TYPE_SYSTEM;
					break;
				case "boolean": //boolean input means $isAdminGrid!
					return $input ? PAGE_TYPE_SYSTEM : PAGE_TYPE_GRID;
					break;
				default:
					return PAGE_TYPE_SYSTEM;
			}		
			
		}
		
		public static function createCloseButton($phpFileName, $divIdToClose) {
			
			$closeBtn = new HTMLImage();
			$src 		= NIOTA_ROOT_DIR . "/" . "etixpert/images/close.png";
			$pageType 	= self::detectPageType($phpFileName);
			$closeBtn->set_src($src)->set_class('float-right pointer')->set_onclick("javascript:closeDefault(\"$divIdToClose\")")->set_title(self::localize("CLOSE", null, $pageType));
			return $closeBtn;
		}
		
		public static function printSimpleBox ($phpFileName) {
			
			$divMain			= new HTMLDiv();
			$divContent			= new HTMLDiv();
			$divMainId			= "registration_from_info_main_id";
			//$contentFormInfo 	= self::loadLoginHelpContent(false, true);
			$divMain->set_id($divMainId)->set_class("registration-form-info-main white-space-normal");
			$divContent->set_class("registration-form-info-content");
			$imgClose 			= self::createCloseButton($phpFileName, $divMainId);
			
			$divMain->printOpeningTag();
			$imgClose->printOpeningTag();
			$divContent->printOpeningTag();
			self::loadLoginHelpContent(false, true);
			$divContent->printClosingTag();
			$divMain->printClosingTag();
			
		}
	}
	
	
	
	
	