<?php

class ET_DynamicMenu {
	
	public static function showMenu($dynamicMenu) {		
		$nav				= new HTMLNav();
		$nav->set_id("primary_nav_wrap");
		$ul					= new HTMLUl();
		$li					= new HTMLLi();
		
		$nav->printOpeningTag();
			$ul->printOpeningTag();
				$li->set_id("li_no_bg")->set_title("")->printOpeningTag();
					self::showLevel($dynamicMenu[0]);
				$li->printClosingTag();
			$ul->printClosingTag();	
		$nav->printClosingTag();
	}
	
	protected static function showLevel($menuItem) {		
		
		$ul					= new HTMLUl();	
		$li					= new HTMLLi();
		$a					= new HTMLa();
		$imgIcon 			= null;
		
		//we have to set href property last because explorer always put it as last attribute, while other browsers don't. we check this in callableObjectHandler.php
		$a->set_href("#");
		
		$parentId			= $menuItem->get_parentId();
		$description		= $menuItem->get_description();
		$icon 				= $menuItem->get_icon();
		$children			= $menuItem->get_children();
		$menuLabel			= $menuItem->get_menuLabel();
		$transactionObject 	= $menuItem->get_transaction();
		
		$isParentItem		= is_null($transactionObject) ? true : false;
		$rootMenuItem 		= is_null($parentId);
		
		$clientConfFolderName	= isset($_SESSION[SESS_CLIENT_FOLDER_NAME]) ? $_SESSION[SESS_CLIENT_FOLDER_NAME] : "";
		$clientName 			= isset($_SESSION[SESS_CLIENT]) ? $_SESSION[SESS_CLIENT] : CLIENT_SYSTEM;
		
		if ($clientName == CLIENT_SYSTEM) {				
			$iconPath =  NIOTA_ROOT_DIR . "/conf/formattings/images/$icon";
		} else {
			$iconPath = NIOTA_ROOT_DIR_BASE . CLIENT_MAIN_CONF_FOLDER . "/$clientConfFolderName/formattings/images/$icon";			
		}
		
		$iconPath = str_replace('\\', '/', $iconPath);
		
		if ($isParentItem && empty($children))
			return;
		
		if ($rootMenuItem)
			$menuLabel 	= null;
		 			
		if(!(is_null($icon)) || $icon != ""){
			$imgIcon = new HTMLImage();		
			$imgIcon->set_src($iconPath)->set_class("margin-right-5px");
		}
		
		if ($isParentItem) {
			
			if(!(is_null($icon)) || $icon != ""){			
				$imgIcon = new HTMLImage();				
				$imgIcon->set_src($iconPath)->set_class("margin-right-5px");
			}
			
			if(!(is_null($menuLabel)) || $menuLabel != "")
				$a->set_display_text($menuLabel);
		
			$a->printOpeningTag();
				self::printIcon($imgIcon);
			$a->printDisplayText();			
			$a->printClosingTag();
			
			$ul->printOpeningTag();
			for ($i = 0; $i < count($children); $i++) {
				$li->set_class("li_bg")->set_title($description)->printOpeningTag();
					self::showLevel($children[$i]);
				$li->printClosingTag();
			}
			$ul->printClosingTag();
		} 
		else {
			
			$li->set_class("li_bg")->set_title($description);			
			
			$targetPage 		= $transactionObject->get_targetPage();
			$transactionType	= self::getTransactionType($targetPage);
			$formName			= $transactionObject->get_transactionCode();
			$menuItemId			= $menuItem->get_menuId();			
			$menuItemId 		= ET_StringCheck::substituteSpecialCharacters($menuItemId);
			
			if ($transactionType == TRANSACTION_TYPE_FORM) {
				$form 	= new HTMLForm();
				$advancedFilter = false;
				
				$li->set_id("li_" . $menuItemId)->printOpeningTag();
				$a->set_onclick("document.getElementById(\"$menuItemId\").submit();dynamic_menu_set_session(\"li_$menuItemId\", true);")->set_display_text($menuLabel);
				
				$form->set_name($formName)->set_id($menuItemId)->set_action($targetPage)->set_method("post")->printOpeningTag();
					
					foreach ($transactionObject->get_params() as $paramName => $value) {
						$inputHiddenParam = new HTMLInput();
						$inputHiddenParam->set_type("hidden")->set_name($paramName)->set_value($value);
						$inputHiddenParam->printOpeningTag();
						
						if ($paramName == "popup_filter") {
							$advancedFilter = true;
						}
					}
					if ($advancedFilter) {
						$inputHiddenParam = new HTMLInput();
						$inputHiddenParam->set_type("hidden")->set_name("filter_from_menu")->set_value(1);
						$inputHiddenParam->printOpeningTag();
					}
					
					$a->printOpeningTag();
					self::printIcon($imgIcon);
					$a->printDisplayText();
					$a->printClosingTag();
				$form->printClosingTag();
				
			} else if ($transactionType == TRANSACTION_TYPE_AJAX) {
				// TODO - check if it is a file-upload CO
				// if yes call
				// ET_DisplayHelper::printFileUploadAndProcessPopup()
				$callableName = "";
				foreach ($transactionObject->get_params() as $key=>$val) {
					$callableName = $val;
				}
				
				$li->set_id("li_" . $menuItemId)->printOpeningTag();
				
				$niotaUser 	= ET_NiotaUser::getNiotaUserFromSession();
				$co 		= $niotaUser->getCallableObject($callableName);				
				$coPageType = intval($co['promptpage_type']);
				
				if ($coPageType === CO_PROMPT_PAGE_FILE_UPLOAD) {
					
					$coordinates 	= $niotaUser->get_userSettings()[USER_PARAM_POPUP_POSITION_UPLOADANDPROCESS];					
					$detailsByType 	= ["headerTitle" => "upload and process file", "labelTitle" => "click here to upload file"];
					$coDetails 		= ["name" => $callableName, "binding_level" => 0, "label" => $menuLabel];
					
					//ET_DisplayHelper::printFileUploadAndProcessPopup();
					$_SESSION['SESS_PRINT_UPLOAD_POPUP'] = true;
					
					$onclick = "display_menu_features(\"uploadandruncallable\", 
									\"$coordinates\", \"" . 
									FILE_UPLOAD . "\"," . 
									json_encode($detailsByType) . ", ". 
									json_encode($coDetails). "
									);
									dynamic_menu_set_session(\"li_$menuItemId\", false);";					
					$a->set_onclick($onclick);
					
				} else {
					$a->set_onclick("dynamic_menu_transction_call(\"$callableName\", \"$menuLabel\");dynamic_menu_set_session(\"li_$menuItemId\", false);");					
				}				
				$a->set_display_text($menuLabel);
					
				
				$a->printOpeningTag();
					self::printIcon($imgIcon);
				$a->printDisplayText();
				$a->printClosingTag();
				
			} else {
				$li->set_id("li_" . $menuItemId)->printOpeningTag();
				$a->set_display_text($menuLabel)->set_class("inactive-dynamic-menu-item");
				$a->printOpeningTag();
				self::printIcon($imgIcon);
				$a->printDisplayText();
				$a->printClosingTag();
			}
			$li->printClosingTag();
		}
	}
	
	
	public static function getTransactionType ($targetPage) {		
		
		if ($targetPage == TARGET_PAGE_NIOTA)
			return TRANSACTION_TYPE_FORM;
		elseif ($targetPage == TARGET_PAGE_EXECUTE_CALLBALE)
			return TRANSACTION_TYPE_AJAX;
		
		return null;
	}
	
	/***
	 * 
	 * @param HTMLImage $imgIcon
	 */
	protected static function printIcon($imgIcon){		
		
		if(!is_null($imgIcon)){
			$imgIcon->printOpeningTag();
		}
					
	}
}