<?php
	class ET_ErrorHandling{
		
		/***
		 * Turns on a custom error handler to make warnings as catchable errors.
		 * Don't forget to call restore_error_handler() function after the usage.
		 */
		function raiseWarningsAsError(){
			set_error_handler('error_handler_to_raise_WARNINGS');			
		}	
		
		/***
		 * Calls the PHP restore_error_handler(); function
		 */
		function restore_error_handler(){
			restore_error_handler();			
		}
		
		/***
		 * Input function for the callback of raiseWarningsAsError(){}
		 * Probably never need to call this.
		 * @param unknown $errno
		 * @param unknown $errstr
		 * @param unknown $errfile
		 * @param unknown $errline
		 * @throws ErrorException
		 */
		function error_handler_to_raise_WARNINGS($errno, $errstr, $errfile, $errline) {
			if($errno == E_WARNING || $errno == E_USER_WARNING) {
				global $errorMessage;
				$errorMessage = $errstr;
				throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
			}
			else{
				return;
			}
		}
		
		function customErrorHandlerToHideWarning(){
			set_error_handler(
					function ($severity, $message, $filename, $lineno) {
						if (error_reporting() == 0) {
							return;
						}
						if (error_reporting() & $severity) {
							//global $errorMessage;
							//$errorMessage = $message;
							return;
						}
					});
		}
		
		
	}