<?php

	require_once __DIR__ . '/../../conf/conf.php';

	class ET_ExcelHelper{
		
		protected $importType 	= "";
		protected $PHPExcel 	= null;
		protected $tableName	= "";
		protected $targetFile	= "";
		
		protected $colMetaTypes 		= array();
		protected $colNames 			= array();
		protected $dbColNames			= array();
		protected $columnInfo 			= null;
		protected $conn 				= "";
		protected $constraintsLowercase = null;
		protected $decimalPoint 		= null;
		protected $fullTableName		= null;
		protected $importDbType			= null;
		protected $importDbCharset		= null;
		protected $lookupValues			= null;
		protected $sheet 				= null;
		
		/**
		 * 
		 * @param string $importType -> one of the constants
		 * @param string $fullTableName -> db table name of the actual catalog instance 
		 */
		public function __construct ($importType, $fullTableName) {
			
			$this->importType 			= $importType;
			$this->tableName 			= ET_CatalogInstance::getTableNameFromFullyQualifiedForm($fullTableName);						
			$this->targetFile 			= $_POST['uploaded_file_path'];
			
			try {
				$inputFileType 	= PHPExcel_IOFactory::identify($this->targetFile);
				$objReader 		= PHPExcel_IOFactory::createReader($inputFileType);
				$this->PHPExcel = $objReader->load($this->targetFile);				
			} catch(Exception $e) {
				throw new Exception(ET_DisplayHelper::localize("ERROR_LOADING_FILE", null, PAGE_TYPE_GRID) . ' "'.pathinfo($this->targetFile,PATHINFO_BASENAME),
						0, $e);
			}			
		}
		
		public static function handleExcelFileUpload() {
			if (isset($_POST['import_xlsx'])) {
				$target_dir = TEMP_FOLDER;
				$target_file = "../" . $target_dir . basename($_FILES["file_path"]["name"]);
				//$target_file =  __FILE__ . "/../../../" . $target_dir  . basename($_FILES["file_path"]["name"]);
				move_uploaded_file($_FILES["file_path"]["tmp_name"], $target_file);
				return $target_file;
			}
		}
		
		public function handleExcelImport($connName, $deleteTable, $fullTableName, $lookups, $constraints, $columnInfo, $fromGridEditPage = true) {
			
			$wasError 		= false;
			$deleteQuery 	= "";
			$conn 			= ET_ConnHelper::getConnection($connName);
				
			$import_db_type 	= ET_ConnHelper::getConnectionTypeByName($connName);
			$import_db_charset 	= ET_ConnHelper::getConnectionCharsetByName($connName);			
			$decimalPoint 		= ET_ConnHelper::getDecimalpointFormatByConnectionName($connName);
			
			$this->conn 			= $conn;		
			$this->importDbType 	= $import_db_type;		
			$this->importDbCharset 	= $import_db_charset;		
			$this->decimalPoint 	= $decimalPoint;
			$this->fullTableName 	= $fullTableName;
			$this->columnInfo 		= $columnInfo;
			$this->dbColNames		= $this->extractDbColNames($columnInfo);
			
			$actionCode = "";
			
			if ($this->importType == EXCEL_UPLOAD_REPLACE)
				$actionCode = LOGGING_SOURCE_EXCEL_IMPORT;
			else if ($this->importType == EXCEL_UPLOAD_REPLACE_PARTIAL)
				$actionCode = LOGGING_SOURCE_EXCEL_IMPORT_PARTIAL;
			
			try {
				ET_LoggingHelper::log($connName, "Excel import starts for $fullTableName.", $actionCode, true);
			} catch (Throwable $e) {				
				throw new Exception("PHPGRID_ERROR: " . ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, PAGE_TYPE_GRID), 0 , $e);
			}
			
			//metadata check			
			$sheet = $this->filterExcelWorksheets($fromGridEditPage);	
			$this->sheet = $sheet;
			
			$colInfoTmp = array();
			
			try {
				$colInfoTmp = $this->fillColumnNamesAndTypes($sheet);
			} catch (Exception $e) {
				unlink($this->targetFile);
				return;
			}			
			
			$this->colNames 	= $colInfoTmp[0];
			$this->colMetaTypes = $colInfoTmp[1];
			
			$constraintsLowercase = array();
			$constraintKeys = array_keys($constraints);
			foreach ($constraintKeys as $key) {
				$constraintsLowercase[strtolower($key)] = $constraints[$key];
			}			
			$this->constraintsLowercase = $constraintsLowercase;
			
			$lookupValues = array();	
			$errorText = "";
			try {
				$lookupValues = self::getLookupValues($lookups);
			} catch (Exception $e) {
				ET_DisplayHelper::addErrorLine($e->getMessage(), 'niota');
				return;
			}
			$this->lookupValues = $lookupValues;
			
			$conn->StartTrans();			
			$insertQueries = array();
			$deleteQueries = array();
			
			if ($this->importType === EXCEL_UPLOAD_REPLACE) {
				try {					
					$deleteQuery 	= self::deleteTable();					
					$insertQueries 	= self::processLines();
				} catch (Exception $e) {
					ET_DisplayHelper::addErrorLine($e->getMessage(), 'niota');
					ET_LoggingHelper::log($connName, "Excel import terminated due to error.", $actionCode);
					
					$conn->failTrans();
					$wasError = true;
				}				
			} else if ($this->importType === EXCEL_UPLOAD_REPLACE_PARTIAL) {				
				try {					
					$deleteQueries = $this->deleteRowsOneByOne($fromGridEditPage);				
					$insertQueries = self::processLines();
				} catch (Exception $e) {					
					ET_LoggingHelper::log($connName, "Excel import terminated due to error.", $actionCode);
					ET_DisplayHelper::addErrorLine($e->getMessage(), 'niota');
					$conn->failTrans();
					$wasError = true;
					
				}			
			} 
			$conn->CompleteTrans();
				
			if (!$wasError) {
				
				$selectedInstanceId = $fromGridEditPage? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] : $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN];
				$catalogId 			= ET_MetaDataConnector::getInstance()->getCatalogId($selectedInstanceId);
				$nologUpload 		= ET_MetaDataConnector::getInstance()->getNologUploadFlag($catalogId);
				
				if ($nologUpload === true) {
					
					$deleteNum = count($deleteQueries);
					$inertsNum 	= count($insertQueries);
					$logStrIns 	= "Table name: $this->fullTableName\t Number of inserted rows: $inertsNum";
					$logStrDel	= "";
					
					try {
						if ($this->importType == EXCEL_UPLOAD_REPLACE_PARTIAL) {
							$logStrDel =  "Table name: $this->fullTableName\t Number of deleted rows: $deleteNum";
						} else if ($this->importType == EXCEL_UPLOAD_REPLACE) {
							$logStrDel = $deleteQuery;
						}
						ET_LoggingHelper::log($connName, $logStrDel, $actionCode);
						ET_LoggingHelper::log($connName, $logStrIns, $actionCode);
						ET_LoggingHelper::log($connName, "Excel import ends for $fullTableName.", $actionCode, true);
					} catch (Throwable $e) {
						die('PHPGRID_ERROR: ' . ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, PAGE_TYPE_GRID));
					}					
				}
				else {					
					if ($this->importType === EXCEL_UPLOAD_REPLACE_PARTIAL) {
						try {
							$this->logQueryArray ($deleteQueries, $connName, $actionCode);							
						} catch (Throwable $th) {
							die('PHPGRID_ERROR: ' . ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, PAGE_TYPE_GRID));
						}
					} else if ($this->importType == EXCEL_UPLOAD_REPLACE) {
						try {
							ET_LoggingHelper::log($connName, $deleteQuery, $actionCode);
						} catch (Throwable $thr) {
							die('PHPGRID_ERROR: ' . ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, PAGE_TYPE_GRID));
						}
					}
					try {						
						$this->logQueryArray ($insertQueries, $connName, $actionCode);						
						ET_LoggingHelper::log($connName, "Excel import ends for $fullTableName.", $actionCode, true);
					} catch (Throwable $e) {
						die('PHPGRID_ERROR: ' . ET_DisplayHelper::localize("LOGGING_ERROR_OCCURED", null, PAGE_TYPE_GRID));
					}					
				}				
			}
			
			if (!$wasError) {
				ET_DisplayHelper::addSuccessLine(ET_DisplayHelper::localize("EXCEL_IMPORT_WAS_SUCCESSFUL", null, PAGE_TYPE_GRID), "niota");
			} else {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("EXCEL_IMPORT_WAS_NOT_SUCCESSFUL", null, PAGE_TYPE_GRID), "niota");
			}
			unlink($this->targetFile); //delete excel file
		}
				
		protected function logQueryArray ($queryArr, $connName, $actionCode) {
			
			for ($i = 0; $i < count($queryArr); $i++) {
				$query = $queryArr[$i];
				ET_LoggingHelper::log($connName, $query, $actionCode);
			}
		}
		
		protected function processLines() {
		
			$errorCount		= 0;			
			$oracle 		= ($this->importDbType == 'oci805');
			$insertQueries 	= array();
			
			$highestRow 	= $this->sheet->getHighestRow();						
			$highestColumn 	= $this->getHighestNonEmptyCol();			
			$highestColumn 	= $this->getRealHighestColumn($highestColumn);
			
			$count = 0;			
			for ($row = 2; $row <= $highestRow; $row++) {
			
				$count++;
				//  Read a row of data into an array			
				$rowData = $this->sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE,	TRUE, FALSE);
				$r = $rowData[0];
				$values 	= array();			
				$emptyLine 	= true;
				$namesStr 	= "";
				
				for ($i = 0; $i < count($r); $i++) {
					
					$trimmedVal = '';
					$colMetaType 	= $this->colMetaTypes[$i];
					$colName 		= $this->colNames[$i];
					
					if (!is_null($r[$i])){
						$trimmedVal = trim($r[$i]);						
					}
					
					if (!empty($trimmedVal))
						$emptyLine = false;
										
					$newVal = ET_MetaDataConnector::getInstance()->getNullValuesForCell($colName, $trimmedVal, $this->columnInfo, $this->importDbType, 'add');
					
					if ($newVal == '___skip___') continue;					
					$namesStr .= $colName . ", ";
					
					// null
					// ''
					// '--'
					// '1900-01-01', other defs
					// ___skip___
					// original
					
					$newValue = $this->applySQLSyntaxOnValues($colMetaType, $trimmedVal, $newVal);
					array_push($values, $newValue);					
				}
			
				if ($emptyLine) continue;
				
				$isThereAnyConstraints 	= !empty($this->constraintsLowercase);
				$isThereAnyLookups 		= !empty($this->lookupValues);
				
				if ($isThereAnyConstraints || $isThereAnyLookups) {
					
					for ($k = 0; $k < count($values); $k++) {
						
						$valueToCheck 	= $values[$k];						
						$colMetaType 	= $this->colMetaTypes[$k];
						$colName 		= $this->colNames[$k];
						$colToCheck 	= strtolower($colName);
						
						if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T' || $colMetaType == 'X') {
							$valueToCheck = trim($valueToCheck, "'");
							if (strpos($valueToCheck, "RRRR-MM-DD, HH24:MI:SS") !== false) {
								$firstQuote = strpos($valueToCheck, "'");
								$secondQuote = strpos($valueToCheck, "'", $firstQuote + 1);
								$valueToCheck = substr($valueToCheck, $firstQuote + 1, $secondQuote - $firstQuote - 1);
							}
						}
			
						if($isThereAnyConstraints) {
							//we only check columns that need to be checked!
							if (isset($this->constraintsLowercase[$colToCheck]) && $this->constraintsLowercase[$colToCheck]['excelImportCheck'] == 1) {
								if (!self::isExcelInputValidForConstraints($valueToCheck, $colToCheck, $colMetaType, $this->constraintsLowercase)) {
									$errorCount++;
									ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_VALIDATION", array($count, $colToCheck), PAGE_TYPE_GRID), "niota");
								}
							}
						}			
						if($isThereAnyLookups) {
							//in lookupValues there are only columns that need to be checked!
							if (!self::isExcelInputValidForLookups($valueToCheck, $colToCheck, $colMetaType, $this->lookupValues)) {
								$errorCount++;
								ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_LOOKUP_VALIDATION", array($count, $colToCheck), PAGE_TYPE_GRID), "niota");
							}
						}
					}
					
				}
				
				if ($errorCount !== -1 && $errorCount === MAXNUMBER_VALIDATIONERR)
					break;
				
				if ($errorCount > 0) 
					continue;
				
				try {
					$valuesStr = $this->setUpValuesStr($values);
				}
				catch (Exception $e) {
					throw new Exception ($e->getMessage() . " Row number: $row - 1 ");
				}
				
				if (ET_StringCheck::endsWith($namesStr, ", ")) {
					$namesStr = substr($namesStr, 0, strlen($namesStr) - 2);
				}
				
				$query = "insert into " . $this->fullTableName . " ($namesStr) values ($valuesStr)";
				array_push($insertQueries, $query);
				
				//QUERY EXECUTION!---------------
				//
				$result = $this->conn->Execute($query);
				//
				//--------------------------------
				
				if (!$result) {
					//addErrorLine(localize("an error occured importing row number") . ": " . $count . "<br>$query", "niota");
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("AN_ERROR_OCCURED_IMPORTING_ROW", array($count, $query), PAGE_TYPE_GRID), "niota");					
					throw new Exception("INSERT_INTO_ERROR");
				}
				
			}
			if ($errorCount > 0) {
				//do something bad for make the transaction rollback work
				throw new Exception("Problem occured during processing line");
			}
			return $insertQueries;
		}
		
		protected function applySQLSyntaxOnValues($colMetaType, $trimmedVal, $newVal) {
			
			$valueSQLSyntax = "";
			$oracle = ($this->importDbType == DB_TYPE_OCI805);
			
			if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T' || $colMetaType == 'X') {
				if ($newVal === NULL) {
					$valueSQLSyntax = '___null___';
				} else if ($newVal === '') {
					$valueSQLSyntax =  "''";
				} else if ($colMetaType == 'T' && $oracle) {
					$mod_ts = "TO_DATE('$newVal','RRRR-MM-DD, HH24:MI:SS')";
					$valueSQLSyntax = $mod_ts;
				} else if ($colMetaType == 'C' && strpos($trimmedVal, "'") !== false) {
					$trimmedVal = str_replace("'", "''", $trimmedVal);
					$valueSQLSyntax = "'" . $trimmedVal. "'";
				} else {
					$valueSQLSyntax = "'" . $newVal . "'";
				}
			}
			else if ($colMetaType == 'N' || $colMetaType == 'I' || $colMetaType == 'R') {
				
				if ($newVal === null) {					
					$valueSQLSyntax = '___null___';
				} else if ($colMetaType == 'N') {
					if ($this->decimalPoint!= '.') {
						$newVal = str_replace($this->decimalPoint, ".", $newVal);
					}
					$valueSQLSyntax = $newVal;
				} else {
					
					$valueSQLSyntax = $newVal;
				}
				
			} else {
				if ($newVal === '' || empty($newVal) || $newVal === NULL) {
					$valueSQLSyntax = '___null___';
				} else {
					$valueSQLSyntax = $v;
				}
			}
			
			return $valueSQLSyntax;
		}
		
		//protected static function deleteTable() {
		protected function deleteTable() {
			$conn = $this->conn;
			$fullTableName = $this->fullTableName;
			
			$deleteQuery = "delete from " . $fullTableName;
			$result = $conn->Execute($deleteQuery);
			if ($result == false) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_DELETE_TABLE_VALUES", array($fullTableName), PAGE_TYPE_GRID), "niota");
				throw new Exception("Delete table failed");
			}
			return $deleteQuery;
		}
		
		public static function getLookupValues($lookups) {
			$lookupValues = array();
			if (!empty($lookups)) {
				$wasError = false;
				foreach ($lookups as $fieldName => $fieldObj) {
					
					//array_push($lookupColumnNames, strtolower($fieldName));
					$lookupCatalogId = $fieldObj['catalogId'];
					$lookupInstanceName = $fieldObj['instanceName'];
					$lookupImportCheck = $fieldObj['excelImportCheck'];
			
					//we only fill lookup infos that need to be checked!
					if($lookupImportCheck) {
						$catalgInstanceIdGrid	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
						$catalgId				= explode(".", $catalgInstanceIdGrid)[0];
						$addNullItem 			= ET_MetaDataConnector::getInstance()->getLookupNullable($catalgId, $fieldName);
						
						$lookupInstance = new ET_LookupInstance($lookupCatalogId, $lookupInstanceName, $addNullItem);
						
						if (!is_null($lookupInstance->getError())) {
							throw new Exception("lookup error - Excel import failed");
							
						}
						else{
							$lookupSQL = $lookupInstance->get_LookupSql();
							$lookupConnName = $lookupInstance->get_ConnName();
				
							$lookupResult = self::getLookupResults($lookupSQL, $lookupConnName);
				
							if ($lookupResult === 1) {
								$wasError = true;
								$errorText = ET_DisplayHelper::localize("ERROR_SQL", null, PAGE_TYPE_GRID);
							} else if ($lookupResult === 2) {
								$wasError = true;
								$errorText = ET_DisplayHelper::localize("ERROR_ALIAS", null, PAGE_TYPE_GRID);
							} else if ($lookupResult === 3){
								$wasError = true;
								$errorText = ET_DisplayHelper::localize("ERROR_EMPTY_QUERY", null, PAGE_TYPE_GRID);
							}
						}
						
						if ($wasError) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_GET_LOOKUP_VALUES", array($errorText, $lookupSQL, $lookupConnName), PAGE_TYPE_GRID), 'niota');
							throw new Exception("lookup error - Excel import failed");
						}
						else {
							$lookup_db_type = ET_ConnHelper::getConnectionTypeByName($lookupConnName);
							$lookup_db_charset = ET_ConnHelper::getConnectionCharsetByName($lookupConnName);
								
							for ($h=0; $h<count($lookupResult); $h++) {
								if ($lookup_db_type == 'odbc_mssql') {
									$lookupResult[$h] = iconv($lookup_db_charset, "UTF-8",$lookupResult[$h]);
								}
								if ($lookup_db_type == 'odbc_teradata') {
									$lookupResult[$h] = iconv("iso-8859-2", "UTF-8",$lookupResult[$h]);
									$lookupResult[$h] = trim($lookupResult[$h]);
								}
							}
							$lookupValues[strtolower($fieldName)] = $lookupResult;
						}
					}
				}
			}
			return $lookupValues;
		}
		
		protected static function fillColumnInfos($headerRowData, $columnInfo) {
			$colNames = array();
			$colMetaTypes = array();
			$countOfCols = count($headerRowData[0]);
			$wasMetaError = false;
			
			for ($i = 0; $i < $countOfCols; $i++) {
				$colName = $headerRowData[0][$i];
			
				
				/* 
				 * WE HAVE TO CHANGE THE LOGIC
				 * THERE CAN BE MORE OR LESS COLUMNS
				 * 
				array_push($colNames, $colName);
				
				if (isset($columnInfo[strtolower($colName)])) {
					array_push($colMetaTypes, $columnInfo[strtolower($colName)]['metaType']);
				} else {
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("META_COL_ERROR_EXCEL_IMPORT", array($colName)), "niota");
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_EXCEL_IMPORT"), "niota");
					$wasMetaError = true;
				}
				*/
				
				if (isset($columnInfo[strtolower($colName)])) {
					array_push($colNames, $colName);
					array_push($colMetaTypes, $columnInfo[strtolower($colName)]['metaType']);
				} else {
					continue;
				}
			}
			/*
			if ($wasMetaError)
				
			*/
			if (empty($colNames) || empty ($colMetaTypes)) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("META_COL_ERROR_EXCEL_IMPORT", array($colName), PAGE_TYPE_GRID), "niota");
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_EXCEL_IMPORT", null, PAGE_TYPE_GRID), "niota");
				throw new Exception("Metadata column info error");
			}
			
			return [$colNames, $colMetaTypes];
		}
		
		protected static function getLookupResults($lookupSql, $selectedConnForLookup) {
			$ret = array();
			$conn = ET_ConnHelper::getConnection($selectedConnForLookup);
		
			if ($lookupSql == "" || $lookupSql == null){
				return 3;
			}
		
			$fromPos1 = strpos(strtolower($lookupSql), " from ");
			$fromPos2 = strpos(strtolower($lookupSql), " from(");
			$fromPos3 = strpos(strtolower($lookupSql), " from" . PHP_EOL);
		
			$fromArray = array();
			if ($fromPos1) array_push($fromArray , $fromPos1);
			if ($fromPos2) array_push($fromArray , $fromPos2);
			if ($fromPos3) array_push($fromArray , $fromPos3);
		
			if (!empty($fromArray)) {
				$asPos = strpos(strtolower($lookupSql), " as ");
				$fromPos = min($fromArray);
				if(($asPos !== False) && ($fromPos !== False)) {
					if ($asPos < $fromPos) {
						return 2;
					}
				}
			}
		
			if ($conn) {
				$result = $conn->Execute($lookupSql);
				if ($result === False) return 1;
		
				if (!empty($result)) {
					while (!$result->EOF) {
						array_push($ret, strval($result -> fields[0]));
						$result->MoveNext();
					}
				}
			}
			return $ret;
		}
		
		protected static function isExcelInputValidForLookups($value, $colNameLowerCase, $colMetaType, $lookupValues) {
			$ret = true;
			if (isset($lookupValues[$colNameLowerCase])) {
				if ($value == '___null___') return $ret;
				$lookupValuesForColumn = $lookupValues[$colNameLowerCase];
				if (!in_array($value, $lookupValuesForColumn, false)) {
					$ret = false;
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_LOOKUP_VALUE_CHECK", array($value), PAGE_TYPE_GRID), "niota");
				}
			}
			return $ret;
		}
		
		protected static function isExcelInputValidForConstraints($value, $colNameLowerCase, $colMetaType, $regionInfoLowerCase) {
			$ret = true;
			if ($value === '') return $ret;
			if ($value === null) return $ret;

			if (isset($regionInfoLowerCase[$colNameLowerCase])) {
				$tempArr = $regionInfoLowerCase[$colNameLowerCase];
				$c_op1 			= $tempArr["operand1"];
				$c_op2 			= $tempArr["operand2"];
				$c_type 		= $tempArr["column_type"];
				$c_operation 	= $tempArr["operation"];
					
				//[array (1, 2, 3, 4, 5, 6, 7, 8, 9, 10), array('equals (=)', 'not equals (&lt;&gt;)', 'greater than (&gt;)', 'less than (&lt;)', 'greater than or equal to (&ge;)', 'less than or equal to (&le;)', 'between', 'not between', 'like', 'not like')]
					
				switch ($c_operation) {
					//equals
					case 1:
						$ret = self::isValidForEqual($value, $colMetaType, $c_type, $c_op1, true);
						if (!$ret) {
							//addErrorLine(localize("value must be equal to") . " " . $c_op1 . ", " . localize("given value is") . " " . $value, "niota");
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_EQUAL", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
						//not equals
					case 2:
						$ret = !self::isValidForEqual($value, $colMetaType, $c_type, $c_op1, false);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_NOT_EQUAL", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
						//greater
					case 3:
						$ret = self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, false, true);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_GREATER_THAN", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
						//less
					case 4:
						$ret = !self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, false, false);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_LESS_THAN", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
						//greater or equal
					case 5:
						$ret = self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, true, true);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_GREATER_THAN_OR_EQUAL_TO", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
						//less or equal
					case 6:
						$ret = !self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, true, false);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_LESS_THAN_OR_EQUAL_TO", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
						//between
					case 7:
						$ret = self::isValidForBetween($value, $colMetaType, $c_type, $c_op1, $c_op2, true);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_BETWEEEN", array($c_op1, $c_op2, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
		
						//not between
					case 8:
						$ret = !self::isValidForBetween($value, $colMetaType, $c_type, $c_op1, $c_op2, false);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_NOT_BETWEEEN", array($c_op1, $c_op2, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
		
						//like
					case 9:
						$ret = self::isValidForLike($value, $colMetaType, $c_type, $c_op1, true);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_CONTAIN", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
		
						//not like
					case 10:
						$ret = !self::isValidForLike($value, $colMetaType, $c_type, $c_op1, false);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_NOT_CONTAIN", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
		
						//starts with
					case 11:
						$ret = self::isValidForStartsWith($value, $colMetaType, $c_type, $c_op1, true);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_STARTS_WITH", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
		
						//not starts with
					case 12:
						$ret = !self::isValidForStartsWith($value, $colMetaType, $c_type, $c_op1, false);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_NOT_STARTS_WITH", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
		
						//ends with
					case 13:
						$ret = self::isValidForEndsWith($value, $colMetaType, $c_type, $c_op1, true);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_ENDS_WITH", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
		
						//not ends with
					case 14:
						$ret = !self::isValidForEndsWith($value, $colMetaType, $c_type, $c_op1, false);
						if (!$ret) {
							ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_NOT_ENDS_WITH", array($c_op1, $value), PAGE_TYPE_GRID), "niota");
						}
						return $ret;
				}
			}
		
			return $ret;
		}
		
		protected static function isValidForEqual($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
			if ($colMetaType == 'I' || $colMetaType == 'R') {
				return intval($value) == intval($c_op1);
			}
			if ($colMetaType == 'N') {
				return floatval($value) == floatval($c_op1);
			}
			if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T') {
				return (string)$value == (string)$c_op1;
			}
		
			return $ifCannotValidate;
		}
		
		protected static function isValidForGreater($value, $colMetaType, $c_type, $c_op1, $andEquals, $ifCannotValidate) {
			if ($colMetaType == 'I' || $colMetaType == 'R') {
				if ($andEquals)
					return intval($value) >= intval($c_op1);
					else
						return intval($value) > intval($c_op1);
			}
			if ($colMetaType == 'N') {
				if ($andEquals)
					return floatval($value) >= floatval($c_op1);
					else
						return floatval($value) > floatval($c_op1);
			}
			if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T') {
				if ($andEquals)
					return (string)$value >= (string)$c_op1;
					else
						return (string)$value > (string)$c_op1;
			}
		
			return $ifCannotValidate;
		}
		
		protected static function isValidForBetween($value, $colMetaType, $c_type, $c_op1, $c_op2, $ifCannotValidate) {
			if ($colMetaType == 'I' || $colMetaType == 'R') {
				return intval($value) >= intval($c_op1) && intval($value) <= intval($c_op2);
			}
			if ($colMetaType == 'N') {
				return floatval($value) >= floatval($c_op1) && floatval($value) <= floatval($c_op2);
			}
			if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T') {
				return (string)$value >= (string)$c_op1 && (string)$value <= (string)$c_op2;
			}
		
			return $ifCannotValidate;
		}
		
		protected static function isValidForLike($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
			if ($colMetaType == 'C') {
				return strpos($value, $c_op1) !== false;
			}
		
			return $ifCannotValidate;
		}
		
		protected static function isValidForStartsWith($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
			if ($colMetaType == 'C') {
				return ET_StringCheck::startsWith($value, $c_op1);
			}
		
			return $ifCannotValidate;
		}
		
		protected static function isValidForEndsWith($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
			if ($colMetaType == 'C') {
				return ET_StringCheck::endsWith($value, $c_op1);
			}
		
			return $ifCannotValidate;
		}
		
		protected static function startsWith($haystack, $needle) {
			$length = strlen($needle);
			return (substr($haystack, 0, $length) === $needle);
		}
		
		protected static function endsWith($haystack, $needle) {
			$length = strlen($needle);
			if ($length == 0) {
				return true;
			}
			return (substr($haystack, -$length) === $needle);
		}
				
		protected function filterExcelWorksheets($fromGridEditPage) {
		
			$tableNameSimlpe 	= ET_CatalogInstance::getTableNameFromFullyQualifiedForm($this->fullTableName);			
			//the PHPExcel->getSheetByName) function is case sensitive 
			$sheet				= $this->PHPExcel->getSheetByName($tableNameSimlpe);
			$phpFileName		= $fromGridEditPage ? "niota" : "";
			
			if (is_null($sheet))
				$sheet = $this->PHPExcel->getSheetByName(strtolower($tableNameSimlpe));
			if (is_null($sheet))
				$sheet = $this->PHPExcel->getSheetByName(strtoupper($tableNameSimlpe));
			
			if (!is_null($sheet) && get_class($sheet) === "PHPExcel_Worksheet") {				
				return $sheet;
			} else {
				$sheet =  $this->PHPExcel->getSheet(0);
				$title = $sheet->getTitle();
				ET_DisplayHelper::addWarningLine("Worksheet with current table name <b>$tableNameSimlpe</b> not found. First sheet <b>$title</b> is imported.", $phpFileName);
				return $sheet;
			}
			
		}
		
		/***
		 * 
		 * @param unknown $sheet
		 * @throws Exception
		 * @return array[] - 2 elements [0] - names, [1] - meta types
		 */
		protected function fillColumnNamesAndTypes ($sheet) {
			
			$colNames 		= array();
			$colMetaTypes 	= array();
			$highestColumn	= $sheet->getHighestColumn();
			$headerRowData 	= $sheet->rangeToArray('A1:' . $highestColumn . '1', NULL, TRUE,	TRUE, FALSE);
			
			try {
				$tempArray = self::fillColumnInfos($headerRowData, $this->columnInfo);
				$colNames = $tempArray[0];
				$colMetaTypes = $tempArray[1];
			} catch (Exception $e) {
				unlink($this->targetFile);
				throw $e;
			}
			
			return [$colNames, $colMetaTypes];
		}
		
		protected function setUpValuesStr ($values) {
			
			$valuesStr = implode(", ", $values);
			
			if ($this->importDbType == 'odbc_mssql') {
				$valuesStr = iconv("UTF-8", $this->importDbCharset, $valuesStr);
			}
			else if ($this->importDbType == 'odbc_teradata') {
				$valuesStr = iconv("UTF-8", "iso-8859-2", $valuesStr);
			}
			
			if ($valuesStr === false) {
				throw new Exception("Illegal character detected. Cannot convert to db characterset - $this->importDbCharset.");
			}
			
			$valuesStr = str_replace('___null___', 'null', $valuesStr);
			
			return $valuesStr;
			
		}
		
		/***
		 * Where looks like: delete from ... where id1 = vavlue1 and id2 = value2 and id3 = value3;
		 * Deletes the content row by row.
		 */
		protected function deleteRowsOneByOne ($fromEditPage) {
			
			$selectedInstanceId = $fromEditPage ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] : $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN];
			$PKs		 		= ET_BrowsingStore::getBrowsingStore()->get_selectedPrimaryKeys($selectedInstanceId);
			$PKCount			= count($PKs);
			$highestRow 		= $this->sheet->getHighestRow();
			$highestColumn 		= "";					
			$PKColRefArray 		= array();						
			$deleteSQLWhere		= "";
			$PKColRefArray 		= $this->getPKReferenceColIdsInExcel($PKs);
			$deleteQueries		= array();
			
			if (!$this->validatePKsInExcelTable($PKs)) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("EXCEL_PK_VALIDATION_ERROR", null, PAGE_TYPE_GRID), "niota");
				throw new Exception(ET_DisplayHelper::localize("EXCEL_PK_VALIDATION_ERROR", null, PAGE_TYPE_GRID));
			}
			
			$highestColumn = $this->getHighestNonEmptyCol();
			$highestColumn = $this->getRealHighestColumn($highestColumn);
			
			for ($row = 2; $row <= $highestRow; $row++) {
				$deleteSQL 		= "DELETE FROM $this->fullTableName ";
				$deleteSQLWhere	= "where ";
				$pKValsOfRowArr = array();
				$excelRowData 	= $this->sheet->rangeToArray('A' . $row . ':' . $highestColumn. $row, NULL, TRUE, FALSE, TRUE);	
				
				if ($this->isRowDataEmpty($excelRowData[$row])) {
					continue;
				}				
								
				try {
					$pKValsOfRowArr = $this->getPKValuesFromRow($excelRowData, $highestColumn, $PKColRefArray, $row);
				} catch (Exception $e) {
					throw new Exception($e);
				}
				
				$counter = 1;
				foreach ($pKValsOfRowArr as $key => $value) {
					$deleteSQLWhere .= " $key = $value ";
					
					if ($counter < $PKCount) {
						$deleteSQLWhere .= "AND ";
					}
					$counter++;
				}
				
				$deleteSQL .= $deleteSQLWhere;
				//---------------------
				// Execute SQL
				$result = $this->conn->Execute($deleteSQL);
				//---------------------
				
				if ($result == false) {
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_DELETE_TABLE_VALUES", array($this->fullTableName), PAGE_TYPE_GRID), "niota");
					throw new Exception("Delete failed at data row: " . $row);
				} else {
					array_push($deleteQueries, $deleteSQL);
				}
			}			
			return $deleteQueries;
		}
		
		protected function getPKValuesFromRow ($excelRowData, $highestColumn, $PKColRefArray, $row) {
			
			$PKValStrForRow = "";			
			$PKValArrayForRow = array();
			$counter = 0;
			
			for ($column = 'A'; $column !== $highestColumn; ++$column) {
				
				$colMetaType = $this->colMetaTypes[$counter];
				
				foreach ($PKColRefArray as $key => $colName) {
					if ($column ===  $key ) {
						$cellData = $excelRowData[$row][$column];
						if (!empty($cellData)) {							
							$trimmedVal			= trim($cellData);							
							$valueSQLSysntax	= $this->applySQLSyntaxOnValues($colMetaType, $trimmedVal, $cellData);							
							$PKValArrayForRow[$colName] = $valueSQLSysntax;
						}
						else {
							throw new Exception("Error! Empty primary key found");
						}						
					}
				}
				$counter++;
			}
			return $PKValArrayForRow;			
		}
		
		protected function deleteRows($fromEditPage = true) {
			
			$selectedInstanceId = $fromEditPage ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] : $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN];
			$PKs		 		= ET_BrowsingStore::getBrowsingStore()->get_selectedPrimaryKeys($selectedInstanceId);
			$PKCount			= count($PKs);
			$PKComposit			= count($PKs) > 1 ? true : false;
			$sheet 				= $this->sheet;
			$highestRow 		= $this->sheet->getHighestRow();
			$highestColumn 		= $this->sheet->getHighestColumn();
			
			$fullTableName 		= $this->fullTableName;
			$conn 				= $this->conn;
			$where 				= "";
			
			$PKsInExcel			= false;
			$PKColRefArray 		= array();
			$pkDataMemberCount	= 0;			
			$deleteSQL 			= "DELETE FROM $fullTableName ";
			$deleteSQLWhere		= "";
						
			if (!$this->validatePKsInExcelTable($PKs)) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("EXCEL_PK_VALIDATION_ERROR", null, PAGE_TYPE_GRID), "niota");
				throw new Exception(ET_DisplayHelper::localize("EXCEL_PK_VALIDATION_ERROR", null, PAGE_TYPE_GRID));
			}
			
			//add column names to where clause
			$deleteSQLWhere = "where (";
			for ($i = 0; $i < $PKCount; $i++) {
				$deleteSQLWhere .= $PKs[$i];
				if ($i !== $PKCount - 1)
					$deleteSQLWhere .= ", ";
			}
			$deleteSQLWhere .= ") in (";
			
			
			//get PK excel column letter  (A,B,...) and the actual value at the current row
			// so we need the pk values for each row separeted.			
			$PKColRefArray 	= $this->getPKReferenceColIdsInExcel($PKs);
			$PKValsForSQL 	= "";
			
			$count = 0;
			for ($row = 2; $row <= $highestRow; $row++) {
					
				$count++;
				//  Read a row of data into an array			
				$excelRowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn. $row, NULL, TRUE, FALSE, TRUE);				
				$PKValStrForRow = "";
				
				if ($this->isRowDataEmpty($excelRowData[$row])) {
					continue;
				}
								
				//iterating through the columns of the actual row
				//row delete => 1 if variable > 1 then bulk delete
				//TODO: put into a function: getPKValuesFromRow()
				$counter = 0;
				for ($column = 'A'; $column !== $highestColumn; ++$column) {
					$colMetaType = $this->colMetaTypes[$counter];					
					foreach ($PKColRefArray as $key => $value) {
						if ($column ===  $key ) {
							$cellData = $excelRowData[$row][$column];
							if (!empty($cellData)) {
								//here we have to place the '-characters
								$trimmedVal	= trim($cellData);								
								$newVal 	= ET_MetaDataConnector::getInstance()->getNullValuesForCell($value, $trimmedVal, $this->columnInfo, $this->importDbType, 'edit');								
								$cellData 	= $this->applySQLSyntaxOnValues($colMetaType, $trimmedVal, $cellData);
								
								$PKValStrForRow .= $cellData . ", ";						
							}
							else 
								$PKValStrForRow = "";
						}						
					}						
					$counter++;
				}
				
				$PKValStrForRow = trim($PKValStrForRow);
				$PKValStrForRow = substr($PKValStrForRow, 0, strlen($PKValStrForRow)-1);
				$pkDataMemberCount = count(explode(",", $PKValStrForRow));
				
				if ($PKComposit && $pkDataMemberCount === count($PKs)) {
					$tmp = $PKValStrForRow;
					$PKValStrForRow = "(" . $tmp . ")";
				} else if ($PKComposit === false && $pkDataMemberCount === count($PKs)) {
					if ($row === 2) {
						$tmp = $PKValStrForRow;
						$PKValStrForRow = "(" . $tmp;
					}
				} else {
					//TODO: prepare for admin pages
					ET_DisplayHelper::addErrorLine("PK value is missing", "niota");
					return;
				}					
								
				if (!empty($PKValStrForRow))
					$PKValsForSQL .= $PKValStrForRow . ",";
				
			}			
			$PKValsForSQL = substr($PKValsForSQL, 0, strlen($PKValsForSQL) - 1);
			
			if ($PKComposit === false && $pkDataMemberCount === count($PKs)) {
				$PKValsForSQL .= ")";
			}
			
			$deleteSQLWhere .= $PKValsForSQL . ")";
			
			//its a misunderstanding but later its maybe useful:
			$browsingStore = ET_BrowsingStore::getBrowsingStore();
			$browsingStore->set_excelPartialDeleteWhere($selectedInstanceId, $deleteSQLWhere);
			$browsingStore->flushBrowsingStore();
			
			$deleteSQL .= $deleteSQLWhere;
			echo $deleteSQL;
			//---------------------
			//EXECUTE DELETE SQL:
			$result = $conn->Execute($deleteSQL);
			//---------------------
			
			if ($result == false) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_DELETE_TABLE_VALUES", array($fullTableName), PAGE_TYPE_GRID), "niota");
				throw new Exception("Delete table failed");
			}
			
			return $deleteSQL;
		}
		
		protected function validatePKsInExcelTable($PKs) {
				
			//get the header row:
			$highestColumn 	= $this->sheet->getHighestColumn();
			$headerData 	= $this->sheet->rangeToArray('A1:' . $highestColumn . '1', NULL, TRUE, TRUE, FALSE);
			$row 			= $headerData[0];
			$PKCount 		= 0;
			$PKsLowercase 	= $this->getPKsLowercase($PKs);
			
			
			for ($i = 0; $i < count($row); $i++) {
				
				$cellContent = trim(strtolower($row[$i])); 
				
				if (in_array($cellContent, $PKsLowercase)) {
					$PKCount++;
				}
			}
		
			if ($PKCount !== count($PKs))
				return false;
			else {				
				return true;
			}			
		}
		
		/***
		  
		 * @param array() $PKs
		 * @param unknown $headerData
		 * return array(A => "col1Name", B = > "col2Name", ...) 
		 */
		protected function getPKReferenceColIdsInExcel ($PKs) {
			$sheet 			= $this->sheet;
			$highestCol 	= $this->getHighestNonEmptyCol();
			$highestRow 	= $sheet->getHighestRow();
			$PKReferenceArr = array();			
			$PKsLowercase	= $this->getPKsLowercase($PKs);
			
			//get data like this: array(A=>'col1Name', B => 'col2Name', ...))
			$headersArr =  $sheet->rangeToArray('A1:' . $highestCol. '1', NULL, TRUE,	TRUE, TRUE)[1];
			
			foreach ($headersArr as $key => $value) {
				
				$trimmedVal = trim(strtolower($value));
				
				if (in_array($trimmedVal, $PKsLowercase)) {
					$PKReferenceArr[$key] = $trimmedVal;
				}
			}
			
			return $PKReferenceArr;
			
		}
		
		protected function getHighestNonEmptyCol () {
			
			$highestCol =  $this->sheet->getHighestColumn();
			$headersArr =  $this->sheet->rangeToArray('A1:' . $highestCol. '1', NULL, TRUE,	TRUE, TRUE)[1];
			
			foreach ($headersArr as $key => $value) {
				if (!is_null($value)) {
					$highestCol = $key;
				}
				else {
					return $highestCol;
				}
			}
			return $highestCol;
		}
		
		protected function isRowDataEmpty ($row) {
			
			foreach ($row as $cell) {
				
				if (!is_null($cell))
					return false;
			}
		
			return true;
		}
		
		protected function getPKsLowercase ($PKs) {
			
			$PKsLowercase = array();
			
			for ($j = 0; $j < count($PKs); $j++) {
				$PKsLowercase[$j] = strtolower($PKs[$j]);
			}
			
			return $PKsLowercase;
		}
		
		protected function getRealHighestColumn($highestColumnIn = "") {
			
			$max 			= "A";
			$highestColumn 	= !empty($highestColumnIn) ? $highestColumnIn : $this->sheet->getHighestColumn();
			$headerRowArr	= $this->sheet->rangeToArray('A' . 1 . ':' . $highestColumn. 1, NULL, TRUE, FALSE, TRUE);
			$headerRow		= $headerRowArr[1];
			
			//$this->sbColNames are lowercase!
			foreach ($headerRow as $excelCol => $dbColName) {				
				if (in_array(strtolower($dbColName), $this->dbColNames) && $excelCol > $max) {					
					$max = $excelCol;
				}
				else {
					continue;
				}
			}
			return $max;
			
		}
		
		protected function extractDbColNames($columnInfo) {
			
			$ret = array();
			
			foreach ($columnInfo as $key => $value) {
				array_push($ret, $key);
			}
			return $ret;
		}
		
		public static function field_name($result, $index){
			$obj_field = new \ADOFieldObject();
			$obj_field = $result->FetchField($index);
			return isset($obj_field->name) ? $obj_field->name : "";
		}
		
		public static function field_metatype($result, $index, $dbType){
			$obj_field = new \ADOFieldObject();
			$obj_field = $result->FetchField($index);
			$type      = "";
			//print_r($obj_field);
			
			//if (strpos($obj_field->type, 'VARCHAR') !== false || strpos($obj_field->type, 'CHAR') !== false || strpos($obj_field->type, 'varchar') !== false)
			if (strpos(strtolower($obj_field->type), strtolower('VARCHAR')) !== false || strpos(strtolower($obj_field->type), strtolower('CHAR')) !== false )
				return 'C';
			//old:	
			//$type = $result->MetaType($obj_field->type, $obj_field->max_length);   // Since ADOdb 3.0, MetaType accepts $fieldobj as the first parameter, instead of $nativeDBType.
			
			if (empty($obj_field->type) && $dbType == DB_TYPE_ODBC_TERADATA) {
				$temp = ET_MetaDataConnector::getInstance()->getTeradataViewColumnType($obj_field->name);
				$type = $result->MetaType($temp);
			}
			else {
				$type = $result->MetaType($obj_field->type, $obj_field->max_length);
			}
				
			return $type;
		}
		
		public static function fetch_array_assoc(&$result){
			$ADODB_FETCH_MODE = ADODB_FETCH_ASSOC;
			if(!$result->EOF){
				$rs = $result->fields;
				$result->MoveNext();
				return $rs;
			}
		}  
		
		/**
		 * columnInfo
		 * @return unkown
		 */
		public function getColumnInfo(){
			return $this->columnInfo;
		}
		
				
		/**
		 * fullTableName
		 * @return unkown
		 */
		public function getFullTableName(){
			return $this->fullTableName;
		}
		
		
		
		
		
	}
	
	
	
	
	
	
	
	
	