<?php

class ET_GridFormatter {

		
protected $con 					= null;

protected $SQLHeaderFormat 		= "";
protected $SQLColumnFormat 		= "";
protected $SQLMetaDBCatalogID 	= "";

protected $userLoglevel 		= "";
protected $systemLogger			= "";

public $set_option_pointer 	= '$dg_2format';
public $undefined 			= '?';

public $arrow 			= ' -> ';
public $open_unquoted 	= '(';
public $close_unquoted 	= ')';

public $open_quoted 	= '("';
public $close_quoted 	= '")';

public $final_close_unquoted 	= ');';
public $final_close_quoted 		= '");';

public $continue_quoted 			= '", "';
public $continue_unquoted 			= ', ';
public $continue_unquoted_and_quote = ', "';

public $open_array_quoted 				=  'array("';
public $close_quote_and_assign 			= '"=>';
public $close_quote_and_assign_quoted 	= '" => "';
public $close_quote_and_continue 		= '", ';
public $close_quote_and_continue_quoted = '", "';

 


public function __construct() {
	
	$this->con 			= ET_ConnHelper::getConnection(ET_METADATA_CONNECTION);
    $this->systemLogger = new \ET_LoggingHelperSystem();

    $this->SQLHeaderFormat = "SELECT catalog_id, instance_name, description, pagesize, form_width, ind_rownumbers, ind_advanced_search, ind_multiselect
           FROM v_et_format_object_php  
	       where catalog_id = ?
             and instance_name = ? "; 	

	$this->SQLColumnFormat = "SELECT catalog_id, instance_name, column_name, column_title_ui, column_heading_ui, editsize, editmaxlength, ind_is_required, ind_is_read_only, ind_is_hidden, ind_editable_hidden, 
         edittype, param_edittype, textarea_rows, textarea_cols, colpos_form, rowpos_form, colvalue_default 
          FROM v_et_format_object_column_php  
	     where catalog_id = ?
		   and instance_name = ? 
	       order by rowpos_form, colpos_form, column_name ";
	  
    $this->SQLMetaDBCatalogID = "SELECT catalog_id FROM v_et_metadb_object where object = ? ";	 
	

	$user  = ET_NiotaUser::getNiotaUserFromSession();
	$this->userLoglevel	= LOGLEVEL_MUTE;
	
	if ($user) {
		$this->userLoglevel = $user->getSQLLogLevelConfig() == 'null'  ? DEBUG_FORMAT_LOGLEVEL : $user->getSQLLogLevelConfig();
	} else {
		$this->userLoglevel = DEBUG_FORMAT_LOGLEVEL; 
	}

    $this->formatallheader = "";
    $this->formatallcolumn = "";

}	

	
public function getSystemCatalogID ($object_md) {

 $query = $this->SQLMetaDBCatalogID;
 
 $stmt = $this->con->prepare($query) or die ('Could not prepare' .  $query);

 $this->con->SetFetchMode(ADODB_FETCH_ASSOC);

 $myMessage = $query;
 $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_WHISPER);

 $this->con->SetFetchMode(ADODB_FETCH_ASSOC);

 $res = $this->con->Execute($stmt, [$object_md]);
 
 // proper errorhandling needed
 if ($res === false) {
		echo $query . "<br>";
		echo $object_md . "<br>";
		return false;
 }	
 
 $row 		= $res->fetchRow();  
 $catalog_id = $row['catalog_id'];
 
	if (isset($catalog_id)) {

        $myMessage = "catalog id returned: " . $catalog_id . " for " . $object_md;
	    $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_WHISPER);
		
	    return $row['catalog_id'];
	} 
	else {
        $myMessage = "no catalog id found for " . $object_md;
	    $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_WHISPER);

		return 0;
	}
}
	
	
public function formatGridInstanceObject ($dg_2format, $catalog_id_2format, $instance_name_2format) {


 $query = $this->SQLHeaderFormat;

 $myMessage = $query;
 $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_WHISPER);

 $stmt = $this->con->prepare($query) or die ('Could not prepare' . $query);

 $this->con->SetFetchMode(ADODB_FETCH_ASSOC);

 $res = $this->con->Execute($stmt, [$catalog_id_2format, $instance_name_2format]);

 // proper errorhandling needed
 if ($res === false) {
		echo $query . "<br>";
		echo $catalog_id_2format . "<br>";
		echo $instance_name_2format . "<br>";

		return false;
 }	

 $row = $res->fetchRow();

 $catalog_id 	= $row['catalog_id'];		
 $instance_name = $row['instance_name'];
 
 $description 			= $row['description'];
 $pagesize 				= $row['pagesize']; 
 $form_width 			= $row['form_width']; 
 $ind_rownumbers 		= $row['ind_rownumbers'];
 $ind_multiselect 		= $row['ind_multiselect']; 
 
 
    if (isset($description)) {
        $set_option_ok = self::compileObjectFormatString($dg_2format, GFO_GRID_CAPTION, $description . " - (". $catalog_id_2format . ".". $instance_name_2format . ")" );		
	}
	
    if (isset($pagesize)) {
        $set_option_ok = self::compileObjectFormatString($dg_2format, GFO_GRID_PAGESIZE, $pagesize);		
	}	

    if (isset($form_width)) {
        $set_option_ok = self::compileObjectFormatString($dg_2format, GFO_FORM_DIMENSION, $form_width);		
	}	

    if (isset($ind_rownumbers) && ($ind_rownumbers == '1')) {
        $set_option_ok = self::compileObjectFormatString($dg_2format, GFO_ROWNUMBERS, 'true');		
	}	
	
    if (isset($ind_multiselect) && ($ind_multiselect == '1')) {
        $set_option_ok = self::compileObjectFormatString($dg_2format, GFO_MULTISELECT, 'true');		
	}
    else {	
	 $set_option_ok = self::compileObjectFormatString($dg_2format, GFO_MULTISELECT, 'false');
	}

   $myMessage = "evaluating " . $catalog_id." ".$instance_name." ". PHP_EOL . $this->formatallheader;
   $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_SHOUT); 
   
   eval($this->formatallheader);
   
}


public function formatGridInstanceColumn ($dg_2format, $catalog_id_2format, $instance_name_2format) {

	 $query = $this->SQLColumnFormat;
	
	 $myMessage = $query;
	 $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_TALK);
	
	 $stmt = $this->con->prepare($query) or die ('Could not prepare' . $query);	
	 $this->con->SetFetchMode(ADODB_FETCH_ASSOC);
	
	 $res = $this->con->Execute($stmt, [$catalog_id_2format, $instance_name_2format]);
	
	 // proper errorhandling needed
	 
	 if ($res === false) {
			echo $query . "<br>";
			echo $catalog_id_2format . "<br>";
			echo $instance_name_2format . "<br>";
	
			return false;
	 }	
	
	
		 
	  $collist_read_only = $this->undefined;
	  $collist_required = $this->undefined;
	
			
	while ($row = $res->fetchRow()) {
	
		 $catalog_id 	= $row['catalog_id'];
		 $instance_name = $row['instance_name'];
		 
		 $column_name 			= $row['column_name'];
		 $column_title_ui 		= $row['column_title_ui']; 
		 $column_heading_ui 	= $row['column_heading_ui']; 
		 $editsize 				= $row['editsize'];
		 $editmaxlength 		= $row['editmaxlength']; 
		 $ind_is_required		= $row['ind_is_required']; 
		 $ind_is_read_only 		= $row['ind_is_read_only']; 
		 $ind_is_hidden 		= $row['ind_is_hidden'];
		 $ind_editable_hidden 	= $row['ind_editable_hidden']; 
		 $edittype 				= $row['edittype'];
		 $param_edittype		= $row['param_edittype']; 
		 $textarea_rows 		= $row['textarea_rows']; 
		 $textarea_cols 		= $row['textarea_cols']; 
		 $colpos_form 			= $row['colpos_form']; 
		 $rowpos_form 			= $row['rowpos_form'];
		 $colvalue_default 		= $row['colvalue_default'];
		
		 $myMessage = "formatting " . $catalog_id." ".$instance_name." ".$column_name;
		 $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_TALK); 
				   
		 if (isset($ind_is_read_only) && ($ind_is_read_only == '1')) { 
		    if ($collist_read_only == $this->undefined) {	
				$collist_read_only = $column_name;
		    }
			else {
				$collist_read_only = $collist_read_only . $this->continue_unquoted . $column_name;		
				}	
		 } 
		
		if (isset($ind_is_required) && ($ind_is_required == '1')) { 
		    if ($collist_required == $this->undefined) {	
				$collist_required = $column_name;
	           }
			else {
				$collist_required = $collist_required . $this->continue_unquoted . $column_name;		
			}	
		} 
	
		
	    if (isset($column_title_ui)) {
	        $set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_COL_TITLE, $column_title_ui);		
		}	
	
	    if (isset($column_heading_ui)) {
	        $set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_COL_HEADERTOOLTIP, $column_heading_ui);		
		}	
	
	    if (isset($colvalue_default))  {
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_COL_DEFAULT, $colvalue_default);
		}	
		
		
	    if ((isset($ind_is_hidden) && ($ind_is_hidden == '1'))  && ((!isset($ind_editable_hidden)) || ($ind_editable_hidden == '0'))) {
	        $set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_COL_HIDDEN, 'false');		
		}
		
	    if ((isset($ind_is_hidden) && ($ind_is_hidden == '1')) && ((!isset($ind_editable_hidden)) || ($ind_editable_hidden == '1'))) {
	        $set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_COL_HIDDEN, 'true');		
		}	
	
	    if (isset($edittype)) {
			switch ($edittype) {
			case GFO_CHECKBOX:
			case GFO_TEXTAREA:
			    if (!isset($param_edittype)) {
				    $param_edittype = $this->undefined;
				}	
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, $edittype, $param_edittype);
			break;	
	
			default:
				$set_option_ok = $this->undefined;
			}	
		}		
	
	    if (isset($editmaxlength))  {
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_MAXLENGTH_PROPERTY, $editmaxlength);
		}	
	
	    if ((isset($editsize)) && (!isset($textarea_rows)))  {
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_SIZE_PROPERTY, $editsize);
		}	
	
	    if (isset($textarea_rows)) {
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_ROWS_PROPERTY, $textarea_rows);
		}	
	
	    if (isset($textarea_cols)) {
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_COLS_PROPERTY, $textarea_cols);
		}
	
	    if (isset($colpos_form))  {
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_FORM_COLPOS, $colpos_form);
		}	
	
	    if (isset($rowpos_form))  {
				$set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_FORM_ROWPOS, $rowpos_form);
		}	
	
	    if (isset($column_name) && ($column_name == "ind_active")) {
		   $set_option_ok = self::compileColumnFormatString($dg_2format, $column_name, GFO_CONDITIONAL_FORMAT, 'ROW'); 
		   
		}	
			
	} // end-while
	
   $this->formatallheader = "";

    if ($collist_read_only != $this->undefined) {
		$set_option_ok = self::compileObjectFormatString($dg_2format, GFO_COL_READONLY, $collist_read_only);	
	}

    if ($collist_required != $this->undefined) {
		$set_option_ok = self::compileObjectFormatString($dg_2format, GFO_COL_REQUIRED, $collist_required);
	}
	 
   if ($this->formatallheader != "") {
   $myMessage = "evaluating column_list " . $catalog_id." ".$instance_name." ". PHP_EOL . $this->formatallheader;
   $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_SHOUT); 
   eval($this->formatallheader);
   }

   $myMessage = "evaluating " . $catalog_id." ".$instance_name." ". PHP_EOL . $this->formatallcolumn;
   $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_SHOUT); 
   eval($this->formatallcolumn);
   
}

protected function compileColumnFormatString ($dg_2format, $column_name, $option_text, $option_value) {


$set_option = "";
$set_option_final = "";

  
  if ( (!isset($option_value)) || (!isset($column_name)) || (!isset($option_text)) || (!isset($option_text)) ) {
	  goto nothingtodo;
  }	  


  switch ($option_text) {
	  case GFO_COL_TITLE: 
	  case GFO_COL_HEADERTOOLTIP:
	  case GFO_COL_DEFAULT:
	  
	    $set_option = $option_text . $this->open_quoted . $column_name . $this->continue_quoted . $option_value . $this->final_close_quoted;
	    break;	
	  case GFO_CHECKBOX:
	    $set_option = GFO_COL_EDITTYPE . $this->open_quoted . $column_name . $this->continue_quoted . GFO_CHECKBOX . $this->continue_quoted . $option_value . $this->final_close_quoted;
	    break;
	  case GFO_TEXTAREA:
	    $set_option = GFO_COL_EDITTYPE . $this->open_quoted . $column_name . $this->continue_quoted . GFO_TEXTAREA . $this->final_close_quoted;
	    break;
	  case GFO_COL_HIDDEN:
	    $set_option = GFO_COL_HIDDEN . $this->open_quoted . $column_name . $this->close_quote_and_continue . $option_value . $this->final_close_unquoted;
	    break;	
	  case GFO_ROWS_PROPERTY:
	  case GFO_COLS_PROPERTY:
	  case GFO_SIZE_PROPERTY:
	  case GFO_MAXLENGTH_PROPERTY:
	
	// -- build this --
	// set_col_property("column", array("editoptions"=>array("rows"=>4)));
	    $set_option = GFO_COL_PROPERTY 
		. $this->open_quoted . $column_name . $this->close_quote_and_continue 
		. $this->open_array_quoted . GFO_EDITOPTIONS . $this->close_quote_and_assign 
		. $this->open_array_quoted . $option_text 
		. $this->close_quote_and_assign . $option_value . $this->close_unquoted . $this->close_unquoted .  $this->final_close_unquoted ;
	    break;	
	
	  case GFO_FORM_COLPOS:
	  case GFO_FORM_ROWPOS:
	  
	// -- build this --
	// set_col_property("column", array("formoptions"=>array("rowpos"=>4)));
	    $set_option = GFO_COL_PROPERTY 
		. $this->open_quoted . $column_name . $this->close_quote_and_continue 
		. $this->open_array_quoted . GFO_FORMOPTIONS . $this->close_quote_and_assign 
		. $this->open_array_quoted . $option_text 
		. $this->close_quote_and_assign . $option_value . $this->close_unquoted . $this->close_unquoted .  $this->final_close_unquoted ;
	    break;	
	
	// -- build this --
	// set_conditional_format("ind_active", "ROW", array("condition"=>"eq", "value"=>"0", "css"=> array("color"=>COLOR_INACTIV_TEXT,"background-color"=>COLOR_INACTIV_BACKGROUND)));
	// --
	// set_conditional_format("ind_active", "ROW", array("condition" => "eq", "value" => "0", "css"=>array("color"=>#FF0040, "background-color"=>#E6E6E6)));
	  case GFO_CONDITIONAL_FORMAT:
	      $set_option = GFO_CONDITIONAL_FORMAT 
		. $this->open_quoted . $column_name . $this->continue_quoted . 'ROW' . $this->close_quote_and_continue
		. $this->open_array_quoted 
		. 'condition' . $this->close_quote_and_assign_quoted . 'eq' . $this->close_quote_and_continue_quoted
		. 'value' . $this->close_quote_and_assign_quoted . '0'.  $this->close_quote_and_continue_quoted
		. 'css' . $this->close_quote_and_assign . $this->open_array_quoted 
		. 'color' . $this->close_quote_and_assign_quoted . COLOR_INACTIV_TEXT . $this->close_quote_and_continue_quoted
		. 'background-color' . $this->close_quote_and_assign_quoted . COLOR_INACTIV_BACKGROUND 
		.  $this->close_quoted . $this->close_unquoted . $this->final_close_unquoted ; 
		break;
	  default:
    $set_option = $this->undefined;
 
 }	

  if ($set_option != $this->undefined) {
     $set_option_final = $this->set_option_pointer .  $this->arrow  . $set_option; 

	 $myMessage = $set_option_final;
	 $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_SHOUT);
     	 
	 $this->formatallcolumn .= $set_option_final . PHP_EOL;
  }
  return (1);
  
nothingtodo:
  return (0);

}

protected function compileObjectFormatString ($dg_2format, $option_text, $option_value) {


$set_option = "";
$set_option_final = "";

  
  if ((!isset($option_value)) || (!isset($option_text)) || ($option_value == "?")) {
	  goto nothingtodo;
  }	  


  switch ($option_text) {
  case GFO_GRID_CAPTION:
  case GFO_COL_READONLY:
  case GFO_COL_REQUIRED:
    $set_option = $option_text . $this->open_quoted . $option_value . $this->final_close_quoted;
    break;	
  case GFO_FORM_DIMENSION:
  case GFO_GRID_PAGESIZE:
  case GFO_ROWNUMBERS:
  case GFO_MULTISELECT:
  
    $set_option = $option_text . $this->open_unquoted. $option_value . $this->final_close_unquoted;
    break;	
  default:
    $set_option = $this->undefined;
 
 }	

  if ($set_option != $this->undefined) {
     $set_option_final = $this->set_option_pointer .  $this->arrow  . $set_option; 

	 $myMessage = $set_option_final;
	 $this->logFormat(GFO_TYPE_DEBUG, $myMessage, LOGLEVEL_SHOUT);
     
	 $this->formatallheader .= $set_option_final . PHP_EOL;
  }
  return (1);
  
nothingtodo:
  return (0);

}

 public function logFormat($type, $message, $loglevel) {
		

		
	if ($this->userLoglevel >= $loglevel) {
		$content = PHP_EOL . "$message" . PHP_EOL;				
		$this->systemLogger->addSystemLogEntry($type, $content, $loglevel);			
	}
	
}
	
} // end of class