<?php

class ET_GridSql {
	
	//---------------------------------------------------
	protected $catalogInstanceId	= "";	
	protected $fullTableName		= "";
	protected $useAdvancedFiltering	= false;
	protected $etDataGridSql 		= "";
	protected $projectionList		= "";
	protected $objectJoin			= "";
	protected $objectJoinAlias		= "";
	protected $objectUnion			= "";
	//--------------------------------------------------
	protected $whereObjectFilter	= "";
	//phpgrid settings:
	protected $whereMasterDetail	= "";
	protected $whereColumnSearch	= "";
	protected $whereSqlFilter		= ""; //hpGrid setting. used only at form edit
	//--------------------------------------------------
	protected $objectGroupBy		= "";
	protected $objectOrder			= "";
	protected $orderByPhpGrid 		= "";
	protected $orderByAdvancedFiltering	= "";
	protected $orderByDefaultPK		= "";
	//--------------------------------------------------
	protected $whereAdvancedFilter 	= "";
	protected $whereAdvancedFilterFilteredTable = "";
	//--------------------------------------------------	
	protected $SQL_RESERVED_ORDER_BY 	= "order by";
	protected $SQL_RESERVED_WHERE	 	= "where";
	protected $SQL_RESERVED_UNION	 	= "union";
	protected $SQL_RESERVED_ASC	 		= "asc";
	protected $SQL_RESERVED_DESC 		= "desc";
	protected $SQL_RESERVED_GROUP_BY	= "group by";
	//--------------------------------------------------
	
	public function generateSql($advancedFilterPopUp = false) {
		
		$sql 			= "SELECT "; 
		
		$projectionList 	= !empty($this->projectionList) ? $this->projectionList : "*";		
		$fullTableName		= $this->setUpFullTableName();
	
		$sql 		.= $projectionList . " FROM " . $fullTableName . " ";		
		
		$where 		= $this->setUpWherePart($advancedFilterPopUp); 
		$orderBy 	= $this->setUpOrderBy();
		$union		= $this->setUpUnionOrGroupBy($this->objectUnion, $this->SQL_RESERVED_UNION);
		$groupBy	= $this->setUpUnionOrGroupBy($this->objectGroupBy, $this->SQL_RESERVED_GROUP_BY);
		
		$sql 	.= !empty($this->objectJoin) ? $this->objectJoin : "";		
		$sql 	.= $where;
		$sql 	.= $groupBy;
		$sql 	.= $union;
		$sql 	.= $orderBy;
		
		$sql 	= ET_MetaDataConnector::getInstance()->substituteSQLQuery($sql, $this->catalogInstanceId);
		
		return $sql;
	}
	
	protected function setUpFullTableName() {
		
		if (!empty($this->objectJoin) && !empty($this->objectJoinAlias)) {			
			return  $this->fullTableName . " " . $this->objectJoinAlias;
		} else {
			return $this->fullTableName;
		}
	}
	
	protected function setUpUnionOrGroupBy($source, $reservedKeyWord) {
		
		$value 	= $this->clearSqlReservedWords($source, $reservedKeyWord);		
		return empty($value) ? "" : " " . strtoupper($reservedKeyWord) . " " . $value;
	}
		
	
	protected function setUpWherePart($advancedFilterPopUp = false) {
		
		$where 						= "";
		$whereStart 				= " WHERE (";		
		$whereObjectFilter 			= $this->clearSqlReservedWords($this->whereObjectFilter, $this->SQL_RESERVED_WHERE);
		$whereMasterDetail			= $this->clearSqlReservedWords($this->whereMasterDetail, $this->SQL_RESERVED_WHERE);
		$whereColumnSearch			= $this->clearSqlReservedWords($this->whereColumnSearch, $this->SQL_RESERVED_WHERE);
		$whereSqlFilter				= $this->clearSqlReservedWords($this->whereSqlFilter, $this->SQL_RESERVED_WHERE);
		$whereAdvancedFilterInPopup = $advancedFilterPopUp ? ($this->clearSqlReservedWords($this->whereAdvancedFilter, $this->SQL_RESERVED_WHERE)) : "";
		$whereAdvancedFilterFilteredTable = $this->clearSqlReservedWords($this->whereAdvancedFilterFilteredTable, $this->SQL_RESERVED_WHERE);
				
		//$where	.= $whereStart;
		$where .= !empty($whereObjectFilter) ? "(" . $whereObjectFilter . ")" : "";
		$where .= (!empty($where) &&  !empty($whereMasterDetail)) ? " AND " : "";
		$where .= !empty($whereMasterDetail) ? "(" . $whereMasterDetail . ")" : "";
		$where .= (!empty($where) && !empty($whereColumnSearch)) ? " AND " : "";
		$where .= !empty($whereColumnSearch) ? "(" . $whereColumnSearch . ")" : "";
		$where .= (!empty($where) && !empty($whereSqlFilter)) ? " AND " : "";
		$where .= !empty($whereSqlFilter) ? "(" . $whereSqlFilter . ")" : "";
				
		$where .= (!empty($where) && !empty($whereAdvancedFilterInPopup)) ? " AND " : "";
		$where .= !empty($whereAdvancedFilterInPopup) ? "(" . $whereAdvancedFilterInPopup. ")" : "";
		
		$where .= (!empty($where) && !empty($whereAdvancedFilterFilteredTable)) ? " AND " : "";
		$where .= !empty($whereAdvancedFilterFilteredTable) ? "(" . $whereAdvancedFilterFilteredTable. ")" : "";
		
		
		return empty($where) ? "" : $whereStart . $where .  ")";
				
	}
	
	protected function setUpOrderBy() {
		
		$orderByPhpGrid 			= $this->clearSqlReservedWords($this->orderByPhpGrid, $this->SQL_RESERVED_ORDER_BY);
		
		$objectOrder 				= $this->clearSqlReservedWords($this->objectOrder, $this->SQL_RESERVED_ORDER_BY);
		$orderByDefaultPK			= $this->clearSqlReservedWords($this->orderByDefaultPK, $this->SQL_RESERVED_ORDER_BY);
		$orderByAdvancedFiltering 	= $this->clearSqlReservedWords($this->orderByAdvancedFiltering, $this->SQL_RESERVED_ORDER_BY);		
		$orderBy 					= " ORDER BY ";
		
		//$orderByPhpGrid means column header is clicked and order by is set by that action
		//if thisi is set that is the only "order by" in use 
		// otherwise the $objectOrderBy is used (when grid is loaded) if filled
		//$this->orderByPhpGrid must be cleared after each request!!		
		if (!empty($orderByPhpGrid)) {
			$orderBy .= $orderByPhpGrid;			
		} else if (!empty($objectOrder)) {
			$orderBy .= $objectOrder;			
		}
		 
		// if there is any field in "order by" list
		if ($orderBy !== " ORDER BY " && !empty($this->orderByAdvancedFiltering)) {
			$tmp 	 = $this->cherryPickingOrderByColumns($orderBy);
			$orderByLower = strtolower($orderBy);
			$asc 	= " asc";
			$desc 	= " desc";
			$orderByLower = trim($orderByLower);
			$ordering = "";
			
			//put ASC/DESC keyword to the correct place
			if (ET_StringCheck::exactSubstringExistanceInString($orderByLower, $asc)|| ET_StringCheck::exactSubstringExistanceInString($orderByLower, $desc)) {
				$orderBy = trim($orderBy);
				if (ET_StringCheck::exactSubstringExistanceInString($orderByLower, $asc)) {					
					$orderBy = substr($orderBy, 0, strlen($orderBy) - 4);
					$ordering = $asc;
				} else if (ET_StringCheck::exactSubstringExistanceInString($orderByLower, $desc)) {
					$orderBy = substr($orderBy, 0, strlen($orderBy) - 5);
					$ordering = $desc;
				}
			}
			
			$orderBy .= $tmp;
			$orderBy .= !empty($ordering) ? $ordering : DEFAULT_GRID_ORDER_BY;
		} else if (!empty( $this->orderByAdvancedFiltering)){
			$orderBy .= $this->orderByAdvancedFiltering;
			$orderBy .= " " . DEFAULT_GRID_ORDER_BY;
		} else if (!empty($orderByDefaultPK) && $orderBy === " ORDER BY ") {			
			$orderBy .=  $orderByDefaultPK;
		} else if ($orderBy === " ORDER BY "){
			$orderBy = "";
		}
		
		return $orderBy;
		
	}
	
	protected function cherryPickingOrderByColumns ($orderBy) {
		
		$addToOrderBy 	= "";
		$tmpArr 		= explode(",", $this->orderByAdvancedFiltering);
		
		for ($i = 0; $i < count($tmpArr); $i++) {			
			if (strpos($orderBy, $tmpArr[$i]) === false ) {
				$addToOrderBy .= ", $tmpArr[$i]"; 
			}			
		}
		return $addToOrderBy;
	}
	
	protected function clearSqlReservedWords($input, $reservedKeyWord, $fromBeginngin = true) {
		
		//$inputLowerCase, $reserverKeyWordLowerCase
		$iL 	= strtolower($input);		
		$rL 	= strtolower($reservedKeyWord);
		$ret 	= "";
				
		//if (strpos($iL, $rL) !== false)  {
		if (preg_match("~\b$rL\b~", $iL)) {
			$pos 			= 0;
			$subStrLength 	= strlen($rL);
			if ($fromBeginngin) {
				$pos = strpos($iL, $rL);
				$ret = substr($input, $pos + $subStrLength, strlen($input));
			} else {
				$pos = strrpos($iL, $rL);
				$ret = substr($input, 0, $pos);
			}
		} else {
			$ret = $input;
		}			
	
	return $ret;
	}
	
	/**
	 * catalogInstanceId
	 * @return string
	 */
	public function getCatalogInstanceId(){
		return $this->catalogInstanceId;
	}
	
	/**
	 * catalogInstanceId
	 * @param string $catalogInstanceId
	 * @return ET_GridSqlHandler
	 */
	public function setCatalogInstanceId($catalogInstanceId){
		$this->catalogInstanceId = $catalogInstanceId;
		return $this;
	}
	
	/**
	 * projectionList
	 * @return string
	 */
	public function getProjectionList(){
		return $this->projectionList;
	}
	
	/**
	 * projectionList
	 * @param string $projectionList
	 * @return ET_GridSqlHandler
	 */
	public function setProjectionList($projectionList){
		$this->projectionList = $projectionList;
		return $this;
	}
	
	
	/**
	 * objectJoin
	 * @return string
	 */
	public function getObjectJoin(){
		return $this->objectJoin;
	}
	
	/**
	 * objectJoin
	 * @param string $objectJoin
	 * @return ET_GridSqlHandler
	 */
	public function setObjectJoin($objectJoin){
		$this->objectJoin = $objectJoin;
		return $this;
	}
	
	/**
	 * objectUnion
	 * @return string
	 */
	public function getObjectUnion(){
		return $this->objectUnion;
	}
	
	/**
	 * objectUnion
	 * @param string $objectUnion
	 * @return ET_GridSqlHandler
	 */
	public function setObjectUnion($objectUnion){
		$this->objectUnion = $objectUnion;
		return $this;
	}
	
	/**
	 * objectGroupBy
	 * @return string
	 */
	public function getObjectGroupBy(){
		return $this->objectGroupBy;
	}
	
	/**
	 * objectGroupBy
	 * @param string $objectGroupBy
	 * @return ET_GridSqlHandler
	 */
	public function setObjectGroupBy($objectGroupBy){
		$this->objectGroupBy = $objectGroupBy;
		return $this;
	}
	
	/**
	 * objectOrder
	 * @return string
	 */
	public function getObjectOrder(){
		return $this->objectOrder;
	}
	
	/**
	 * objectOrder
	 * @param string $objectOrder
	 * @return ET_GridSqlHandler
	 */
	public function setObjectOrder($objectOrder){
		$this->objectOrder = $objectOrder;
		return $this;
	}
	
	public function setEtDataGridSql($sql) {
		$this->etDataGridSql = $sql;
	}
	
	public function getEtDataGridSql() {
		return $this->etDataGridSql;
	}
	
	public function getSqlUntilWherePart() {		
		$wherePos = strpos(strtolower($this->etDataGridSql), "where");
		return trim(substr($this->etDataGridSql, 0, $wherePos));
	}

 

    /**
     * whereObjectFilter
     * @return string
     */
    public function getWhereObjectFilter(){
        return $this->whereObjectFilter;
    }

    /**
     * whereObjectFilter
     * @param string $whereObjectFilter
     * @return ET_GridSql
     */
    public function setWhereObjectFilter($whereObjectFilter){
        $this->whereObjectFilter = $whereObjectFilter;
        return $this;
    }

    /**
     * whereMasterDetail
     * @return string
     */
    public function getWhereMasterDetail(){
        return $this->whereMasterDetail;
    }

    /**
     * whereMasterDetail
     * @param string $whereMasterDetail
     * @return ET_GridSql
     */
    public function setWhereMasterDetail($whereMasterDetail){
        $this->whereMasterDetail = $whereMasterDetail;
        return $this;
    }

    /**
     * whereColumnSearch
     * @return string
     */
    public function getWhereColumnSearch(){
        return $this->whereColumnSearch;
    }

    /**
     * whereColumnSearch
     * @param string $whereColumnSearch
     * @return ET_GridSql
     */
    public function setWhereColumnSearch($whereColumnSearch){
        $this->whereColumnSearch = $whereColumnSearch;
        return $this;
    }

    /**
     * orderByPhpGrid
     * @return string
     */
    public function getOrderByPhpGrid(){
        return $this->orderByPhpGrid;
    }

    /**
     * orderByPhpGrid
     * --------------
     * orderByPhpGrid must be cleared after each request and fill at the beginnig of 
     * data.php and masterdetail.php if needed!!
     * 
     * @param string $orderByPhpGrid
     * @return ET_GridSql
     */
    public function setOrderByPhpGrid($orderByPhpGrid){
        $this->orderByPhpGrid = $orderByPhpGrid;
        return $this;
    }


    /**
     * fullTableName
     * @return string
     */
    public function getFullTableName(){
        return $this->fullTableName;
    }

    /**
     * fullTableName
     * @param string $fullTableName
     * @return ET_GridSql
     */
    public function setFullTableName($fullTableName){
        $this->fullTableName = $fullTableName;
        return $this;
    }


    /**
     * whereSqlFilter
     * @return string
     */
    public function getWhereSqlFilter(){
        return $this->whereSqlFilter;
    }

    /**
     * whereSqlFilter
     * @param string $whereSqlFilter
     * @return ET_GridSql
     */
    public function setWhereSqlFilter($whereSqlFilter){
        $this->whereSqlFilter = $whereSqlFilter;
        return $this;
    }

    /**
     * SQL_RESERVED_GROUP_BY
     * @return string
     */
    public function getSQL_RESERVED_GROUP_BY(){
        return $this->SQL_RESERVED_GROUP_BY;
    }

    /**
     * SQL_RESERVED_GROUP_BY
     * @param string $SQL_RESERVED_GROUP_BY
     * @return ET_GridSql
     */
    public function setSQL_RESERVED_GROUP_BY($SQL_RESERVED_GROUP_BY){
        $this->SQL_RESERVED_GROUP_BY = $SQL_RESERVED_GROUP_BY;
        return $this;
    }
    
    public function setObjectJoinAlias($objectJoinAlias) {
    	$this->objectJoinAlias = $objectJoinAlias;
    	return $this;
    }
    
    public function getObjectJoinAlias() {
    	return $this->objectJoinAlias;
    }


    /**
     * useAdvancedFiltering
     * @return boolean
     */
    public function getUseAdvancedFiltering(){
        return $this->useAdvancedFiltering;
    }

    /**
     * useAdvancedFiltering
     * @param boolean $useAdvancedFiltering
     * @return ET_GridSql
     */
    public function setUseAdvancedFiltering($useAdvancedFiltering){
        $this->useAdvancedFiltering = $useAdvancedFiltering;
        return $this;
    }
    
    public function getWhereAdvancedFilter() {
    	return $this->whereAdvancedFilter;
    }
    
    public function setWhereAdvancedFilter($advancedFilterWherePart) {
    	$this->whereAdvancedFilter = $advancedFilterWherePart;
    }

    public function getWhereAdvancedFilterFilteredTable() {
    	return $this->whereAdvancedFilterFilteredTable;
    }
    
    public function setWhereAdvancedFilterFilteredTable($wherePart) {
    	$this->whereAdvancedFilterFilteredTable = $wherePart;
    }
    
    public function setOrderByAdvancedFiltering ($oderBy) {
    	$this->orderByAdvancedFiltering = $oderBy;
    }
    
    public function getOrderByAdvancedFiltering () {
    	return  $this->orderByAdvancedFiltering;
    }
    
   
    public function setOrderByDefaultPK($oderBy) {
    	$this->orderByDefaultPK= $oderBy;
    }
    
    public function getOrderByDefaultPK() {
    	return  $this->orderByDefaultPK;
    }
    
    /**
     * SQL_RESERVED_ORDER_BY
     * @return string
     */
    public function getSQL_RESERVED_ORDER_BY(){
        return $this->SQL_RESERVED_ORDER_BY;
    }

    /**
     * SQL_RESERVED_ORDER_BY
     * @param string $SQL_RESERVED_ORDER_BY
     * @return ET_GridSql
     */
    public function setSQL_RESERVED_ORDER_BY($SQL_RESERVED_ORDER_BY){
        $this->SQL_RESERVED_ORDER_BY = $SQL_RESERVED_ORDER_BY;
        return $this;
    }

    /**
     * SQL_RESERVED_WHERE
     * @return string
     */
    public function getSQL_RESERVED_WHERE(){
        return $this->SQL_RESERVED_WHERE;
    }

    /**
     * SQL_RESERVED_WHERE
     * @param string $SQL_RESERVED_WHERE
     * @return ET_GridSql
     */
    public function setSQL_RESERVED_WHERE($SQL_RESERVED_WHERE){
        $this->SQL_RESERVED_WHERE = $SQL_RESERVED_WHERE;
        return $this;
    }

    /**
     * SQL_RESERVED_UNION
     * @return string
     */
    public function getSQL_RESERVED_UNION(){
        return $this->SQL_RESERVED_UNION;
    }

    /**
     * SQL_RESERVED_UNION
     * @param string $SQL_RESERVED_UNION
     * @return ET_GridSql
     */
    public function setSQL_RESERVED_UNION($SQL_RESERVED_UNION){
        $this->SQL_RESERVED_UNION = $SQL_RESERVED_UNION;
        return $this;
    }

    /**
     * SQL_RESERVED_ASC
     * @return string
     */
    public function getSQL_RESERVED_ASC(){
        return $this->SQL_RESERVED_ASC;
    }

    /**
     * SQL_RESERVED_ASC
     * @param string $SQL_RESERVED_ASC
     * @return ET_GridSql
     */
    public function setSQL_RESERVED_ASC($SQL_RESERVED_ASC){
        $this->SQL_RESERVED_ASC = $SQL_RESERVED_ASC;
        return $this;
    }

    /**
     * SQL_RESERVED_DESC
     * @return string
     */
    public function getSQL_RESERVED_DESC(){
        return $this->SQL_RESERVED_DESC;
    }

    /**
     * SQL_RESERVED_DESC
     * @param string $SQL_RESERVED_DESC
     * @return ET_GridSql
     */
    public function setSQL_RESERVED_DESC($SQL_RESERVED_DESC){
        $this->SQL_RESERVED_DESC = $SQL_RESERVED_DESC;
        return $this;
    }
    
}

?>