<?php

class ET_HTMLGenerator{
	
	/***
	 * IMPORTANT: the display text has to be displayText=>"string value" in the array!
	 * @param arrray $optionData -> associative array for the raw data of the options. eg.: name=>optionname, value=>optionValue
	 * @param string $firstLine -> the first, unselectable line of the  option. Eg.: -- select object -- 
	 */
	public function generateAndPrintOptions($optionData, $firstLine = "", $onlyReturn = false){
		
		$resultOptions = "";
		
		if($firstLine !== ""){
			$firstOption = new HTMLBase("option");
			$firstOption->getset_name('---')->getset_value('---');
			$resultOptions .= $firstOption->printOpeningTag(true) . $firstLine . $firstOption->printClosingTag(true);
		}
			
		for($i = 0; $i < count($optionData); $i++){
			
			$currentOption 	= new HTMLBase("option");
			$displayText 	= "";
			
			foreach($optionData[$i] as $key => $value){
				
				switch ($key){
					case "name":
						$currentOption->setname($value);
						break;
					case "value":
						$currentOption->setvalue($value);
						break;
					case "class":
						$currentOption->setclass($value);
						break;
					case "id":
						$currentOption->setid($value);
						break;
					case "selected":
						$currentOption->setselected($value);
						break;
					case "displayText":
						$displayText = $value;
						break;
				}	
			}
			$resultOptions .= $currentOption->printOpeningTag(true) . $displayText . $currentOption->printClosingTag(true);
		}
		if (!$onlyReturn)
			echo $resultOptions;
		
		return $resultOptions;
	}
	
	
}