<?php

	class ET_LDAPSAuthentication {
		/*connection*/
		private $host 		 	= "";
		private $port 		 	= "";
		
		/*user authentication*/
		private $definitionDn = ET_LDAP_AUTHENTICATION['PHPGRID_DB_DN'];
		private $user 		 	= "";		
		private $dn			 	= "";
		//$dn input format:
		//uid=test2,ou=test_ou,dc=troja,dc=etixpert,dc=com
		private $ou 			 = null;		
				
		private $ldapConn 	 	= null;		
		public $loginSuccess 	= null;
		private $ldaps			= false;
		
		private $connectionError	= false;
		
		public function __construct(){			
			
			try {
				$this->ldapConn = ET_ConnHelper::getLDAPconnection();
			} catch (Exception $e) {
				ET_DisplayHelper::addErrorLine($e->getMessage(), "login");
				$this->connectionError = true;
				return;
			}
				
			/*
			if (isset( ET_LDAP_AUTHENTICATION['PHPGRID_DB_OU']))
				$this->ou = ET_LDAP_AUTHENTICATION['PHPGRID_DB_OU'];
			
			if (isset(ET_LDAP_AUTHENTICATION['PHPGRID_LDAP_SSL'])) {
				$this->ldaps = ET_LDAP_AUTHENTICATION['PHPGRID_LDAP_SSL'];
			}
			*/
		}
		
		/***
		 * 
		 * @param string $username
		 * @param string $password
		 * @return boolean true if authentication is succeeeded thervise false
		 */
		function makeLDAPSlogin($username, $password){
						
			$isUserNameOk 	= ET_StringCheck::checkForSpecChars($username);
			
			$bind			= false;
			if ($isUserNameOk) {			
				
				ldap_set_option($this->ldapConn, LDAP_OPT_PROTOCOL_VERSION, 3);
				ldap_set_option($this->ldapConn, LDAP_OPT_REFERRALS, 0);		
							
				//ldap_set_option(null, LDAP_OPT_DEBUG_LEVEL, 7); 
				
				$this->user  = "uid=".$username;	//it might be "uid=....."
				//$this->user  = "cn=".$username;	//it might be "uid=....."
				
				if (is_null($this->ou))
					$this->dn	 = $this->user . "," . $this->definitionDn;
				else
					$this->dn	 = $this->user . $this->ou . "," . $this->definitionDn;
				
				ldap_set_option($this->ldapConn, LDAP_OPT_DEBUG_LEVEL, 7);
				
				try {
					$bind = $this->makeLdapBind($password);
				} catch (Exception $e) {
					throw new Exception($e->getMessage());
				}	
				
				if (!$bind) {
					if (ldap_errno($this->ldapConn) == 49) {
						throw new Exception("invalid user credentials for LDAP login");
					}
					else if (ldap_errno($this->ldapConn) == -1) {
						$this->connectionError = true;
						throw new Exception("LDAP connection error");
					} else {
						throw new Exception("LDAP error");
					}
				}
			}
			
			ldap_close($this->ldapConn);
			return $bind;
			
		}
		
		public function isConnectionError() {
			return $this->connectionError;
		}
		
		private function makeLdapBind ($password) {
			
			$bind = ldap_bind($this->ldapConn, $this->dn, $password);
			
			if ($bind){
				$this->loginSuccess = true;
			}
			else{
				$this->loginSuccess = false;
			}
			return $bind;
		}
		
	}
	
	
	
	
	