<?php

	class ET_LoggingInfo {
		protected $loggingSettings = array();
		
		public function addLogSetting($connName, $logfileName, $callableObjectName) {
			$logSetting = array();
			$logSetting['logfileName'] 			= $logfileName;
			$logSetting['callableObjectName'] 	= $callableObjectName;
			
			$this->loggingSettings[$connName] = $logSetting;
		}

		public function clearLogSettings() {
			$this->loggingSettings = array();
		}
		
		public function getLogSetting($connName) {
			if (isset($this->loggingSettings[$connName]))
				return $this->loggingSettings[$connName];
			return false;
		}
	}

	class ET_LoggingHelper {
		protected static function getLoggingInfo() {
			if (isset($_SESSION[SESS_LOGGING_SETTINGS]))
				return unserialize($_SESSION[SESS_LOGGING_SETTINGS]);
			return null;
		}
		
		public static function setLogInfo($logSettings, $adminPage = false) {
			
			$loggingInfo = self::getLoggingInfo();
			
			if (is_null($loggingInfo))
				$loggingInfo = new ET_LoggingInfo();
			
			$loggingInfo->clearLogSettings();
			
			for ($i = 0; $i < count($logSettings); $i++) {
				
				$logSetting = $logSettings[$i];
				
				$resolvedFileName = self::resolveLogfileName($logSetting['filename_log'], $adminPage);
				$loggingInfo->addLogSetting($logSetting['conn_name'], $resolvedFileName, $logSetting['callable_object']);	
			}
			self::flushLoggingInfo($loggingInfo);
		}
		
		protected static function resolveLogfileName($logfileName, $adminPage = false) {
			
			if (is_null($logfileName) || empty($logfileName)) return $logfileName;
			
			$catalogInstanceId = ET_CallableObjectHelper::getCatalogInstanceId($adminPage);
			//$catalogInstanceId = $adminPage ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] : $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
			$tableName 	= "_";
			$connName 	= "_";
			
			if (!ET_DisplayHelper::is_blank($catalogInstanceId)) {
				$browsingStore	= ET_BrowsingStore::getBrowsingStore();
				$connName 		= $browsingStore->get_connName($catalogInstanceId);				
				$fullTableName 	= $browsingStore->get_fullTableName($catalogInstanceId);
				$tableName 		= ET_CatalogInstance::getTableNameFromFullyQualifiedForm($fullTableName);
			}
						
			$logfileName = str_replace('$date', date("Y-m-d"), $logfileName);
			$logfileName = str_replace('$domain', $connName, $logfileName);
			$logfileName = str_replace('$tableName', $tableName, $logfileName);
			
			return $logfileName;
		}
		
		public static function flushLoggingInfo($loggingInfo) {
			$_SESSION[SESS_LOGGING_SETTINGS] = serialize($loggingInfo);
		}
		
		public static function getLogToFile($connName) {
			
			$logSetting = self::getLoggingInfo()->getLogSetting($connName);			
			if ($logSetting == FALSE) return null;
			$logFileName = $logSetting['logfileName'];
			return !(is_null($logFileName) || empty($logFileName)) ? $logFileName : null;
		}

		public static function getLogToDb($connName) {
			$logSetting = self::getLoggingInfo()->getLogSetting($connName);
			if ($logSetting == FALSE) return null;
			$logDB = $logSetting['callableObjectName'];
			return !(is_null($logDB) || empty($logDB)) ? $logDB : null;
		}
		
		public static function log($connName, $sqlCrud, $actionCode, $forceLogToFile = false) {
			
			
			$logfilename 	= ET_LoggingHelper::getLogToFile($connName);			
			$callableObject = ET_LoggingHelper::getLogToDb($connName);
			
			$filePath		= "";
			$folderPathLog	= self::getLogFolderPath();
						
			
			if (!is_null($logfilename)) {
				if ($actionCode == LOGGING_SOURCE_EXCEL_EXPORT || $actionCode == LOGGING_SOURCE_EXCEL_IMPORT) {
					if (!self::isLoggingExcelExportImportToFileAllowed() && !$forceLogToFile)
						return;
				}
				
				$filePath = $folderPathLog . $logfilename;
				
				if (!file_put_contents($filePath, date("Y-m-d H:i:s") . "\t" . $_SESSION[SESS_USERNAME] . "\t$actionCode\t" . $sqlCrud . LOGFILE_LINE_SEPARATOR, FILE_APPEND)) {
					throw new Exception('PHPGRID_ERROR: Logfile error');
				} 
			}
			
			if (!is_null($callableObject)) {
				
				if ($actionCode == LOGGING_SOURCE_EXCEL_EXPORT || $actionCode == LOGGING_SOURCE_EXCEL_IMPORT) {
					if (!self::isLoggingExcelExportImportThroughConnectionAllowed()) {
						return;
					}		
				}
				
				if (!ET_CallableObjectHelper::callLoggingToDB($callableObject, $sqlCrud, $actionCode)) {					
					throw new Exception('PHPGRID_ERROR: Logging connection error');					
				}
				
			}
		}
		
		public static function isLoggingExcelExportImportToFileAllowed() {
			$ret = true;
			if (defined('LOG_EXCEL_EXPORT_IMPORT_TO_FILE'))
				return LOG_EXCEL_EXPORT_IMPORT_TO_FILE;
			return $ret;
		}
		
		public static function isLoggingExcelExportImportThroughConnectionAllowed() {
			$ret = false;
			
			if (defined('LOG_EXCEL_EXPORT_IMPORT_THROUGH_CONNECTION')) {				
				return LOG_EXCEL_EXPORT_IMPORT_THROUGH_CONNECTION;
			}
			
			return $ret;
		}
		
		public static function getLogFolderPath () {
			
			$clientName		= isset($_SESSION[SESS_CLIENT]) ? $_SESSION[SESS_CLIENT] : CLIENT_SYSTEM;
			
			if ($clientName != CLIENT_SYSTEM && isset($_SESSION[SESS_CLIENT_FOLDER_PATH])) {
				$folderPath	= $_SESSION[SESS_CLIENT_FOLDER_PATH] . "/";
			} else {
				$folderPath = __DIR__ . "/../../";
			}
			
			$folderPathLog 	= $folderPath . "log/";
			
			if (!file_exists($folderPathLog)) {
				
				$old = umask(0);
				mkdir($folderPathLog,0770);
				umask($old);			
				
			}
			
			return $folderPathLog;
			
		}		
		
	}


?>