<?php

/*
 * Class to handle error and debug logging.
 * Useraction logging is made by ET_LoggingHelper
 * */
class ET_LoggingHelperSystem {
    
    var $niotaVersion;
    var $phpVerison;
    var $installationName;
    var $type;
    
    public function __construct() {
        
        $this->niotaVersion       = VERSION;
        $this->phpVerison         = PHP_VERSION;
        $this->installationName   = INSTALLATION_NAME;         
    }
    
    public function addSystemLogEntry ($type, $message, $logLevel = null) {
        
        $newContent     = "";
        $userName       = isset($_SESSION['username']) ? $_SESSION['username'] : USERNAME_NOT_LOGGED_IN;
        $filePath		= "";        
        $folderPath		= "";
        $targetFile     = $type . ".log";
        
        //that part is one line in Java:
        //starts:
        $time           = microtime(true);        
        $milliseconds   = $time - floor($time);        
        $milliseconds   = substr($milliseconds, 1);        
        $timestamp      = sprintf('%s%s', date('Y-m-d H:i:s'), $milliseconds);
        //ends        
                
        $folderPathLog 	= ET_LoggingHelper::getLogFolderPath();                
        $filePath 		= $folderPathLog . $targetFile;
                
        $this->checkAndCreateLogFile($filePath);
        $newContent .= "[user: $userName] [time: $timestamp]";
        $newContent .= !is_null($logLevel) ? " [log level: $logLevel] [message: $message]" : " [message: $message]";
        $newContent .= "\n";
        
        file_put_contents($filePath, $newContent, FILE_APPEND);
    }
    
    public function addSystemPlainText ($type, $message, $logLevel = null) {
    	
    	$newContent     = "";
    	$userName       = $_SESSION['username'];
    	$filePath		= "";
    	$folderPath		= "";
    	$targetFile     = $type . ".log";
    	
    	$folderPathLog 	= ET_LoggingHelper::getLogFolderPath();
    	$filePath 		= $folderPathLog . $targetFile;
    	
    	$this->checkAndCreateLogFile($filePath);
    	$newContent .= "[user: $userName]";
    	$newContent .= $message;
    	$newContent .= "\n";
    	
    	file_put_contents($filePath, $newContent, FILE_APPEND);
    }
    
    public function setGridDebugEyeCacher($catalogInstanceId) {
    	return PHP_EOL . ET_DisplayHelper::localize("DEBUG_SECTION_START", array($catalogInstanceId));    	
    }
    
    private function checkAndCreateLogFile ($path) {
        
        if (!file_exists($path)) {
            file_put_contents($path, self::getHeaderInfo());
        }
        
    }
    
    private function getHeaderInfo () {
        
        $ret = "";
        
        $ret .= "Niota version:\t" . $this->niotaVersion . "\n";
        $ret .= "Php version:\t" . $this->phpVerison . "\n";
        $ret .= "Installation:\t" . $this->installationName. "\n\n";
        
        return $ret;
        
    }
    
    
    
}

