<?php
/***
 * SIMPLE FACTORY FOR LOOKUPS
 */
class ET_LookupFactory {
	
	
	/***
	 * 
	 * @param string $catalogId
	 * @param string $instanceName 
	 * @param array $lookupSettings
	 * @return NULL|ET_CascadingLookupInstance|ET_LookupInstance
	 */
	public static function createLookupInstance ($lookupSettings) {
		
		$lookupInstance = null;
		
		//general lookup settings:
		$catalogId 			= $lookupSettings['catalogId'];
		$instanceName 		= $lookupSettings['instanceName'];
		//$type				= $lookupSettings['type'];
		$useExtendedLookup	= $lookupSettings['useExtendedDef'];
		$addNullItem		= $lookupSettings['addNullItem'];		
		$type				= '0';
		
		if ($useExtendedLookup) {
			
			// lookup type can be found out by the type of extended lookup
			$extendedLookupName = $lookupSettings['extendedLookup'];
			$type 				= ET_MetaDataConnector::getInstance()->getLookupType($extendedLookupName);
			 
			// if we have other types - 'else if' blocks will be defined
			if ($type == LOOKUP_TYPE_CASCADING && $useExtendedLookup) {				
				$lookupInstance = new ET_CascadingLookupInstance($lookupSettings);
			} else {				
				ET_DisplayHelper::addErrorLine("lookup config error", "niota");
				return;
			}			
		} else {
			//I do do not wnat to midofy ET_LookupInstance constructor bcs it is used in other features - validation, import...
			$lookupInstance = new ET_LookupInstance($catalogId, $instanceName, $addNullItem, LOOKUP_TYPE_STANDARD, $useExtendedLookup);
		}
		
		/*
		if ($type == LOOKUP_TYPE_CASCADING && $useExtendedLookup) {
			$lookupInstance = new ET_CascadingLookupInstance($lookupSettings);
		} else {
			//I do do not wnat to midofy ET_LookupInstance constructor bcs it is used in other features - validation, import...
			$lookupInstance = new ET_LookupInstance($catalogId, $instanceName, $addNullItem, LOOKUP_TYPE_STANDARD, $useExtendedLookup); 
		}
		*/
		return $lookupInstance;
		
	}
	
	
	
}
?>