<?php
	class ET_LookupInstance extends ET_CatalogInstance {
		
		protected $type;
		protected $useExtendedLookup;
		protected $addNullItem;
		
		public function __construct($catalogId, $instanceName, $addNullItem, $type = "", $useExtendedLookup = false) {
			
			$this->metaDataConnector = ET_MetaDataConnector::getInstance();			
			$this->catalogId = $catalogId;
			$this->instanceName = $instanceName;			
			$this->catalogInstanceId = $this->catalogId . "." . $this->instanceName;
			
			$this->type 				= $type == "" ? LOOKUP_TYPE_STANDARD : $type;
			$this->useExtendedLookup 	= $useExtendedLookup;
			$this->addNullItem			= $addNullItem;
			
			
			$this->initializeProperties($catalogId, $instanceName);
			$this->fillLookups();
				
			$projection = $this->isActiveProjList ? $this->projectionList : null;
			$filter 	= $this->isActiveObjectfilter ? $this->objectFilter : null;
			$objectjoin	= $this->isActiveObjectjoin ? $this->objectjoin : null;
			$union		= $this->isAcitveObjectunion ? $this->objectunion : null;
			$orderBy	= $this->isActiveObjectorder ? $this->objectorder : null;
			$groupBy	= $this->isActiveObjectgroupby ? $this->objectgroupby : null;
			
			$br = ET_BrowsingStore::getBrowsingStore();
			
			if ( !isset($br->getBrowsingStates[$this->catalogInstanceId])) {
				$br->create_browsingState($this->catalogInstanceId);
				$br->flushBrowsingStore();
				$br = ET_BrowsingStore::getBrowsingStore();
			} else {
				//do nothing
			}
			
			$dbName 		= ET_ConnHelper::getDbNameByConnectionName($this->connName);
			$fullTableName 	= $dbName . "." . $this->object;
			$br->set_connName($this->catalogInstanceId, $this->connName);
			$br->set_fullTableName($this->catalogInstanceId, $fullTableName);
			$br->flushBrowsingStore();
						
			$tmpArr		= array();
			parent::fillPredefinedPrimaryKeys($catalogId);
			try{				
				$tmpArr 	= ET_MetaDataConnector::getInstance()->getCatalogMetaDataInfo ($this->connName, 
																							$this->catalogInstanceId, 
																							$this->object, 
																							$this->predefinedPrimaryKeys, 
																							$projection, 
																							$objectjoin, 
																							$filter, 
																							FALSE, 
																							1, 
																							false,
																							$union,
																							$orderBy,
																							$groupBy);	
			}catch (Exception $e) {
				ET_DisplayHelper::addErrorLine($e->getMessage(), "niota");
				$this->error = $e->getMessage();				
				return;
			}
			
			if ($tmpArr === FALSE) {
				$pageType = $this->connName == ET_METADATA_CONNECTION ? PAGE_TYPE_SYSTEM : PAGE_TYPE_GRID;
				die(localize("NO_PRIMARY_KEY_OF_THIS_TABLE", null, $pageType));
			}
					
			if ( !isset($br->getBrowsingStates[$this->catalogInstanceId])) {
				//$br->create_browsingState($gridIdentifier);
				$br->create_browsingState($this->catalogInstanceId);
				$br->flushBrowsingStore();
				$br = ET_BrowsingStore::getBrowsingStore();
			} else {
				//do nothing
			}
			$br->set_connName($this->catalogInstanceId, $this->connName);
			$br->set_fullTableName($this->catalogInstanceId, $tmpArr['full_table_name']);
			$br->flushBrowsingStore();
			
			$this->primaryKeys 	= $tmpArr['primary_keys'];
			$this->columnInfo 	= $tmpArr['column_info'];
			
			$this->SQLForGrid = ET_MetaDataConnector::getInstance()->substituteSQLQuery($tmpArr['sql_for_datagrid'], $this->catalogInstanceId);
			
		}
		
		
		public function get_ConnName() {			
			return $this->connName;
		}
		
		public function get_LookupSql() {
			
			return $this->SQLForGrid;
		}
		
		public function getType() {
			return  $this->type;
		}
		
		public function isExtendedLookupInUse () {
			return $this->useExtendedLookup;
		}
		
		public function getAddNullItem() {
			return $this->addNullItem;
		}
		
		protected function setQueryObjectIntoSession($logicalLink = "", $useAdvancedFiltering = false, $columnInfo = array(), $defaultOrderBy = "") {
			//lookup instance does not need to pass the sql parts to data.php or masterdetail.php
			//so this function is blank that case
		}
	}