<?php

	class ET_MessageHelper {
		
		public static function getMessage ($connName, &$ret, $isAdminGrid) {
			
			
			$res = array();
			
			$guid						= $ret[CO_MESSAGE_GUID];
			$ret[CO_MESSAGE_CONN_NAME]	= $connName;
			$stopCallableExecution		= false;
			
			$connMsgName 	= ET_MetaDataConnector::getInstance()->getMessageConnectionName($connName);
			$fullDbName 	= ET_ConnHelper::getfullDbName($connMsgName);
			$sqlGetMessage 	= "select * from " . $fullDbName . "." . T_MESSAGE . " where " . COL_MESSAGE_GUID . " = '%guid%'";		
			$connMsg 		= ET_ConnHelper::getConnection($connMsgName);
			$pageType		= ET_DisplayHelper::detectPageType($isAdminGrid);
			
			
			$sql = str_replace("%guid%", $guid, $sqlGetMessage);
			
			$connMsg->SetFetchMode(ADODB_FETCH_ASSOC);
			
			$res = $connMsg->Execute($sql);
			
			if ($connMsg->_connectionID === false){
				//uncomment, if you want this: if there was a connection error before, we do not duplicate error messages
				//if ($ret[CO_EXECUTION_ERROR] == false) {
					ET_CallableObjectHelper::addMessage($ret, ET_DisplayHelper::localize("CO_MSG_CONN_ERROR", null, $pageType), CO_MESSAGE_TYPE_ERROR_SYSTEM);
					
				//}
				return;
			} else if ($res === FALSE) {
				ET_CallableObjectHelper::addMessage($ret, ET_DisplayHelper::localize("CO_MSG_ERROR_SQL", array($sql), $pageType), CO_MESSAGE_TYPE_ERROR_SYSTEM);	
				//echo $connMsg->errorMsg();
				return;
			}
			
			$ra = $res->NumRows();
				
			if ($ra == 0) {
				ET_CallableObjectHelper::addMessage($ret, ET_DisplayHelper::localize("CO_MSG_WARNING_NO_MSG", array($guid), $pageType), CO_MESSAGE_TYPE_WARNING);
				return;
			}

			while ($row = $res->fetchRow()) {
				$row 	= ET_MetaDataConnector::getInstance()->arrayKeysToLower($row);
				$text 	= "";
				
				if (!$stopCallableExecution)
					$stopCallableExecution = $row[COL_STOP_MESSAGE] ? true : false;
				
				if (!empty($connName))  {
					$text = ET_StringCheck::convertToUTF8($row[COL_MESSAGE], $connName);
				}
				ET_CallableObjectHelper::addMessage($ret, $text, $row[COL_MESSAGE_TYPE]);
			}
			
			$ret[CO_MESSAGE_STOPPED]	= $stopCallableExecution;
			$ret[CO_MESSAGE_RECEIVED]	= TRUE;			
			self::setUITimestamp($ret, $connMsg, $pageType);
			
		}
		
		public static function setUITimestamp($coResult, $connMsg, $pageType) {
			
			$msgConnName = $coResult[CO_MESSAGE_CONN_NAME];
			$msgGuid = $coResult[CO_MESSAGE_GUID];
			
			// if - by accident - it was not an active messaging call
			if (empty($msgGuid)) return;
			
			$msgConnType = ET_ConnHelper::getConnectionTypeByName($msgConnName);
			$sql 		= "update " . T_MESSAGE . " set " . COL_UI_TIMESTAMP . " = %timestamp_function% where " . COL_MESSAGE_GUID . " = '$msgGuid'";
			
			if ($msgConnType == DB_TYPE_MYSQLI) {
				$sql = str_replace('%timestamp_function%', 'CURRENT_TIMESTAMP()', $sql);
			}
			else {
				$sql = str_replace('%timestamp_function%', 'CURRENT_TIMESTAMP', $sql);
			}
			
			$connMsg->SetFetchMode(ADODB_FETCH_ASSOC);
			
			$res = $connMsg->Execute($sql);

			if ($res === FALSE) {
				ET_CallableObjectHelper::addMessage($coResult, ET_DisplayHelper::localize("CO_MSG_ERROR_SET_TIMESTAMP", null, $pageType), CO_MESSAGE_TYPE_ERROR_SYSTEM);
			}
			//$affectedRows = $connMsg->affected_rows();
		}
				
		/***
		 * $messages -> numbered array whitch contains key value paris [CO_MESSAGE_TYPE =>"", CO_MESSAGE_TEXT => ""] on each index
		 * 
		 * returns HTML code of the whole message
		 */
		public static function processMessageLines ($messages, $connName = "", $isAdminPage) {
			
			$ret 		= array();
			$msgs 		= "";
			$headerMsgs	= "";
			$rowNum 	= count($messages);
			$customMsgNum = 0;
			$numInfo 	= 0;
			$numWarning = 0;			
			$numError 	= 0;
			$numFailure = 0;
			$numMisc	= 0;
			
			$pageType = ET_DisplayHelper::detectPageType($isAdminPage);
			
			for ($i = 0; $i < $rowNum; $i++) {
				
				$spanMsg	= new HTMLSpan();
				$iconMsg	= new HTMLImage();
				$divMsgLine = new HTMLDiv();
				
				$msgLine 	= $messages[$i];
				$type		= strtolower($msgLine[CO_MESSAGE_TYPE]);
				$text		= $msgLine[CO_MESSAGE_TEXT];
				
				switch ($type) {
					case CO_MESSAGE_TYPE_INFO :
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/co_msg_inf.png");
						$numInfo++;
						break;
					case CO_MESSAGE_TYPE_WARNING :
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/co_msg_wrn.png");
						$numWarning++;
						break;					
					case CO_MESSAGE_TYPE_SUCCESS :						
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/success.png");						
						break;
					case CO_MESSAGE_TYPE_ERROR :						
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/co_msg_err.png");
						$numError++;
						break;
					case CO_MESSAGE_TYPE_FAILURE :
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/unsuccess.png");
						$numFailure++;
						break;		
					case CO_MESSAGE_TYPE_SUCCESS_SYSTEM :
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/success.png");
						break;
					case CO_MESSAGE_TYPE_FAILURE_SYSTEM :
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/unsuccess.png");						
						break;		
					case CO_MESSAGE_TYPE_WARNING_SYSTEM : 
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/unsuccess.png");
						break;
					case CO_MESSAGE_TYPE_ERROR_SYSTEM : 
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/unsuccess.png");						
						break;
					default:
						$iconMsg->set_src(NIOTA_ROOT_DIR . "/etixpert/images/co_msg_msc.png");
						$numMisc++;
						
				}
				
				$divMsgLine->set_class("co-message-div vertical-middle-content");
				$iconMsg->set_class("float-left element-inline margin-right-5px");
				$spanMsg->set_class("element-inline");
				$spanMsg->set_display_text($text);
				
				if (in_array($type, CO_MESSAGE_TYPE_ARRAY_SYSTEM)) {
					$headerMsgs.= self::setUpMessageLine($divMsgLine, $iconMsg, $spanMsg);
				}
				else {
					$msgs .= self::setUpMessageLine($divMsgLine, $iconMsg, $spanMsg);
				}
				
			}
			
			$customMsgNum = $numInfo + $numError + $numWarning + $numMisc;
			
			if ($customMsgNum > DISPLAY_CALLABLE_MESSAGE_SUMMARY) {
				
				$divMsgLine->set_class("co-message-div vertical-middle-content co-summary");				
				$spanMsg->set_class("element-inline");
				$spanMsg->set_display_text(ET_DisplayHelper::localize("CO_MESSAGE_SUMMARY", array($numError, $numWarning, $numInfo, $numMisc), $pageType));
				$headerMsgs .= self::setUpMessageLine($divMsgLine, null, $spanMsg);
			}
			
			$ret['messages'] 	= $msgs;
			$ret['header']		= $headerMsgs;			
			return $ret;			
		}

		
		/**
		 *
		 * @param array $rets -> chain return array
		 */
		public static function mergeSubstitutionsAndGridHandling ($rets) {
			
			$allMessages 		= array();
			$substitutionObjs 	= array();			
			$processedRows 		= 0;
			$execError 			= false;
			$reloadGrid 		= false;
			
			for ($i = 0; $i < count($rets); $i++) {
				
				$actRet			 	= $rets[$i];				
				$actSubstitutionObj = $actRet[CO_SUBSTITUTION_VARS];
				$coName				= $actSubstitutionObj->getName();
			
				
				array_push($substitutionObjs, $actSubstitutionObj);
				
				if (isset($actRet[CO_RELOAD_GRID])) {
					$actReloadGrid = $actRet[CO_RELOAD_GRID];
					if ($actReloadGrid)
						$reloadGrid = true;
				}
				
				if (isset($actRet[CO_LINE_LEVEL_PROCESSED_ROWS])) {
					$actProcessedRows = $actRet[CO_LINE_LEVEL_PROCESSED_ROWS];
					$processedRows += $actProcessedRows;
				}
			}
			
			$ret[CO_SUBSTITUTION_VARS] 			= $substitutionObjs;						
			$ret[CO_LINE_LEVEL_PROCESSED_ROWS] 	= $processedRows;
			$ret[CO_RELOAD_GRID]				= $reloadGrid;
			
			return $ret;
		}
			
		
		
		/**
		 * 
		 * @param array $rets -> chain return array
		 */
		public static function mergeMessages ($rets) {
			
			$allMessages 		= array();
			$substitutionObjs 	= array();
			
			$processedRows = 0;
			$execError = false;
			$reloadGrid = false;
			
			
			for ($i = 0; $i < count($rets); $i++) {
				
				$actRet = $rets[$i];
				$messageArr = $actRet[CO_MESSAGES];
				$actSubstitutionObj = $actRet[CO_SUBSTITUTION_VARS];

				array_push($substitutionObjs, $actSubstitutionObj);
				
				if ($i === 0) {
					$allMessages = $messageArr;
				}
				else {					
					$allMessages = array_merge($allMessages, $messageArr);
				}
				
				if (isset($actRet[CO_LINE_LEVEL_PROCESSED_ROWS])) {
					$actProcessedRows = $actRet[CO_LINE_LEVEL_PROCESSED_ROWS];
					$processedRows += $actProcessedRows;
				}
				if (isset($actRet[CO_RELOAD_GRID])) {
					$actReloadGrid = $actRet[CO_RELOAD_GRID];
					if ($actReloadGrid)
						$reloadGrid = true;
				}
				if (isset($actRet[CO_EXECUTION_ERROR])) {
					$actExecutionError = $actRet[CO_EXECUTION_ERROR];
					if ($actExecutionError)
						$execError = true;
				}
				
			}
			
			$ret = array();
			
			$ret[CO_SUBSTITUTION_VARS] 			= $substitutionObjs;
			$ret[CO_CONN_NAME] 					= "MySQL_meta";
			$ret[CO_MESSAGES] 					= $allMessages;
			$ret[CO_LINE_LEVEL_PROCESSED_ROWS] 	= $processedRows;
			$ret[CO_RELOAD_GRID] 				= $reloadGrid;
			$ret[CO_EXECUTION_ERROR] 			= $execError;
			$ret[CO_MESSAGE_CONN_NAME] 			= "MySQL_meta";
			//ET_DisplayHelper::vardumpHighlighPretty($ret);
			return $ret;
		}
		
		protected static function setUpMessageLine ($divMsgLine, $iconMsg, $spanMsg) {
			
			$ret = $divMsgLine->printOpeningTag(true);
			
			if (!empty($iconMsg))
				$ret .= $iconMsg->printOpeningTag(true);
			
			$ret .= $spanMsg->printOpeningTag(true) .
					$spanMsg->printDisplayText(true).
					$spanMsg->printClosingTag(true).
					$divMsgLine->printClosingTag(true);
			
			return $ret;
		}
		
		
		
		
		
		
	}