<?php

class ET_MetaDataConnector {
		
	protected $conn 			= null;	
	protected $metaConnType		= "";
	protected $metaConnName		= "";
	
	protected $v_user; 
	protected $v_obj; 
	protected $v_obj_access;
	protected $v_obj_instance;
	protected $v_usergroup;
	protected $v_usergroup_member;
	protected $v_catalog_object_col_prop; 
	protected $v_lookup;
	protected $v_constraint;
	protected $v_callable_access;
	protected $v_callable_object;
	protected $v_callable_object_sequence;
	protected $v_catalog_object_callable;
	protected $v_master_detail;
	protected $v_master_detail_link;
	protected $v_transaction;
	protected $v_transaction_access; 
	protected $v_transaction_menu; 
	protected $v_transaction_parameter_set; 
	protected $v_logging;
	protected $v_user_parameter;
	protected $v_connection;	
	
	protected $t_user;
	protected $t_user_parameter;
	protected $t_catalog_object_config;
	
	protected $SQLcheckUserActive;
	protected $SQLuserGroup;
	protected $SQLvisibleCatalogInstances;
	protected $SQLuserRights;
	protected $SQLuserInfo;
	protected $SQLbasicAuthenticationData;
	protected $SQLinstanceInfo;
	protected $SQLlookupInfo;
	protected $SQLconstraintInfo;
	protected $SQLcallableAccessInfoForCatalog;
	protected $SQLmasterDetail;
	protected $SQLfilterMappings;
	protected $SQLmenuChildren; 
	protected $SQLtransaction; 
	protected $SQLcallableObjects;
	protected $SQLcallableSequence;
	protected $SQLupdatePassword;
	protected $SQLupdatePersonalData;
	protected $SQLlogging;
	protected $SQLcatalogPrimaryKeys;
	protected $SQLuserParametersUserLevel;
	protected $SQLuserParametersCatalogLevel;
	protected $SQLuserParametersColumnLevel;	
	protected $SQLsaveUserParameter;
	protected $SQLdeleteUserParameter;
	protected $SQLuserConfig;
	protected $SQLfindPossiblyExistingParameterCatalog;
	protected $SQLfindPossiblyExistingParameterUser;
	protected $SQLfindDefaultCatalogInstanceId;
	protected $SQLgetMessageConnection;
	protected $SQLnologUpoad;
	protected $SQLvalidationSettingsForCatalog;
	protected $SQLGroupByAndOrderByForCatalog;
	protected $SQLLanguageOptions;
	
	protected $SQLLookupCatalogInstanceIdByName;
	protected $SQLLookupNullable;
	protected $SQLLookupType;
	
	protected $SQLFilterInstanceFortransactionAdvancedFilter;
	
	protected $SQLSaveRegistrationData;
	protected $SQLCheckExisitngEmail;
	protected $SQLCheckExisitngUserName;
	protected $SQLActivationData;
	protected $SQLAcitvateUser;
	protected $SQLGetUserDataByEmail;
	
	public static function getInstance() {
		static $instance = null;
		if (is_null($instance)) {			
			$instance = new ET_MetaDataConnector();
		}
		
		return $instance;
	}
	
	/***
	 * 
	 * @param object $conn -> db connection to run queries against
	 */
	protected function __construct() {
		
		$this->metaConnName = ET_ConnHelper::getMetaDataConnectionName();
		$this->metaConnType = ET_ConnHelper::getConnectionTypeByName($this->metaConnName);
		$this->conn = ET_ConnHelper::getConnection($this->metaConnName);
		
		if ($this->conn == false)
			throw new ET_NiotaException(ET_DisplayHelper::localize('ERROR_LOGIN_CONN_OR_SQL', array($this->metaConnName)));
		
		$this->v_user 						= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USER, $this->metaConnName, false);
		$this->v_obj 						= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CATALOGOBJECT, $this->metaConnName, false);
		$this->v_obj_access 				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CATOBJACCESS, $this->metaConnName, false);
		$this->v_obj_instance				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CATALOGOBJECTINST, $this->metaConnName, false);
		$this->v_usergroup					= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERGROUP, $this->metaConnName, false);
		$this->v_usergroup_member 			= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERGROUPMEMB, $this->metaConnName, false);
		$this->v_catalog_object_col_prop 	= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CATALOGOBJCOLPROP, $this->metaConnName, false);
		$this->v_lookup 					= ET_SysTableHandler::getSpecificTableOrViewFullName(T_LOOKUP, $this->metaConnName, false);
		$this->v_constraint 				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CONSTRAINT, $this->metaConnName, false);
		$this->v_callable_access 			= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CALLABLEACC, $this->metaConnName, false);
		$this->v_callable_object 			= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CALLABLEOBJ, $this->metaConnName, false);
		$this->v_callable_object_sequence	= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CALLABLEOBJSEQ, $this->metaConnName, false);
		$this->v_catalog_object_callable 	= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CATALOGOBJCALLABLE, $this->metaConnName, false);
		$this->v_master_detail 				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_MASTERDETAIL, $this->metaConnName, false);
		$this->v_master_detail_link			= ET_SysTableHandler::getSpecificTableOrViewFullName(T_MASTERDETAILLINK, $this->metaConnName, false);
		$this->v_user_settings				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERSETTING, $this->metaConnName, false);
		$this->v_transaction_access			= ET_SysTableHandler::getSpecificTableOrViewFullName(T_TRANSACTACCESS, $this->metaConnName, false);
		$this->v_transaction_menu			= ET_SysTableHandler::getSpecificTableOrViewFullName(T_TRANSACTMENU, $this->metaConnName, false);
		$this->v_transaction_parameter_set	= ET_SysTableHandler::getSpecificTableOrViewFullName(T_TRANSACTPARAMSET, $this->metaConnName, false);
		$this->v_transaction				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_TRANSACTION, $this->metaConnName, false);		
		$this->v_logging					= ET_SysTableHandler::getSpecificTableOrViewFullName(T_LOGGING, $this->metaConnName, false);
		$this->v_user_parameter				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERPARAMETER, $this->metaConnName, false);
		$this->v_connection					= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CONNECTION, $this->metaConnName, false);
		$this->v_userConfig					= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERCONFIG, $this->metaConnName, false);
		
		$this->v_lookup_value_system		= ET_SysTableHandler::getSpecificTableOrViewFullName(T_LOOKUPSYSTEM, $this->metaConnName, false);
		
		$this->t_user_settings				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERSETTING, $this->metaConnName, true);
		$this->t_user_settings_catalog		= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERSETTINGCATALOG, $this->metaConnName, true);
		$this->t_user						= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USER, $this->metaConnName, true);
		$this->t_user_parameter				= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USERPARAMETER, $this->metaConnName, true);
		$this->t_catalog_object_config		= ET_SysTableHandler::getSpecificTableOrViewFullName(T_CATALOGOBJECTCONFIG, $this->metaConnName, true);
		
		$this->SQLcheckUserActive = "select ind_active from $this->v_user where username = '%username%'";
		
		$this->SQLuserGroup = "select usergroupname from (select usergroupname from (select a.usergroupname from 
				$this->v_usergroup_member a left join $this->v_usergroup b on a.usergroupname = b.usergroupname
				where a.username = '%username%'
				and a.ind_active = 1 and b.ind_active = 1) a 
				union
				(select username as usergroupname from $this->v_user where username = '%username%')
      			union
      			(select (
        		case when ind_is_admin = 1 then (select usergroupname from $this->v_usergroup where usergroupname = '*ALL_ADMIN_GROUP' and ind_active = 1) 
        		else (select usergroupname from $this->v_usergroup where usergroupname = '*ALL_NON_ADMIN_GROUP' and ind_active = 1) END
      			) as usergroupname from $this->v_user where username = '%username%')
      			union
				(select usergroupname from $this->v_usergroup where usergroupname = '*ALL_GROUP' and ind_active = 1)
     			) g where g.usergroupname is not null";

		
		/*$this->SQLvisibleCatalogInstances = "select distinct a.catalog_id, a.instance_name, b.conn_name, b.object, b.description, b.objectcategory from
		$this->v_obj_access a left join $this->v_obj b on a.catalog_id = b.catalog_id where a.usergroupname in (%usergroups%)
		and a.ind_active = 1 and b.ind_active = 1 order by b.conn_name, b.object";*/
		
		// removed: and a.ind_active = 1 from both cases
		/*		
		$this->SQLvisibleCatalogInstances = "select distinct * from (
				(select distinct a.catalog_id, a.instance_name, b.conn_name, b.object, b.description, b.objectcategory, a.ind_hidden from
						$this->v_obj_access a left join $this->v_obj b on a.catalog_id = b.catalog_id 
						left join $this->v_obj_instance c on b.catalog_id = c.catalog_id
						where a.usergroupname in (%usergroups%)
						and a.ind_active = 1 and b.ind_active = 1 and c.ind_active = 1 and a.instance_name <> '*ANY')
				union all
				(select distinct a.catalog_id, c.instance_name, b.conn_name, b.object, b.description, b.objectcategory, a.ind_hidden from
						$this->v_obj_access a left join $this->v_obj_instance c on a.catalog_id = c.catalog_id left join $this->v_obj b on 
						a.catalog_id = b.catalog_id where a.usergroupname in (%usergroups%)
						and a.ind_active = 1 and b.ind_active = 1 and a.instance_name = '*ANY' )
				) g order by %orderby%";
		*/
		/*
		$this->SQLvisibleCatalogInstances = "select distinct * from (
			(select distinct a.catalog_id, a.instance_name, b.conn_name, b.object, b.description, b.objectcategory, a.ind_hidden, c.description as instdescr from
				$this->v_obj_access a left join $this->v_obj b on a.catalog_id = b.catalog_id
				left join $this->v_obj_instance c on a.catalog_id = c.catalog_id and a.instance_name = c.instance_name
				where a.usergroupname in (%usergroups%)
				and a.ind_active = 1 and b.ind_active = 1 and c.ind_active = 1)
			union all
			(select distinct a.catalog_id, c.instance_name, b.conn_name, b.object, b.description, b.objectcategory, a.ind_hidden, c.description as instdescr from
				$this->v_obj_access a left join $this->v_obj_instance c on a.catalog_id = c.catalog_id and a.instance_name = c.instance_name left join $this->v_obj b on
				a.catalog_id = b.catalog_id where a.usergroupname in (%usergroups%)
				and a.ind_active = 1 and b.ind_active = 1 and a.instance_name = '*ANY' )
			) g order by %orderby%";
			*/	
		
		$this->SQLvisibleCatalogInstances = "select distinct a.catalog_id, a.instance_name, b.conn_name, b.object, b.description, b.objectcategory, a.ind_hidden, c.description as instdescr from
				$this->v_obj_access a left join $this->v_obj b on a.catalog_id = b.catalog_id
				left join $this->v_obj_instance c on a.catalog_id = c.catalog_id and a.instance_name = c.instance_name
				where a.usergroupname in (%usergroups%)
					and a.ind_active = 1 and b.ind_active = 1 and c.ind_active = 1 
				order by %orderby%";
				
		$this->SQLuserRights = "select max(ind_allow_ins) as ind_allow_ins, max(ind_allow_upd) as ind_allow_upd, max(ind_allow_del) as ind_allow_del, 
							max(ind_allow_import) as ind_allow_import, max(ind_allow_export) as ind_allow_export, max(ind_allow_upd_partial) as ind_allow_upd_partial,
							max(ind_allow_upload_partial) as ind_allow_upload_partial from $this->v_obj_access
							where catalog_id = %catalog_id% and (instance_name = '%instance_name%' or instance_name = '*ANY') and usergroupname in (%usergroups%) and ind_active = 1";
		
		//TODO remove this:			
		$this->SQLuserSettings = "select param_name, param_value from $this->v_user_settings where username = '%userName%'";		
		
		$this->SQLinstanceInfo = "select conn_name, object, a.description as table_description, b.description as instance_description,
				b.projection_list, b.ind_active_projection_list, b.read_only_list, b.ind_active_read_only_list, b.objectfilter, b.ind_active_objectfilter,
				b.objectjoin, b.ind_active_objectjoin, a.objectcategory, a.format_file_prefix, b.objectunion, b.ind_active_objectunion, b.objectgroupby, b.ind_active_objectgroupby, 
				b.objectorder, b.ind_active_objectorder from $this->v_obj a left join $this->v_obj_instance b on 
				a.catalog_id = b.catalog_id where a.ind_active = 1 and b.catalog_id = %catalog_id% and b.instance_name = '%instance_name%' and b.ind_active = 1";
		
		
		$this->SQLbasicAuthenticationData = "select ind_active, password, ind_active_ldap, username from $this->v_user where username = '%username%'";
		
		$this->SQLuserInfo = "select ind_active, firstname, lastname, email, phone, ind_active_ldap, username_ldap, ind_is_admin, lang_grid from $this->v_user where username = '%username%'";
		
		$this->SQLlookupInfo = "select a.column_name, b.catalog_id_lookup, b.instance_name_lookup, b.lookup_type, 
				a.ind_lookup_import_check, a.lookup_name_extended, a.column_name_extended_lookup, 
				a.ind_use_extended_lookup, a.ind_add_null 
				from $this->v_catalog_object_col_prop a 
				left join $this->v_lookup b on a.lookup_name  = b.lookup_name where a.catalog_id = %catalog_id% and a.ind_active = 1 
				and a.lookup_name is not null and b.ind_active = 1";
		
		$this->SQLcatalogPrimaryKeys = "select column_name from $this->v_catalog_object_col_prop where catalog_id = %catalogId% and 
				ind_active = 1 and ordinal_position_pkey is not null order by ordinal_position_pkey";
		
		$this->SQLconstraintInfo = "select b.column_name, operand_1, operand_2, column_type, operation, b.ind_constraint_import_check from 
				$this->v_constraint a left join $this->v_catalog_object_col_prop b
				on a.constraint_name = b.constraint_name
				where b.catalog_id = %catalog_id% and a.IND_ACTIVE = 1 and b.IND_ACTIVE = 1";
				
		$this->SQLcallableAccessInfoForCatalog = "select a.callable_object, c.binding_level, b.icon_callable, b.promptpage_type, b.ind_messaging, b.ind_reload_grid 
				from $this->v_callable_access a left join $this->v_callable_object b on a.callable_object = b.callable_object 
				left join $this->v_catalog_object_callable c on a.callable_object = c.callable_object
  				where usergroupname in (%usergroups%) and a.ind_active = 1 and b.ind_active = 1 and c.ind_active = 1 and c.catalog_id = %catalogId% order by b.callobject_category, b.sortorder";
		
		$this->SQLmasterDetail = "select a.catalog_id_detail, a.instance_name_detail, a.grid_location_detail, b.column_name_master, b.column_name_detail, b.operation, b.sortorder, a.logical_link
				from $this->v_master_detail a left join $this->v_master_detail_link b 
				on (a.logical_link = b.logical_link and a.catalog_id_master = b.catalog_id_master and a.instance_name_master = b.instance_name_master) 
				where a.catalog_id_master = %catalogId% and a.instance_name_master = '%instanceName%' and a.linktype = 0 order by a.grid_location_detail, a.logical_link";
		/*
		$this->SQLfilterMappings = "select a.catalog_id_detail, a.instance_name_detail, a.catalog_id_master, a.instance_name_master, b.column_name_master, b.column_name_detail, b.operation, b.sortorder, a.logical_link, a.ind_logical_link_default from 
				$this->v_master_detail a left join $this->v_master_detail_link b on a.catalog_id_master = b.catalog_id_master and a.instance_name_master = b.instance_name_master 
				and a.logical_link = b.logical_link where 
				((a.catalog_id_master = %catalogIdMaster% and a.instance_name_master = '%instanceNameMaster%') 
				or (a.catalog_id_detail = %catalogIdMaster% and a.instance_name_detail = '%instanceNameMaster%')) 
				and a.linktype = 1";
		
		$this->SQLfilterMappings = "select a.catalog_id_detail, a.instance_name_detail, a.catalog_id_master, a.instance_name_master, 
			b.column_name_master, b.column_name_detail, b.operation, b.sortorder, a.logical_link, a.ind_logical_link_default, a.icon_link, a.description from
			$this->v_master_detail a right join $this->v_master_detail_link b 
			on a.catalog_id_master = b.catalog_id_master and a.instance_name_master = b.instance_name_master
			and a.logical_link = b.logical_link where
			((a.catalog_id_master = %catalogIdMaster% and a.instance_name_master = '%instanceNameMaster%')
			or (a.catalog_id_detail = %catalogIdMaster% and a.instance_name_detail = '%instanceNameMaster%'))
			and a.linktype = 1";
		*/	
		
		// a.ind_logical_link_default is removed from sql - 2022-04-07
		/*
		$this->SQLfilterMappings = "select a.catalog_id_detail, a.instance_name_detail, a.catalog_id_master, a.instance_name_master, 
			b.column_name_master, b.column_name_detail, b.operation, b.sortorder, a.logical_link, a.ind_logical_link_default, a.icon_link, a.description from
			$this->v_master_detail a right join $this->v_master_detail_link b 
			on a.catalog_id_detail = b.catalog_id_master and a.instance_name_detail = b.instance_name_master
			and a.logical_link = b.logical_link where
			((a.catalog_id_master = %catalogIdFilter% and a.instance_name_master = '%instanceNameFilter%')
			or (a.catalog_id_detail = %catalogIdFilter% and a.instance_name_detail = '%instanceNameFilter%'))
			and a.linktype = 1 order by ind_logical_link_default desc, grid_location_detail asc";
		*/
		
		$this->SQLfilterMappings = "select a.catalog_id_detail, a.instance_name_detail, a.catalog_id_master, a.instance_name_master,
			b.column_name_master, b.column_name_detail, b.operation, b.sortorder, a.logical_link, a.ind_logical_link_default, a.icon_link, a.description from
			$this->v_master_detail a right join $this->v_master_detail_link b
			on a.catalog_id_master = b.catalog_id_master and a.instance_name_master = b.instance_name_master
			and a.logical_link = b.logical_link where
			((a.catalog_id_master = %catalogIdData% and a.instance_name_master = '%instanceNameData%')
			or (a.catalog_id_detail = %catalogIdData% and a.instance_name_detail = '%instanceNameData%'))
			and a.linktype = 1 order by ind_logical_link_default desc, grid_location_detail asc";
		
		$this->SQLmenuChildren = "select * from $this->v_transaction_menu where 
		(transaction_code is null or (transaction_code is not null and transaction_code in 
			(select transaction_code from $this->v_transaction_access a where a.usergroupname in (%userGroups%) and a.ind_active = 1))) 
		and menu_id_parent %menuParentIdWithOperator% and ind_active = 1 order by sortorder";
				
		$this->SQLtransaction = "select description, targetpage, b.param_name, b.param_value from $this->v_transaction a left join $this->v_transaction_parameter_set b 
				on a.transaction_code = b.transaction_code and a.param_set = b.param_set where a.transaction_code = '%transactionCode%' and a.ind_active = 1";
		
		/*
		$this->SQLcallableObjects = "select conn_name, command, a.callobject_type, a.description, a.callable_object, a.ind_messaging, a.ind_reload_grid, a.ind_seq, a.promptpage_type, icon_callable,
 					a.ind_use_uca, a.ind_save_uca, a.uca
					from $this->v_callable_object a 
					left join $this->v_callable_access b on 
					a.callable_object = b.callable_object
					where	b.usergroupname in (%userGroups%) and a.ind_active = 1 and b.ind_active = 1";
		*/
		
		$this->SQLcallableObjects = "select a.conn_name, a.command, a.callobject_type, a.description, a.callable_object, a.ind_messaging, a.ind_reload_grid, a.ind_seq, a.promptpage_type, a.icon_callable,
		a.ind_use_uca, a.ind_save_uca, a.uca
		from $this->v_callable_object a
		left join $this->v_callable_access b on
		a.callable_object = b.callable_object
		where b.usergroupname in (%userGroups%) and a.ind_active = 1 and b.ind_active = 1
		union
		(SELECT distinct co.conn_name, co.command, co.callobject_type, co.description, co.callable_object, co.ind_messaging, co.ind_reload_grid, co.ind_seq, co.promptpage_type, co.icon_callable,
				co.ind_use_uca, co.ind_save_uca, co.uca from $this->v_callable_object co, $this->v_logging lg where co.callable_object = lg.callable_object)";
		
		$this->SQLcallableSequence = "select a.callable_object, a.conn_name, a.command, a.callobject_type, a.description, a.callable_object, a.ind_messaging, a.ind_reload_grid, a.ind_seq, a.ind_use_uca,
			a.ind_save_uca, a.uca from $this->v_callable_object a 
			left join $this->v_callable_object_sequence b on a.callable_object = b.callable_object_seq_member
 			where a.ind_active = 1 and a.callable_object in
			(select callable_object_seq_member from $this->v_callable_object_sequence where callable_object = '%callableObject%' and ind_active = 1 order by sort_order);";
		
		$this->SQLsaveUserSetting = "insert into $this->t_user_settings values('%userName%', '%paramName%', '%paramValue%')";		
		$this->SQLdeleteUserSetting = "delete from $this->t_user_settings where username = '%userName%' and param_name = '%paramName%'";
		$this->SQLupdatePassword = "update $this->t_user set password = '%password%' where username = '%username%'";
		$this->SQLupdatePersonalData = "update $this->t_user set %valuesToSet% where username = '%username%'";
		
		$this->SQLlogging = "select conn_name,
				(case when ind_active_logfile = 1 then filename_log else null end) as filename_log, 
				(case when ind_active_logdb = 1 then callable_object else null end) as callable_object from $this->v_logging";		
		
		$this->SQLuserParametersUserLevel = "select param_name, param_value from  $this->v_user_parameter
				where username = '%userName%' and param_name in (" . $this->getListStrFromArray(USER_PARAM_NAME_ARRAY_USER_LEVEL) . ")";

		$this->SQLuserParametersCatalogLevel = "select param_name, param_value, param_filter_01, param_filter_02, param_filter_03, param_filter_04 , param_filter_05  from 
				$this->v_user_parameter where username = '%userName%' and param_name in (" . $this->getListStrFromArray(USER_PARAM_NAME_ARRAY_CATALOG_LEVEL) . ") 
							and param_filter_01 = '%catalogInstanceId%%logicalLink%'";
		
		$this->SQLuserParametersColumnLevel = "select param_name, param_value, param_filter_01, param_filter_02, param_filter_03, param_filter_04 , param_filter_05  from
				$this->v_user_parameter where username = '%userName%' and param_name in (" . $this->getListStrFromArray(USER_PARAM_NAME_ARRAY_COLUMN_LEVEL) . ")
				and param_filter_01 = '%catalogInstanceId%%logicalLink%'";
					
		$this->SQLsaveUserParameter = "insert into $this->t_user_parameter (username, param_name, param_value, param_filter_01, param_filter_02,
					param_filter_03,param_filter_04, param_filter_05) values ('%userName%', '%paramName%', '%paramValue%', 	%paramFilter1%, %paramFilter2%, 
					%paramFilter3%, %paramFilter4%, %paramFilter5%)";
		
		$this->SQLdeleteUserParameter = "delete from $this->t_user_parameter where param_id = %id%";
				
		$this->SQLuserConfig = "select cfg_id, cfg_value from $this->v_userConfig where username = '%userName%' AND appcode_cfg = '%applicationCodeCustomer%'";			
		
		$this->SQLfindPossiblyExistingParameterUser = "select param_id from $this->v_user_parameter where username = '%userName%' and param_name = '%paramName%'";
		
		$this->SQLfindPossiblyExistingParameterCatalog = "select param_id from $this->v_user_parameter where username = '%userName%' and param_name = '%paramName%' %paramFiltersPlace%";
		
		$this->SQLfindDefaultCatalogInstanceId = "select param_id from $this->v_user_parameter where username = '%userName%' and param_name = '" . USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID . "'";
		
		$this->SQLgetMessageConnection = "select conn_name_msg from $this->v_connection where conn_name = '%conn_name%'";
		
		$this->SQLnologUpoad = "select cfg_value from $this->t_catalog_object_config where catalog_id = %catalogId% and appcode_cfg = 'niota' and cfg_id = '" . EXCEL_NOLOG_UPLOAD . "'";
		
		$this->SQLvalidationSettingsForCatalog = "select cfg_id, cfg_value from $this->t_catalog_object_config where catalog_id = %catalogId% and appcode_cfg = 'niota' and (cfg_id = '" . CFG_ID_MAXNUMBER_VALIDATIONROW . "'
		or cfg_id = '". CFG_ID_MAXNUMBER_VALIDATIONMSG . "' or cfg_id = '" . CFG_ID_MAXNUMBER_VALIDATIONERR . "')";
		
		$this->SQLGroupByAndOrderByForCatalog = "SELECT objectorder, objectgroupby from $this->v_obj_instance where catalog_id = %catalogId% and instance_name = '%instanceName%'";
		
		$this->SQLLookupSystemSetting = "SELECT lookup_name, lookup_number, lookup_int, lookup_char, lookup_description, ind_active from $this->v_lookup_value_system where lookup_name = '%settingName%'";
		
		$this->SQLLookupCatalogInstanceIdByName = "SELECT catalog_id_lookup, instance_name_lookup from $this->v_lookup where lookup_name = '%lookupName%'";
		
		$this->SQLLookupNullable = "SELECT ind_add_null from $this->v_catalog_object_col_prop	where 
											catalog_id = %catalogId% AND column_name = '%columnName%'";
		
		$this->SQLLookupType = "SELECT lookup_type from $this->v_lookup where lookup_name = '%lookupName%'";
				
		$this->SQLFilterInstanceFortransactionAdvancedFilter = "select catalog_id_detail, instance_name_detail from $this->v_master_detail where catalog_id_master = %selectedCatalogId% 
																and instance_name_master = '%selectedInstanceName%' and ind_logical_link_default = 1 limit 1";
		
		$this->SQLSaveRegistrationData = "INSERT INTO $this->t_user (username, ind_active, password, email, firstname, lastname, company_name) values (?, ?, ?, ?, ?, ?, ?)";
		
		$this->SQLSaveVerifyLink 		= "INSERT INTO $this->t_user_parameter (username, param_name, param_value) values (?, ?, ?)";
		$this->SQLCheckExisitngEmail 	= "SELECT username from $this->t_user where email = ?";
		$this->SQLCheckExisitngUserName = "SELECT count(*) as usercnt from $this->v_user where username = '%username%'";
		//$this->SQLActivationData		= "SELECT username, param_filter_01 from $this->v_user_parameter where param_name = '" . USER_PARAM_VERIFYGUID . "' AND param_value = ?";
		$this->SQLActivationData		 = "SELECT u.username, param_filter_01 from $this->v_user_parameter p LEFT JOIN $this->v_user u
		ON u.username = p.username WHERE u.ind_active = 0 and p.param_value = ?";
		$this->SQLAcitvateUser			= "UPDATE $this->t_user set ind_active = 1 where username = '%username%'";
		$this->SQLGetUserDataByEmail	= "SELECT * from $this->v_user where email = ?";
		$this->SQLGetUserParameterByUsername = "SELECT param_value from $this->v_user_parameter where username = '%username%' and param_name = '%parameterName%'";
	}
	
	public function getConnection(){
		return $this->conn;
	}
	
	public function getCatalogInstanceInfo($catalogId, $instanceName) {
								
		$ret = [];
		$query = str_replace("%catalog_id%", $catalogId, $this->SQLinstanceInfo);
		$query = str_replace("%instance_name%", $instanceName, $query);
		
		$this->conn->SetFetchMode(ADODB_FETCH_NUM);
				
		$res = $this->conn->Execute($query);
		
		$row = $res->fetchRow();
		
		$ret['conn_name'] 					= $row[0];
		$ret['object'] 						= $row[1];
		$ret['table_description'] 			= $row[2];
		$ret['instance_description'] 		= $row[3];
		$ret['proj_list'] 					= $row[4];
		$ret['ind_active_proj_list'] 		= $row[5];
		$ret['read_only_list'] 				= $row[6];
		$ret['ind_active_read_only_list'] 	= $row[7];
		$ret['objectfilter'] 				= $row[8];
		$ret['ind_active_objectfilter']		= $row[9];
		$ret['objectjoin'] 					= $row[10];
		$ret['ind_active_objectjoin'] 		= $row[11];
		$ret['objectcategory']				= $row[12];
		$ret['format_file_prefix']			= $row[13];
		
		$ret['objectunion']					= $row[14];
		$ret['ind_active_objectunion']		= $row[15];
		$ret['objectgroupby']				= $row[16];
		$ret['ind_active_objectgroupby']	= $row[17];
		$ret['objectorder']					= $row[18];
		$ret['ind_active_objectorder']		= $row[19];
				
		return $ret;
	}
	
	public function isUserActive($userName) {
		$query = str_replace("%username%", $userName, $this->SQLcheckUserActive);
		
		$this->conn->SetFetchMode(ADODB_FETCH_BOTH);
		$res = $this->conn->Execute($query);
		
		$row = $res->fetchRow();
		
		if ($row === FALSE) return false;
		$row = $this->arrayKeysToLower($row);
		
		return ($row['ind_active'] == 1);
		
	}
	
	/***
	 * Returns the array of usergroups where the specified user belongs to.
	 * If the user doesn't belong to any group the array will contain only the username.
	 * @param object $connMeta -> metadata connection
	 * @param string $connNameMeta -> metadata connection name
	 * @param string $username
	 *
	 * $return -> array
	 */
	public function getUsergroups($userName){
		$ret = array();
		$this->conn->SetFetchMode(ADODB_FETCH_BOTH);
				
		$query = str_replace("%username%", $userName, $this->SQLuserGroup);

		$res = $this->conn->Execute($query);
		
		while ($row = $res->fetchRow()){			
				$row = $this->arrayKeysToLower($row);
				array_push($ret, $row['usergroupname']);
		}
		
		return $ret;
	}
	
	/***
	 * Returns the visible catalog object instances for a specific user
	
	 * @param array $userName
	 *
	 * @return array() or false;
	 */
	public function getVisibleCatalogInstances($userGroups, $orderBy) {
				
		$ret 				= array();
		$connNameDisplay	= "";
		$userGroupList 		= $this->getListStrFromArray($userGroups);
		
		$SQL = str_replace('%usergroups%', $userGroupList, $this->SQLvisibleCatalogInstances);
		$SQL = str_replace('%orderby%', $orderBy, $SQL);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->logSQL("visible catalog instances", $SQL, 2);
		$res = $this->conn->Execute($SQL);
		
		$db_charset = ET_ConnHelper::getConnectionCharsetByName(ET_METADATA_CONNECTION);
		$db_type = ET_ConnHelper::getConnectionTypeByName(ET_METADATA_CONNECTION);
		
		while ($row = $res->fetchRow()){
			
			$row = $this->arrayKeysToLower($row);
			try{
				$connNameDisplay = ET_ConnHelper::getConnectionDisplayNameByConnName($row['conn_name']);
			}
			catch (Exception $e){
				echo $e->getMessage();
				return $ret;
			}
			
			$actDescription = $row['description'];
			
			if ($db_type == DB_TYPE_ODBC_MSSQL)
				$actDescription = iconv($db_charset, "utf-8", $actDescription);
			else if ($db_type == DB_TYPE_ODBC_TERADATA) {
				$actDescription = rtrim(iconv($db_charset, "utf-8", $actDescription));
			}
			
			$catalogObjInst = array("catalog_id"		=> $row['catalog_id'], 
									"instance_name"		=> $row['instance_name'], 
									"conn_name"			=> $row['conn_name'], 
									"object"			=> $row['object'], 
									"description"		=> $actDescription,
									"objectcategory" 	=> $row['objectcategory'],
									"conn_name_display" => $connNameDisplay,
									"hidden" 			=> $row['ind_hidden'],
									"instance_descr"	=> $row['instdescr']
								);
			$ret [] = $catalogObjInst;
		}
		
		return $ret;
	}

	/***
	 * Returns the visible catalog object instances for a specific user
	
	 * @param integer $catalogId
	 * @param string $instanceName
	 * @param array $userGroups
	 *
	 * @return array() or false;
	 */
	public function getUserRightsForCatalogInstance($catalogInstanceId, $userGroups) {
		$ret = array();
		$userGroupList = $this->getListStrFromArray($userGroups);
		
		
		$SQL = str_replace('%catalog_id%', 		$this->getCatalogId($catalogInstanceId), $this->SQLuserRights);
		$SQL = str_replace('%instance_name%', 	$this->getInstanceName($catalogInstanceId), $SQL);
		
		$SQL = str_replace('%usergroups%', $userGroupList, $SQL);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);

		$res = $this->conn->Execute($SQL);

		$row = $res->fetchRow();
		$row = $this->arrayKeysToLower($row);
		$ret = array(	"allow_insert"			=> !is_null($row['ind_allow_ins']) ? $row['ind_allow_ins'] : 0 ,
						"allow_update"			=> !is_null($row['ind_allow_upd']) ? $row['ind_allow_upd'] : 0, 
						"allow_delete"			=> !is_null($row['ind_allow_del']) ? $row['ind_allow_del'] : 0,
						"allow_import"			=> !is_null($row['ind_allow_import']) ? $row['ind_allow_import'] : 0,
						"allow_export"			=> !is_null($row['ind_allow_export']) ? $row['ind_allow_export'] : 0,
						//"allow_import_update"	=> !is_null($row['ind_allow_upd_partial']) ? $row['ind_allow_upd_partial'] : 0,
						"allow_import_partial"	=> !is_null($row['ind_allow_upload_partial']) ? $row['ind_allow_upload_partial'] : 0
		);
		
		if ($ret["allow_import"])
			$ret["allow_import_partial"] = 1;
	
		return $ret;
	}
	
	function getCatalogMetaDataInfo($connName, $catalogInstanceId, $catalogName, $predefinedPrimaryKeys, $projectionlist, $objectjoin, $objectFilter, 
			$callFromSubgrid = false, $subgridNumber = '1', $useAdvancedFiltering = false, $union = null,
			$objectOrderBy = null, $groupBy = null, $filterDialog = false) {
				
		if (!is_null($objectjoin))
			return $this->getCatalogMetaDataInfoForObjectJoin($connName, $catalogInstanceId, $catalogName, $predefinedPrimaryKeys, $projectionlist, $objectjoin,
					$objectFilter, $callFromSubgrid, $subgridNumber, $useAdvancedFiltering, $union, $groupBy, $objectOrderBy, $filterDialog);
				
		$ret = array();
	
		$databaseName 	= ET_ConnHelper::getDbNameByConnectionName($connName);
		$connType 		= ET_ConnHelper::getConnectionTypeByName($connName);
		$conn 			= ET_ConnHelper::getConnection($connName);
				
		$sqlForDataGrid = "";
		$fullTableName 	= ($connType == 'oci805') ? $catalogName : $databaseName . "." . $catalogName;
		
		$primaryKeys = array();
		$primaryKeys = $this->getPrimaryKeys($conn, $connType, $fullTableName);
		
		if (empty($primaryKeys) && !empty($predefinedPrimaryKeys)) {
			$primaryKeys = $predefinedPrimaryKeys;
		}
		
		$columnInfo = array();
		$columnInfo = $this->getColumnInfo($conn, $connName, $connType, $fullTableName);
				
		$orderByAdvencedFilter = "";
		
		if ($useAdvancedFiltering) {
			
			$filterMappings = $_SESSION[SESS_ADVANCED_FILTER_FILTERMAPPINGS];			
			$filterKeyPairs = ET_BrowsingStore::getBrowsingStore()->get_filterKeyPair($catalogInstanceId);
			
			$ret['filter_key_pairs']	= $filterKeyPairs;
			$objectFilter 				= ET_AdvancedFilterHelper::resolveFilterMappings($filterMappings, $filterKeyPairs, $columnInfo);
			$orderByAdvencedFilter 		= ET_AdvancedFilterHelper::resolveOrderBy($filterMappings);
					
		}
		//$orderBy = $this->resolveOrderBy($objectOrderBy, $primaryKeys, $filterDialog, $callFromSubgrid, "", $orderByAdvencedFilter);
		$defaultPkOrderBy = self::getDefaultOrderByClause($primaryKeys);		
		$sqlForDataGrid = $this->setUpGridSQL($fullTableName, $objectFilter, $union, $groupBy, $objectOrderBy, $orderByAdvencedFilter, $projectionlist, $primaryKeys, $filterDialog, $callFromSubgrid);
		//$sqlForDataGrid = "SELECT " . $this->resolveProjectionList($projectionlist) . " FROM " . $fullTableName . $this->resolveObjectFilter($objectFilter) . $this->resolveOrderBy($orderByAdvencedFilter);
		
		$debugInfo = $this->getDebugInfo($columnInfo, $connName, $databaseName, $catalogName, $primaryKeys, $sqlForDataGrid, $fullTableName);
			
		$ret['debug_info'] 		= $debugInfo;
		$ret['primary_keys']	= $primaryKeys;
		$ret['column_info'] 	= $columnInfo;
		$ret['full_table_name'] = $fullTableName;
		$ret['default_order_by'] = $defaultPkOrderBy;
		
		$this->logSQL("Table / lookup sql", $sqlForDataGrid, 1);
		
		$ret['sql_for_datagrid'] = $this->substituteSQLQuery($sqlForDataGrid, $catalogInstanceId);
				
		return $ret;
	}

	public function getFullTableName($objectName, $connName) {
		
		$databaseName 	= ET_ConnHelper::getDbNameByConnectionName($connName);
		$connType 		= ET_ConnHelper::getConnectionTypeByName($connName);
		
		return ($connType == 'oci805') ? $objectName : $databaseName . "." . $objectName;
	}
	
	//we need  extra parameters because of php and adodb upgrade
	//original:
	//public function getPrimaryKeys($conn, $connType, $fullTableName, $dbAndSchema = "") {
	//new:
	public function getPrimaryKeys($conn, $connType, $tableName, $dbAndSchema = "") {
		$primaryKeys = array();
		//because of adodb v5.20.14 we need the table name itself, and db + schema as addittional parameters 
		
		$tableName = !empty($dbAndSchema) ?  $tableName . "." . $dbAndSchema : $tableName;
		if ($connType == DB_TYPE_ODBC_MSSQL  || $connType == DB_TYPE_MSSQL) {
			$primaryKeys = $conn->ET_MetaPrimaryKeys($tableName);
		} else {
			$primaryKeys = $conn->MetaPrimaryKeys($tableName);
		}
		
		
		return $primaryKeys;
	}
	
	/***
	 * 
	 * @param unknown $conn
	 * @param unknown $connType
	 * @param string $fullTableName - full table name for drivers
	 * @throws Exception
	 */
	public  function getColumnInfo($conn, $connName, $connType, $fullTableName) {
		$columnInfo = array();
		
		$db_charset = ET_ConnHelper::getConnectionCharsetByName($connName);
		
		if ($connType == DB_TYPE_ODBC_MSSQL  || $connType == DB_TYPE_MSSQL) {
			$metaColumnInfo = $conn->ET_MetaColumns($fullTableName, true, $db_charset);
		} else {
			$metaColumnInfo = $conn->MetaColumns($fullTableName);
		}

		if ($metaColumnInfo == false) {
			//throw new Exception("Metadata for table '$fullTableName' could not be retrieved.");
			//throw new ET_NiotaException("Metadata for table '$fullTableName' could not be retrieved."); ERROR_TABLE_METADATA
			throw new ET_NiotaException(ET_DisplayHelper::localize("ERROR_TABLE_METADATA", array($fullTableName, $connName), PAGE_TYPE_GRID, false));
		}
		
		$keys = array_keys($metaColumnInfo);
		
		foreach ($keys as $key) {
			$actualType = $metaColumnInfo[$key]->type;
				
			if (strpos($actualType, 'VARCHAR') !== false)
				$actualType = 'VARCHAR';
				
			$val = array();
			$val['defaultValue'] = '';
			$val['actualType'] 	= $actualType;
			
			$val['metaType'] = "";
			if($connType == DB_TYPE_ODBC_TERADATA) {
				/// in the case of teradata views the col type is NULL.
				// need a workaround to get the real value
				if (empty($actualType)) {
					$actualType          = $this->getTeradataViewColumnType($connName, $fullTableName, $key);
					$val['actualType']   = $actualType;
					$val['metaType']     = $conn->MetaType($actualType);
				}
				else {
					$val['metaType'] = $conn->MetaType($actualType);
				}
			}
			else
				$val['metaType'] 	= $conn->MetaType($actualType);
			
			$val['originalColumnName'] = $key;
			$val['orderNumber'] = $metaColumnInfo[$key]->orderNumber;
			//$val['defaultValue'] = $this->resolveDefaultValue($metaColumnInfo[$key]->default_value, $val['metaType'], $connType);
			if (isset($metaColumnInfo[$key]->default_value)) {
				$val['defaultValue'] = $this->resolveDefaultValue($metaColumnInfo[$key]->default_value, $val['metaType'], $connType);
			}
			$val['notNull'] = $metaColumnInfo[$key]->not_null;
			
			$columnInfo[strtolower($key)] = $val;
		}

		return $columnInfo;
		
	}
	
	/***
	 * 
	 *$fullTableName stands for the whole "FROM ... JOIN" part in the case of objectjoin
	 * */
	public function setUpGridSQL($fullTableName, $objectFilter, $union, $groupBy, $objectOrderBy, $orderByAdvencedFilter, $projectionlist, $primaryKeys, $filterDialog = false, $callFromSubgrid = false, $objectJoinAlias = "") {
		
		$ret 		= "";
		//$orderBy 	= !empty($orderByAdvencedFilter) ? $orderByAdvencedFilter : $objectOrderBy;
		//we need $objectOrderBy and $orderByAdvancedFilter also 
		$advancedFilterWhere = "";
		
		$ret = "SELECT " . $this->resolveProjectionList($projectionlist) .
							" FROM " . $fullTableName . 
							$this->resolveObjectFilter($objectFilter, $callFromSubgrid) . 
							$this->resolveUnion($union) . 
							$this->resolveGroupBy($groupBy, $filterDialog, $callFromSubgrid) . 
							$this->resolveOrderBy($objectOrderBy, $primaryKeys, $filterDialog, $callFromSubgrid, $objectJoinAlias, $orderByAdvencedFilter);
						
		return $ret;
	}
	
	public function getTeradataViewColumnType ($connName, $fullTableName, $colName) {
		
		$TDConnecion       = ET_ConnHelper::getConnection($connName);
		$type              = "";
		$t                 = "";
		$sql               = "SELECT type($fullTableName.$colName) as col_type";
		
		$TDConnecion->SetFetchMode(ADODB_FETCH_ASSOC);
		$res               = $TDConnecion->Execute($sql);
		//var_dump($res->fields);
		$type              = trim($res->fields['col_type']);
		
		// I use preg match because in some cases data length is returned concatenated with the type
		// eg: TIMESTAMP(6)
		// also varchar can return as e.g.: CHAR(100)
		
		switch (strtoupper($type)) {
			case (preg_match('/BYTEINT.*/', $type)? true : false ) :
				$t = 'I1';
				break;
			case (preg_match('/SMALLINT.*/', $type)? true : false ) :
				$t = "I2";
				break;
			case (preg_match('/INTEGER.*/', $type)? true : false ) :
				$t = "I";
				break;
			case (preg_match('/BIGINT.*/', $type)? true : false ) :
				$t = "I8";
				break;
			case (preg_match('/DECIMAL.*/', $type)? true : false ) :
				$t = "D";
				break;
			case (preg_match('/NUMERIC.*/', $type)? true : false ) :
				$t = "N";
				break;
			case (preg_match('/FLOAT.*/', $type)? true : false ) :
				$t = "F";
				break;
			case (preg_match('/CHAR.*/', $type)? true : false ) :
				$t = "CF";
				break;
			case (preg_match('/VARCHAR.*/', $type)? true : false ) :
				$t = "CF";
				break;
			case (preg_match('/CHARACTER LARGE OBJECT.*/', $type)? true : false ) :
				$t = "CO";
				break;
			case (preg_match('/BINARY LARGE OBJECT.*/', $type)? true : false ) :
				$t = "BO";
				break;
			case (preg_match('/DATE.*/', $type)? true : false ) :
				$t = "DA";
				break;
			case (preg_match('/TIME.*/', $type)? true : false ) :
				$t = "AT";
				break;
			case (preg_match('/TIMESTAMP.*/', $type)? true : false ) :
				$t = "TS";
				break;
		}
		return $t;
	}
	
	public function substituteSQLQuery($sqlForDataGrid, $catalogInstanceId) {
		$user 			= ET_NiotaUser::getNiotaUserFromSession();
		$browsingStore 	= ET_BrowsingStore::getBrowsingStore();
		$userData 		= ET_CallableObjectHelper::fillUserData($user);
		
		$systemData 	= ET_CallableObjectHelper::fillSystemData($browsingStore, $user, $catalogInstanceId);
		
		$sql = ET_CallableObjectHelper::resolveQueryString($sqlForDataGrid, $userData);
		$sql = ET_CallableObjectHelper::resolveQueryString($sql, $systemData);
		
		return $sql;
	}
	
	protected function getFirstFieldFromProjectionList($projectionList) {
		$pos = strpos($projectionList, ",");
		$firstElement = $projectionList;
		
		if ($pos) {
			$firstElement = substr($projectionList, 0, $pos);
		}
		
		$pos = strpos($firstElement, '.');
		if ($pos) {
			$firstElement = trim(substr($firstElement, $pos + 1));
		} 

		$pos = strpos(strtolower($firstElement), " as");
		
		if ($pos) {
			$firstElement = substr($firstElement, 0, $pos);
		}		
		
		return $firstElement;
		
	}
	
	protected function getCatalogMetaDataInfoForObjectJoin($connName, $catalogInstanceId, $catalogName, $predefinedPrimeryKeys, $projectionlist, $objectjoin, $objectFilter,
			$callFromSubgrid = false, $subgridNumber = '1', $useAdvancedFiltering = false, $union = "", $groupBy = "", $objectOrderBy = "", $filterDialog = false) {
		
		$ret = array();

		$databaseName 	= ET_ConnHelper::getDbNameByConnectionName($connName);
		$connType 		= ET_ConnHelper::getConnectionTypeByName($connName);
		$conn 			= ET_ConnHelper::getConnection($connName);
		$primaryKeys 	= array();
		$catalogId 		= self::getCatalogId($catalogInstanceId);
		$sqlForDataGrid = "";
		//$primaryKeys = $this->getFirstFieldFromProjectionList($projectionlist);
		array_push($primaryKeys, $this->getFirstFieldFromProjectionList($projectionlist));
		$columnInfo = array();
		
		$fullTableName = ($connType == 'oci805') ? $catalogName : $databaseName . "." . $catalogName;
		
		// primary keys
		$primaryKeys = array();
		if (!empty($predefinedPrimeryKeys))
			$primaryKeys = $predefinedPrimeryKeys;
		else
			$primaryKeys = $this->getPrimaryKeys($conn, $connType, $fullTableName);
		
		// column info
		$columnInfo = array();
		$columnInfo = $this->getColumnInfo($conn, $connName, $connType, $fullTableName);
		
		$alias = "";
		if ($objectjoin){
			$alias = $this->resolveObjectJoinAlias($catalogId);	
		}
					
		$from = $fullTableName . " " . $alias .  " " . $objectjoin;
		
		$orderByAdvencedFilter = "";
		if ($useAdvancedFiltering) {
		
			$filterMappings = $_SESSION[SESS_ADVANCED_FILTER_FILTERMAPPINGS];
			//$filterKeyPairs = $_SESSION[SESS_ADVANCED_FILTER_KEYPAIR];
				
			$filterKeyPairs 			= ET_BrowsingStore::getBrowsingStore()->get_filterKeyPair($catalogInstanceId);
			$ret['filter_key_pairs'] 	= $filterKeyPairs;
			$objectFilter 				= ET_AdvancedFilterHelper::resolveFilterMappings($filterMappings, $filterKeyPairs, $columnInfo, $alias);
			$orderByAdvencedFilter 		= ET_AdvancedFilterHelper::resolveOrderBy($filterMappings, $alias);
			//$_SESSION[SESS_ADVANCED_FILTER_KEYPAIR] = null;		
		}
		
		$sqlForDataGrid = $this->setUpGridSQL($from, $objectFilter, $union, $groupBy, $objectOrderBy, $orderByAdvencedFilter, $projectionlist, $primaryKeys, $filterDialog, $callFromSubgrid, $alias);
		
		$debugInfo = $this->getDebugInfo($columnInfo, $connName, $databaseName, $catalogName, $primaryKeys, $sqlForDataGrid, $from);
			
		$ret['primary_keys'] 		= $primaryKeys;
		
		$SQLresolved = $this->substituteSQLQuery($sqlForDataGrid, $catalogInstanceId);
		$this->logSQL("Joined table sql", $SQLresolved, 1);
		
		$ret['sql_for_datagrid'] 	= $SQLresolved;
		$ret['full_table_name'] 	= $fullTableName;
		$ret['column_info'] 		= $columnInfo;
		$ret['debug_info'] 			= $debugInfo;
		$ret['join_alias']			= $alias;
		
		return $ret;
	}
	
	protected function resolveDefaultValue($value, $metaType, $dbType) {
		//file_put_contents('log_default', $value . "\n", FILE_APPEND);
		if (is_null($value) || empty($value)) return '';
		
		if ($dbType == 'odbc_mssql') {
			if ($metaType == 'I' || $metaType == 'N') {
				$value = str_replace("(", "", $value);
				$value = str_replace(")", "", $value);
			} else if ($metaType == 'C') {
				if (ET_StringCheck::startsWith($value, "("))
					$value = substr($value, 1);
				if (ET_StringCheck::endsWith($value, ")"))
					$value = rtrim($value, ")");
			}
		}
		
		return $value;
	}
	
	protected function getDefaultValueForNotNullableFields($metaType, $dbType) {
		if ($metaType == 'C' || $metaType == 'X') {
			if ($dbType == 'oci805')
				return '--';
			else {
				return '';
				//return null;
			}

		}
		if ($metaType == 'I' || $metaType == 'N') return 0;
		if ($metaType == 'D') return '1900-01-01';
		if ($metaType == 'T') return '1970-01-01 00:00:00';
		
	}
	
	public function logSQL($message, $query, $loglevel) {
		
		$user 			= ET_NiotaUser::getNiotaUserFromSession();
		$userLoglevel	= 0;
		
		if ($user) {
			$userLoglevel = $user->getSQLLogLevelConfig();
		} else {
			$userLoglevel = DEBUG_SQL_LOGLEVEL; 
		}
		
		if ($userLoglevel >= $loglevel) {
			$content = PHP_EOL . "$message: \t$query" . PHP_EOL;				
			$systemLogger = new ET_LoggingHelperSystem();
			$systemLogger->addSystemLogEntry(LOG_TYPE_DEBUG, $content, $loglevel);			
		}
	
	}
	
	public function resolveObjectJoinAlias ($catalogId) {
		
		$alias = "";
		if (!strpos(SYSTEM_OBJECT_ALIAS_GRID, "%cat_id%")) 
			$alias = SYSTEM_OBJECT_ALIAS_GRID;
		else
			$alias = str_replace("%cat_id%", $catalogId, SYSTEM_OBJECT_ALIAS_GRID);
		
		return $alias;
	}
	
	public function getNullValuesForCell($colName, $val, $columnInfo, $dbType, $oper) {
		$ret = $val;
		
		if (isset($columnInfo[strtolower($colName)])) {
			$info = $columnInfo[strtolower($colName)];
			$colMetaType = $info['metaType'];
			$has_default = isset($info['defaultValue']) ? !empty($info['defaultValue']) : FALSE;
			$nullable = !$info['notNull'];
			
			if ($colMetaType == 'I' || $colMetaType == 'N' || $colMetaType == 'D' || $colMetaType == 'T') {				
				
				if ($val === '') {		
					
					if ($has_default) {
						if ($oper == 'add')
							$ret = '___skip___';
					} else if ($nullable) {						
						$ret = null;						
					} else {						
						//$ret = $this->getDefaultValueForNotNullableFields($colMetaType, $dbType);						
						$ret = ERROR_NOT_NULL_VIOLATION;						
					}
				} else if ($val == '~') {
					$ret = null;
				}
			} else if ($colMetaType == 'C' || $colMetaType == 'X') {
				
				if ($val == '') {
					if ($has_default) {						
						if ($oper == 'add')
							$ret = '___skip___';
					} else if ($nullable) {
						$ret = null;						
					} else {
						// $ret = $this->getDefaultValueForNotNullableFields($colMetaType, $dbType);
						// if not nullable and not filled anyway we set to null and db will throw error.
						// we have empty-string and null-value markers - see below
						$ret = null;
					}
				} else if ($val == '--') {
					if ($dbType == 'oci805')
						$ret = '--';
					else
						$ret = '';
				} else if ($val == '~') {
					$ret = null;
				}				
			}
				
		}
		
		return $ret;
		
	}
	
	public function setNullValuesForSQLQuery(&$arrFields, $columnInfo, $dbType, $oper) {	
	
		foreach ($arrFields as $colName => $val) {
			//$arrFields[$colName] = trim($val, " ");
			$newVal = $this->getNullValuesForCell($colName, $val, $columnInfo, $dbType, $oper);
			
			if ($newVal == '___skip___') {
				unset($arrFields[$colName]);
			}
			else if ($newVal == ERROR_NOT_NULL_VIOLATION) {
				throw new Exception("Column $colName must be filled!");				
			}
			else
				$arrFields[$colName] = $newVal; 
		}
		
		return $arrFields;
	}
	
	public function constructMultipleDeleteWhereConditionSQLServer($sql_key=array(), $key_value=array(), $columnInfo){
		$sqlWhere = "";
	
		for($i =0; $i < count($key_value); $i++){
			$pk_val_fields = explode(PK_DELIMITER, $key_value[$i]);
			$sqlWhere .= "(";
	
			for($j=0; $j < count($sql_key); $j++){
				$colName = $sql_key[$j];
				$fm_type = $columnInfo[strtolower($colName)]['metaType'];
	
				if($fm_type != 'I' && $fm_type != 'N' && $fm_type != 'R'){
					$pk_val_fld = "'" . $pk_val_fields[$j] ."'";
				}else{
					$pk_val_fld = $pk_val_fields[$j];
				}
				$pk_val_fields[$j] = $pk_val_fld;
	
				$sqlWhere .= $colName . " = " . $pk_val_fld;
	
				if ($j != count($sql_key) -1) {
					$sqlWhere .= " AND ";
				}
			}
			$sqlWhere .= ")";
			if ($i != count($key_value) -1) {
				$sqlWhere .= " OR ";
			}
		}
		return $sqlWhere;
	}
	
	/***
	 * 
	 * @param array $sql_key - column name array
	 * @param array $key_value - PK values
	 * @param unknown $columnInfo
	 * @return string[]
	 */
	public function constructMultipleDeleteValueGroups($sql_key=array(), $key_value=array(), $columnInfo){
		$pk_val_new = array();
	
		for($i =0; $i < count($key_value); $i++){
			$pk_val_fields = explode(PK_DELIMITER, $key_value[$i]);
	
	
			for($j=0; $j < count($sql_key); $j++){
				$colName = $sql_key[$j];
	
				$fm_type = $columnInfo[strtolower($colName)]['metaType'];
	
				if($fm_type != 'I' && $fm_type != 'N' && $fm_type != 'R'){
					$pk_val_fld = "'" . $pk_val_fields[$j] ."'";
				}else{
					$pk_val_fld = $pk_val_fields[$j];
				}
				$pk_val_fields[$j] = $pk_val_fld;
			}
	
			$pk_val_new[] = '('. implode(',', $pk_val_fields) .')';
		}
		return $pk_val_new;
	}
	
	public function getLoggingSettings() {
		$ret = array();
		$SQL = $this->SQLlogging;
	
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
	
		$res = $this->conn->Execute($SQL);

		if ($res === FALSE) return FALSE;
		
		while($row = $res->fetchRow()) {
			$row = $this->arrayKeysToLower($row);
			$ret[] = array("conn_name" => $row['conn_name'], "filename_log" => $row['filename_log'],  "callable_object" => $row['callable_object']);
		}
		
		return $ret;
	}
	
	public function getLookupInfo($catalogId){
		$ret = array();
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$SQL = str_replace("%catalog_id%", $catalogId, $this->SQLlookupInfo);
		
		$res = $this->conn->Execute($SQL);
				
		while($row = $res->fetchRow()) {
			$row = $this->arrayKeysToLower($row);
			$ret[$row['column_name']] = array("catalogId" 		=> $row['catalog_id_lookup'], 
											"instanceName" 		=> $row['instance_name_lookup'], 
											"excelImportCheck" 	=> $row['ind_lookup_import_check'],
											"type"				=> $row['lookup_type'],
											"extendedLookup"	=> $row['lookup_name_extended'],
											"extendedColumn"	=> $row['column_name_extended_lookup'],
											"useExtendedDef"	=> $row['ind_use_extended_lookup'] === '1' ? true : false,
											"addNullItem"		=> $row['ind_add_null'] === '1' ? true : false
			); 
		}
		
		return $ret;
		
	}

	public function getCatalogPrimaryKeys($catalogId) {
		$ret = array();
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		
		$SQL = str_replace("%catalogId%", $catalogId, $this->SQLcatalogPrimaryKeys);
		
		$res = $this->conn->Execute($SQL);
		
		while($row = $res->fetchRow()) {
			$row = self::arrayKeysToLower($row);
			$ret[] = $row['column_name'];
		}
		
		return $ret;		
		
	}
	
	public function getConstraintInfo($catalogId){
		$ret = array();
	
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$SQL = str_replace("%catalog_id%", $catalogId, $this->SQLconstraintInfo);
		
		$res = $this->conn->Execute($SQL);
	
		while ($row = $res->fetchRow()) {
			$row = $this->arrayKeysToLower($row);
			$ret[$row['column_name']] = array("operand1" => $row['operand_1'], "operand2" => $row['operand_2'],
					"column_type" => $row['column_type'],"operation" => $row['operation'], "excelImportCheck" => $row['ind_constraint_import_check']
			);
		}	
		return $ret;
	}
	
	public function getMasterDetailInfoForCatalogInstance($catalogId, $instanceName) {
		
		$ret 				= array();
		$detailOrderValues 	= array();
		
		$SQL = str_replace('%catalogId%', $catalogId, $this->SQLmasterDetail);
		$SQL = str_replace('%instanceName%', $instanceName, $SQL);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);		
		$this->logSQL("Master-detail sql: ", $SQL, 2);		
		$res = $this->conn->Execute($SQL);				
				
		while ($row = $res->fetchRow()) {
			$row = $this->arrayKeysToLower($row);
			$detailArray = array(
						"catalog_id_detail" 	=> $row['catalog_id_detail'], 
						"instance_name_detail" 	=> $row['instance_name_detail'], 
						"column_name_master"	=> $row['column_name_master'], 
						"column_name_detail"	=> $row['column_name_detail'], 
						"operation"				=> $row['operation'], 
						"logical_link"			=> $row['logical_link'],
						"sortorder" 			=> $row['sortorder'],
						"location_detail"		=> $row['grid_location_detail']
						);
			
			$ret[] = $detailArray;		
			$detailOrderValues []= $row['grid_location_detail'];
		}
		
		if (!empty($ret)) {
			$this->validateDetailGridOrdering($detailOrderValues);			
		}
		
		
		return $ret;
	}
	
	public function getFilterMappings ($catalogIdData, $instanceNameData, $default = false, $logicalLinkName = '') {
		
		$ret = array();
		
		$SQL = $this->SQLfilterMappings;
		
		$SQL = str_replace('%catalogIdData%', $catalogIdData, $SQL);
		$SQL = str_replace('%instanceNameData%', $instanceNameData, $SQL);
		
		if (!empty($logicalLinkName))
			$SQL = str_replace('%logicalLink%', $logicalLinkName, $SQL);
			
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);		
		$res = $this->conn->Execute($SQL);
		if ($res === FALSE) return FALSE;
		
		while ($row = $res->fetchRow()) {
			$row 	= self::arrayKeysToLower($row);
			$actRow = array(
						
						"catalog_id_master" 	=> $row["catalog_id_detail"],
						"instance_name_master" 	=> $row["instance_name_detail"],
						"catalog_id_detail" 	=> $row["catalog_id_master"],
						"instance_name_detail" 	=> $row["instance_name_master"],						
						"column_name_master" 	=> $row["column_name_detail"],
						"column_name_detail" 	=> $row["column_name_master"],
						"operation" 			=> $row["operation"],
						"sortorder" 			=> $row['sortorder'],
						"logical_link" 			=> $row['logical_link'],						
						"logical_link_default" 	=> $row['ind_logical_link_default'],
						
						"icon"					=> $row['icon_link'],
						"description"			=> $row['description']
					);			
			$ret [] = $actRow;
		}
		
		return $ret;
	}
	
	/***
	 * Returns basic authentication data, such as: ind_active, password, ind_active_ldap. 
	 * 
	 * @param string $username
	 * @param string $password
	 * @param boolean $activeLdap
	 * @throws Exception
	 * @return array or boolean -> if the authenticaion is succeeded, returns an array with user settings othervise false
	 */
	public function getBasicAuthenticationData($username){
		
		$SQL 		= "";
		$ret 		= null;
		$row 		= array();
		$return 	= array();
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);		
		
		$SQL = str_replace('%username%', $username, $this->SQLbasicAuthenticationData);
		
		//here is an example to force mysql to make string check case sensitive despite of the collation set in the db (utf8_general_ci):
		//SELECT username COLLATE utf8_bin, password, ind_active, ind_active_ldap from niota_meta_test.et_user where username = 'AdMin' COLLATE utf8_bin;
		
		$res = $this->conn->Execute($SQL);
		
		if ($res == false) {
			return null;	
		}

		//CHECK EMPTY RESULT		
		//$ra = $res != false ? $res->NumRows() : 0;
		$ra = $res->NumRows();
		
		if ($ra == 0){			
			return 0;
		}		
		
		$row = $res->fetchRow();
		
		$row = $this->arrayKeysToLower($row);
		
		$ret["password"] 		= $row['password'];
		$ret["isLdapActive"] 	= $row['ind_active_ldap'];
		$ret["ind_active"]		= $row['ind_active'];
		$ret["username"]		= $row['username'];
		
		return $ret;
				
	}

	public function getUserInfo($username){
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$ret 	= array();
		$SQL 	= str_replace('%username%', $username, $this->SQLuserInfo);
		$res 	= $this->conn->Execute($SQL);
		//CHECK EMPTY RESULT
		$ra = $res->NumRows();
		if ($ra == 0){
			throw new Exception(ET_DisplayHelper::localize("INVALID_USER_CREDENTIALS"));
		}		
		
		$row = $res->fetchRow();
		
		$row = $this->arrayKeysToLower($row);
		$ret = ["is_active" => $row['ind_active'], 
				"is_admin" => $row['ind_is_admin'],
				"firstname" => $row['firstname'], 
				"lastname" => $row['lastname'],
				"phone" => $row['phone'], 
				"email" => $row['email'],							
				"grid_language" => $row['lang_grid'] == 'null' ? null : $row['lang_grid']
				];
		
		return $ret;
	}
	
	public function getCallableObjectsForCatalog($catalogId, $userGroups){
		//echo "getCallableObjectsForCatalog<br>";
		$ret = array();
		$userGroupList = $this->getListStrFromArray($userGroups);
		$SQL = str_replace('%catalogId%', $catalogId, $this->SQLcallableAccessInfoForCatalog);
		$SQL = str_replace('%usergroups%', $userGroupList, $SQL);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		
		//$this->logSQL("Callable object access sql: ", $SQL, 0);
		
		$res = $this->conn->Execute($SQL);
		
		while ($row = $res->fetchRow()) {
			$row = $this->arrayKeysToLower($row);
			
			$callObject = array("callable_object" 	=> $row['callable_object'],
								"binding_level" 	=> $row['binding_level'],
								"messaging_active" 	=> $row['ind_messaging'],
								"reload_grid" 		=> $row['ind_reload_grid'],
								"name"				=> ET_StringCheck::convertToUTF8($row['callable_object'], ET_METADATA_CONNECTION),
								"icon"				=> $row['icon_callable'],
								"promptpage_type"	=> $row['promptpage_type']
							);
			$ret [] = $callObject;
		}
		
		return $ret;
	}
	
	public function getCallableSequence($coName) {
		$ret = array();
		
		$SQL = str_replace("%callableObject%", $coName, $this->SQLcallableSequence);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->logSQL("Callable object sql: ", $SQL, 2);
		$res = $this->conn->Execute($SQL);
		
		if ($res) {
			while ($row = $res->fetchRow()) {
				$row = $this->arrayKeysToLower($row);
				$currArray = array(
						"conn_name" 		=> $row["conn_name"],
						"command" 			=> $row["command"],
						"description" 		=> ET_StringCheck::convertToUTF8($row['description'], ET_METADATA_CONNECTION),
						"callobject_type" 	=> $row["callobject_type"],
						"messaging_active" 	=> $row['ind_messaging'],
						"reload_grid" 		=> $row['ind_reload_grid'],
						"sequence"			=> $row['ind_seq'],
						//"name"			=> $row["callable_object"]
						"name"				=> ET_StringCheck::convertToUTF8($row['callable_object'], ET_METADATA_CONNECTION),
						//"overwrite_binding" => $row['overwrite_binding']
						"use_uca"			=> $row['ind_use_uca'],
						"save_uca"			=> $row['ind_save_uca'],
						"uca"				=> $row['uca']
				);
				array_push($ret, $currArray);
			}
		}
		
		
		return $ret;
	}	
	
	public function getCallableObjects($userGroups) {
		
		$ret = array();
		$userGroupList = $this->getListStrFromArray($userGroups);
		
		$SQL = str_replace("%userGroups%", $userGroupList, $this->SQLcallableObjects);
		//echo $SQL;
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->logSQL("Callable object sql: ", $SQL, 2);
		$res = $this->conn->Execute($SQL);
		
		if ($res) {
			while ($row = $res->fetchRow()) {
				$row = $this->arrayKeysToLower($row);
				$ret[$row["callable_object"]] = array(
													"conn_name" 		=> $row["conn_name"],
													"command" 			=> $row["command"],
													/*"description" 	=> $row["description"],*/
													"description" 		=> ET_StringCheck::convertToUTF8($row['description'], ET_METADATA_CONNECTION),
													"callobject_type" 	=> $row["callobject_type"],
													"messaging_active" 	=> $row['ind_messaging'],
													"reload_grid" 		=> $row['ind_reload_grid'],
													"sequence"			=> $row['ind_seq'],
													//"name"			=> $row["callable_object"]
													"name"				=> ET_StringCheck::convertToUTF8($row['callable_object'], ET_METADATA_CONNECTION),
													"promptpage_type"	=> $row['promptpage_type'],
													"icon"				=> $row['icon_callable'],
													"use_uca"			=> $row['ind_use_uca'],
													"save_uca"			=> $row['ind_save_uca'],
													"uca"				=> $row['uca']
													);
			}
		}
		
		return $ret;		
	}
	
	public function getDynamicMenuChildren($parentId, $userGroups) {
		$ret = array();
		$userGroupList = $this->getListStrFromArray($userGroups);
		$SQL = str_replace('%menuParentIdWithOperator%', is_null($parentId) ? " is null" : " = '$parentId'", $this->SQLmenuChildren);
		$SQL = str_replace('%userGroups%', $userGroupList, $SQL);
	
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$res = $this->conn->Execute($SQL);
		
		while ($row = $res->fetchRow()) {
			
			$row = $this->arrayKeysToLower($row);
			$transactionCode = $row['transaction_code'];
			$transaction = null;
			if (!is_null($transactionCode))
				$transaction = self::getTransaction($transactionCode);
			
			$menuLabel 		= ET_StringCheck::convertToUTF8($row['menu_label'], $this->metaConnName);
			$description 	= ET_StringCheck::convertToUTF8($row['description'], $this->metaConnName);
					
			$menuItem = new ET_DynamicMenuItem(
						$row['menu_id'], 
						$transaction, 
						$menuLabel,
						$description,
						//$row['menu_label'], 
						//$row['description'], 
						$row['menu_id_parent'], 
						$row['icon_menu'], 
						self::getDynamicMenuChildren($row['menu_id'], $userGroups));	
			$ret [] = $menuItem;
			
		}
		return $ret;
	}
	
	public function getTransaction($transactionCode) {
		$ret = null;
		
		$SQL = str_replace('%transactionCode%', $transactionCode, $this->SQLtransaction);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->logSQL("Transaction details sql: ", $SQL, 2);
		$res = $this->conn->Execute($SQL);

		$targetPage 	= "";
		$description 	= "";
		$params 		= array();
			
		while ($row = $res->fetchRow()) {
			$row = $this->arrayKeysToLower($row);
			
			$targetPage = $row['targetpage'];
			$description = $row['description'];
			
			if (isset($row['param_name']) && !is_null($row['param_name'])) {
				$params[$row['param_name']] = $row['param_value'];
			}
		}
		
		$this->fillPopupFilterInstance($params);
				
		return new ET_Transaction($transactionCode, $description, $targetPage, $params);
		
	}
	
	public function getUserSettings($userName, $parameterLevel, $catalogInstanceId = "", $logicalLink = "", $optionKey = "") {
		$ret 			= array();
		$query 			= "";
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		
		if ($parameterLevel == USER_PARAM_LEVEL_USER) {						
			$query 			=  $this->SQLuserParametersUserLevel;
		}
		else if ($parameterLevel == USER_PARAM_LEVEL_CATALOG || $parameterLevel == USER_PARAM_LEVEL_COLUMN) {
			$query = $parameterLevel == USER_PARAM_LEVEL_CATALOG ? $this->SQLuserParametersCatalogLevel : $this->SQLuserParametersColumnLevel;
			
			if (!empty($optionKey)) {	//we're on an admin page. $logicalLink contains optionKey as well
				if (!empty($logicalLink)) {
					$query 	= str_replace("%catalogInstanceId%", $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $logicalLink, $query);
				}
				else {					
					$query 	= str_replace("%catalogInstanceId%", $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $optionKey, $query);					
				}
				$query 	= str_replace("%logicalLink%", "", $query);
			}
			else {	//we're in the grid area
				$query 	= str_replace("%catalogInstanceId%", $catalogInstanceId, $query);
				$query = str_replace("%logicalLink%", !empty($logicalLink) ? FORMATTING_LINK_SEPARATOR . $logicalLink : "", $query);
			}
		}
		else {
			return $ret;
		}
			
		$query 	= str_replace("%userName%", $userName, $query);
		
		$this->logSQL("Getting user settings", $query, 3);
		
		$res = $this->conn->Execute($query);

		if ($parameterLevel == USER_PARAM_LEVEL_USER || $parameterLevel == USER_PARAM_LEVEL_CATALOG) {
			while ($row = $res->fetchRow()) {
				$row = $this->arrayKeysToLower($row);
				$ret[$row["param_name"]] = $row["param_value"];
			}
				
		} else {
			while ($row = $res->fetchRow()) {
				$row = $this->arrayKeysToLower($row);
				$colName = $row['param_filter_02'];
				$paramName = $row['param_name'];
				$paramValue = $row['param_value'];
				$colArray = isset($ret[$colName]) ? $ret[$colName] : array();
				$colArray[$paramName] = $paramValue;
				$ret[$colName] = $colArray;
				
			}
		}
		return $ret;
	}
	
	public function getUserConfig($userName) {
		
		$ret = [];
		
		$query 	= str_replace("%userName%", $userName, $this->SQLuserConfig);		
		$query 	= str_replace("%applicationCodeCustomer%", APPLICATION_CODE_SYSTEM, $query);
		
		$this->logSQL("Getting user config", $query, 3);		
		
		$res = $this->conn->Execute($query);
		
		if ($res) {
			while ($row = $res->fetchRow()) {				
				$row 		= $this->arrayKeysToLower($row);				
				$configName	= $row['cfg_id'];
				$configVal	= NULL;
				
				if ($configName == USER_CONFIG_DEBUG_GRID) {					
					$configVal = $row['cfg_value'] == 'null' ? null : boolval($row['cfg_value']);
				} elseif ($configName == USER_CONFIG_SQL_LOGLEVEL) {					
					$configVal = $row['cfg_value'] == 'null' ? null : intval($row['cfg_value']);
				}
				
				$ret[$configName]		= $configVal;				
			}			
		}	
		
		$this->mergeUserLogSettings($ret);		
		return $ret;
	}
	
	/***
	 * If user has no log settings user settings are filled with system settings - debug_defaults.php
	 * @param array $userConfigArr
	 * return log settings of the user in the config array
	 */
	protected function mergeUserLogSettings(&$userConfigArr) {
		
		if (!isset($userConfigArr[USER_CONFIG_DEBUG_GRID]) || is_null($userConfigArr[USER_CONFIG_DEBUG_GRID])) {
			$userConfigArr[USER_CONFIG_DEBUG_GRID] = DEBUG_GRID;
		}
		if (!isset($userConfigArr[USER_CONFIG_SQL_LOGLEVEL]) || is_null($userConfigArr[USER_CONFIG_SQL_LOGLEVEL])) {			
			$userConfigArr[USER_CONFIG_SQL_LOGLEVEL] = DEBUG_SQL_LOGLEVEL;
		}		
		
		$this->setDebugStatusMessage('niota', $userConfigArr);		
	}
	
	public static function setDebugStatusMessage($fileName, $userConfigArr = array()) {
		
		$setMessage = false;
		$pageType = ET_DisplayHelper::detectPageType($fileName);
		
		if (empty($userConfigArr)) {
			
			$niotaUser = ET_NiotaUser::getNiotaUserFromSession();
			if (!is_null($niotaUser)) {
				$userConfigArr[USER_CONFIG_DEBUG_GRID] = $niotaUser->getDebugGridConfig();
				$userConfigArr[USER_CONFIG_SQL_LOGLEVEL] = $niotaUser->getSQLLogLevelConfig();
			} else {
				return;
			}			
		} 
		
		if ($userConfigArr[USER_CONFIG_DEBUG_GRID] || $userConfigArr[USER_CONFIG_SQL_LOGLEVEL] > 0) {
			ET_DisplayHelper::addWarningLine(ET_DisplayHelper::localize('INFO_DEBUG_IS_ON', null, $pageType), $fileName);
		}
		
		
	}
	
	public function saveUserSetting ($userSetting) {
		
		$userName 			= $userSetting['userName'];		
		$paramName 			= $userSetting['paramName'];		
		$paramValue 		= $userSetting['paramValue'];
		$paramFilter1 		= $userSetting['paramFilter1'];
		$paramFilter2 		= $userSetting['paramFilter2'];
		$paramFilter3 		= $userSetting['paramFilter3'];
		$paramFilter4 		= $userSetting['paramFilter4'];
		$paramFilter5 		= $userSetting['paramFilter5'];
		
		$possibleExistingSetting = $this->findPossiblyExistingParameter($userName, $paramName, $paramFilter1, $paramFilter2, 
										$paramFilter3, $paramFilter4, $paramFilter5);

		$this->conn->StartTrans();
		
		
		if ($possibleExistingSetting) {
			while ($row = $possibleExistingSetting->fetchRow()) {
				$row = $this->arrayKeysToLower($row);
				$parameterId = $row['param_id'];
				$this->deleteUserSetting($parameterId);
			}
		}
		
		$query 	= $this->SQLsaveUserParameter;
		
		$query = str_replace("%userName%", $userName, $query);			
		$query = str_replace("%paramName%", $paramName, $query);
		$query = str_replace("%paramValue%", $paramValue, $query);
		
		$filter1 = is_null($paramFilter1) ? "null" : "'" . $paramFilter1 . "'";
		$filter2 = is_null($paramFilter2) ? "null" : "'" . $paramFilter2 . "'";
		$filter3 = is_null($paramFilter3) ? "null" : "'" . $paramFilter3 . "'";
		$filter4 = is_null($paramFilter4) ? "null" : "'" . $paramFilter4 . "'";
		$filter5 = is_null($paramFilter5) ? "null" : "'" . $paramFilter5 . "'";
			
		$query = str_replace("%paramFilter1%", $filter1, $query);
		$query = str_replace("%paramFilter2%", $filter2, $query);
		$query = str_replace("%paramFilter3%", $filter3, $query);
		$query = str_replace("%paramFilter4%", $filter4, $query);
		$query = str_replace("%paramFilter5%", $filter5, $query);
		
		$ret = $this->conn->Execute($query);
		
		$this->conn->CompleteTrans();
		
		return $ret;
	}
	
	public function findDefaultCatalogInstanceParameterId ($userName) {
		
		$query = str_replace("%userName%", $userName, $this->SQLfindDefaultCatalogInstanceId);		
		
		$ret = $this->conn->Execute($query);		
		$row = $ret->fetchRow();
		$row = $this->arrayKeysToLower($row);
		$paramId = $row['param_id'];
		
		return $paramId;
	}
	
	public function deleteUserSetting ($parameterId) {
		
		$query = str_replace("%id%", $parameterId, $this->SQLdeleteUserParameter);
		
		$ret = $this->conn->Execute($query);
		//echo "deleted: "; var_dump($this->conn->affected_rows()); die();
		return $ret;
		
	}
	
	public function findPossiblyExistingParameter ($userName, $paramName, $paramFilter1, $paramFilter2, $paramFilter3, $paramFilter4, $paramFilter5) {
		
		$query				= "";		
		$paramLevel 		= $this->getParamLevelByArgumentList($paramName);
		$paramFilterString 	= "";
		
		if ($paramLevel == USER_PARAM_LEVEL_CATALOG || $paramLevel == USER_PARAM_LEVEL_COLUMN) {
			
			$paramFilterString = $this->createParamListPartForQueryCondition($paramFilter1, $paramFilter2, $paramFilter3, $paramFilter4, $paramFilter5);
			$query = $this->SQLfindPossiblyExistingParameterCatalog;
			$query = str_replace("%userName%", $userName, $query);
			$query = str_replace("%paramName%", $paramName, $query);
			$query = str_replace("%paramFiltersPlace%", $paramFilterString, $query);						
		} 
		else if ($paramLevel == USER_PARAM_LEVEL_USER) {			
			$query = $this->SQLfindPossiblyExistingParameterUser;
			$query = str_replace("%userName%", $userName, $query);
			$query = str_replace("%paramName%", $paramName, $query);
			$query = str_replace("%paramFiltersPlace%", $paramFilterString, $query);
		}
		else {
			return false;
		}
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		
		return $this->conn->Execute($query);
	}
	
	public function updateUserPassword($userName, $passwordHashed){
		
		$SQL = str_replace("%username%", $userName, $this->SQLupdatePassword);
		$SQL = str_replace("%password%", $passwordHashed, $SQL);
		
		$ret = $this->conn->Execute($SQL);
		
		if($ret)
			return true;
		else 
			return false;
	}
	
	public function updatePersonalData($userName, $updateData){
	
		$SQL = str_replace("%username%", $userName, $this->SQLupdatePersonalData);
		$SQL = str_replace("%valuesToSet%", $updateData, $SQL);
		
		$ret = $this->conn->Execute($SQL);
		
		if($ret)
			return true;
		else
			return false;
	}
	
	protected function fillPopupFilterInstance(&$params) {
		
		if (isset($params[SYSTEM_LOOKUP_TRANSACTION_PARAM_VALUE_POPUP]) && $params[SYSTEM_LOOKUP_TRANSACTION_PARAM_VALUE_POPUP] === "1") {
						
			$filterInstance = "";
			try {
				$filterInstance = $this->getFilterInstanceForTransactionAdvancedFilter($params[SYSTEM_LOOKUP_TRANSACTION_PARAM_VALUE_SELECTED_INST]);
			} catch (Exception $e) {
				ET_DisplayHelper::addErrorLine($e->getMessage(), "niota");
			}
			
			$params['filter_instance'] = $filterInstance;
		} else {		
			return;
		}	
		
	}
	
	protected function getFilterInstanceForTransactionAdvancedFilter ($selectedCatalogInstanceId) {
		
		//IMPORTANT: $selectedCatalogInstanceId here menas "DATA INSTANCE" (master instance in meta db)!			
		$filterCatalogId		= null;
		$filterInstance			= "";
		$selectedCatId 			= $this->getCatalogId($selectedCatalogInstanceId);
		$selectedInstanceName 	= $this->getInstanceName($selectedCatalogInstanceId);
		$SQL 					= str_replace("%selectedCatalogId%", $selectedCatId, $this->SQLFilterInstanceFortransactionAdvancedFilter);
		$SQL 					= str_replace("%selectedInstanceName%", $selectedInstanceName, $SQL);
		
		$res = $this->conn->Execute($SQL);
		
		if ($res) {
			while ($row = $res->fetchRow()) {
				$row 				= $this->arrayKeysToLower($row);
				$filterCatalogId 	= $row['catalog_id_detail'];
				$filterInstance 	= $row['instance_name_detail'];
				//$this->deleteUserSetting($parameterId);
			}
			return $this->generateCatalogInstanceId($filterCatalogId, $filterInstance);
		}
		else {
			throw new Exception(ET_DisplayHelper::localize("ERROR_TRANSACTION_POPUP_FILTER_NOT_FOUND", array($selectedCatalogInstanceId)));
		}
		
		
	}
	
	protected function createParamListPartForQueryCondition ($paramFilter1, $paramFilter2, $paramFilter3, $paramFilter4, $paramFilter5) {
		
		$retStr = "";
		
		if (!is_null($paramFilter1)) {			
			$retStr .= " and param_filter_01 = '$paramFilter1' and ";
		}
		if (!is_null($paramFilter2)) {
			$retStr .= " param_filter_02 = '$paramFilter2' and ";
		}
		if (!is_null($paramFilter3)) {
			$retStr .= " param_filter_03 = '$paramFilter3' and ";
		}
		if (!is_null($paramFilter4)) {
			$retStr .= " param_filter_04 = '$paramFilter4' and ";
		}
		if (!is_null($paramFilter5)) {
			$retStr .= " param_filter_05 = '$paramFilter5'";
		}
		
		if (ET_StringCheck::endsWith($retStr, " and ")) {
			$retStr = substr($retStr, 0, strlen($retStr) - 5);
		}
		
		return $retStr;
	}
	
	protected function getParamLevelByArgumentList ($paramName) {
			
		if (!is_null($paramName) || !empty($paramName)) {
			if (in_array($paramName, USER_PARAM_NAME_ARRAY_CATALOG_LEVEL))
				return USER_PARAM_LEVEL_CATALOG;
			else if (in_array($paramName, USER_PARAM_NAME_ARRAY_USER_LEVEL)) {
				return USER_PARAM_LEVEL_USER;
			}
			else if (in_array($paramName, USER_PARAM_NAME_ARRAY_COLUMN_LEVEL)) {
				return USER_PARAM_LEVEL_COLUMN;
			} else {
				return USER_PARAM_LEVEL_USER;
			}
		}		
	}
	
	protected function getDebugInfo($columnInfo, $connName, $databaseName, $catalogName, $primaryKeys, $sqlForDataGrid, $from) {
		$ret = "";
		
		$columnInfoKeys 		= array_keys($columnInfo);
		$columnInfoActualTypes 	= array();
		$columnInfoMetaTypes 	= array();
		$dateCols				= array();
		$dateTimeCols			= array();
		
		for ($i = 0; $i < count($columnInfoKeys); $i++) {
			$colName		= $columnInfoKeys[$i];
			$colMetaType	= $columnInfo[$colName]['metaType'];
			
			array_push($columnInfoActualTypes, $columnInfo[$columnInfoKeys[$i]]['actualType']);
			array_push($columnInfoMetaTypes, $columnInfo[$columnInfoKeys[$i]]['metaType']);
			
			if ($colMetaType == 'D') {
				array_push($dateCols, $colName);
			} else if ($colMetaType == 'T') {
				array_push($dateTimeCols, $colName);
			}
			
		}
		
		$def_date_source_format 			= ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_SOURCE_DATE_FORMAT);
		$def_date_destination_format 		= ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_DISPLAY_DATE_FORMAT);
		$def_datetime_source_format 		= ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_SOURCE_DATETIME_FORMAT);
		$def_datetime_destination_format 	= ET_ConnHelper::getDateAndDatetimeFormat($connName, PHPGRID_DISPLAY_DATETIME_FORMAT);
		
		$ret .= ET_DisplayHelper::localize("SELECTED_CONNECTION") . ":\t\t\t" . $connName . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("SELECTED_DATABASE") . ":\t\t\t". $databaseName . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("SELECTED_TABLE") . ":\t\t\t\t" . $catalogName . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("PRIMARY_KEYS") . ":\t\t\t\t\t" . ($primaryKeys ? implode(",", $primaryKeys) : "n/a") . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("COL_NAMES") . ":\t\t" . implode(",", $columnInfoKeys) . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("COL_TYPES") . ":\t\t\t" . implode(",", $columnInfoActualTypes) . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("META_COL_TYPES") . ":\t\t\t" . implode(",", $columnInfoMetaTypes) . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("SQL_FOR_GRID") . ":\t\t\t\t\t" . $sqlForDataGrid . PHP_EOL;
		$ret .= ET_DisplayHelper::localize("TABLE_NAME_PASSED_FOR_GRID") . ":\t" . $from . PHP_EOL;
		
		for ($j = 0; $j < count($dateCols); $j++) {
			$ret .= PHP_EOL . ET_DisplayHelper::localize("DATE_FORMAT_FOR_DEBUG", array($dateCols[$j], $def_date_source_format, $def_date_destination_format),
					PAGE_TYPE_GRID)  . PHP_EOL;
		}
		for ($k = 0; $k < count($dateTimeCols); $k++) {
			$ret .= ET_DisplayHelper::localize("DATETIME_FORMAT_FOR_DEBUG", array($dateTimeCols[$k], $def_datetime_source_format, $def_datetime_destination_format),
					PAGE_TYPE_GRID) . PHP_EOL;
		}
		
		return $ret;
	}
		
	public function resolveObjectFilter($objectFilter, $callFromsubgrid) {
		
		//if it's a subgrid we set up the final grid sql in masterdetail.php
		//WHERE condition will be used there. In that point for detail grid objectFilter is omitted!
		//if (is_null($objectFilter) || $objectFilter == '' || $callFromsubgrid)
		if (is_null($objectFilter) || $objectFilter == '')
			return '';
		else {			
			//LOWERCASE where IS A MUST! BECAUSE IN masterdetail.php IT IS CHECKED!
			//parenthesis needs because of further conditions (master-detail, column filter, etc)
			return " where (" . trim($objectFilter) . ")";
		}
	}
	
	protected function resolveProjectionList($projectionList) {
		
		if (is_null($projectionList) || $projectionList == '')
			return '*';
		else
			return trim($projectionList);
	}
	
	public function resolveOrderBy($orderBy, $primaryKeys, $filterDialog, $callFromSubgrid, $objectJoinAlias, $orderByAdvancedFilter = "") {
		
		$ret = ""; 
		
		//advanced filter: makes no sense to ordering one row - and messes up the SQL
		//subgrid: order by is inherited from master table
		if ($filterDialog || $callFromSubgrid) {			
			return $ret;
		} else if ((is_null($orderBy) || $orderBy == '')) {
			
			$ret = self::getDefaultOrderByClause($primaryKeys);
		
		} else if (!empty($orderBy)) {
			$ret = " ORDER BY ";
			$ret .= trim($orderBy);
		} else {
				$ret = "";
		}
		
		return $ret;
		
	}
	
	public static function getDefaultOrderByClause($primaryKeys) {
		
		$ret 		= "";
		$keysNum 	= count($primaryKeys);
		
		if (USE_DEFAULT_PK_ORDER_BY) {
			$ret = " ORDER BY ";
			
			for ($i = 0; $i < $keysNum; $i++) {
				
				if (empty($objectJoinAlias)) {
					$ret .= $primaryKeys[$i];
				} else {
					$ret .= $objectJoinAlias ."." . $primaryKeys[$i];
				}
				
				if ($i < $keysNum - 1)
					$ret .= ', ';
			}
			$ret .= " " . DEFAULT_GRID_ORDER_BY . " ";			
		}
		return $ret;
		
	}
	
	public function resolveGroupBy($groupBy, $filterDialog, $callFromSubgrid) {
		if (is_null($groupBy) || $groupBy == ''|| $filterDialog || $callFromSubgrid)
			//advanced filter: makes no sense to ordering one row - and messes up the SQL
			//subgrid: order by is inherited from master table
			return '';
		else 
			return " GROUP BY " . trim($groupBy);
		
	}
	
	public function resolveUnion($union) {
		
		if (is_null($union) || $union == '')
			return '';
		else
			return " UNION " . trim($union);
	}
	
	public function arrayKeysToLower($array){
		$ret = array();
		foreach ($array as $key=>$val){
			$key2 = strtolower($key);
			$ret[$key2] = $val;
		}
		
		return $ret;		
	}
	
	protected function getListStrFromArray($arr) {
		$ret = "";
		$size = count($arr) - 1;
	
		for($i = 0; $i < count($arr); $i++){
			$ret .= "'" . $arr[$i] . "'";
			if($i !== $size)
				$ret .= ", ";
		}
	
		return $ret;
	}
	
	public function getCatalogId($catalogInstanceId) {
		if (empty($catalogInstanceId)) return "";
		$tmp = explode(".", $catalogInstanceId);
		return $tmp[0];
	}
	
	public function getInstanceName($catalogInstanceId) {
		if (empty($catalogInstanceId)) return "";
		$tmp = explode(".", $catalogInstanceId);
		return $tmp[1];
	}
	
	public function generateCatalogInstanceId($catalogId, $instanceName) {
		return $catalogId . "." . $instanceName;
	}
	
	public function getCatalogInstanceLookupSQL ($connName) {
		
		$sql 		= "";
		$connType 	= ET_ConnHelper::getConnectionTypeByName($connName);
		
		$tableName 	= ET_SysTableHandler::getSpecificTableOrViewFullName(V_CATALOGINSTANCEID, $connName, false);
		
		if ($connType == DB_TYPE_OCI805) {
			$sql = "select cataloginstanceid, description from $tableName";
		}
		else if ($connType == DB_TYPE_ODBC_MSSQL) {
			//$sql = "select CAST(catalog_id AS varchar(16)) + '.' + instance_name as cataloginstanceid from $tableName";
			$sql = "select cataloginstanceid, description from $tableName";
		}
		else if ($connType == DB_TYPE_MYSQLI) {
			//$sql = "select concat(catalog_id, '.', instance_name) as cataloginstanceid from $tableName";
			$sql = "select cataloginstanceid, description from $tableName";
		}
		
		return $sql;
	}
	
	public function getMessageConnectionName ($connName) {
		
		
		$sql = str_replace("%conn_name%", $connName, $this->SQLgetMessageConnection);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);		
		$res = $this->conn->Execute($sql);		
		$ra = $res->NumRows();
		
		if ($ra == 0){
			return null;
		}
		
		$row = $res->fetchRow();
		$row = $this->arrayKeysToLower($row);
		
		if (empty($row['conn_name_msg'])) {
			$row['conn_name_msg'] = ET_METADATA_CONNECTION;
		}
			
		return $row['conn_name_msg'];	
	}
	
	public function getNologUploadFlag ($catalogId) {
		
		$sql = str_replace('%catalogId%', $catalogId, $this->SQLnologUpoad);
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		
		$res = $this->conn->Execute($sql);
		$ra = $res->NumRows();
		$ret = null;
		
		if ($ra == 0){
			return false;
		}
		
		$row = $res->fetchRow();
		$row = $this->arrayKeysToLower($row);
		 
		if ($row['cfg_value'] === 'false') {
			$ret = false;
		}
		else if ($row['cfg_value'] === 'true') {
			$ret = true;
		} 
		else {
			$ret = false;
		}		
		
		return $ret;
	}
	
	public function getAndInitializePredefinedValidationSettings($catalogId) {
		
		$ret 				= [];
		$dbValue 			= "";
		$systemSettingRow 	= defined('MAXNUMBER_VALIDATIONROW') ? MAXNUMBER_VALIDATIONROW : -1;
		$systemSettingErr 	= defined('MAXNUMBER_VALIDATIONERR') ? MAXNUMBER_VALIDATIONERR : -1;
		$systemSettingMsg 	= defined('MAXNUMBER_VALIDATIONMSG') ? MAXNUMBER_VALIDATIONMSG : -1;
		
		$sql 				= str_replace("%catalogId%", $catalogId, $this->SQLvalidationSettingsForCatalog);
		$res 				= $this->conn->Execute($sql);
		
		$ra = $res->NumRows();
		$ret['maxMsg'] = $systemSettingMsg;
		$ret['maxRow'] = $systemSettingRow;
		$ret['maxErr'] = $systemSettingErr;
		
		if ($res) {
			while ($row = $res->fetchRow()) {
				
				$row = $this->arrayKeysToLower($row);
				
				if ($row['cfg_id'] == CFG_ID_MAXNUMBER_VALIDATIONERR) {
					$ret['maxErr'] = $row['cfg_value'];
				} else if ($row['cfg_id'] == CFG_ID_MAXNUMBER_VALIDATIONMSG) {
					$ret['maxMsg'] = $row['cfg_value'];
				} else if ($row['cfg_id'] == CFG_ID_MAXNUMBER_VALIDATIONROW) {
					$ret['maxRow'] = $row['cfg_value'];
				}
			}
		}
		//echo "<br>" . $ret['maxRow'];
		return $ret;
	}
	
	public function getGroupByAndOrderByForCatalogInstance($catalogInstanceId) {
		
		$ret 		= [];
		$catId 		= $this->getCatalogId($catalogInstanceId);
		$instName 	= $this->getInstanceName($catalogInstanceId);
		
		$sql 		= str_replace("%catalogId%", $catId, $this->SQLGroupByAndOrderByForCatalog);
		$sql 		= str_replace("%instanceName%", $instName, $sql);
		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);
		$res = $this->conn->Execute($sql);
		$ra = $res->NumRows();
		
		if ($ra === 0){
			return false;
		}
		
		$row = $res->fetchRow();
		$row = $this->arrayKeysToLower($row);
		
		$ret['groupBy'] = $row['objectgroupby'];
		$ret['orderBy'] = $row['objectorder'];
		
		return $ret;
		
	}
	
	public function getLanguageOptions() {
		
		$ret = array();		
		
		$sql = str_replace('%settingName%', 'ui_language', $this->SQLLookupSystemSetting);		
		$this->conn->SetFetchMode(ADODB_FETCH_ASSOC);		
		$res = $this->conn->Execute($sql);
		
		$ra = $res->NumRows();
		
		if ($ra === 0){
			return false;
		} else {		
			while ($row = $res->fetchRow()) {
				
				$row 		= $this->arrayKeysToLower($row);
				$resDataTmp = array();
				
				if ($row['ind_active'] === '1') {
					$resDataTmp[$row['lookup_char']] = $row['lookup_description'];					
				}
				
				$ret []= $resDataTmp; 
			}			
		}
		
		return $ret;
	}
	
	public function getLookupCatalogInstanceIdByName ($lookupName) : array {
		
		$ret = [];
		$sql = str_replace('%lookupName%', $lookupName, $this->SQLLookupCatalogInstanceIdByName);
		$res = $this->conn->Execute($sql);
		
		if ($res !== false) {
			$row = $res->fetchRow();
			$ret['catalogId'] 		= $row['catalog_id_lookup'];
			$ret['instanceName']	= $row['instance_name_lookup'];
		}
		
		return $ret;
		
	}
	
	public function getLookupNullable($catalgId, $columnName) {
		
		$ret = false;
		$sql = str_replace('%catalogId%', $catalgId, $this->SQLLookupNullable);
		//$sql = str_replace('%lookupName%', $lookupName, $sql);
		$sql = str_replace('%columnName%', $columnName, $sql);
		
		$res = $this->conn->Execute($sql);
		
		if ($res !== false) {
			$row = $res->fetchRow();			
			$ret = $row['ind_add_null'];
		}
		
		return $ret;
		
	}
	
	public function getLookupType($lookupName) {
		
		$ret = '0';
		
		$sql = str_replace('%lookupName%', $lookupName, $this->SQLLookupType);
		$res = $this->conn->Execute($sql);
		
		if ($res !== false) {
			$row = $res->fetchRow();
			$ret = $row['lookup_type'];
		}
		
		return $ret;
	}
	
	/***
	 * logs detailed messages into etx_message_detailed
	 * function requires the final sql isnert statement to avoid a lot of parameters in function call 
	 * 
	 * @param unknown $sql
	 */
	public function logDetailedValidationMessages ($sql) {
		
		$ret = null;
		$ret = $this->conn->Execute($sql);
		
		if ($ret === false) {
			$dbErrorMsg = $this->conn->ErrorMsg();
			throw new Exception("Detailed log error!<br>" . $dbErrorMsg);
		}		
		
		return $ret;
		
	}

	public function saveRegistrationData($regDataForQuery) {
		
		//"INSERT INTO et_user (username, ind_active, password, email, firstname, lastname) values (?, ?, ?, ?, ?, ?)"
		$preparedSQL 	= $this->conn->prepare($this->SQLSaveRegistrationData);
		$result 		= $this->conn->execute($preparedSQL, $regDataForQuery);
		
		if ($result === false) {
			$systemLogger = new ET_LoggingHelperSystem();
			$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, "Rergistration data saving error! Cannot get sql.\r\n
					DB error message: " . $this->conn->errorMsg());
			
			return false;
		} else  {
			
			$rowCnt = intval($this->conn->affected_rows());
			if ($rowCnt === 1) {
				return true;
			} else {
				return false;
			}
		}
	}
	
	/***
	 * Checks if given e-mail address exists in table et_user.
	 *
	 * @param string $email
	 * @throws Exception
	 * @return boolean - true if email exists, false if not
	 */
	public function doesEmailExist($email) {
		
		//SELECT username from et_user where email = ?;
		$sql = $this->SQLCheckExisitngEmail;
		
		$preparedSQL = $this->conn->prepare($sql);
		
		try {
			$result = $this->conn->execute($preparedSQL, [$email]);
			//ET_DisplayHelper::vardumpHighlighPretty($result);
			
			if ($result->rowCount() !== 0 ) {
				return true;
			} else {
				return false;
			}
		} catch (Exception $e) {
			$systemLogger = new ET_LoggingHelperSystem();
			$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, "Rergistration email check query error! SQL: $result->sql");
			throw new Exception("REGISTRATION_EMAIL_CHECK_QUERY_ERROR");
			
		}
	}
	
	public function checkExistingUserName($username) {
		
		$sql = $this->SQLCheckExisitngUserName;
		$sql = str_replace('%username%', $username, $sql);
		$res = $this->conn->Execute($sql);
		$ret = null;
		
		if ($res !== false) {
			//usercnt
			$row 		= $res->fetchRow();
			$userCnt 	= $row['usercnt'];
			if ($userCnt === "0") {
				$ret = false;
			} else {
				$ret = true;
			}
		} else {
			$systemLogger = new ET_LoggingHelperSystem();
			$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, "Exisitng username checking query error! SQL: $sql");
			throw new Exception("REGISTRATION_USERNAME_CHECK_QUERY_ERROR");
		}
		return $ret;
		
	}
	
	/***
	 * Returns username and verification GUID by email and pw. Returns array["username" => "asdf", "verify_guid" => "1sadf31"] on succes
	 * and false on failure.
	 *
	 * @param string $email
	 * @param string $pw
	 * @throws Exception
	 * @return boolean|array{}
	 */
	public function getUserInfoByEmailAndPw ($email, $pw) {
		
		$ret			= [];
		$pwMatch 		= false;
		$preparedSQL 	= $this->conn->prepare($this->SQLGetUserDataByEmail);
		$username		= "";
		$verifyGuid		= "";
		
		try {
			$result = $this->conn->execute($preparedSQL, [$email]);
			
			if ($result->rowCount() !== 0 ) {
				while ($row = $result->fetchRow()) {
					
					$username 	= $row['username'];
					$pwFromDb 	= $row['password'];
					$pwMatch 	= password_verify($pw, $pwFromDb);
					
					if ($pwMatch) {
						break;
					}
				}
				if (!$pwMatch) {
					return "VERIFY_RESEND_AUTH_ERROR";
				} else {
					$ret["username"] 	= $username;
					$verifyGuid			= $this->getVerifyGuidByUsername($username);
				}
				
				if ($verifyGuid === false) {
					return false;
				} else {
					$ret["verify_guid"] = $verifyGuid;
				}
				
				return $ret;
				
			} else {
				return false;
			}
		} catch (Exception $e) {
			$systemLogger = new ET_LoggingHelperSystem();
			$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, "Rergistration email check query error! SQL: $result->sql");
			throw new Exception("REGISTRATION_EMAIL_CHECK_QUERY_ERROR");
			
		}
	}
	
	public function getVerifyGuidByUsername($username) {
		
		$ret	= null;
		$sql  	= str_replace("%username%", $username, $this->SQLGetUserParameterByUsername);
		$sql 	= str_replace("%parameterName%", USER_PARAM_VERIFYGUID, $sql);
		
		$result = $this->conn->execute($sql);
		
		if ($result !== false && $result->rowCount() == 1 ) {
			$row = $result->fetchRow();
			return $row["param_value"];
		} else {
			$systemLogger = new ET_LoggingHelperSystem();
			$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, "Cannot retrieve verify GUID! SQL: $sql");
			return false;
		}
		
	}
	
	/***
	 * 
	 * @param array $orderingValues
	 * @return bool
	 */
	protected function validateDetailGridOrdering ($orderingValues) :bool {
		
		$ret = true;
		$valueCount = count($orderingValues);
		
		if ($valueCount == 1) {		
			 $ret = true;
		} else if ($valueCount == 2 || $valueCount == 3) {
			
			if (!in_array("2", $orderingValues) || !in_array("3", $orderingValues)) {				
				$ret = false;
			} else if ($valueCount == 3 && !in_array("4", $orderingValues)) {				
				$ret = false;
			} else {
				
				$prevValue = -1;
				for ($i = 0; $i < $valueCount; $i++) {
					
					$actValue = $orderingValues[$i];
					
					if (ET_DisplayHelper::is_blank($actValue) || $actValue == "null") {						
						$ret = false;
						break;
					}else if ($actValue == $prevValue) {						
						$ret = false;
						break;
					} else	if (!in_array($actValue, array("2", "3", "4")) || ($valueCount == 2 && $actValue == "4")) {						
						$ret = false;
						break;
					}
					$prevValue = $actValue;
				}
			}
		} else {			
			$ret = false;
		}
		
		if (!$ret) {
			ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("DETAIL_ORDER_ERROR"), "niota");
		}
		
		return $ret;		
		
	}
	
	public function saveVerifyData($regData, $guid) {
		
		$email 		= $regData["email"];
		$username 	= $regData["username"];
		$systemLogger = new \ET_LoggingHelperSystem();
		
		try {
			$userSettingArr = ET_GeneralHelperAdmin::createUserSettingArray($username, USER_PARAM_VERIFYGUID, $guid, time());
			self::saveUserSetting($userSettingArr);
			return true;
		} catch (Exception $e){
			$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR_SQL,  "Verfiication link save failed!" . "\n[SQL]\t");
			throw new  Exception("Verification link saving error!");
		}
	}
	
	
	public function getActivationData($guid) {
		
		
		$sql 			= $this->SQLActivationData;
		$preparedSQL 	= $this->conn->prepare($sql);
		$ret			= [];
		
		try {
			$result = $this->conn->execute($preparedSQL, [$guid]);
			//var_dump($result);die();
			if ($result !== false) {
				if($result->rowCount() === 1) {
					$row = $result->fetchRow();
					$ret['regTS'] 		= $row['param_filter_01'];
					$ret['username'] 	= $row['username'];
					
					return $ret;
				} else {
					return false;
				}
			} else {
				$systemLogger = new ET_LoggingHelperSystem();
				$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, "ERROR GETTING ACTIVATION GUID" .  $this->conn->errorMsg());
				return false;
			}
		} catch (Exception $e) {
			$systemLogger = new ET_LoggingHelperSystem();
			$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, "ERROR GETTING ACTIVATION GUID" . $this->conn->errorMsg());
			throw new Exception("ERROR GETTING ACTIVATION GUID");
			
		}
	}
	
	public function activateUser($username) {
		
		$sql = str_replace('%username%', $username, $this->SQLAcitvateUser);
		$result = $this->conn->execute($sql);
		
		if ($result !== false) {
			
			if ($this->conn->affected_rows() == 1) {
				return ACTIVATION_SUCCESS;
			} else {
				// there is no way to check exactly if an UPDATE stmt is right but no affected rows
				if ($this->conn->_affected === false && $this->conn->_errorCode === false) {
					return ACTIVATION_ALREADY_ACTIVATED;
				}
				return ACTIVATION_DB_ERROR;
			}
			
		} else {
			return ACTIVATION_DB_ERROR;
		}
	}
	
	public function clearUserSetting($userName, $userSettingName) {
		
		//$userSettingArr = ET_GeneralHelperAdmin::createUserSettingArray($userName, $userSettingName, "");
		
		//$userName 			= $userSetting['userName'];
		//$paramName 			= $userSetting['paramName'];		
		$paramFilter1 	= "";
		$paramFilter2 	= "";
		$paramFilter3 	= "";
		$paramFilter4 	= "";
		$paramFilter5 	= "";
		
		$possibleExistingSetting = $this->findPossiblyExistingParameter($userName, $userSettingName, $paramFilter1, $paramFilter2, $paramFilter3, $paramFilter4, $paramFilter5);
		
		while ($row = $possibleExistingSetting->fetchRow()) {
			$row 			= $this->arrayKeysToLower($row);
			$parameterId 	= $row['param_id'];
			$ret 			= $this->deleteUserSetting($parameterId);
		}
	}
}

