<?php
 class ET_NiotaException extends Exception {
 	 	
 	protected $putIntoSession;
 	protected $page;
 	protected $displayGrid = false;
 	
 	public function __construct($message, $putIntoSession = false, $page = "", $variablesForLocalize = array(), $displayGrid = false){
 		
 		$message = ET_DisplayHelper::localize($message, $variablesForLocalize);
 		
 		if ($putIntoSession) {
 			$this->putIntoSession 	= $putIntoSession;
 			$this->page 			= $page;
 			$this->displayGrid		= $displayGrid;
 			
 			ET_DisplayHelper::addErrorLine($message, $page); 			
 		}
 		
 		parent::__construct($message); 		
 	}
 	
 	public function isGridDisplayable() {
 		return $this->displayGrid;
 	}
 	
 }