<?php

	class ET_NiotaUser {
		
		protected $username						= "";
		protected $visibleCatalogInstances 		= array();
		protected $visibleConnections			= array();
		protected $userRights					= array();
		protected $userGroups					= array();
		protected $userSettings					= array();
		protected $userSettingsCatalog			= array();
		protected $userConfig					= array();
		protected $callableObjectsForCatalogs	= array();
		protected $callableObjects 				= array();
		protected $adminFeatures				= array();
		protected $dynamicMenu					= array();
		protected $dynamicMenuShown				= FALSE;
		
		protected $description 		= "";
		protected $email			= "";
		protected $firstname		= "";
		protected $lastname			= "";
		protected $phone			= "";
		protected $activeLdap		= null;
		protected $usernameLdap		= "";
		protected $isAdmin			= null;
		protected $active			= null;
		    
		protected $gridLanguage		= "";
		protected $systemLanguage	= "";
		
		function __construct($username) {
			$this->username = $username;
			$this->initialize();
		}
		
		protected function initialize() {			
			$metaDataConnector 	= ET_MetaDataConnector::getInstance();
			$userInfo 			= $metaDataConnector->getUserInfo($this->username);
			$this->fillUserInfo($userInfo);
			$this->active = $metaDataConnector->isUserActive($this->username);
			
			if ($this->get_active()) {
				$this->userGroups 		= $metaDataConnector->getUsergroups($this->username);				
				$this->userSettings		= $this->mergeUserSettings($metaDataConnector);
				$this->userConfig		= $this->fillUserConfig($metaDataConnector);
				
				$orderBy = DEFAULT_CATALOG_ORDER_BY;
				if (isset($this->userSettings[USER_PARAM_CATALOG_ORDER_BY]))
					$orderBy = $this->userSettings[USER_PARAM_CATALOG_ORDER_BY];
				
				$this->visibleCatalogInstances 	= $metaDataConnector->getVisibleCatalogInstances($this->userGroups, $orderBy);
				//this array is only for different catalogId-s
				$catalogIds = array();
				$catalogInsanceIds = array();
				
				for ($i = 0; $i < count($this->visibleCatalogInstances); $i++) {
					
					$row = $this->visibleCatalogInstances[$i];
					
					$catalogId 		= $row['catalog_id'];
					$instanceName 	= $row['instance_name'];

					$catalogInstanceId = $metaDataConnector::getInstance()->generateCatalogInstanceId($catalogId, $instanceName);
					
					//gathering different catalogId-s for callable objects
					if (!in_array($catalogId, $catalogIds)) {
						array_push($catalogIds, $catalogId);
					}
					array_push($catalogInsanceIds, ET_MetaDataConnector::getInstance()->generateCatalogInstanceId($catalogId, $instanceName));
					
					$userRightRow = $metaDataConnector->getUserRightsForCatalogInstance($catalogInstanceId, $this->userGroups);
					$this->userRights[$catalogInstanceId] = $userRightRow;
					
				}

				//$this->userSettingsCatalog = $this->mergeUserSettingsCatalog($metaDataConnector, $catalogInsanceIds);
				
				for ($i = 0; $i < count($catalogIds); $i++) {
					$catalogId = $catalogIds[$i];
					$callableObjectsForCatalogId = $metaDataConnector->getCallableObjectsForCatalog($catalogId, $this->userGroups);
					$this->callableObjectsForCatalogs[$catalogId] = $callableObjectsForCatalogId;
				}
				
				$this->dynamicMenu = $metaDataConnector->getDynamicMenuChildren(null, $this->userGroups);				
				$this->callableObjects = $metaDataConnector->getCallableObjects($this->userGroups);				
				$this->checkDynamicMenu($this->dynamicMenu);
					
			}
		} 

		public function setAdminFeature($optionKey, $adminFeature) {
			$this->adminFeatures[$optionKey] = $adminFeature;
		}
		
		public function getAdminCallableObject($optionKey, $callableObjectName) {
			return $this->adminFeatures[$optionKey]->getCallableObject($callableObjectName);
		}
		
		public function getAdminTableLevelProps($optionKey, $fileName) {
			if (ET_StringCheck::endsWith($fileName, "_reverse"))
				$optionKey = $fileName;
			if (!isset($this->adminFeatures[$optionKey])) return [];
			return $this->adminFeatures[$optionKey]->getTableLevelCallableProps();
		}
		
		public function getAdminLineLevelProps($optionKey, $fileName) {
			if (ET_StringCheck::endsWith($fileName, "_reverse"))
				$optionKey = $fileName;
			if (!isset($this->adminFeatures[$optionKey])) return [];
			return $this->adminFeatures[$optionKey]->getLineLevelCallableProps();
		}
		
		
		protected function mergeUserSettings($metaDataConnector) {
			$userSettingsAny = $metaDataConnector->getUserSettings(QUERY_ANY, USER_PARAM_LEVEL_USER);
			$userSettings = $metaDataConnector->getUserSettings($this->username, USER_PARAM_LEVEL_USER);
			return array_merge($userSettingsAny, $userSettings);
		}

		protected function fillUserConfig($metaDataConnector) {
			
			return $metaDataConnector->getUserConfig($this->username);
		}
		
		protected function processUserSettingsCatalogArray($userSettingsCatalogs, $targetArray) {
			
			
			for ($i = 0; $i < count($userSettingsCatalogs); $i++) {
				$row = $userSettingsCatalogs[$i];
				
				$catalogId = $row['catalog_id'];
				$instanceName = $row['instance_name'];
				$paramName = $row['param_name'];
				$paramValue = $row['param_value'];
				
				$catalogInstanceId = ET_MetaDataConnector::getInstance()->generateCatalogInstanceId($catalogId, $instanceName);
				
				if (!array_key_exists($catalogInstanceId, $targetArray)) {
					$targetArray[$catalogInstanceId] = array();
				}
				
				$paramArray = $targetArray[$catalogInstanceId];
				
				$paramArray[$paramName] = $paramValue;
				
				$targetArray[$catalogInstanceId] = $paramArray;
			}

			return $targetArray;
		}
		
		
		protected function checkDynamicMenu($dynamicMenuLevel) {
			if (empty($dynamicMenuLevel)) return;
			
			for ($i = 0; $i < count($dynamicMenuLevel); $i++) {
				$menuItem = $dynamicMenuLevel[$i];
				
				if (!is_null($menuItem->get_transaction())) {
					if (empty($menuItem->get_children())) {
						$this->dynamicMenuShown = TRUE;
					} else {
						ET_DisplayHelper::addErrorLine("Dynamic menu structure is invalid.", "niota");
					}
				} else {
					self::checkDynamicMenu($menuItem->get_children());
				}
			}
			return;
		}
		
		public function is_superUser() {
			return ($this->username == SUPERUSER);
		}
		
		public function getFilterFromVisibleConnsOrCats($filterType) {
			$ret = array();
			$filterField = ($filterType == FILTER_CONNECTION) ? 'conn_name' : ($filterType == FILTER_CATEGORY ? 'objectcategory' : null);
			
			if (is_null($filterField)) return FALSE;
			
			for ($i = 0; $i < count($this->visibleCatalogInstances); $i++) {				
				
				if ($this->visibleCatalogInstances[$i]['hidden'] == 0) {
					$fieldText = $this->visibleCatalogInstances[$i][$filterField];
					$fieldDisplay = ($filterField == 'conn_name') ? $this->visibleCatalogInstances[$i]['conn_name_display'] : $this->visibleCatalogInstances[$i][$filterField];
					
					$ret[$fieldText] = [$fieldText, $fieldDisplay];
				}				
			}
			ksort($ret);
			return $ret;
		}
		
		protected  function fillUserInfo($userInfo){
			
			//Backwards direction (character conversion) is not working!!
			foreach ($userInfo as $key => $value) {
				$userInfo[$key] = ET_StringCheck::convertToUTF8($value, ET_METADATA_CONNECTION);
			} 
			
			
			$this->firstname 	= $userInfo['firstname'];
			$this->lastname 	= $userInfo['lastname'];
			$this->email 		= $userInfo['email'];
			$this->phone 		= $userInfo['phone'];
			$this->active 		= $userInfo['is_active'];
			$this->isAdmin 		= $userInfo['is_admin'];
			
			$this->setLanguage($userInfo);
		}
		
		public function get_userGroups() {
		  return $this->userGroups;
		}
		
		public function get_userSettings() {
			
			return $this->userSettings;
		}
		
		public function get_userSettingsCatalog($catalogInstanceId) {
			return isset($this->userSettingsCatalog[$catalogInstanceId]) ? $this->userSettingsCatalog[$catalogInstanceId] : array();
		}
		
		public function get_visibleCatalogInstances($connFilterValue = 'all', $categoryFilterValue = 'all') {
			$ret = array();

			$preFiltered = array();
			
			for ($i = 0; $i < count($this->visibleCatalogInstances); $i++) {
				if ($this->visibleCatalogInstances[$i]["hidden"]) continue;
				if ($connFilterValue != 'all') {
					if ($this->visibleCatalogInstances[$i]["conn_name"] == $connFilterValue)
						array_push($preFiltered, $this->visibleCatalogInstances[$i]);
				} else {
					array_push($preFiltered, $this->visibleCatalogInstances[$i]);
				}
			}
			
			for ($i = 0; $i < count($preFiltered); $i++) {
				if ($categoryFilterValue != 'all') {
					if ($preFiltered[$i]["objectcategory"] == $categoryFilterValue)
						array_push($ret, $preFiltered[$i]);
				} else {
					array_push($ret, $preFiltered[$i]);
				}
			}
			
			return $ret;
		}
		
		public function isCatalogInstanceHidden ($catalogInstanceIdInput) {
			
			for ($i = 0; $i < count($this->visibleCatalogInstances); $i++) {
				$catalogInstance 	= $this->visibleCatalogInstances[$i];
				$catalogInstanceId 	= $catalogInstance['catalog_id'] . "." . $catalogInstance['instance_name'];
				
				if ($catalogInstanceId == $catalogInstanceIdInput) {
					return $catalogInstance['hidden'] == 1 ? true : false;
				}
			}
			return false;
		}
		
		public function isCatalogInstanceVisible($catalogInstanceId) {
			for ($i = 0; $i < count($this->visibleCatalogInstances); $i++) {
				$catalogInstance = $this->visibleCatalogInstances[$i];
				$actCatalogInstanceId = $catalogInstance['catalog_id'] . "." . $catalogInstance['instance_name'];
				if ($actCatalogInstanceId == $catalogInstanceId) return true;
			}
			return false;
		}
		
		public function get_userRights() {
		  return $this->userRights;
		}
		
		public function getCallableObjectsForCatalog($catalogId, $bindingLevel = -1) {
			$ret = array();
			
			if (!isset($this->callableObjectsForCatalogs[$catalogId]))
				return $ret;
					
			$callableObjectsForCatalogId = $this->callableObjectsForCatalogs[$catalogId];
				
			for ($i = 0; $i < count($callableObjectsForCatalogId); $i++) {
				$callableObjectForCatalogId = $callableObjectsForCatalogId[$i];

				$callableObject = $this->getCallableObject($callableObjectForCatalogId['callable_object']);
				
				$callableObjectForCatalogId['command'] 			= $callableObject['command'];
				$callableObjectForCatalogId['conn_name'] 		= $callableObject['conn_name'];
				$callableObjectForCatalogId['description'] 		= $callableObject['description'];
				$callableObjectForCatalogId['messaging_active'] = $callableObject['messaging_active'];
				$callableObjectForCatalogId['reload_grid'] 		= $callableObject['reload_grid'];
				$callableObjectForCatalogId['name'] 			= $callableObject['name'];
				
				if ($bindingLevel != -1) {
					if ($callableObjectForCatalogId['binding_level'] == $bindingLevel)
						array_push($ret, $callableObjectForCatalogId);
				} else {
					array_push($ret, $callableObjectForCatalogId);
				}
			}
			return $ret;
		}
		
		public function isThereAnyCallableObjectForCatalog($catalogId){
			$callableObjectsForCatalogId = $this->getCallableObjectsForCatalog($catalogId);
			return (!empty($callableObjectsForCatalogId));
		}
		
		public function getCallableObject($callObjectName) {
			if (isset($this->callableObjects[$callObjectName]))
				return $this->callableObjects[$callObjectName];
			return null;
		}
		
		public function getCallableObjects() {
			return $this->callableObjects;
		}
		
		public function printDynamicMenu() {
			if ($this->dynamicMenuShown)
				ET_DynamicMenu::showMenu($this->dynamicMenu);
		}
		
		public function printPersonalModal($fromAdminPage = false, $currentFileName, $targetMenuItem = "") {
			ET_DisplayHelper::printPersonalModal($this->firstname, $this->lastname, $this->email, $this->phone, $fromAdminPage, $currentFileName, $targetMenuItem, $this->gridLanguage);
		} 
		
		protected function findDynamicMenuItem($id, $item) {
			
			if ($item->get_menuId() == $id) {
				return $item;
			}
			$children = $item->get_children();
			
			for ($i = 0; $i < count($children); $i++) {
				$child = $children[$i];
				
				$actRet = $this->findDynamicMenuItem($id, $child);
				
				if (!is_null($actRet))
					return $actRet;				
			}
			return null;			
		}
		
		public function  getDynamicMenuItemById($id) {			
			return $this->findDynamicMenuItem($id, $this->dynamicMenu[0]);
		}
		
		public function getSelectedAdminMenuItem () {
			
			$menuState	= isset($this->userSettings[USER_PARAM_ADMIN_MENU_STATE]) ? $this->userSettings[USER_PARAM_ADMIN_MENU_STATE] : "";
			
			if ($_SESSION['first_login']) {
				$menuState = !empty($menuState) ? $menuState : ADMIN_DEFAULT_PAGE;
				$_SESSION[USER_PARAM_ADMIN_MENU_STATE] = $menuState;
			}
			else 
				$menuState = isset($_SESSION[USER_PARAM_ADMIN_MENU_STATE]) ? $_SESSION[USER_PARAM_ADMIN_MENU_STATE] : ADMIN_DEFAULT_PAGE;
			
			return $menuState;
		}
		
		public function get_username(){
			return $this->username;
		}
		
		public function get_description(){
		  return $this->description;
		}
		
		public function get_active(){
		  return $this->active;
		}
		
		public function get_email() {
		  return $this->email;
		}
		
		public function get_firstname() {
		  return $this->firstname;
		}
		
		public function get_lastname() {
		  return $this->lastname;
		}
		
		public function get_activeLdap() {
		  return $this->activeLdap;
		}
		
		public function get_usernameLdap() {
		  return $this->usernameLdap;
		}
		
		public function get_isAdmin() {
		  return $this->isAdmin;
		}
		
		public function get_phone() {
		  return $this->phone;
		}
		
		public function get_fullName(){
			return $this->firstname . " " . $this->lastname;
		}

		public function reset() {
			$this->initialize();
		}
		
		public static function getNiotaUserFromSession() {
			
			return isset($_SESSION[SESS_USEROBJECT]) ? unserialize($_SESSION[SESS_USEROBJECT]) : null;
		}
		
		public function flushNiotaUser() {
			$_SESSION[SESS_USEROBJECT] = serialize($this);
			//var_dump($_SESSION[SESS_USEROBJECT]);
			//die();
		}
		
		public function get_userConfig(){
			return $this->userConfig;
		}
		
		public function getDebugGridConfig() {
			return $this->userConfig[USER_CONFIG_DEBUG_GRID];
		}
		
		public function getSQLLogLevelConfig() {
			return $this->userConfig[USER_CONFIG_SQL_LOGLEVEL];
		}
		
		public function getGridLanguage() {
			return  $this->gridLanguage;
		}
		
		public function getSystemLanguage() {
			return  $this->systemLanguage;
		}
		
		protected function setLanguage($userSettings) {
			
			if (!isset($userSettings['grid_language']) || ET_DisplayHelper::is_blank($userSettings['grid_language'])) {
				$this->gridLanguage = GRID_AREA_LANGUAGE;
			} else {
				$this->gridLanguage = $userSettings['grid_language'];
			}
			
			$this->systemLanguage = SYSTEM_LANGUAGE;
		}
		
		
		
		
		
		
		
	}
	
	
	