<?php
class ET_PathHelper {
	
	/***
	 * Returns the path as a relative path to the NIOTA_ROOT_DIR constant.
	 * */
	public static function getRelativePath($pathPart) {
		
		$ret 			= "";
		$pathPartLength = strlen($pathPart);
		//$pathPart 		= str_ireplace("\\", "/", $pathPart);

		if (strpos($pathPart, "/") === 0) {
			$pathPart = substr($pathPart, 1);
		}
		if (strrpos($pathPart, "/") !== $pathPartLength - 1) {
			$pathPart .= "/";
		}
		
		$ret =  NIOTA_ROOT_DIR . "/" . $pathPart;
		$ret = str_replace("\\", "/", $ret);
		
		return $ret;
	}
	
	/***
	 * Absolute path to niota-application dir => htdocs/niota/app/
	 * @param unknown $pathPart
	 * @return string
	 */
	public static function getAbsolutePath($pathPart) {
		
		$absRoot 		= "";
		$slash 			= self::getSlash();
		$niotaRootDir	= substr(NIOTA_ROOT_DIR, 1);
		
		$absRoot = $_SERVER['DOCUMENT_ROOT']  . $slash . $niotaRootDir . $slash; 
		
		if (strpos($pathPart, "\\") === 0 || strpos($pathPart, "/") === 0) {
			$pathPart = substr($pathPart, 1);
		}
		
		return $absRoot . $pathPart . $slash;
	}
	
	
	/***
	 * Returns the path of the 'conf' folder of the client if set. Otherwise the system conf folder path is rturned. 
	 * @return string
	 */
	public static function getClientConfSubFolderAbsolutePath($targetDir) :string{
		$path = "";
		
		if (isset($_SESSION[SESS_CLIENT])) {
			$clientSetting   	= $_SESSION[SESS_CLIENT];
			
			if ($clientSetting == CLIENT_SYSTEM) {
				$path =  dirname(__FILE__)  . "/../conf/";
			} else {
				$clientFolderName 	= ET_PropertiesStartUp::getInstance()->myParameter('conffolder');
				$path 				=  dirname(__FILE__)  . "/../../../conf/$clientFolderName/$targetDir/";			
			}
		} else {
			return $path;
		}
		
		return $path;
	}
	
	public static function getPathMemeberCount($inputStr) {
		
		$count = 0;
		
		if (strpos($inputStr, "/") !== false) {
			$count = count(explode('/', $inputStr));
		} else if (strpos($inputStr, "\\") !== false) {
			$count = count(explode('\\', $inputStr));
		} else {
			$count = 1;
		}
		
		return  $count;
	}
	
	public static function ensureTrailingSlashInRelativePathPart($inputStr) {
		
		$ret = "";
		
		if (strpos($inputStr, "\\") == $customFolderLength - 1 ) {			
			$ret = substr($inputStr, 0, $customFolderLength - 2);
			$ret .= "/";
		} else if (strpos($inputStr, "/") !== $customFolderLength - 1 ) {
			$ret .= "/";
		} else {
			return $inputStr;
		}
		
		return $ret;
		
	}
	
	public static function getOSType() {
		
		return (strpos(strtoupper(PHP_OS), "WIN") !== FALSE) ? OS_WIN : OS_LINUX;
		
	}	
	
	/***
	 * Generates the customer's custom icon/image path relative for the document root
	 * Can be used for html image refernces
	 * @param string $fileName
	 */
	public static function getCustomerImagePathForHTMLSource ($fileName) {
		
		$clientFolderName = isset($_SESSION[SESS_CLIENT_FOLDER_NAME]) ? $_SESSION[SESS_CLIENT_FOLDER_NAME] : false;
		
		if (!$clientFolderName) {
			throw new Exception("Client folder is not set!");
		} else {
			return NIOTA_ROOT_DIR . "/../conf/$clientFolderName/" . CLIENT_FOLDER_FORMATTING . "/images/$fileName";
		}
		
	}
	
	/**
	 * Generates system icon/image path relative for the document root
	 * Can be used for html image refernces
	 * @param string $fileName
	 * @return string
	 */
	public static function getSystemImagePathForHTMLSource ($fileName) {
		
		return NIOTA_ROOT_DIR . "/etixpert/images/$fileName";
		
	}
	
	public static function getLoginPathWithClientDef() {
		
		$clientName = "";
		try {
			$clientName = ET_CookieHandler::getCookieClientName();
		} catch (Exception $e) {
			$clientName = CLIENT_SYSTEM;
			ET_DisplayHelper::addErrorLine($e->getMessage(), "login");
		}
		
		$clientNameToURL 	= $clientName !== CLIENT_SYSTEM ? "?client=$clientName" : "";
		return NIOTA_ROOT_DIR . "/login.php$clientNameToURL";
		
	}
	
	private static function getSlash() {
		
		$osType = self::getOSType();
		return $osType == OS_WIN ? "\\" : "/";
		
	}
			
}