<?php 

	class ET_PopupHeader {
		
		protected $divHeader;
		protected $divHeaderText;
		protected $divClose;
		protected $imgClose;
		protected $spanHeader;
		protected $headerId;
		protected $headerTitle;
		protected $divToClose;
		
		public function __construct($headerId, $headerTitle, $divToClose) {
			
			$this->divHeader		= new HTMLDiv();
			$this->divHeaderText 	= new HTMLDiv();
			$this->divClose			= new HTMLDiv();
			$this->imgClose			= new HTMLImage();
			$this->spanHeader		= new HTMLSpan();
			$this->headerId			= "";
			$this->headerTitle		= "";
			
			$this->headerId 	= $headerId;
			$this->headerTitle 	= $headerTitle;
			$this->divToClose 	= $divToClose;
		}
		
		protected function setUpHeader() {
			
			$this->divHeader->set_class("import-header")->set_id($this->headerId);
			$this->divHeaderText->set_class("vertical-middle-content height-100perc float-left");
			$this->divClose->set_class("vertical-middle-content height-100perc float-right margin-left-5px");
			
			$this->spanHeader->set_id("upload_window_title")->set_display_text($this->headerTitle)
								->set_class("element-block float-left");
			$this->imgClose->set_src(NIOTA_ROOT_DIR . "/etixpert/images/close.png")
							->set_onclick("closeDefault(\"" . $this->divToClose . "\");")
							->set_class("float-right pointer element-block")
							->set_title(ET_DisplayHelper::localize("CLOSE", null, PAGE_TYPE_GRID));
		}
		
		
		public function printHeader() {
			
			$this->setUpHeader();
			
			$this->divHeader->printOpeningTag();
				$this->divClose->printOpeningTag();
					$this->imgClose->printOpeningTag();
				$this->divClose->printClosingTag();
				$this->divHeaderText->printOpeningTag();
					$this->spanHeader->printOpeningTag();
						$this->spanHeader->printDisplayText();
					$this->spanHeader->printClosingTag();
				$this->divHeaderText->printClosingTag();
			$this->divHeader->printClosingTag();
		}
	}


?>