<?php
 class ET_PopupWindow {
 	
 	protected $divImport;
 	protected $formUpload;
 	protected $inputUpload;
 	protected $inputHidden;
 	protected $inputHiddenEditable;
 	protected $inputHiddenCoSource;
 	protected $inputHiddenCoBindingLevel;
 	protected $inputImage;
 	protected $labelImport; 	
 	protected $labelFileChoose;
 	protected $spanForLabel;
 	protected $allowImport;
 	protected $allowImportPartial;
 	protected $popupHeader = null;
 	
 	protected $imageForUploadOnclick;
 	
 	public function __construct($userRights = "") {
 		
 		$this->divImport 					= new HTMLDiv();
 		$this->formUpload					= new HTMLForm();
 		$this->inputUpload					= new HTMLInput();
 		$this->inputHidden					= new HTMLInput();
 		$this->inputHiddenEditable 			= new HTMLInput();
 		$this->inputHiddenCoSource			= new HTMLInput();
 		$this->inputHiddenCoBindingLevel 	= new HTMLInput();
 		$this->inputImage					= new HTMLInput();
 		$this->labelImport					= new HTMLLabel();
 		$this->labelFileChoose				= new HTMLLabel();
 		$this->spanForLabel					= new HTMLSpan();
 		
 		$this->imageForUploadOnclick		= new HTMLImage();
 		
 		$this->allowImport 			= "";
 		$this->allowImportPartial	= "";
 		
 		$this->inputHidden->set_type("hidden");
 		$this->inputHiddenCoSource->set_type("hidden");
 		$this->inputHiddenCoBindingLevel->set_type("hidden");
 		
 		if (!empty($userRights)) {
 			$this->allowImport 			= $userRights['allow_import'];
 			$this->allowImportPartial 	= $userRights['allow_import_partial'];
 		}
 	}
 	
 	
 	public function printPopupWindow() {
 		
 		$this->divImport->printOpeningTag();
	 		$this->popupHeader->printHeader();
	 		$this->formUpload->printOpeningTag();
		 		$this->inputUpload->printOpeningTag();
		 		$this->inputHidden->printOpeningTag();
		 		$this->inputHiddenEditable->printOpeningTag();
		 		HTMLBase::printBr();
		 		$this->printIconToAct();
		 		
		 		$this->printLabelPart();
		 		
	 		$this->formUpload->printClosingTag();
 		$this->divImport->printClosingTag();			
 		
 	}
 	
 	protected function printLabelPart() {
 		
 		
 		$printLabel = true;
 		
 		if (!$this->labelImport->getAttributeValue("for")) {
 			$printLabel = false;
 		}
 		
 		if ($printLabel)
 			$this->labelImport->printOpeningTag();
	 		
 			$this->spanForLabel->printOpeningTag();
	 			$this->spanForLabel->printDisplayText();
	 		$this->spanForLabel->printClosingTag();
 		
	 	if ($printLabel)
	 		$this->labelImport->printClosingTag();
 	}
 	
 	protected function printIconToAct() {
 		
 		$printImageOnly = $this->imageForUploadOnclick->getAttributeValue("src");
 		
 		if ($printImageOnly) {
 			$this->imageForUploadOnclick->printOpeningTag();
 		} else {
 			$this->inputImage->printOpeningTag();
 		}	
 	}
 	
    /**
     * divImport
     * @return unkown
     */
    public function getDivImport(){
        return $this->divImport;
    }

    /**
     * divImport
     * @param [class => "", id =>""] 
     * @return ET_PopupWindow
     */
    public function setDivImport($inputArray){
    	if (isset($inputArray["class"]))
    		$this->divImport->set_class($inputArray["class"]);
    	if (isset($inputArray["id"]))
    		$this->divImport->set_id($inputArray["id"]);
        return $this;
    }

    /**
     * formUpload
     * @return unkown
     */
    public function getFormUpload(){
        return $this->formUpload;
    }

    /**
     * formUpload
     * @param [action"=>"", "id"=>"", "enctype"=>"", "method"=>"","onsubmit"=>""]
     * @return ET_PopupWindow
     */
    public function setFormUpload($inputArray){
    	
    	if (isset($inputArray["action"]))
    		$this->formUpload->set_action($inputArray["action"]);
    	if (isset($inputArray["id"]))
    		$this->formUpload->set_id($inputArray["id"]);
    	if (isset($inputArray["enctype"]))
    		$this->formUpload->set_enctype($inputArray["enctype"]);
    	if (isset($inputArray["method"]))
    		$this->formUpload->set_method($inputArray["method"]);
    	if (isset($inputArray["onsubmit"]))
    		$this->formUpload->set_onsubmit($inputArray["onsubmit"]);
    	
        return $this;
    }

    /**
     * inputUpload
     * @return unkown
     */
    public function getInputUpload(){
        return $this->inputUpload;
    }

    /**
     * inputUpload
     * @param [type"=>"", "name"=>"", "id"=>"", "class"=>"", "accept" =>""]
     * @return ET_PopupWindow
     */
    public function setInputUpload($inputArray) {
        
    	if (isset($inputArray["type"]))
    		$this->inputUpload->set_type($inputArray["type"]);
    	if (isset($inputArray["name"]))
    		$this->inputUpload->set_name($inputArray["name"]);
    	if (isset($inputArray["id"]))
    		$this->inputUpload->set_id($inputArray["id"]);
    	if (isset($inputArray["class"]))
    		$this->inputUpload->set_class($inputArray["class"]);
    	if (isset($inputArray["accept"]))
    		$this->inputUpload->set_accept($inputArray["accept"]);
    		
        return $this;
    }

    /**
     * inputHidden
     * @return unkown
     */
    public function getInputHidden(){
        return $this->inputHidden;
    }

    /**
     * inputHidden
     * @param ["type" => "", "name" => "", "value" => ""]
     * @return ET_PopupWindow
     */
    public function setInputHidden($inputArray){
    	
    	if (isset($inputArray["type"]))
    		$this->inputHidden->set_type($inputArray["type"]);
    	if (isset($inputArray["name"]))
    		$this->inputHidden->set_name($inputArray["name"]);
    	if (isset($inputArray["value"]))
    		$this->inputHidden->set_value($inputArray["value"]);
    	
    	return $this;
    }

    /**
     * inputHiddenEditable
     * @return unkown
     */
    public function getInputHiddenEditable(){
        return $this->inputHiddenEditable;
    }

    /**
     * inputHiddenEditable
     * @param ["id"=> "", "type" =>, "", "name" =>, "", "value"=>""]
     * @return ET_PopupWindow
     */
    public function setInputHiddenEditable($inputArray) {
    	
    	if (isset($inputArray["id"]))
    		$this->inputHiddenEditable->set_id($inputArray["id"]);
    	if (isset($inputArray["type"]))
    		$this->inputHiddenEditable->set_type($inputArray["type"]);
    	if (isset($inputArray["name"]))
    		$this->inputHiddenEditable->set_name($inputArray["name"]);
    	if (isset($inputArray["value"]))
    		$this->inputHiddenEditable->set_value($inputArray["value"]);
    			
        return $this;
    }

    /**
     * inputImage
     * @return unkown
     */
    public function getInputImage(){
        return $this->inputImage;
    }

    /**
     * inputImage
     * @param ["type" => "", "id" => "", "src" => "", "onclick" => ""]
     * @return ET_PopupWindow
     */
    public function setInputImage($inputArray){
        
    	if (isset($inputArray["id"]))
    		$this->inputImage->set_id($inputArray["id"]);
    	if (isset($inputArray["type"]))
    		$this->inputImage->set_type($inputArray["type"]);
    	if (isset($inputArray["src"]))
    		$this->inputImage->set_src($inputArray["src"]);
    	if (isset($inputArray["onclick"]))
    		$this->inputImage->set_onclick($inputArray["onclick"]);
    		
        return $this;
    }

    /**
     * labelImport
     * @return unkown
     */
    public function getLabelImport(){
        return $this->labelImport;
    }

    /**
     * labelImport
     * @param ["for" => "", "id" => "", "class" => ""]
     * @return ET_PopupWindow
     */
    public function setLabelImport($inputArray){
        
    	if (isset($inputArray["for"]))
    		$this->labelImport->set_for($inputArray["for"]);
    	if (isset($inputArray["id"]))
    		$this->labelImport->set_id($inputArray["id"]);
    	if (isset($inputArray["class"]))
    		$this->labelImport->set_class($inputArray["class"]);
    			
        return $this;
    }

    /**
     * labelFileChoose
     * @return unkown
     */
    public function getLabelFileChoose(){
        return $this->labelFileChoose;
    }

    /**
     * labelFileChoose
     * @param unkown $labelFileChoose
     * @return ET_PopupWindow
     */
    public function setLabelFileChoose($labelFileChoose){
        $this->labelFileChoose = $labelFileChoose;
        return $this;
    }

    /**
     * spanForLabel
     * @return unkown
     */
    public function getSpanForLabel(){
        return $this->spanForLabel;
    }

    /**
     * spanForLabel
     * @param ["class" => "", "display_text" => "", "id" => "", "onclick" => ""]
     * @return ET_PopupWindow
     */
    public function setSpanForLabel($inputArray) {
        
    	if (isset($inputArray["class"]))
    		$this->spanForLabel->set_class($inputArray["class"]);
    	if (isset($inputArray["display_text"]))
    		$this->spanForLabel->set_display_text($inputArray["display_text"]);
    	if (isset($inputArray["id"]))
    		$this->spanForLabel->set_id($inputArray["id"]);
        if (isset($inputArray["onclick"]))
        	$this->spanForLabel->set_onclick($inputArray["onclick"]);
    	return $this;
    }

    /**
     * allowImport
     * @return unkown
     */
    public function getAllowImport(){
        return $this->allowImport;
    }

    /**
     * allowImport
     * @param unkown $allowImport
     * @return ET_PopupWindow
     */
    public function setAllowImport($allowImport){
        $this->allowImport = $allowImport;
        return $this;
    }

    /**
     * allowImportPartial
     * @return unkown
     */
    public function getAllowImportPartial(){
        return $this->allowImportPartial;
    }

    /**
     * allowImportPartial
     * @param unkown $allowImportPartial
     * @return ET_PopupWindow
     */
    public function setAllowImportPartial($allowImportPartial){
        $this->allowImportPartial = $allowImportPartial;
        return $this;
    }


    /**
     * popupHeader
     * @return unkown
     */
    public function getPopupHeader(){
        return $this->popupHeader;
    }

    /**
     * popupHeader
     * @param unkown $popupHeader
     * @return ET_PopupWindow
     */
    public function setPopupHeader($headerId, $headerTitle, $divToClose){
        $this->popupHeader = new ET_PopupHeader($headerId, $headerTitle, $divToClose);
        return $this;
    }


    /**
     * inputHiddenCoSource
     * @return unkown
     */
    public function getInputHiddenCoSource(){
        return $this->inputHiddenCoSource;
    }

    /**
     * inputHiddenCoSource
     * @param unkown $inputHiddenCoSource
     * @return ET_PopupWindow
     */
    public function setInputHiddenCoSource($inputHiddenCoSource){
        $this->inputHiddenCoSource = $inputHiddenCoSource;
        return $this;
    }

    /**
     * inputHiddenCoBindingLevel
     * @return unkown
     */
    public function getInputHiddenCoBindingLevel(){
        return $this->inputHiddenCoBindingLevel;
    }

    /**
     * inputHiddenCoBindingLevel
     * @param unkown $inputHiddenCoBindingLevel
     * @return ET_PopupWindow
     */
    public function setInputHiddenCoBindingLevel($inputHiddenCoBindingLevel){
        $this->inputHiddenCoBindingLevel = $inputHiddenCoBindingLevel;
        return $this;
    }

    /**
     * imageForUploadOnclick
     * @return unkown
     */
    public function getImageForUploadOnclick(){
        return $this->imageForUploadOnclick;
    }

    /**
     * imageForUploadOnclick
     * @inputArray ["class" =>, "onclick" => "", "src" => ""]
     * @return ET_PopupWindow
     */
    public function setImageForUploadOnclick($inputArray){
    	
    	if (isset($inputArray["class"]))
    		$this->imageForUploadOnclick->set_class($inputArray["class"]);
    	if (isset($inputArray["onclick"]))
    		$this->imageForUploadOnclick->set_onclick($inputArray["onclick"]);
    	if (isset($inputArray["src"]))
    		$this->imageForUploadOnclick->set_src($inputArray["src"]);
    			
    			
        return $this;
    }

}