<?php
	class ET_PrintCallables{
		
		public static function printCallableObjectTables($callableObjectsTable, $callableObjectsLine, $optionKey = "", $fileName = "") {
			
			?>
			<table id="sp_wrap">
				<tr id="noHover">
			<?php 
				if (!empty($callableObjectsTable)) {
					print("<td valign=\"top\" class=\"sp_table\">");
					self::printTable($callableObjectsTable, BINDING_LEVEL_TABLE, $optionKey, $fileName);
					print("</td>");
				}
				if (!empty($callableObjectsLine)) {
					print("<td valign=\"top\" class=\"sp_table\">");
					self::printTable($callableObjectsLine, BINDING_LEVEL_LINE, $optionKey, $fileName);
					print("</td>");
				}
			?>
				</tr>
			</table>
			<?php 
		}
			
		protected static function printTable($callableObjects, $coBindingLevel, $optionKey, $fileName = "") {
			//var_dump($callableObjects);
			
			$pageType 	= ET_DisplayHelper::detectPageType($fileName);
			$caption 	= ET_DisplayHelper::localize("LINE_LEVEL_COMMANDS", null, $pageType);
			$class 		= "line_level_style";
			$imgExecute = new HTMLImage();
			//$imgExecute->set_src(NIOTA_ROOT_DIR . "/etixpert/images/execute.png")->set_title(ET_DisplayHelper::localize("EXECUTE"));			
			$missingIcons = array();
			
			if ($coBindingLevel == BINDING_LEVEL_TABLE)
				$caption = ET_DisplayHelper::localize("TABLE_LEVEL_COMMANDS", null, $pageType);
				
			?>
			<table id="sp_call_tables">
				<tr class="sp_header"><td colspan="3"><b><?=$caption?></b></td></tr>
				<tr class="sp_header"><th><?php print(ET_DisplayHelper::localize("DESCRIPTION", null, $pageType));?></th><th class="cell_center"><?php print(ET_DisplayHelper::localize("ACTION", null, $pageType));?></th><th class="cell_center"><?php print( ET_DisplayHelper::localize("SUCCESS", null, $pageType));?></th></tr>
					
			<?php
			
				for ($i = 0; $i < count($callableObjects); $i++) {
					$callableObject = $callableObjects[$i];
					
					//$coName 			= ET_StringCheck::convertToUTF8($callableObject['callable_object'], ET_METADATA_CONNECTION);
					$coName 			= $callableObject['name'];
					//$coDescription	= ET_StringCheck::convertToUTF8($callableObject['description'], ET_METADATA_CONNECTION);
					$coDescription		= $callableObject['description'];
					$icon				= isset($callableObject['icon']) ? $callableObject['icon'] : null;
					$promptpageType		= isset($callableObject['promptpage_type']) ? $callableObject['promptpage_type'] : 0;
					$onclick			= "";
					$detailsByType		= array();
					$runButtonTitle		= ET_DisplayHelper::localize("EXECUTE", null, $pageType);
					$path 				= NIOTA_ROOT_DIR . "/etixpert/images/execute.png";
					
					if ($icon != 0 || !is_null($icon)) {
						//absoulute path is checked:
						if ($_SESSION[SESS_CLIENT] != CLIENT_SYSTEM) {
							$tmp = $_SESSION[SESS_CLIENT_FOLDER_PATH] . "/formattings/images/$icon";
							
							if (file_exists($tmp)) {
								$clientFolderName = $_SESSION[SESS_CLIENT_FOLDER_NAME];
								//browser requires a relative path:
								$path = NIOTA_ROOT_DIR . "/../conf/$clientFolderName/formattings/images/$icon";
							}
							else {
								if (!in_array($icon, $missingIcons))
									array_push($missingIcons, $icon);
							}
						} else {
							$tmp = ET_PathHelper::getAbsolutePath("conf/formattings/images/");
							$tmp .= $icon;
							
							if (file_exists($tmp)) {
								$path = NIOTA_ROOT_DIR . "/conf/formattings/images/$icon";
							} else {
								if (!in_array($icon, $missingIcons))
									array_push($missingIcons, $icon);
							}
						}
					}
					$imgExecute->set_src($path);
							
					if ($promptpageType == 1) {
						$niotaUser = ET_NiotaUser::getNiotaUserFromSession();
						$coordinates = $niotaUser->get_userSettings()[USER_PARAM_POPUP_POSITION_UPLOADANDPROCESS];
						$coDetails = ["name" => $coName, "binding_level" => $coBindingLevel];
						//set onclick to open upload dialog  uploadusual
						$detailsByType = ["headerTitle" => "upload and process file", "labelTitle" => "click here to upload file"];
						$onclick = "display_menu_features(\"uploadandruncallable\", \"$coordinates\", \"" . FILE_UPLOAD . "\",". json_encode($detailsByType) . ", ".json_encode($coDetails). ")";
						$runButtonTitle = ET_DisplayHelper::localize("UPLOAD_FILE", null, $pageType);
					} else {
						$onclick = "sendCallables(\"$coName\", $coBindingLevel, getSelRows(), \"$optionKey\")";
					}
						
					$imgExecute->set_title($runButtonTitle);
			?>
				<tr>
					<td width="150px" title="<?=$coName?>">
						<?=$coDescription?>
					</td>
					<td width="60px" align="center" class="cell_center">					
						<a style="border: none; background: none; display: inline; color: darkblue;" class="pointer" onclick=<?="'" . $onclick . "'"?>>
							<?php 
								$imgExecute->printOpeningTag();
							?>
						</a>				
					</td>
					<td width="60px" align="center" id="call_result_<?=$coName?>" class="cell_center" name="result_cell"></td>
				</tr>
			<?php 
				}
				
				if (!empty($missingIcons)) {
					
					ET_DisplayHelper::addErrorLine("Callable icon(s) not found: " . implode(", ", $missingIcons) . ".", $fileName);
					
				}
			?>
			</table>					
			<?php 
		}
	}
?>