<?php
	class ET_PrintGridFunctions{
		
		 public static function printWysiwygFormatterFunction($col_wysiwygs) {
		 	?>
		 	<script>
		    		function wysiwyg_edit_function(id, tempVar){
				<?php 
					foreach($col_wysiwygs as $columnName => $value) {
				?>
    						$("#" + id + "_" + "<?=$columnName?>").wysiwyg({
    			                                plugins: {
    			                                    autoload: true,
    			                                    i18n: { lang: "en" },
    			                                    rmFormat: { rmMsWordMarkup: true }
    			                                },
    			                                autoSave:true,
    			                                controls: {
    			                                    html: {visible: true},
    			                                    colorpicker: {
    			                                        groupIndex: 11,
    			                                        visible: true,
    			                                        css: {
    			                                            "color": function (cssValue, Wysiwyg) {
    			                                                var document = Wysiwyg.innerDocument(),
    			                                                    defaultTextareaColor = $(document.body).css("color");

    			                                                if (cssValue !== defaultTextareaColor) {
    			                                                    return true;
    			                                                }

    			                                                return false;
    			                                            }
    			                                        },
    			                                        exec: function() {
    			                                            if ($.wysiwyg.controls.colorpicker) {
    			                                                $.wysiwyg.controls.colorpicker.init(this);
    			                                            }
    			                                        },
    			                                        tooltip: "Colorpicker"
    			                                    }
    			                                }
    									
								});
							<?php } ?>
						}	
		 	
				 </script>
		 	
		 	
		 	<?php 
		 }
		
		
		 public static function printNumberFormatterFunction($decimaPoint) {
			?>
				<script>
		    		function decimalPointFormat(cellValue, options, rowdata) {
			    		
		        		if (cellValue==null){
		            		return '';
		        		}

						//2021-08-25: browser update - js cannot call cellValue.replace if cellValue is number
		        		
		        		if (typeof(cellValue == "number")) {
			        		//console.log("number");
			        		cellValue = cellValue.toString();
			        	} else {
							//console.log("string");
				        }
		        		
						var temp = cellValue.replace(".", "<?=$decimaPoint?>");
						if (temp.indexOf('<?=$decimaPoint?>') == 0)
								temp = "0" + temp;
						return temp;
		    		}
		    		function decimalPointUnformat(cellvalue, options, cell) {
						//alert('unformat' + JSON.stringify(cellvalue));
		        		if (cellvalue==null){
		            		return '';
		        		}
						return cellvalue.replace("<?=$decimaPoint?>", ".");
						
		    		}    	

				</script>
				<?php 
			}
			
			//on line 119 the decimal_validation is used in the case of any numeric type checks!
			public static function setColumnFormatters($columnInfo, $decimalPoint, $dg, $detailDataGrids = array()) {
				$wasOne = false;
				//main grid
				foreach ($columnInfo as $colName => $colArr) {
					$metaType = $colArr['metaType'];
					$origColName = $colArr['originalColumnName'];
								
					if ($metaType == 'N') {
						$dg->set_col_property($origColName, array('formatter'=>'###decimalPointFormat###', 'unformatter'=>'###decimalPointUnformat###'));
						$dg->set_col_customrule($origColName, 'decimal_validation');
						$wasOne = true;
					}
				}
				//detail grids
				for ($i = 0; $i < count($detailDataGrids); $i++) {
					$detailDataGrid = $detailDataGrids[$i];
					
					$sdg = $detailDataGrid->getCLSDataGrid();
					$sdgColumnInfo = $detailDataGrid->getColumnInfo();
					
					foreach ($sdgColumnInfo as $colName => $colArr) {
						$metaType = $colArr['metaType'];
						$origColName = $colArr['originalColumnName'];
												
						if ($metaType == 'N') {
							$sdg->set_col_property($origColName, array('formatter'=>'###decimalPointFormat###', 'unformatter'=>'###decimalPointUnformat###'));
							$sdg->set_col_customrule($origColName, 'decimal_validation');
							$wasOne = true;
						}
					}
				}
												
				if ($wasOne) {
					print("<script lang=\"javascript\">");
					?>
					function decimal_validation(value, colname) {
						if (value == null || value == '') return [true, ""];
						
						value2 = value.replace("<?=$decimalPoint?>", ".");
						if (isNaN(value2))
							return [false, colname + ", <?= ET_DisplayHelper::localize("TYPE_ERROR_NUMBER", null, PAGE_TYPE_GRID)?>"];
							
						return [true,""];
					}
					
					<?php 
					print("</script>");
						
				}
			}
			
			//on line 119 the decimal_validation is used in the case of any numeric type checks!
			public static function setColumnFormattersOnly($columnInfo, $decimalPoint, $dg, $detailDataGrids = array()) {
				
				foreach ($columnInfo as $colName => $colArr) {
					$metaType 		= $colArr['metaType'];
					$origColName 	= $colArr['originalColumnName'];
					
					if ($metaType == 'N') {
						$dg->set_col_property($origColName, array('formatter'=>'###decimalPointFormat###', 'unformatter'=>'###decimalPointUnformat###'));						
					}
				}
				//detail grids
				for ($i = 0; $i < count($detailDataGrids); $i++) {
					$detailDataGrid = $detailDataGrids[$i];
					
					$sdg = $detailDataGrid->getCLSDataGrid();
					$sdgColumnInfo = $detailDataGrid->getColumnInfo();
					
					foreach ($sdgColumnInfo as $colName => $colArr) {
						$metaType = $colArr['metaType'];
						$origColName = $colArr['originalColumnName'];
						
						if ($metaType == 'N') {
							$sdg->set_col_property($origColName, array('formatter'=>'###decimalPointFormat###', 'unformatter'=>'###decimalPointUnformat###'));							
						}
					}
				}				
			}
			
			public static function printCustomValidationFunctionsWrapperStyle($dg, $regionInfo, $decimalPoint, $catalogInstanceId, $columnInfo) {
				
				
				$numericTypes 					= ['I', 'N'];
				$numericFieldsWithoutConstraint = array();
				
				if (!empty($regionInfo)) {
					
					$numericFieldsWithConstraint = array();
					
					foreach ($regionInfo as $field_name => $settings) {
						$c_op1 		= $settings['operand1'];
						$c_op2 		= $settings['operand2'];
						$c_type 	= $settings['column_type'];
						$c_op 		= $settings['operation'];
						//merge this and line 183:
						
						$isNumeric	= in_array($c_type, $numericTypes);
						
						$col_customrule_name	= $field_name . "_validatonWrapper";
						$col_custom_validator 	= "<script lang=\"javascript\" charset=\"UTF-8\"> function " . $col_customrule_name . " (value, colname){";						
						
						if($c_op1 == "{str_empty}")
							$c_op1 = '';
							
						if($c_op2 == "{str_empty}")
							$c_op2 = '';
						
						if ($isNumeric) {
							$numericFound = true;
							//lowercase is necessary because $columnInfo keys are lowercase too
							array_push($numericFieldsWithConstraint, strtolower($field_name));
						}
							
						$function_name = self::getValidatorFunctionName($catalogInstanceId, $field_name);
						
						if ($isNumeric) {	
							
							$col_custom_validator .= " var res = decimal_validation(value, colname); 																			                                                           
															if (res[0] == false){
																 return res;
															}  
							                               else {
																return $function_name(value, colname);	                                                            																
															}
														}"; 
						}
						else {
							$col_custom_validator .= "return $function_name(value, colname);}";
						}
												
						$col_custom_validator .= "</script>";						
						print("<script lang=\"javascript\" charset=\"UTF-8\">");						
						
						if ($c_op == 7) {
							self::printCustomValidationBetween($c_op1, $c_op2, $c_type, $field_name, $decimalPoint, $function_name);
						} else if ($c_op == 8) {
							self::printCustomValidationNotBetween($c_op1, $c_op2, $c_type, $field_name, $decimalPoint, $function_name);
						} else if ($c_op == 1) {
							self::printCustomValidationEquals($c_op1, $c_type, $field_name, $decimalPoint, false, $function_name);
						} else if ($c_op == 2) {
							self::printCustomValidationEquals($c_op1, $c_type, $field_name, $decimalPoint, true, $function_name);
						} else if ($c_op == 3) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, false, false, $function_name);
						} else if ($c_op == 4) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, false, true, $function_name);
						} else if ($c_op == 5) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, true, false, $function_name);
						} else if ($c_op == 6) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, true, true, $function_name);
						} else if ($c_op == 9) {
							self::printCustomValidationLike($c_op1, $c_type, $field_name, false, $function_name);
						} else if ($c_op == 10) {
							self::printCustomValidationLike($c_op1, $c_type, $field_name, true, $function_name);
						} else if ($c_op == 11) {
							self::printCustomValidationStartsWith($c_op1, $c_type, $field_name, false, $function_name);
						} else if ($c_op == 12) {
							self::printCustomValidationStartsWith($c_op1, $c_type, $field_name, true, $function_name);
						} else if ($c_op == 13) {
							self::printCustomValidationEndsWith($c_op1, $c_type, $field_name, false, $function_name);
						} else if ($c_op == 14) {
							self::printCustomValidationEndsWith($c_op1, $c_type, $field_name, true, $function_name);
						}
						print("</script>");
						print($col_custom_validator);
						$dg->set_col_customrule($field_name, $col_customrule_name);
					}
					
					
					foreach ($columnInfo as $key => $value) {
						
						$metaType = $value['metaType'];
						
						if (in_array($metaType, $numericTypes) && !in_array($key, $numericFieldsWithConstraint)) {
							array_push($numericFieldsWithoutConstraint, $key);
							//self::printDecimalValidationIfNoConstraintOnCol($dg, $columnInfo, $decimalPoint);
							
						}						
					}
					
				}
				else {
					foreach ($columnInfo as $key => $value) {
						$metaType = $value['metaType'];
						
						if (in_array($metaType, $numericTypes)) {
							array_push($numericFieldsWithoutConstraint, $key);
						}
					}
				}
				if (!empty($numericFieldsWithoutConstraint)) {
					for ($i = 0; $i < count($numericFieldsWithoutConstraint); $i++) {
						
						$dg->set_col_customrule($numericFieldsWithoutConstraint[$i], 'decimal_validation');
						$dg->set_col_customrule(strtoupper($numericFieldsWithoutConstraint[$i]), 'decimal_validation');
						$dg->set_col_customrule(strtolower($numericFieldsWithoutConstraint[$i]), 'decimal_validation');
					}
					self::printDecimalValidationIfNoConstraintOnCol($decimalPoint);
				}
			}
			 
			
			public static function printCustomValidationStartsWith($c_op1, $c_type, $field_name, $not, $functionName) {
				$opSign = $not ? "==" : "!=";
			
				$opName = $not ? " not start with " : " start with ";
			
				?>
				function <?=$functionName?>(value, colname) {
					if (value == null || value == '') return [true, ""];
				<?php 
					if ($c_type == 'C') {
				?>
				 		if (value.indexOf('<?=$c_op1?>') <?=$opSign?> 0) {
				       		//return [false,"<?=$field_name?> should <?=$opName?> '<?=$c_op1?>'!"];
				       		return [false, "<?=ET_DisplayHelper::localize("STRATS_WITH_AND_NOT_FAILED", array($field_name, $opName, $c_op1), PAGE_TYPE_GRID);?>"];
				   		}
				<?php
				   	}
				?>
				    else {
				   		return [true,""];
					}
				}		
				<?php 
			}
				
			public static function printCustomValidationEndsWith($c_op1, $c_type, $field_name, $not, $functionName) {
				$opSign = $not ? "" : "!";
			
				$opName = $not ? " not end with " : " end with ";
			
				?>
					function <?=$functionName?>(value, colname) {
						if (value == null || value == '') return [true, ""];
					<?php 
						if ($c_type == 'C') {
					?>
							
					 		String.prototype.endsWith = function(suffix) {
							    return this.indexOf(suffix, this.length - suffix.length) !== -1;
							};	
							if(<?=$opSign?>value.endsWith('<?=$c_op1?>')){
				       			//return [false,"<?=$field_name?> should <?=$opName?> '<?=$c_op1?>'!"];
				       			return [false,"<?=ET_DisplayHelper::localize("ENDS_WITH_AND_NOT_FAILED", array($field_name, $opName, $c_op1), PAGE_TYPE_GRID);?>"];
					   		}
					 		//if(<?=$opSign?>value.charAt(value.length-1) == '<?=$c_op1?>'){
					       	//	return [false,"<?=$field_name?> should <?=$opName?> '<?=$c_op1?>'!"];
					   		//}
					<?php 
					   	}
					?>
					    else {
					   		return [true,""];
						}
					}		
					<?php 
				}
			
			public static function printCustomValidationLike($c_op1, $c_type, $field_name, $not, $functionName) {
				$opSign = $not ? "!" : "";
			
				$opName = $not ? " not contain " : " contain ";
			
				?>
				function <?=$functionName?>(value, colname) {
					if (value == null || value == '') return [true, ""];
				<?php 
					if ($c_type == 'C') {
				?>
				 		if (value.indexOf('<?=$c_op1?>') <?=$opSign?>== -1) {
				       		//return [false,"<?=$field_name?> should <?=$opName?> '<?=$c_op1?>'!"];
				       		return [false,"<?=ET_DisplayHelper::localize("LIKE_AND_NOT_FAILED", array($field_name, $opName, $c_op1), PAGE_TYPE_GRID);?>"];
				   		}
				<?php 
				   	}
				?>
				    else {
				   		return [true,""];
					}
				}		
				<?php 
			}
			
			public static function printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, $equals, $not, $functionName) {
				$opSign = $not ? ">" : "<";
				if (!$equals)
					$opSign .= "=";
				
				
				$opName = $not ? "less" : "greater";
				if ($equals)
					$opName .= " or equal ";
				
				?>
				//BECAUSE OF THE TRANSLATION OF FEEDBACK MESSAGES I HAVE TO SEPARATE THE RETURN CASES!
				//Because of the mixed JS and PHP code it's not possible to write a function for the redundant 'else if' seections!
						
				function <?=$functionName?>(value, colname) {
					if (value == null || value == '') {return [true, ""];}
				<?php 
					
					if ($c_type == 'I') {				
				?>
				  		if (parseInt(value) <?=$opSign?>  <?=$c_op1?>) {
				       		//return [false,"<?=$field_name?> should be <?=$opName?> than <?=$c_op1?>!"];		       		
				       		if("<?=$opSign?>" == ">="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == ">"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}		   	
				   		}
				 <?php 
					}
					else if ($c_type == 'N') {
				?>
						value2 			= value.replace("<?=$decimalPoint?>", ".");
						var op1Replaced = "<?=$c_op1?>";			
						op1Replaced 	= op1Replaced.replace("<?=$decimalPoint?>", ".");
						
						if (parseFloat(value2) <?=$opSign?>  op1Replaced) {
					  		
				       		//return [false,"<?=$field_name?> should be <?=$opName?> than <?=$c_op1?>!"];		       		
				       		if("<?=$opSign?>" == ">="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == ">"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}		   	
						} else if (!parseFloat(value2)) {
							return [false, "Wrong format for float: " + value2];
						}
						
			  	<?php 
					}
					else if ($c_type == 'T') {
						$value_js_format = $c_op1;
						//DATETIME greater
				?>
				   		
				   		var valDate = '<?=$value_js_format?>';
			    		var valDateParts = valDate.split('-');
			    		var valTime = valDateParts[2].split(' ')[1];
			    		valTime = valTime.trim();
			    		var valDay = valDateParts[2].substring(0,2);
			    		var valHh = valTime.substring(0,2);
			    	    var valMm = valTime.substring(3,5);
			    	    var valSs = valTime.substring(6);
			    	    valDate = new Date(valDateParts[0],valDateParts[1]-1,valDay, valHh, valMm, valSs);
				   				
				   		var fieldDate = value;
			    		//console.log(fieldDate);
			    		var fieldDateParts = fieldDate.split('-');
			    		var time = fieldDateParts[2].split(' ')[1];
			    		time = time.trim();
			    		var day =  fieldDateParts[2].substring(0,2);
			    	    day = day.trim();
			    	    var hh = time.substring(0,2);
			    	    var mm = time.substring(3,5);
			    	    var ss = time.substring(6);
			    	    var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,day, hh, mm, ss);
				   		
				   		var valDateValue = valDate.valueOf();
			    	    var newFieldDateValue = newFieldDate.valueOf();	    	    	    	    
				   					
				   		if (newFieldDateValue <?=$opSign?>  valDateValue) {
				       		if("<?=$opSign?>" == ">="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == ">"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}		   	
				   		}
			  	<?php 
					}
				   	else if ($c_type == 'D') {
				   		$value_js_format = str_replace("-", "/", $c_op1);
				   		//DATE greater
				?>
				   		var valDate = '<?=$value_js_format?>';
				   	    var valDateParts = valDate.split("/");
				   	    var newValDate = new Date(valDateParts[0],valDateParts[1]-1,valDateParts[2]);
				   	    
				   	    var fieldDate = value;
			    	    fieldDate = fieldDate.replace(/-/g, '/');
		    	    	var fieldDateParts = fieldDate.split("/");
		    	    	var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,fieldDateParts[2]);
				   	    
				   	    var valDateValue = newValDate.valueOf();
				   	    var newFieldDateValue = newFieldDate.valueOf();
				   	    
				   	    			
				   		if (newFieldDateValue <?=$opSign?>  valDateValue) {
				       		//return [false,"<?=$field_name?> should be <?=$opName?> than '<?=$c_op1?>'!"];
				       		if("<?=$opSign?>" == ">="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == ">"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}		   	
				   		}
			  	<?php }
				   	else if ($c_type == 'C') {
				?>				 		
				 		if (value <?=$opSign?>  '<?=$c_op1?>') {
				       		//return [false,"<?=$field_name?> should be <?=$opName?> than '<?=$c_op1?>'!"];
				       		if("<?=$opSign?>" == ">="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<="){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == "<"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("GREATER_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}
				       		else if("<?=$opSign?>" == ">"){		       			
				       			return [false, "<?=ET_DisplayHelper::localize("LESS_OR_EQ_FAILED", [$field_name, $c_op1], PAGE_TYPE_GRID);?>"];
				       		}		   			   	
				   		}		   		
				<?php 
				   	}
			   	?>
				    else {
				    	return [true,""];
				    	}
					}		
				<?php 
			}
			
			public static function printCustomValidationEquals($c_op1, $c_type, $field_name, $decimalPoint, $not, $functionName) {
				
				$opSign = $not ? "==" : "!=";
				$plus = $not ? " not" : "";
				
					
				?>
					function <?=$functionName?>(value, colname) {
		
					<?php 
						if ($c_op1 != "") {
					?>
										
						if (value == null || value == '') return [true, ""];				
						
					<?php
						}
					
					if ($c_type == 'I') {
					?>
						
			    		if (parseInt(value) <?=$opSign?>  <?=$c_op1?>) {
			        		//return [false,"<?=$field_name?> should<?=$plus?> be equal to <?=$c_op1?>!"];
			        		<?php 
			        			if ($plus == " not"){
			        		?>
			        		return [false,"<?=ET_DisplayHelper::localize("NOT_EQUALS_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
			        		
			        		<?php 
			        			}
			        			else{	        				
			        		?>
			        			return [false,"<?=ET_DisplayHelper::localize("EQUALS_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
			        		<?php 
			        			}	        			
			        		?>
			    		}
			    	<?php 
					}
					else if ($c_type == 'N') {
						?>
						value2 			= value.replace("<?=$decimalPoint?>", ".");
						var op1Replaced = "<?=$c_op1?>";			
						op1Replaced 	= op1Replaced.replace("<?=$decimalPoint?>", ".");				
						
						if (parseFloat(value2) <?=$opSign?>  op1Replaced) {
					  		<?php 
			        			if ($plus == " not"){
			        		?>
			        		return [false,"<?=ET_DisplayHelper::localize("NOT_EQUALS_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
			        		<?php 
			        			}
			        			else{	        				
			        		?>
			        			return [false,"<?=ET_DisplayHelper::localize("EQUALS_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
			        		<?php 
			        			}	        			
			        		?>
						}
					   	<?php 
					}
					else if ($c_type == 'T') {
						$value_js_format = $c_op1;
						
			    	?>
			    				
			    		var fieldDate = value;
		    			var fieldDateParts = fieldDate.split('-');
			    		var time = fieldDateParts[2].split(' ')[1];
			    		time = time.trim();
			    		var day =  fieldDateParts[2].substring(0,2);
			    	    day = day.trim();
			    	    var hh = time.substring(0,2);
			    	    var mm = time.substring(3,5);
			    	    var ss = time.substring(6);
			    	    var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,day, hh, mm, ss);
			    	    
			    	    var valDate = '<?=$value_js_format?>';
			    		var valDateParts = valDate.split('-');
			    		var valTime = valDateParts[2].split(' ')[1];
			    		valTime = valTime.trim();
			    		var valDay = valDateParts[2].substring(0,2);
			    		var valHh = valTime.substring(0,2);
			    	    var valMm = valTime.substring(3,5);
			    	    var valSs = valTime.substring(6);
			    	    valDate = new Date(valDateParts[0],valDateParts[1]-1,valDay, valHh, valMm, valSs);
			    	    
			    	    var valDateValue = valDate.valueOf();
			    	    var newFieldDateValue = newFieldDate.valueOf();
					    					
			    		if (newFieldDateValue <?=$opSign?>  valDateValue) {
			        		<?php 
			        			if ($plus == " not"){
			        		?>
			        		return [false,"<?=ET_DisplayHelper::localize("NOT_EQUALS_FAILED", array($field_name, $c_op1),PAGE_TYPE_GRID);?>"];
			        		<?php 
			        			}
			        			else{	        				
			        		?>
			        			return [false,"<?=ET_DisplayHelper::localize("EQUALS_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
			        		<?php 
			        			}	        			
			        		?>
			    		}
			    	<?php 
					}
			    	else if ($c_type == 'D') {
			    		$value_js_format = str_replace("-", "/", $c_op1);
			    		
			    		?>
			    	    		var valDateString = '<?=$value_js_format?>';
			    	    		valDateString = valDateString.trim();
			    	    		var valDate = new Date(valDateString);
			    	    		var fieldDate = value;  
			    	    		fieldDate = fieldDate.replace(/-/g, '/');
			    	    		fieldDate = fieldDate.trim();
			    	    		
			    	    		
		    	    			var fieldDateParts = fieldDate.split("/");
		    	    			var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,fieldDateParts[2]);
		    	    			valDate.setHours(00);
		    	    			valDate.setMinutes(00);
		    	    			valDate.setSeconds(00);
			    	    		var valDateValue = valDate.valueOf();
			    	    		var newFieldDateValue = newFieldDate.valueOf();
			    	    			    	    		
			    	    		if (newFieldDateValue <?=$opSign?>  valDateValue) {
			    	        		<?php 
					        			if ($plus == " not"){
					        		?>
					        			return [false,"<?=ET_DisplayHelper::localize("NOT_EQUALS_FAILED", array($field_name, $c_op1),PAGE_TYPE_GRID);?>"];
					        		<?php 
					        			}
					        			else{	        				
					        		?>
					        			return [false,"<?=ET_DisplayHelper::localize("EQUALS_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
					        		<?php 
					        			}	        			
					        		?>
			    	    		}
			    	    	<?php }
			    	else if ($c_type == 'C') {
			    	?>
			    		
			    		if (jQuery('#<?=$field_name?>').val() <?=$opSign?>  '<?=$c_op1?>') {        			
		        			<?php         			
		        				if ($plus == " not"){        					
			        		?>	        		
			        				return [false,"<?=ET_DisplayHelper::localize("NOT_EQUALS_FAILED", array($field_name, $c_op1),PAGE_TYPE_GRID);?>"];
			        		<?php 
			        			}
			        			else{	        				
			        		?>
			        			return [false,"<?=ET_DisplayHelper::localize("EQUALS_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
			        		<?php 
			        			}	        			
			        		?>
			    		}
			    		
					<?php 
			    	}
			    	?>
			    		else {
			        		return [true,""];
			    		}
					}		
					<?php 
				}
			
			public static function printCustomValidationBetween($c_op1, $c_op2, $c_type, $field_name, $decimalPoint, $functionName) {
				?>
				function <?=$functionName?>(value, colname) {
				debugger;
					if (value === null || value === '') return [true, ""];
					
				<?php 
				if ($c_type == 'I') {
				?>
				
		    		if (parseInt(value) >  <?=$c_op2?>) {
		        		return [false,"<?=$field_name?> maximum value is <?=$c_op2?>!"];
		        		return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MAX_FAILED", array($field_name, $c_op2), PAGE_TYPE_GRID);?>"];
		    		}
		    		if (parseInt(value) <  <?=$c_op1?>) {
		        		return [false,"<?=$field_name?> minimum value is <?=$c_op1?>!"];
		        		return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MIN_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
		    		}
		    	<?php 
				}
				else if ($c_type == 'N') {
					?>
					
					value2 			= value.replace("<?=$decimalPoint?>", ".");
					var op2Replaced = "<?=$c_op2?>";
					var op1Replaced = "<?=$c_op1?>";
					op2Replaced 	= op2Replaced.replace("<?=$decimalPoint?>", ".");			
					op1Replaced 	= op1Replaced.replace("<?=$decimalPoint?>", ".");
					
					if (parseFloat(value2) >  op2Replaced) {
				  		//return [false,"<?=$field_name?> maximum value is <?=$c_op2?>!"];
				  		return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MAX_FAILED", array($field_name, $c_op2), PAGE_TYPE_GRID);?>"];
					}
				    if (parseFloat(value2) <  op1Replaced) {
				    	//return [false,"<?=$field_name?> minimum value is <?=$c_op1?>!"];
				    	return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MIN_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
				    }
				   	<?php 
				}
				else if ($c_type == 'T') {
					$min_value_js_format = $c_op1;
					$max_value_js_format = $c_op2;
					//DATETIME between
		    	?>
		    		    		
		    		var fieldDate = value;
		    		var fieldDateParts = fieldDate.split('-');
		    		var time = fieldDateParts[2].split(' ')[1];
		    		time = time.trim();
		    		var day =  fieldDateParts[2].substring(0,2);
		    	    day = day.trim();
		    	    var hh = time.substring(0,2);
		    	    var mm = time.substring(3,5);
		    	    var ss = time.substring(6);
		    	    var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,day, hh, mm, ss);
		    		var newFieldDateValue = newFieldDate.valueOf();
		    		
		    		var minDate = '<?=$min_value_js_format?>';
		    		var minDateParts = minDate.split('-');
		    		var minTime = minDateParts[2].split(' ')[1];
		    		minTime = minTime.trim();
		    		var minDay = minDateParts[2].substring(0,2);
		    		var minHh = minTime.substring(0,2);
		    	    var minMm = minTime.substring(3,5);
		    	    var minSs = minTime.substring(6);
		    	    minDate = new Date(minDateParts[0],minDateParts[1]-1,minDay, minHh, minMm, minSs);
		    	    var minDateValue = minDate.valueOf();
		    	    
		    	    var maxDate = '<?=$max_value_js_format?>';
		    	    var maxDateParts = maxDate.split('-');
		    		var maxTime = maxDateParts[2].split(' ')[1];
		    		maxTime = maxTime.trim();
		    		var maxDay = maxDateParts[2].substring(0,2);
		    		var maxHh = maxTime.substring(0,2);
		    	    var maxMm = maxTime.substring(3,5);
		    	    var maxSs = maxTime.substring(6);
		    		maxDate = new Date(maxDateParts[0],maxDateParts[1]-1,maxDay, maxHh, maxMm, maxSs);
		    		var maxDateValue = maxDate.valueOf();
		    		
		    		
		    		if (newFieldDateValue >  maxDateValue) {
		        		//return [false,"<?=$field_name?> maximum value is '<?=$c_op2?>'!"];
		        		return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MAX_FAILED", array($field_name, $c_op2), PAGE_TYPE_GRID);?>"];
		    		}
		    		if (newFieldDateValue <  minDateValue) {
		        		//return [false,"<?=$field_name?> minimum value is '<?=$c_op1?>'!"];
		        		return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MIN_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
		    		}
		    		
		    	<?php 
				}
		    	else if ($c_type == 'D') {
		    		$min_value_js_format = str_replace("-", "/", $c_op1);	
		    		$max_value_js_format = str_replace("-", "/", $c_op2);
		    		//DATE between
		    		?>
		    	    		var minDate = new Date('<?=$min_value_js_format?>');
		    	    		var maxDate = new Date('<?=$max_value_js_format?>');
		    	    		//minDate = minDate.setHours(minDate.getHours() - 2);
		    	    		minDate.setHours(00);
		    	    		minDate.setMinutes(00);
		    	    		minDate.setSeconds(00);
		    	    		var minDateValue = minDate.valueOf();
		    	    		
		    	    		maxDate.setHours(23);
		    	    		maxDate.setMinutes(59);
		    	    		maxDate.setSeconds(59);
		    	    		var maxDateValue = maxDate.valueOf();
		    	    		
		    	    		
		    	    		var fieldDate = value; 	    		
		    	    		var fieldDateParts =fieldDate.split('-');
		    	    		var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,fieldDateParts[2]); 
		    	    		var newFieldDateValue = newFieldDate.valueOf();
		    	    		
		    	    		if (newFieldDateValue > maxDateValue){
		    	    			//return [false,"<?=$field_name?> maximum value is '<?=$c_op2?>'!"];
		    	    			return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MAX_FAILED", array($field_name, $c_op2), PAGE_TYPE_GRID);?>"];
		    	    		}
		    	    		  	    		    	    		
		    	    		if (newFieldDateValue < minDateValue){
		    	    			//return [false,"<?=$field_name?> minimum value is '<?=$c_op1?>'!"];
		    	    			return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MIN_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
		    	    		}
		    	    		
		    	    		
		    	    	<?php }
		    	else if ($c_type == 'C') {
		    		
		    	?>
		    	
			    	if (value >  '<?=$c_op2?>') {
			        		//return [false,"<?=$field_name?> maximum value is '<?=$c_op2?>'!"];
			        		return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MAX_FAILED", array($field_name, $c_op2), PAGE_TYPE_GRID);?>"];
			    		}
			    	if (value <  '<?=$c_op1?>') {
			        	//return [false,"<?=$field_name?> minimum value is '<?=$c_op1?>'!"];
		        		return [false,"<?=ET_DisplayHelper::localize("BETWEEN_MIN_FAILED", array($field_name, $c_op1), PAGE_TYPE_GRID);?>"];
			    	}
				<?php 
		    	}
		    	?>
		    		else {
		        		return [true,""];
		    		}
				}		
				<?php 
			}
			
			public static function printCustomValidationNotBetween($c_op1, $c_op2, $c_type, $field_name, $decimalPoint, $functionName) {
				?>
					function <?=$functionName?>(value, colname) {
						if (value == null || value == '') return [true, ""];
					<?php 
					if ($c_type == 'I') {
					?>
			    		if (parseInt(value) <  <?=$c_op2?> && parseInt(value) >  <?=$c_op1?>) {
			        		//return [false,"<?=$field_name?> should not be between <?=$c_op1?> and <?=$c_op2?>!"];
			        		return [false,"<?=ET_DisplayHelper::localize("NOT_BETWEEN_FAILED", array($field_name, $c_op1, $c_op2), PAGE_TYPE_GRID);?>"];
			    		}
			    	<?php 
					}
					else if ($c_type == 'N') {
						?>
						value2 			= value.replace("<?=$decimalPoint?>", ".");
						var op2Replaced = "<?=$c_op2?>";
						var op1Replaced = "<?=$c_op1?>";
						op2Replaced 	= op2Replaced.replace("<?=$decimalPoint?>", ".");			
						op1Replaced 	= op1Replaced.replace("<?=$decimalPoint?>", ".");
						
						if (parseFloat(value2) <  op2Replaced && parseFloat(value2) >  op1Replaced) {
							//return [false,"<?=$field_name?> should not be between <?=$c_op2?> and <?=$c_op2?>!"];
							return [false,"<?=ET_DisplayHelper::localize("NOT_BETWEEN_FAILED", array($field_name, $c_op1, $c_op2), PAGE_TYPE_GRID);?>"];
						}
						<?php 
					}
					else if ($c_type == 'T') {
						//DATETIME not between
						$min_value_js_format = str_replace("-", "/", $c_op1);
						$max_value_js_format = str_replace("-", "/", $c_op2);
						
					?>	
						var fieldDate = value;
		    			var fieldDateParts = fieldDate.split('-');
		    			var time = fieldDateParts[2].split(' ')[1];
		    			time = time.trim();
			    		var day =  fieldDateParts[2].substring(0,2);
			    	    day = day.trim();
			    	    var hh = time.substring(0,2);
			    	    var mm = time.substring(3,5);
			    	    var ss = time.substring(6);
			    	    var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,day, hh, mm, ss);
			    	    var newFieldDateValue =  newFieldDate.valueOf();
			    		
			    		var minDate = '<?=$c_op1?>';
			    		var minDateParts = minDate.split('-');
			    		var minTime = minDateParts[2].split(' ')[1];
			    		var minDay = minDateParts[2].substring(0,2);
			    		var minHh = minTime.substring(0,2);
			    	    var minMm = minTime.substring(3,5);
			    	    var minSs = minTime.substring(6);
			    	    minDate = new Date(minDateParts[0],minDateParts[1]-1,minDay, minHh, minMm, minSs);
			    	    var minDateValue = minDate.valueOf();
				    	    
			    	    var maxDate = '<?=$c_op2?>';
			    	    var maxDateParts = maxDate.split('-');
			    		var maxTime = maxDateParts[2].split(' ')[1];
			    		var maxDay = maxDateParts[2].substring(0,2);
			    		var maxHh = maxTime.substring(0,2);
			    	    var maxMm = maxTime.substring(3,5);
			    	    var maxSs = maxTime.substring(6);
			    		maxDate = new Date(maxDateParts[0],maxDateParts[1]-1,maxDay, maxHh, maxMm, maxSs);
			    		var maxDateValue = maxDate.valueOf();
						    					
						if (newFieldDateValue < maxDateValue && newFieldDateValue >  minDateValue) {
					 		//return [false,"<?=$field_name?> should not be between <?=$c_op1?> and <?=$c_op2?>!"];
					 		return [false,"<?=ET_DisplayHelper::localize("NOT_BETWEEN_FAILED", array($field_name, $c_op1, $c_op2),PAGE_TYPE_GRID);?>"];
						}
					<?php 
					}
					else if ($c_type == 'D') {
						$min_value_js_format = str_replace("-", "/", $c_op1);
						$max_value_js_format = str_replace("-", "/", $c_op2);
						//DATE not between
			    	?>	
			    		var minDate = new Date('<?=$min_value_js_format?>');
		    	    	var maxDate = new Date('<?=$max_value_js_format?>');
		    	    	minDate = minDate.setHours(minDate.getHours() - 2);
		    	    	maxDate.setHours(23);
		    	    	maxDate.setMinutes(59);
		    	    	maxDate.setSeconds(59);
		    	    	
		    	    	var fieldDate = value;
		    	    	var fieldDateParts =fieldDate.split('-');
		    	    	var newFieldDate = new Date(fieldDateParts[0],fieldDateParts[1]-1,fieldDateParts[2]);
			    		
			    		if (newFieldDate <  maxDate && newFieldDate >  minDate) {
			        		//return [false,"<?=$field_name?> should not be between '<?=$c_op1?>' and '<?=$c_op2?>'!"];
			        		return [false,"<?=ET_DisplayHelper::localize("NOT_BETWEEN_FAILED", array($field_name, $c_op1, $c_op2), PAGE_TYPE_GRID);?>"];
			    		}
			    	<?php }
			    	else if ($c_type == 'C') {
			    	?>	
			    	  	if (value <  '<?=$c_op2?>' && value >  '<?=$c_op1?>') {
			        		//return [false,"<?=$field_name?> should not be between '<?=$c_op1?>' and '<?=$c_op2?>'!"];
			        		return [false,"<?=ET_DisplayHelper::localize("NOT_BETWEEN_FAILED", array($field_name, $c_op1, $c_op2), PAGE_TYPE_GRID);?>"];
			    		}
					<?php 
			    	}
			    	?>
			    		else {
			        		return [true,""];
			    		}
					}		
					<?php 
				}
			/*
			public static function printCustomValidationFunctions($dg, $regionInfo, $decimalPoint, $catalogInstanceId) {
				if (!empty($regionInfo)) {
					print("<script lang=\"javascript\" charset=\"UTF-8\">");
				
					foreach ($regionInfo as $field_name => $settings) {
						$c_op1 		= $settings['operand1'];
						$c_op2 		= $settings['operand2'];
						$c_type 	= $settings['column_type'];
						$c_op 		= $settings['operation'];
						//$field_name = $fieldName;
										
						if($c_op1 == "{str_empty}")
							$c_op1 = '';
						
						if($c_op2 == "{str_empty}")
							$c_op2 = '';
						
						$function_name = self::getValidatorFunctionName($catalogInstanceId, $field_name);
							
						$dg->set_col_customrule($field_name, $function_name);
				
						if ($c_op == 7) {
							self::printCustomValidationBetween($c_op1, $c_op2, $c_type, $field_name, $decimalPoint, $function_name);
						} else if ($c_op == 8) {
							self::printCustomValidationNotBetween($c_op1, $c_op2, $c_type, $field_name, $decimalPoint, $function_name);
						} else if ($c_op == 1) {
							self::printCustomValidationEquals($c_op1, $c_type, $field_name, $decimalPoint, false, $function_name);
						} else if ($c_op == 2) {
							self::printCustomValidationEquals($c_op1, $c_type, $field_name, $decimalPoint, true, $function_name);
						} else if ($c_op == 3) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, false, false, $function_name);
						} else if ($c_op == 4) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, false, true, $function_name);
						} else if ($c_op == 5) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, true, false, $function_name);
						} else if ($c_op == 6) {
							self::printCustomValidationGreater($c_op1, $c_type, $field_name, $decimalPoint, true, true, $function_name);
						} else if ($c_op == 9) {
							self::printCustomValidationLike($c_op1, $c_type, $field_name, false, $function_name);
						} else if ($c_op == 10) {
							self::printCustomValidationLike($c_op1, $c_type, $field_name, true, $function_name);
						} else if ($c_op == 11) {
							self::printCustomValidationStartsWith($c_op1, $c_type, $field_name, false, $function_name);
						} else if ($c_op == 12) {
							self::printCustomValidationStartsWith($c_op1, $c_type, $field_name, true, $function_name);
						} else if ($c_op == 13) {
							self::printCustomValidationEndsWith($c_op1, $c_type, $field_name, false, $function_name);
						} else if ($c_op == 14) {
							self::printCustomValidationEndsWith($c_op1, $c_type, $field_name, true, $function_name);
						}
							
					}
					print("</script>");
				}
			}			
			*/
			public static function getValidatorFunctionName($catalogInstanceId, $fieldName){
				
				$ret = $catalogInstanceId;
				
				if(strpos($ret, "*"))
					$ret = str_replace("*", "_star_", $ret);
				if (strpos($ret, '.')) {
					$ret = str_replace('.', '_', $ret);
				}
							
				return "et_" . $ret . '_' . $fieldName . '_validation';			
			}
		
			protected static function printDecimalValidationIfNoConstraintOnCol ($decimalPoint) {
				
				$col_customrule_name = "decimal_validation";
				
				print("<script lang=\"javascript\">");
				?>
							function <?= $col_customrule_name ?>(value, colname) {
								if (value == null || value == '') return [true, ""];
								
								value2 = value.replace("<?=$decimalPoint?>", ".");
								
								if (isNaN(value2) && value2 != '~')
									return [false, colname + ", <?= ET_DisplayHelper::localize("TYPE_ERROR_NUMBER", null, PAGE_TYPE_GRID)?>"];
									
								return [true,""];
							}
							
							<?php 
							print("</script>");
				
				/*
				foreach ($columnInfo as $key => $value) {
				
					$numeric = false;
					if(in_array($value['metaType'],  ['I', 'N'])) {
						$numeric = true;
					}
					if ($numeric) {
						$col_customrule_name = "decimal_validation";
						
						print("<script lang=\"javascript\">");
						?>
							function <?= $col_customrule_name ?>(value, colname) {
								if (value == null || value == '') return [true, ""];
								
								value2 = value.replace("<?=$decimalPoint?>", ".");
								if (isNaN(value2))
									return [false, colname + ", <?= ET_DisplayHelper::localize("TYPE_ERROR_NUMBER")?>"];
									
								return [true,""];
							}
							
							<?php 
							print("</script>");
							break;
					}						
				}
				*/			
			}
	} 