<?php
	class ET_Properties {
		
		protected $properties = array();
	
		/***
		 * 
		 * @param string $filePath
		 * @return boolean|number (number of skipped lines)
		 */
		public function __construct($filePath) {
			
			$propertyLines 	= $this->createPropertyLinesOutOfFile($filePath);
			$skipped 		= -1;	
			
			if ($propertyLines == false)
				return false;
				
			for ($k = 0; $k < count($propertyLines); $k++) {
				
				$propertyLine 	= $propertyLines[$k];
				$pos 			= strpos($propertyLine, PROPERTY_FILE_KEY_VALUE_DELIMITER);
				
				if (!$pos) {
					if ($skipped === -1)
						$skipped = 1; 
					else 
						$skipped++;
					
					continue;
				}
				
				$key 		= trim(substr($propertyLine, 0, $pos));
				$valuesStr 	= trim(substr($propertyLine, $pos + 1));
				
				$this->properties[$key] = $valuesStr;
			}
			
			return $skipped < 0 ? true : $skipped;
		}
		
		/***
		 * Reads a property file and creates arrays out of it's content.
		 * @param string $propertyFileContent
		 * @param string $lineDelimiter
		 * @return array|false
		 */
		protected function createPropertyLinesOutOfFile ($filePath, $absolutePath = false) {

			if (!$absolutePath) {
				$filePath = "{$_SERVER['DOCUMENT_ROOT']}" . $filePath;
			}
			
			if (file_exists($filePath)) {
				
				$propertyFileContent = file_get_contents($filePath);
				return !empty($propertyFileContent) ? preg_split( '/\r\n|\r|\n/', $propertyFileContent) : false;
			}
			else {
				return false;
			}
					
		}
		
		/***
		 * Returns the value(s) of the given key in the given type
		 * @param string $key
		 * @param string $type
		 * @return boolean| the requested type
		 */
		public function getValue ($key, $type) {

			// if i use this line: 
			//if (isset($this->properties[$key]) && !empty($this->properties[$key]) -> undefinedIndex error raises.
			// php does not jump to the else after the 1st failed statement
			if (isset($this->properties[$key])) {
				// string "0" is consedered as empty in PHP therefore we need that || part:
					if (!empty($this->properties[$key]) || $this->properties[$key] === "0") {					
						$ret = null; 
						
						if ($type === PROPERTY_VALUE_TYPE_ARRAY) {					
							$ret = $this->createValueArray($key);
						}
						else if ($type === PROPERTY_VALUE_TYPE_STRING) {
							$ret = $this->createValueString($key);
						}
						else if ($type === PROPERTY_VALUE_TYPE_BOOLEAN) {					
							$ret = $this->createValueBoolean($key);
						}
						else if ($type === PROPERTY_VALUE_TYPE_NUMERIC) {
							$ret = $this->createValueNumeric($key);
						}
						
						return $ret;
					}
			}
			else {
				return false;
			}
			
		}
	
		/*** 
		 * 
		 * @return false|array()
		 */
		protected function createValueArray ($key) {
			
			$values = $this->properties[$key];
			$ret 	= array();
			
			if (!empty($values)) {
				
				$ret = explode(PROPERTY_FILE_VALUES_DELIMITER, $values);
				
				for ($i = 0; $i < count($ret); $i++) {
					$ret[$i] = trim($ret[$i]);
					
				}
				
			}										
			return $ret;				
		}
		
		protected function createValueString ($key) {
			
			$value = strval($this->properties[$key]);
			return trim($value);
		}
		
		protected function createValueBoolean ($key) {
			
			$value 		= $this->properties[$key];
			$value 		= trim($value);
			$trueArray 	= [1, '1', true, 'true']; 
			$falseArray = [0, '0', false, 'false'];
			
			if (in_array($value, $trueArray)) {
				return true;
			}
			else if (in_array($value, $falseArray)) {
				return false;
			}
			else {
				throw new ET_NiotaException("Property file processing error! Boolean cannot be retrieved for key: $key!");
			}
		}
		
		protected function createValueNumeric($key) {
			
			$value = (int)$this->properties[$key];
			
			return $value;
		}
	}
	
	