<?php
class ET_PropertiesStartUp {
	
	protected $ConfigFiles		= array();
	protected $DefaultSettings	= array();
	protected $CustomSettings	= array();
	protected $SystemSettings	= array();
	
	protected $startUpPairs		= array();
	protected $virtualElements	= array();
	
	private static $instance	= null;
	protected $iniFileName		= "";
	
	public static function getInstance () {
		
		if (is_null(self::$instance)) {
			self::$instance = new ET_PropertiesStartUp();
		}
		
		return self::$instance;
	}
	
	private function __construct() {
		
		$this->iniFileName = "client.ini";
		
		$niotaClient = isset($_SESSION["client"]) ? $_SESSION["client"] : CLIENT_SYSTEM;
		
		$propertyFile = null;
		$propertyCustom = null;
		
		try {
			$propertyCustom = $this->readStartUpPropFile();
			$this->fillConfigSections($propertyCustom);
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
			//ET_DisplayHelper::addErrorLine($e->getMessage(), 'login');
		}
	}
	
	protected function fillConfigSections ($propertyFileContent) {
		
		$offset 	= 0;
		$counter 	= 0;
		$clientName	= "";
		
		// if client is not set then $_SESSION had been expired
		if (!isset($_SESSION['client'])) {
			header("Location: ../../login.php");
		} else {
			$clientName = $_SESSION['client'];
		}
				
		$ConfigStartTag = strtoupper("[$clientName]");
		$ConfigEndTag 	= strtoupper("[/$clientName]");
		
		$startPosConfig = strpos($propertyFileContent, $ConfigStartTag, $offset);
		$endPosConfig = strpos($propertyFileContent, $ConfigEndTag, $offset);
				
		if (strpos($propertyFileContent, $ConfigStartTag, $offset) === false ||
				strpos($propertyFileContent, $ConfigEndTag, $offset) === false) {					
					throw new Exception("niota cannot start<br>Start or close tag for client config is missing. 
										Please validate file: 'client.ini' or omit client definition.<br>");
		}
				
		$startPosConfig = $startPosConfig + strlen($ConfigStartTag);
		$endPosConfig = $endPosConfig - strlen($endPosConfig) +1;
		
		$configBlock = trim(substr($propertyFileContent, $startPosConfig, $endPosConfig - $startPosConfig));
		
		$this->getSettings($configBlock);
				
	}
	
	protected function getSettings ($ConfigBlockData) {
		
		$validPairs	 = array();
		$ConfigLines = explode("\r\n", $ConfigBlockData);
		
		$remark = ';';
		$assign = '=';
		
		for ($i = 0; $i < count($ConfigLines); $i++) {
			
			$ConfigPair	= trim($ConfigLines[$i]);
			
			// if it is a remark
			if (strpos($ConfigPair, $remark, 0) === 0 )
				continue;
				
				// if there is no assignment or no name on the left
				if (strpos($ConfigPair, $assign) === false || strpos($ConfigPair, $assign) === 0)
					continue;
			
			// split the string at the "=" sign
			$Pair = preg_split("/=/", $ConfigPair);
			
			// move it to an associative array
			$this->startUpPairs[$Pair[0]] = $Pair[1];
					
		}
		
		//     return $validPairs;
	}
	
	public function myParameter ($parameter) {
		
		$ret = $this->startUpPairs[$parameter];
		
		return $ret;
	}
	
	
	
	/***
	 *
	 * @param string $featureSectionDelimiter - ###feature-name###
	 */
	protected function getFeatureName($nameWithHashes) {
		
		$ret = substr($nameWithHashes, 3, strlen($nameWithHashes) - 6);
		
		if (!empty($ret))
			return $ret;
			else return false;
	}
	
	protected function readStartUpPropFile() {
		
		$fileContent = "";
		
		$IniFilePath = null;						
		$IniFilePath = dirname(__FILE__) . "/../../../conf/";
	
		$niotaIniFile = $IniFilePath . $this->iniFileName;
				
		if (file_exists($niotaIniFile)) {
		
			$fileContent = file_get_contents($niotaIniFile);
			
			if (empty($fileContent)) {
				throw new Exception("Start up" . $niotaIniFile . " is empty!");
			}
		} else {
			throw new Exception("Start up $this->iniFileName file not found!");
		}
		return $fileContent;
	}

	
	
	
	
	
	
	
}