<?php
class ET_PwCheck {
	
	private $password;
	
	private $lowerMatchNum;
	private $upperMatchNum;
	private $digitMatchNum;
	private $spechMatchNum;
	private $pwLength;
	
	private $regexPatternLower 	= "/[a-z]/";
	private $regexPatternUpper 	= "/[A-Z]/";	
	private $regexPatternNum 	= "/[0-9]/";
	//checked special characters are: !"#$%&'()*+,\-./:;<=>?@[\]^_`{|}~
	private $regexPatternSpec 	= "/[[:punct:]]/";
	
	
	public function __construct($pw) {
		
		$this->password = $pw;
		
		if (defined('PW_POLICY_LOWER_MATCH_COUNT')) {
			$this->lowerMatchNum = PW_POLICY_LOWER_MATCH_COUNT;
		} else {
			throw new Exception("PW POLICY CONFIGURATION ERROR! 'PW_POLICY_LOWER_MATCH_COUNT' is not defined");
		}
		
		if (defined('PW_POLICY_UPPER_MATCH_COUNT')) {
			$this->upperMatchNum = PW_POLICY_UPPER_MATCH_COUNT;
		} else {
			throw new Exception("PW POLICY CONFIGURATION ERROR! 'PW_POLICY_UPPER_MATCH_COUNT' is not defined.");
		}
		
		if (defined('PW_POLICY_DIGIT_MATCH_COUNT')) {			
			$this->digitMatchNum = PW_POLICY_DIGIT_MATCH_COUNT;			
		} else {
			throw new Exception("PW POLICY CONFIGURATION ERROR! 'PW_POLICY_DIGIT_MATCH_COUNT' is not defined");
		}
		
		if (defined('PW_POLICY_SPECIAL_MATCH_COUNT')) {
			$this->spechMatchNum = PW_POLICY_SPECIAL_MATCH_COUNT;
		} else {
			throw new Exception("PW POLICY CONFIGURATION ERROR! 'PW_POLICY_SPECIAL_MATCH_COUNT' is not defined");
		}
		
		if (defined('PW_POLICY_MIN_LENGTH')) {
			$this->pwLength = PW_POLICY_MIN_LENGTH;
		} else {
			throw new Exception("PW POLICY CONFIGURATION ERROR! 'PW_POLICY_MIN_LENGTH' is not defined");
		}
		
	}
	
	public function checkPW() {
		
		return (preg_match_all($this->regexPatternLower, $this->password) >= $this->lowerMatchNum &&
				preg_match_all($this->regexPatternUpper, $this->password) >= $this->upperMatchNum &&
				preg_match_all($this->regexPatternNum, $this->password) >= $this->digitMatchNum &&
				preg_match_all($this->regexPatternSpec, $this->password) >= $this->spechMatchNum &&
				$this->checkLength()) ? true : false;
		
	}
	
	public  function checkLength() {
		
		if (strlen($this->password) >= $this->pwLength) {
			return true;
		} else {
			return false;
		}
		
	}
	
}