<?php

	class ET_StringCheck {
		
		public const EMAILERRORFORMAT 		= "EMAIL_FORMAT_ERROR";
		public const EMAILEXISTINGERROR 	= "EXISITNG_EMAIL_ERROR";
				
		public static function checkForSpecChars($userInput){
			if(trim($userInput) != "" || is_null($userInput)){
				if (preg_match('/[\'^$?*()}{><,|=+;]/', $userInput))
					return false;
				else
					return true;
			}
			else 
				return false;
		}		
		
		public static function startsWith($haystack, $needle) {
			$length = strlen($needle);
			return (substr($haystack, 0, $length) === $needle);
		}
		
		public static function endsWith($haystack, $needle) {
			$length = strlen($needle);
			if ($length == 0) {
				return true;
			}
			return (substr($haystack, -$length) === $needle);
		}
		
		public static function rTrimValues($arrFields) {
			foreach ($arrFields as $colName => $val) {
				$arrFields[$colName] = trim($val, " ");
			}
			return $arrFields;
		}
		
		public static function convertToUTF8 ($text, $connName) {
			
			$db_type 	= ET_ConnHelper::getConnectionTypeByName($connName);
			$db_charset = ET_ConnHelper::getConnectionCharsetByName($connName);
			
			if ($db_type == DB_TYPE_ODBC_MSSQL)
				$text = iconv($db_charset, "utf-8", $text);
			else if ($db_type == DB_TYPE_ODBC_TERADATA) {
				$text = rtrim(iconv($db_charset, "utf-8", $text));
			}
			
			return $text;			
		}
		
		public static function convertToDbCharset ($text, $connName) {
			$db_type 	= ET_ConnHelper::getConnectionTypeByName($connName);
			$db_charset = ET_ConnHelper::getConnectionCharsetByName($connName);
			
			if ($db_type !== DB_TYPE_OCI805)
				$text = iconv("utf-8", $db_charset, $text);
			
			return $text;
			
		}
		
		public static function resolveSubstitutedCharactersInGET($inputStr) {
			
			//# substitution
			if (strpos($inputStr, SUBSTITUTION_HASHMARK_HTML_GET) !== false) {
				$inputStr = str_replace(SUBSTITUTION_HASHMARK_HTML_GET, "#", $inputStr);
			}
			//& substitution
			if (strpos($inputStr, SUBSTITUTION_AMPERSAND_HTML_GET) !== false) {
				$inputStr = str_replace(SUBSTITUTION_AMPERSAND_HTML_GET, "&", $inputStr);
			}
			if (strpos($inputStr, SUBSTITUTION_DOT_JQUERY_SELECTOR) !== false) {
				$inputStr = str_replace(SUBSTITUTION_DOT_JQUERY_SELECTOR, ".", $inputStr);
			}
								
			return $inputStr;
					
		}
		
		public static function substituteSpecialCharacters ($inputStr) {
			
			$ret = $inputStr;
			
			if (strpos($ret, "&")  !== 0) {
				$ret = str_replace("&", SUBSTITUTION_AMPERSAND_HTML_GET, $ret);
			}			
			if (strpos($ret, "#")  !== 0) {
				$ret = str_replace("#", SUBSTITUTION_HASHMARK_HTML_GET, $ret);
			}
			if (strpos($ret, ".")  !== 0) {				
				$ret = str_replace(".", SUBSTITUTION_DOT_JQUERY_SELECTOR, $ret);
			}
						
			return $ret;
			
		}
		
		public static function exactSubstringExistanceInString ($haystack, $needle) {
			if (preg_match("~\b$needle\b~", $haystack)) {
				return true;
			} else {
				return false;
			}
		}
		
		/***
		 * If dot or @ character is missing or at the index [0] of the string returns false
		 *
		 * @param string $email
		 * @return boolean on succes or messge on failure
		 */
		public static function basicEmailCheck($email, $resendEmail = false) {
			
			$emailValid = filter_var($email, FILTER_VALIDATE_EMAIL);
			
			//funciton filter_var($email, FILTER_VALIDATE_EMAIL); returns the input string on success
			//and false on failure
			if ($resendEmail) {
				return $emailValid !== false ? true : false;
			} else {
				if ($emailValid) {
					if (!ET_MetaDataConnector::getInstance()->doesEmailExist($email)) {
						return true;
					} else {
						return self::EMAILEXISTINGERROR;
					}
				} else {
					return self::EMAILERRORFORMAT;
				}
			}
		}
		
	}
	
	
	
	
	
	