<?php
	class ET_SysTableHandler {
		
		/***
		 * Returns the specific meta table with full name or false.
		 * 
		 * @param string $tableKey -> can be one of the following list: catalogObject, catalogObjectInstance, user, userSetting,
		 * userGroup, catalogObjectAccess, adminDomains, transaction, callableObject, catalogObjectCallable, transactionParameterSet,
		 * transactionMenu, callableAccess, catalogObjectColumnProp, constraint, lookup, masterDetail, masterDetailLink, logging
		 * 
		 * @param string $conn_name -> metadata connection name
		 * 
		 * @param bool $isTable -> if true, returns the tablename, if false returns the view name. true by default
		 * 
		 * @return string or false 
		 */
		public static function getSpecificTableOrViewFullName($tableKey, $conn_name, $isTable = true) {
			
			$tableOrViewFullName = false;
			$metaSettings 		= array();			
			$tableOrView 		= self::getElementFromSysArray($tableKey, $isTable);
			
			try {
				$metaSettings 	= self::getMetadataSettings($conn_name);
			} catch (Exception $e) {
				echo "Error in ET_SysTableHandler.php! " . $e->getMessage();
				return;
			}
			
			switch ($metaSettings["dbType"]){
				case "oci805":
					//returns only the table name, no db
					$tableOrViewFullName = $tableOrView;
					break;
				case "odbc_mssql":
					$tableOrViewFullName = $metaSettings['dbName'] . "." . $tableOrView;
					break;
				case "odbc_teradata":
					$tableOrViewFullName = $metaSettings['dbName'] . "." . $tableOrView;
					break;
				case "mysqli":
					$tableOrViewFullName = $metaSettings['dbName'] . "." . $tableOrView;
					break;
			}
			
			return $tableOrViewFullName;
		}
		
				
		/***
		 * Returns the specific meta table with full name or false.
		 *
		 * @param string $tableKey -> can be one of the following list: catalogObject, catalogObjectInstance, user, userSetting,
		 * userGroup, catalogObjectAccess, adminDomains, transaction, callableObject, catalogObjectCallable, transactionParameterSet,
		 * transactionMenu, callableAccess, catalogObjectColumnProp, constraint, lookup, masterDetail, masterDetailLink, logging
		 *
		 * @param string $conn_name -> metadata connection name
		 *
		 * @return array
		 */		
		public static function getSpecificTableAndViewFullName($tableKey, $conn_name) {
			$ret = array();
			try{
				$tableFullname 	= self::getSpecificTableOrViewFullName($tableKey, $conn_name);
				$viewFullname 	= self::getSpecificTableOrViewFullName($tableKey, $conn_name, false);					
			}
			catch (Exception $e) {
				echo "Error when get meta table name in ET_SysTableHandler.php! " . $e->getMessage();
				return;
			}
			$ret[] = [$tableFullname, $viewFullname];
			
			return $ret;
		}

		/***
		 * Returns the connection attributes in an associaive array
		 * @param string $conn_name -> meta connection name
		 * @return boolean|string[][] 
		 * associative array: dbName, dbType, dbPlusSchema
		 */
		private static function getMetadataSettings($conn_name){
			$return 	= array();
			
			if (isset(ET_CONNECTIONS[$conn_name])) {
				$dbName 	= ET_CONNECTIONS[$conn_name]['PHPGRID_DB_NAME'];
				$dbType 	= ET_CONNECTIONS[$conn_name]['PHPGRID_DB_TYPE'];
				$metadaDbPrefix = "";
									
				$return += array("dbName" => $dbName);
				$return += array("dbType" => $dbType);
			} else {
				throw new Exception("Cannot retrieve metadata info!");
			}
			
			return $return;			
		}
		
		private static function getElementFromSysArray($tableKey, $isTable) {
			$ret = "";
			
			if (key_exists($tableKey, SYSTEM_TABLES)) {
				$ret = $isTable ? SYSTEM_TABLES[$tableKey][0] : SYSTEM_TABLES[$tableKey][1];
			}  else if (key_exists($tableKey, SYSTEM_VIEWS)) {
				$ret = SYSTEM_VIEWS[$tableKey][0];
			}
			
			return $ret;
		}
	}