<?php
class ET_UCAConnector {
	
	private $connName;
	private $conn;
	private $connType;
	private $ucaStrResolved;
	private $ucaStrRaw;	
	private $columnList = ['username', 'appcode', 'id_session', 'guid_msg', 'lang', 'uca'];	 
	private $systemDataList;
	private $fullDbName;
	private $fullTableName;
	private $user;
	private $userName;
	private $msgGuid;
	private $systemData;
	
	private $SQLSelect;
	private $SQLInsert;
	private $SQLUpdate;
	/***
	 * 
	 * @param unknown $ucaStrResolved - resolved uca string
	 * @param unknown $coConnName	- callable obejct connection name
	 */
	public function __construct($coConnName, $msgGuid, $isAdminGrid, $ucaData) {
		
		$this->connName 	= $coConnName;
		$this->conn			= ET_ConnHelper::getConnection($this->connName);		
		$this->connType		= ET_ConnHelper::getConnectionTypeByName($this->connName);
		//$this->ucaStr		= $ucaStrResolved;
		$this->fullDbName 	= ET_ConnHelper::getfullDbName($this->connName);
		$this->fullTableName = $this->fullDbName . ".et_user_comm_area";
		$this->user 		= ET_NiotaUser::getNiotaUserFromSession();
		$this->userName		= $this->user->get_username();		
		$this->msgGuid		= $msgGuid;
		
		$this->ucaStrRaw	= $ucaData['uca'];
		
		//$catalogInstanceId = $isAdminGrid ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN] : $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
		$catalogInstanceId = ET_CallableObjectHelper::getCatalogInstanceId($isAdminGrid);
		$this->systemData	= $systemData = ET_CallableObjectHelper::fillSystemData(ET_BrowsingStore::getBrowsingStore(), $this->user, $catalogInstanceId);		
		$this->systemData 	=  ET_CallableObjectHelper::resolveAdminCatalogIdAndInstName($catalogInstId, $this->systemData);
		
		$this->SQLSelect 	= "SELECT * from %tableName% where username = '%userName%'";
		$this->SQLInsert	= "INSERT INTO %tableName% (%columnList%) values (%valueList%)";
		$this->SQLUpdate	= "UPDATE %tableName% set %valueList% where username = '%userName%'";
	}
	
	public function updateUCATable() {
		
		$ret 		= false;
		$rowExists 	= $this->chcekUserRow();				
		$dataList 	= array($this->userName, APPLICATION_CODE_SYSTEM, $this->systemData['sessionId'], $this->msgGuid, $this->systemData['lang'], $this->ucaStrResolved);
		
		$sql 		= "";
		
		if ($rowExists) {
			//update		
			$valueList 		= $this->setUpValueList($dataList);
			$sql 			= str_replace('%tableName%', $this->fullTableName, $this->SQLUpdate);
			$sql 			= str_replace('%valueList%', $valueList, $sql);	
			$sql			= str_replace('%userName%', $this->userName, $sql);
		} else {			
			//insert
			$valueList  = $this->setUpValueList($dataList, false);
			$columnList = $this->connType == DB_TYPE_OCI805 ? strtoupper(implode(', ', $this->columnList)) : implode(', ', $this->columnList);
			
			$sql = str_replace('%tableName%', $this->fullTableName, $this->SQLInsert);
			$sql = str_replace('%columnList%', $columnList, $sql);
			$sql = str_replace('%valueList%', $valueList, $sql);			
		}
				
		$result 		= $this->conn->Execute($sql);	
		//var_dump($this->conn);
		//$affectedRows 	= $this->conn->affected_rows();
		
		if ($this->connType == DB_TYPE_MSSQL) {
			$ret = gettype($result) == "object" ? true : false;
		} else {
			$ret = ET_DisplayHelper::is_blank($this->conn->_errorMsg) ? true : false; 
			//$ret = $affectedRows;
		}
		
		return $ret;
		
	}
	
	public function resolveUCAStr($coDisplayName) {
		
		$systemData				= $this->systemData;
		$systemData['msgGuid'] 	= $this->msgGuid;
		
		$this->ucaStrResolved	= ET_CallableObjectHelper::resolveQueryString($this->ucaStrRaw, $systemData,  null, $coDisplayName);
		
		return $this->ucaStrResolved;
		
	}
	
	protected function chcekUserRow() {
				
		$sql 	= str_replace('%tableName%', $this->fullTableName, $this->SQLSelect);
		$sql 	= str_replace('%userName%', $this->userName, $sql);		
 		
		$result	= $this->conn->Execute($sql);		
		
		if ($result === false) {
			$ret 	= false;
		} else {
			$ret = $result->numRows();
		}
				
		return 	$ret;
		
	}
	
	protected function setUpValueList($dataList, $update = true) {
		$ret = "";
		
		if ($update) {
			
			for ($i = 0; $i < count($this->columnList); $i++) {				
				$colName = $this->connType == DB_TYPE_OCI805 ? strtoupper($this->columnList[$i]) : $this->columnList[$i];
				$ret 	.= " $colName = '" . $dataList[$i] . "'";
				
				if ($i < count($this->columnList) - 1) {
					$ret .= ", ";
				}
			}
			
		} else {
			
			for ($i = 0; $i < count($dataList); $i++) {
				$tmp[$i] = "'" . $dataList[$i] . "'";
			}
			$ret = implode(',', $tmp);
		}
		
		return $ret;
	}	
	
	public function getSystemData() {
		return $this->systemData;
	}
	
	public function setUCAStr($ucaStr) {
		$this->ucaStrResolved = $ucaStr;
	}	
	
}