<?php
/***
 * 
 * @author Zalan
 * This satic class is responsible for handling uploaded file data in the $_SESSION
 */
class ET_UploadFileDataSessionManager {

	public static function storeUploadedFileName($fileName) {
		
		$_SESSION[SESS_UPLOADED_FILE_NAME] = $fileName;
	}

	public static function storeUploadedFileFullPath($fullPath) {
		
		$_SESSION[SESS_UPLOADED_FILE_PATH] = $fullPath;		
	}
	
	public static function storeUploadFolderPath($folderPath) {
		
		$_SESSION[SESS_UPLOAD_FOLDER_PATH]	= $folderPath;
	}
	
	public static function getUploadedFileName() {
		
		if(isset($_SESSION[SESS_UPLOADED_FILE_NAME])) {
			if (!empty($_SESSION[SESS_UPLOADED_FILE_NAME])) {
				return $_SESSION[SESS_UPLOADED_FILE_NAME];
			}
		}
		return false;
	}
	
	public static function getUploadedFileFullPath() {
		
		if(isset($_SESSION[SESS_UPLOADED_FILE_PATH])) {
			if (!empty($_SESSION[SESS_UPLOADED_FILE_PATH])) {
				return $_SESSION[SESS_UPLOADED_FILE_PATH];
			}
		}
		return false;		
	}
	
	public static function getUploadFolderPath() {
		
		if(isset($_SESSION[SESS_UPLOAD_FOLDER_PATH])) {
			if (!empty($_SESSION[SESS_UPLOAD_FOLDER_PATH])) {
				return $_SESSION[SESS_UPLOAD_FOLDER_PATH];
			}
		}
		return false;
	}
	
	public static function resetUpoladedFileData() {
		
		if (isset($_SESSION[SESS_UPLOADED_FILE_NAME]))
			unset($GLOBALS["_SESSION"][SESS_UPLOADED_FILE_NAME]);
		if (isset($_SESSION[SESS_UPLOADED_FILE_PATH]))
			unset($GLOBALS["_SESSION"][SESS_UPLOADED_FILE_PATH]);
		if (isset($_SESSION[SESS_UPLOAD_FOLDER_PATH]))
			unset($GLOBALS["_SESSION"][SESS_UPLOAD_FOLDER_PATH]);
	}
	
	public static function isThereUploadedFile() {
		
		if (isset($_SESSION[SESS_UPLOAD_FOLDER_PATH]) && isset($_SESSION[SESS_UPLOADED_FILE_PATH]) && isset($_SESSION[SESS_UPLOADED_FILE_NAME])) {
			return true;
		} else {
			return false;
		}
		
	}
}

?>