<?php
	
	class ET_ValidationDataConnector {
		
		public static function getValidationSettings($catalogInstanceId, $connName) {
			
			$ret 		= [];
			$fullTableName 	= ET_BrowsingStore::getBrowsingStore()->get_fullTableName($catalogInstanceId);
			
			try{
				$ret = self::getPredefinedValidationSettings($connName, $fullTableName, $catalogInstanceId);
			} catch (Exception $e) {
				throw new Exception($e->getMessage());
			}
			
			return $ret;
		}
		
		public static function getChunkSizeValue() {
			return defined('VALIDATION_CHUNK_SIZE') ? VALIDATION_CHUNK_SIZE : 1000;
		}
		
		public static function calculateToValue($toPrevious, $chunkSize, $rowCount) {
			
			$ret 	= null;			
			$to 	= $toPrevious + $chunkSize - 1;
			
			if (intval($rowCount) === 1) {				
				$ret = $rowCount;
			}
			else if ($to > $rowCount) {
				$ret = $rowCount - 1;
			} else {
				$ret = $to;
			}
			
			return $ret;
		}
		
		public static function getDataSetChunk($connName, $connType, $fullTableName, $from, $to, $chunkSize, $columnSet, $PKs) {
			
			$ret 			= [];
			$conn 			= ET_ConnHelper::getConnection($connName);
			$PKsStr			= implode(",", $PKs);
			$colList 		= self::setColumnSetToChange($columnSet, $PKs);
			$sql 			= "SELECT $colList FROM $fullTableName ";
		
			
			switch ($connType) {
				case DB_TYPE_OCI805:
					$sql = "SELECT $colList from (SELECT $colList, ROWNUM AS rn FROM $fullTableName ORDER BY $PKsStr) where rn between $from and $to";
					//$sql .= " ORDER BY $PKsStr OFFSET $from FETCH NEXT $chunkSize ROWS ONLY";
					break;
				case DB_TYPE_ODBC_MSSQL:
				case DB_TYPE_MSSQL:
					$sql .= " ORDER BY $PKsStr OFFSET $from ROWS FETCH NEXT $chunkSize ROWS ONLY";
					break;
				case DB_TYPE_ODBC_TERADATA:
					$sql .= " QUALIFY ROW_NUMBER () OVER (ORDER BY $PKsStr) BETWEEN $from and $to;";
					break;
				case DB_TYPE_MYSQLI:
					$sql .= " ORDER BY $PKsStr limit $chunkSize OFFSET $from";
					break;
			}
			
			$conn->SetFetchMode(ADODB_FETCH_ASSOC);
			
			$res 	= $conn->Execute($sql);
			$ra 	= $res->NumRows();
			
			if ($ra == 0){
				return null;
			} else {
				while ($row = $res->fetchRow()) {
					array_push($ret, $row);
				}
			}
			return $ret;
		} 
		
		public static function makeConstraintsKeyToLowerCase($constraints) {
			$constraintsLowercase = [];
			$constraintKeys = array_keys($constraints);
			foreach ($constraintKeys as $key) {
				$constraintsLowercase[strtolower($key)] = $constraints[$key];
			}
			return  $constraintsLowercase;
		}
				
		protected static function getPredefinedValidationSettings($connName, $fullTableName, $catalogInstanceId) {
			
			$ret 				= [];
			$ret['maxRow']		= 0;
			$sql 				= "";
			$catalogId			= ET_MetaDataConnector::getInstance()->getCatalogId($catalogInstanceId);
			$tableLenght		= null;
			
			$predefinedValidationSettings = ET_MetaDataConnector::getInstance()->getAndInitializePredefinedValidationSettings($catalogId);
			$preDefinedRowCount = $predefinedValidationSettings['maxRow'];
			
			$connType			= ET_ConnHelper::getConnectionTypeByName($connName);
			$tableLenght 		= self::getTableLength($connName, $fullTableName);
			
			
			if ($preDefinedRowCount == -1 || $preDefinedRowCount > $tableLenght) {
				$ret['maxRow'] = $tableLenght;
			} else {
				$ret['maxRow'] = $preDefinedRowCount;					
			}
			
			$ret['maxErr'] = $predefinedValidationSettings['maxErr'];
			$ret['maxMsg'] = $predefinedValidationSettings['maxMsg'];
			
			return $ret;
		}
		
		protected static function getTableLength($connName, $fullTableName) {
			
			$ret = null;
			$sql 	= "select count(*) as res from $fullTableName";
			$conn 	= ET_ConnHelper::getConnection($connName);
			$conn->SetFetchMode(ADODB_FETCH_ASSOC);
			$res 	= $conn->Execute($sql);
			
			$resRows = $res->NumRows();
			
			if ($resRows) {
				$row = $res->fetchRow();
				$row = ET_MetaDataConnector::getInstance()->arrayKeysToLower($row);
				return $row['res'];
			} else {
				throw new Exception("Cannot query number the of rows");
			}
		}
		
		protected static function setColumnSetToChange($columnsToCheck, $PKs) {
			
			$tmp = array_merge($columnsToCheck, $PKs);
			$tmp = array_unique($tmp);
			
			return implode(",", $tmp);
		}
		
	}