<?php 
	class ET_ValidationDataSessionManager {
		
		public static function setRowCount($msgGuid, $rowCount) {
			
			$_SESSION[$msgGuid][SESS_VALIDATION_ROWCOUNT] = intval($rowCount);
		}
		
		public static function getRowcount($msgGuid) {
			
			if(isset($_SESSION[$msgGuid][SESS_VALIDATION_ROWCOUNT]) && !is_null($_SESSION[$msgGuid][SESS_VALIDATION_ROWCOUNT])) {
				return $_SESSION[$msgGuid][SESS_VALIDATION_ROWCOUNT];
			}
			return false;
		}
		
		public static function setFinished($msgGuid, $finished) {
			$_SESSION[$msgGuid][SESS_VALIDATION_FINISHED] = $finished;
		}
		
		public static function getFinished($msgGuid) {
			
			if(isset($_SESSION[$msgGuid][SESS_VALIDATION_FINISHED]) && !is_null($_SESSION[$msgGuid][SESS_VALIDATION_FINISHED])) {
				return $_SESSION[$msgGuid][SESS_VALIDATION_FINISHED];
			}
			return false;
		}
		
		public static function setFrom($msgGuid, $from) {
			$_SESSION[$msgGuid][SESS_VALIDATION_FROM] = $from;
		}
		
		public static function getFrom($msgGuid) {
			if(isset($_SESSION[$msgGuid][SESS_VALIDATION_FROM]) && !is_null($_SESSION[$msgGuid][SESS_VALIDATION_FROM])) {
				return $_SESSION[$msgGuid][SESS_VALIDATION_FROM];
			}
			return false;
		}
		
		public static function setTo($msgGuid, $to) {
			$_SESSION[$msgGuid][SESS_VALIDATION_TO] = $to;
		}
		
		public static function getTo($msgGuid) {
			if(isset($_SESSION[$msgGuid][SESS_VALIDATION_TO]) && !is_null($_SESSION[$msgGuid][SESS_VALIDATION_TO])) {
				return $_SESSION[$msgGuid][SESS_VALIDATION_TO];
			}
			return false;
		}
		
		public static function setChunkSize($msgGuid, $chunkSize) {
			$_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_SIZE] = $chunkSize;
		}
		
		public static function getChunkSize($msgGuid) {
			if(isset($_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_SIZE]) && !is_null($_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_SIZE])) {
				return $_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_SIZE];
			}
			return false;
		}
		
		public static function increaseErrorCountLookup($msgGuid) {
			
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_LKP]))
				$_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_LKP] += 1;
		}
		public static function increaseErrorCountConstraint($msgGuid) {
			
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_CONST]))
				$_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_CONST] += 1;
		}
		
		public static function getErrorCountLookup($msgGuid) {
			if(isset($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_LKP]) && !is_null($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_LKP])) {
				return $_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_LKP];
			}
			return false;
		}
		public static function getErrorCountConstraint($msgGuid) {
			if(isset($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_CONST]) && !is_null($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_CONST])) {
				return $_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_CONST];
			}
			return false;
		}
		
		public static function increaseCheckedRowsCounter($msgGuid) {
			
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_CHECKED_ROWS_COUNT]))
				$_SESSION[$msgGuid][SESS_VALIDATION_CHECKED_ROWS_COUNT] += 1;
		}
		
		public static function getCheckedRowsCounter($msgGuid) {
			
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_CHECKED_ROWS_COUNT]))
				return $_SESSION[$msgGuid][SESS_VALIDATION_CHECKED_ROWS_COUNT];
		}
		
		public static function setMaxError($msgGuid, $value) {
			$_SESSION[$msgGuid][SESS_VALIDATION_MAX_ERROR_AMOUNT] = $value;
		}
		
		public static function getMaxError($msgGuid) {
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_MAX_ERROR_AMOUNT]))
				return $_SESSION[$msgGuid][SESS_VALIDATION_MAX_ERROR_AMOUNT];
		}
		
		public static function setMaxMsg($msgGuid, $value) {
			$_SESSION[$msgGuid][SESS_VALIDATION_MAX_MESSAGES_AMOUNT] = $value;
		}
		
		public static function getMaxMsg($msgGuid) {
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_MAX_MESSAGES_AMOUNT]))
				return $_SESSION[$msgGuid][SESS_VALIDATION_MAX_MESSAGES_AMOUNT];
		}
		
		public static function addValidationChunkDataToCollector($msgGuid, $arr) {
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_COLLECTOR]))
				array_push($_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_COLLECTOR], $arr);
		}
		
		public static function getValidationChunkDataToCollector($msgGuid) {
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_COLLECTOR]))
				return $_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_COLLECTOR];
		}
		
		public static function increaseErrorLogCount($msgGuid) {
			
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_LOG_COUNT]))
				$_SESSION[$msgGuid][SESS_VALIDATION_ERROR_LOG_COUNT] += 1;
		}
		
		public static function getErrorLogCount($msgGuid) {
			
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_ERROR_LOG_COUNT]))
				return $_SESSION[$msgGuid][SESS_VALIDATION_ERROR_LOG_COUNT];
		}
		
		public static function setLookupValuesForValidation($msgGuid, $lookupValsArr) {
			
			$_SESSION[$msgGuid][SESS_VALIDATION_LOOKUP_VALUES] = $lookupValsArr;
		}
		
		public static function getLookupValuesForValidation($msgGuid) {
			
			if (isset($_SESSION[$msgGuid][SESS_VALIDATION_LOOKUP_VALUES]))
				return $_SESSION[$msgGuid][SESS_VALIDATION_LOOKUP_VALUES];
		}
		
		public static function resetCurrentValidationData($msgGuid) {
		
			if (isset($_SESSION[$msgGuid]))
				unset($GLOBALS["_SESSION"][$msgGuid]);
			
			/*
			if (isset($_SESSION[SESS_VALIDATION_ROWCOUNT]))
				unset($GLOBALS["_SESSION"][SESS_VALIDATION_ROWCOUNT]);
			if (isset($_SESSION[SESS_VALIDATION_FINISHED]))
				unset($GLOBALS["_SESSION"][SESS_VALIDATION_FINISHED]);
			if (isset($_SESSION[SESS_VALIDATION_FROM]))
				unset($GLOBALS["_SESSION"][SESS_VALIDATION_FROM]);
			if (isset($_SESSION[SESS_VALIDATION_TO]))
				unset($GLOBALS["_SESSION"][SESS_VALIDATION_TO]);
			if (isset($_SESSION[SESS_VALIDATION_CHUNK_SIZE]))
				unset($GLOBALS["_SESSION"][SESS_VALIDATION_CHUNK_SIZE]);
			if (isset($_SESSION[SESS_VALIDATION_ERROR_COUNT]))
				unset($GLOBALS["_SESSION"][SESS_VALIDATION_ERROR_COUNT]);
				*/
		}
		
		/***
		 * 
		 * @param unknown $array like: ["rowCunt" => $rowCount, "from" => $from, etc.]
		 */
		public static function setAnyValidationSessionVariable($msgGuid, $array) {
			
			if (isset($array["rowCount"]))
				self::setRowCount($msgGuid, $array["rowCount"]);
			if (isset($array["from"]))
				self::setFrom($msgGuid, $array["from"]);
			if (isset($array["to"]))
				self::setTo($msgGuid, $array["to"]);
			if (isset($array["finished"]))
				self::setFinished($msgGuid, $array["finished"]);
			if (isset($array["chunkSize"]))
				self::setChunkSize($msgGuid, $array["chunkSize"]);
			if (isset($array["maxErr"]))
				self::setMaxError($msgGuid, $array["maxErr"]);
			if (isset($array["maxMsg"]))
				self::setMaxMsg($msgGuid, $array["maxMsg"]);
		}
	}

?>