<?php 

class ET_ValidationHandler {
			
		
	public static function handleValidation($from, $to, $chunkSize, $rowCount, $catalogInstanceId, $msgGuid) {
		
		$chunk					= array();
		$columnsWithLookup 		= array();
		$columnsWithConstraint 	= array();
		$ret					= "";
		$validationResult		= null;
		
		$br				= ET_BrowsingStore::getBrowsingStore();
		$connName		= $br->get_connName($catalogInstanceId);
		$connType		= ET_ConnHelper::getConnectionTypeByName($connName);
		$fullTableName 	= $br->get_fullTableName($catalogInstanceId);
		$lookups 		= $br->get_lookupSettings($catalogInstanceId);
		$constraints 	= $br->get_constraintSettings($catalogInstanceId);
		$primaryKeys 	= $br->get_selectedPrimaryKeys($catalogInstanceId);
		$columnInfo		= $br->get_selectedColumnInfo($catalogInstanceId);		
		$columnsToCheck	= self::getColumnsToCheck($lookups, $constraints);
		$chunk 			= ET_ValidationDataConnector::getDataSetChunk($connName, $connType, $fullTableName, $from, $to, $chunkSize, $columnsToCheck, $primaryKeys);
		
		try {
			$validationResult = self::validateChunkData($chunk, $lookups, $constraints, $primaryKeys, $columnInfo, $msgGuid);
		} catch (Exception $e) {			
			$validationResult['error_logging'] 		= true;			
			$validationResult['error_logging_msg'] 	=  $e->getMessage();
		}
		
				
		return $validationResult;
	}
	
	public static function writeSummaryLogMsg($msgGuid, $errorLimitReached, $connName) {
		
		$maxMsgSetting = ET_ValidationDataSessionManager::getMaxMsg($msgGuid);
		$maxRowSetting	= ET_ValidationDataSessionManager::getRowcount($msgGuid);
		
		$violationsLookup 		= ET_ValidationDataSessionManager::getErrorCountLookup($msgGuid);
		$violationsConstraint 	= ET_ValidationDataSessionManager::getErrorCountConstraint($msgGuid);
		$logCount				= ET_ValidationDataSessionManager::getErrorLogCount($msgGuid);
		$rowsProcessed			= ET_ValidationDataSessionManager::getRowcount($msgGuid);
		$logMaxReached			= self::isLoggingEnough($msgGuid, $maxMsgSetting);
		$logMaxReachedStr		= $logMaxReached ? 'true' : 'false';
		$errorLimitReachedStr	= $errorLimitReached ? 'true' : 'false';		
		$violationsSum 			= $violationsConstraint + $violationsLookup;
		
		$phraseSum = "";
		$phraseLookupViolations = "";
		$phraseConstraintViolations = "";
		$phraseLoggedViolations = "";
		
		$logMsg =	ET_DisplayHelper::localize("VALIDATION_SUMMARY_SUM", array($violationsSum), PAGE_TYPE_GRID) . "\n".
					ET_DisplayHelper::localize("VALIDATION_SUMMARY_LOOKUP", array($violationsLookup), PAGE_TYPE_GRID) . "\n".
					ET_DisplayHelper::localize("VALIDATION_SUMMARY_CONSTRAINT", array($violationsConstraint), PAGE_TYPE_GRID) . "\n".
					ET_DisplayHelper::localize("VALIDATION_SUMMARY_LOGGED", array($logCount), PAGE_TYPE_GRID) . "\n".
					ET_DisplayHelper::localize("VALIDATION_SUMMARY_ROWS_PROC", array($rowsProcessed), PAGE_TYPE_GRID) . "\n".
					ET_DisplayHelper::localize("VALIDATION_SUMMARY_MAX_LOG_REACHED" , array($logMaxReachedStr), PAGE_TYPE_GRID) . "\n".
					ET_DisplayHelper::localize("VALIDATION_SUMMARY_MAX_ERROR_REACHED", array($errorLimitReachedStr), PAGE_TYPE_GRID);					
		
		$logger = new ET_DirectLogger($connName);
		$logger->log($logMsg, $msgGuid, CO_MESSAGE_TYPE_INFO, ET_DirectLogger::LOG_MSG_TYPE_SIMPLE);
		$msgEndLoaclized = ET_DisplayHelper::localize("VALIDATION_END", array(), PAGE_TYPE_GRID);
		$logger->log($msgEndLoaclized, $msgGuid, CO_MESSAGE_TYPE_INFO, ET_DirectLogger::LOG_MSG_TYPE_SIMPLE);
				
		return $logMsg;
	}
	
	protected static function getColumnsToCheck($lookups, $constraints) {
		
		$columsToCheck = [];
		
		foreach ($lookups as $key => $value) {
			array_push($columsToCheck, $key);
		}
		
		foreach ($constraints as $key => $value) {
			if (!in_array($key, $columsToCheck));
				array_push($columsToCheck, $key);
		}
				
		return $columsToCheck;
	}

	protected static function validateChunkData($chunk, $lookups, $constraints, $primaryKeys, $columnInfo, $msgGuid) {
		
		$ret 						= array();
		$constraintsLowerCase		= ET_ValidationDataConnector::makeConstraintsKeyToLowerCase($constraints);
		$errorDataCollected			= array();
		$errorCount					= 0;
		$maxErrorSetting 			= ET_ValidationDataSessionManager::getMaxError($msgGuid);
		$maxRowSetting 				= ET_ValidationDataSessionManager::getRowcount($msgGuid);
		$maxLogSetting				= ET_ValidationDataSessionManager::getMaxMsg($msgGuid);
		$stopValidation				= false;
		$stopLoggingDetails			= false;
		$lookupValues				= ET_ValidationDataSessionManager::getLookupValuesForValidation($msgGuid);
		$primaryKeysLowerCase		= array_map('strtolower',$primaryKeys);
		
		for($i = 0; $i < count($chunk); $i++) {
			
			$row 					= $chunk[$i];
			$rowKeysLower 			= array_change_key_case($row, CASE_LOWER); 
			$rowErrorData			= [];
			$rowErrorData["PKData"] = [];
			$rowErrorData["errorsLookup"] 		= "";
			$rowErrorData["errorsConstraint"] 	= "";
			$pkData 				= [];
			$rowError 				= false;
			$ret["errorLimitReached"] = false;
			
			foreach ($rowKeysLower as $key => $value) {
				//i have to add the pk value to the error arr by default because do not know if there will be an error 
				if (in_array($key, $primaryKeysLowerCase)) {
					$pkData[$key] = $value;
				}
				
				if (!ET_Validator::validateLookups($value, $key, $lookupValues, VALIDATION_TYPE_GRID_DIRECTLY)) {
					
					$rowError = true;
					$msg	  = "";
					ET_ValidationDataSessionManager::increaseErrorCountLookup($msgGuid);
					$stopLoggingDetails = self::isLoggingEnough($msgGuid, $maxLogSetting);
					
					if (!$stopLoggingDetails) {
						if (empty($rowErrorData['errorsLookup'])) {
							$rowErrorData['errorsLookup'] .= ET_DisplayHelper::localize("VALIDATION_ROW_ERROR_LOOKUP", array($key, $value), PAGE_TYPE_GRID);
						}
						else {
							$rowErrorData['errorsLookup'] .= ET_DisplayHelper::localize("VALIDATION_ROW_ERROR_LOOKUP_ADD", array($key, $value), PAGE_TYPE_GRID);
						}
						ET_ValidationDataSessionManager::increaseErrorLogCount($msgGuid);
					}
				}
				
				$colMetaType = $columnInfo[$key]['metaType'];
				
				$constraintCheckResult = ET_Validator::validateConstraints($value, $key, $colMetaType, $constraintsLowerCase, VALIDATION_TYPE_GRID_DIRECTLY);
				
				if (isset($constraintCheckResult['success']) && $constraintCheckResult['success'] == false) {
					
					$rowError = true;
					ET_ValidationDataSessionManager::increaseErrorCountConstraint($msgGuid);
					$stopLoggingDetails = self::isLoggingEnough($msgGuid, $maxLogSetting);
					
					if (!$stopLoggingDetails) {
						if (empty($rowErrorData['errorsConstraint'])) {
							$rowErrorData['errorsConstraint'] .= ET_DisplayHelper::localize("VALIDATION_ROW_ERROR_CONSTRAINT", array($key, $value), PAGE_TYPE_GRID);
						} else{
							$rowErrorData['errorsConstraint'] .= ET_DisplayHelper::localize("VALIDATION_ROW_ERROR_CONSTRAINT_ADD", array($key, $value), PAGE_TYPE_GRID);
						}
						ET_ValidationDataSessionManager::increaseErrorLogCount($msgGuid);
					}
				}
			}
			
			if ($rowError && !$stopLoggingDetails) {
				$rowErrorData["PKData"] = $pkData;
				array_push($errorDataCollected, $rowErrorData);
				//TODO put here a try-catche block then handle log erro on JS side
				try {
					self::handleRowLogging($rowErrorData, $msgGuid);
				} catch (Exception $e) {
					throw new Exception($e->getMessage());
				}
				
			}
			ET_ValidationDataSessionManager::increaseCheckedRowsCounter($msgGuid);
						
			if ($maxErrorSetting != -1)
				$ret["errorLimitReached"] = self::isErrorEnough($msgGuid, $maxErrorSetting);
			
			if ($ret["errorLimitReached"]) {
					return $ret;
			}
			
		}
		
		return $ret;
	}
	
	protected static function isErrorEnough($msgGuid, $maxErrorSetting) {
		
		$errCountLkp 	= ET_ValidationDataSessionManager::getErrorCountLookup($msgGuid);
		$errCountConst 	= ET_ValidationDataSessionManager::getErrorCountConstraint($msgGuid);
		$total 			= $errCountLkp + $errCountConst;
		
	
		if ($total >= $maxErrorSetting) {
			return true;
		} else 
			return false;
	}
	
	protected static function isLoggingEnough($msgGuid, $maxMsgSetting) {
		
		$loggedErrors = ET_ValidationDataSessionManager::getErrorLogCount($msgGuid);
		
		if ($maxMsgSetting == -1) 
			return false;
		
		if ($maxMsgSetting == 0)
			return true;
		
		if ($loggedErrors >= $maxMsgSetting)
			return true;
			
		return false;	
	}
	
	protected static function handleRowLogging($rowErrorData, $msgGuid) {
		
		$ret 		= null;
		$PKdata 	= $rowErrorData["PKData"];
		$PKStr		= self::setUpPKStr($PKdata);
		
		$logPartLookupMsg = $rowErrorData["errorsLookup"];
		$logPartConstrMsg = $rowErrorData["errorsConstraint"];
				
		$catInstId = $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
		$connName	= ET_BrowsingStore::getBrowsingStore()->get_connName($catInstId);
		
		$logger = new ET_DirectLogger($connName);
				
		$logMsg = $logPartLookupMsg . "\n" . $logPartConstrMsg;
		$logMsg = self::truncateLogMsg($logMsg);
		
		try {
			
			$ret = $logger->log($logMsg, $msgGuid, LOG_TYPE_ERROR, ET_DirectLogger::LOG_MSG_TYPE_DETAILED, LOGGING_SOURCE_VALIDATION, $PKStr);
		} catch (Exception $e) {
			throw $e;
		}
		
		return $ret;
		
	}
	
	protected static function setUpPKStr($PKdata) {
		
		$ret = "";
			
		foreach ($PKdata as $key => $value) {
			$ret .= "[$key] = $value, ";
		}
		
		$ret = substr($ret, 0, strlen($ret) - 2);
		return $ret . ".";
		
	}
	
	public static function getLookupValues($lookups) {
		$lookupValues = array();
		if (!empty($lookups)) {
			$wasError = false;
			foreach ($lookups as $fieldName => $fieldObj) {
				
				//array_push($lookupColumnNames, strtolower($fieldName));
				$lookupCatalogId 	= $fieldObj['catalogId'];
				$lookupInstanceName = $fieldObj['instanceName'];
				
				$catalgInstanceIdGrid	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
				$catalgId				= explode(".", $catalgInstanceIdGrid)[0];
				$addNullItem 			= ET_MetaDataConnector::getInstance()->getLookupNullable($catalgId, $fieldName);
				
				$lookupInstance = new ET_LookupInstance($lookupCatalogId, $lookupInstanceName, $addNullItem);
				
				if (!is_null($lookupInstance->getError())) {
					throw new Exception("lookup error - validation failed");
					
				}
				else{
					$lookupSQL = $lookupInstance->get_LookupSql();
					$lookupConnName = $lookupInstance->get_ConnName();
					
					$lookupResult = self::getLookupResults($lookupSQL, $lookupConnName);
					
					if ($lookupResult === 1) {
						$wasError = true;
						$errorText = ET_DisplayHelper::localize("ERROR_SQL", null, PAGE_TYPE_GRID);
					} else if ($lookupResult === 2) {
						$wasError = true;
						$errorText = ET_DisplayHelper::localize("ERROR_ALIAS", null, PAGE_TYPE_GRID);
					} else if ($lookupResult === 3){
						$wasError = true;
						$errorText = ET_DisplayHelper::localize("ERROR_EMPTY_QUERY", null, PAGE_TYPE_GRID);
					}
				}
				
				if ($wasError) {
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_GET_LOOKUP_VALUES", array($errorText, $lookupSQL, $lookupConnName), PAGE_TYPE_GRID), 'niota');
					throw new Exception("lookup error - validation failed! $errorText");
				}
				else {
					$lookup_db_type = ET_ConnHelper::getConnectionTypeByName($lookupConnName);
					$lookup_db_charset = ET_ConnHelper::getConnectionCharsetByName($lookupConnName);
					
					for ($h=0; $h<count($lookupResult); $h++) {
						if ($lookup_db_type == 'odbc_mssql'  || $lookup_db_type == DB_TYPE_MSSQL) {
							$lookupResult[$h] = iconv($lookup_db_charset, "UTF-8",$lookupResult[$h]);
						} else if ($lookup_db_type == 'odbc_teradata') {
							$lookupResult[$h] = iconv("iso-8859-2", "UTF-8",$lookupResult[$h]);
							$lookupResult[$h] = trim($lookupResult[$h]);
						}
					}
					$lookupValues[strtolower($fieldName)] = $lookupResult;
				}
			}
		}
		return $lookupValues;
	}
	
	protected static function getLookupResults($lookupSql, $selectedConnForLookup) {
		$ret = array();
		$conn = ET_ConnHelper::getConnection($selectedConnForLookup);
		
		if ($lookupSql == "" || $lookupSql == null){
			return 3;
		}
		
		$fromPos1 = strpos(strtolower($lookupSql), " from ");
		$fromPos2 = strpos(strtolower($lookupSql), " from(");
		$fromPos3 = strpos(strtolower($lookupSql), " from" . PHP_EOL);
		
		$fromArray = array();
		if ($fromPos1) array_push($fromArray , $fromPos1);
		if ($fromPos2) array_push($fromArray , $fromPos2);
		if ($fromPos3) array_push($fromArray , $fromPos3);
		
		if (!empty($fromArray)) {
			$asPos = strpos(strtolower($lookupSql), " as ");
			$fromPos = min($fromArray);
			if(($asPos !== False) && ($fromPos !== False)) {
				if ($asPos < $fromPos) {
					return 2;
				}
			}
		}
		
		if ($conn) {
			$result = $conn->Execute($lookupSql);
			if ($result === False) return 1;
			
			if (!empty($result)) {
				while (!$result->EOF) {
					array_push($ret, strval($result -> fields[0]));
					$result->MoveNext();
				}
			}
		}
		return $ret;
	}
	
	protected static function truncateLogMsg($msg) {
		
		$ret = $msg;
		
		if (strlen($msg) > ETX_MESSAGE_DETAIL_LOG_MSG_LENGTH) {
			
			$ret = substr($msg, 0, ETX_MESSAGE_DETAIL_LOG_MSG_LENGTH - 5);
			$msg .= "...";
		}
		
		return $ret; 
	}
	
}

?> 