<?php

/***
 * 
 * @author Zalan
 *Lookup and constraint validating
 */
class ET_Validator {
	
	public static function validateLookups($value, $colNameLowerCase, $lookupValues, $validationType = VALIDATION_TYPE_EXCEL) {
		
		$ret = true;
		if (isset($lookupValues[$colNameLowerCase])) {
			if ($value == '___null___') 
				return $ret;
			
			$lookupValuesForColumn = $lookupValues[$colNameLowerCase];
			if (!in_array($value, $lookupValuesForColumn, false)) {
				
				$ret = false;
				
				if ($validationType == VALIDATION_TYPE_EXCEL)
					ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_IMPORT_LOOKUP_VALUE_CHECK", array($value), PAGE_TYPE_GRID), "niota");
			}
		}
		return $ret;
	}
	
	public static function validateConstraints($value, $colNameLowerCase, $colMetaType, $regionInfoLowerCase, $validationType = VALIDATION_TYPE_EXCEL) {
		
		$success = true;
		$msg 	= "";
		$ret	= array();
		
		if ($value === '') return $success;
		if ($value === null) return $success;
		
		if (isset($regionInfoLowerCase[$colNameLowerCase])) {
			
			$tempArr 		= $regionInfoLowerCase[$colNameLowerCase];
			$c_op1 			= $tempArr["operand1"];
			$c_op2 			= $tempArr["operand2"];
			$c_type 		= $tempArr["column_type"];
			$c_operation 	= $tempArr["operation"];
			
			//[array (1, 2, 3, 4, 5, 6, 7, 8, 9, 10), array('equals (=)', 'not equals (&lt;&gt;)', 'greater than (&gt;)', 'less than (&lt;)', 'greater than or equal to (&ge;)', 'less than or equal to (&le;)', 'between', 'not between', 'like', 'not like')]
			
			//why are there so many returns? could it be breaks, then one return at the end of the swithc?
			switch ($c_operation) {
				//equals
				case 1:
					$success = self::isValidForEqual($value, $colMetaType, $c_type, $c_op1, true);
					if (!$success) {
						//addErrorLine(localize("value must be equal to") . " " . $c_op1 . ", " . localize("given value is") . " " . $value, "niota");
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_EQUAL", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//not equals
				case 2:
					$success = !self::isValidForEqual($value, $colMetaType, $c_type, $c_op1, false);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_NOT_EQUAL", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//greater
				case 3:
					$success = self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, false, true);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_GREATER_THAN", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//less
				case 4:
					$success = !self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, false, false);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_LESS_THAN", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//greater or equal
				case 5:
					$success = self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, true, true);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_GREATER_THAN_OR_EQUAL_TO", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//less or equal
				case 6:
					$success = !self::isValidForGreater($value, $colMetaType, $c_type, $c_op1, true, false);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_LESS_THAN_OR_EQUAL_TO", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//between
				case 7:
					$success = self::isValidForBetween($value, $colMetaType, $c_type, $c_op1, $c_op2, true);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_BETWEEEN", array($c_op1, $c_op2, $value), PAGE_TYPE_GRID);
					}
					break;
					//not between
				case 8:
					$success = !self::isValidForBetween($value, $colMetaType, $c_type, $c_op1, $c_op2, false);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_NOT_BETWEEEN", array($c_op1, $c_op2, $value), PAGE_TYPE_GRID);
					}
					break;
					//like
				case 9:
					$success = self::isValidForLike($value, $colMetaType, $c_type, $c_op1, true);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_CONTAIN", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//not like
				case 10:
					$success = !self::isValidForLike($value, $colMetaType, $c_type, $c_op1, false);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_NOT_CONTAIN", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//starts with
				case 11:
					$success = self::isValidForStartsWith($value, $colMetaType, $c_type, $c_op1, true);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_STARTS_WITH", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//not starts with
				case 12:
					$success = !self::isValidForStartsWith($value, $colMetaType, $c_type, $c_op1, false);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_NOT_STARTS_WITH", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//ends with
				case 13:
					$success = self::isValidForEndsWith($value, $colMetaType, $c_type, $c_op1, true);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_ENDS_WITH", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
					//not ends with
				case 14:
					$success = !self::isValidForEndsWith($value, $colMetaType, $c_type, $c_op1, false);
					if (!$success) {
						$msg = ET_DisplayHelper::localize("ERROR_IMPORT_CONSTRAINT_MUST_NOT_ENDS_WITH", array($c_op1, $value), PAGE_TYPE_GRID);
					}
					break;
			}
			if ($validationType == VALIDATION_TYPE_EXCEL) {
				ET_DisplayHelper::addErrorLine($msg, 'niota');
			}
		}
		$ret['success'] = $success;
		$ret['msg'] = $msg;
		
		if ($validationType == VALIDATION_TYPE_EXCEL)
			return $ret['success'];
		else
			return $ret;
	}
	
	protected static function isValidForEqual($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
		if ($colMetaType == 'I' || $colMetaType == 'R') {
			return intval($value) == intval($c_op1);
		}
		if ($colMetaType == 'N') {
			return floatval($value) == floatval($c_op1);
		}
		if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T') {
			return (string)$value == (string)$c_op1;
		}
		
		return $ifCannotValidate;
	}
	
	protected static function isValidForGreater($value, $colMetaType, $c_type, $c_op1, $andEquals, $ifCannotValidate) {
		if ($colMetaType == 'I' || $colMetaType == 'R') {
			if ($andEquals)
				return intval($value) >= intval($c_op1);
				else
					return intval($value) > intval($c_op1);
		}
		if ($colMetaType == 'N') {
			if ($andEquals)
				return floatval($value) >= floatval($c_op1);
				else
					return floatval($value) > floatval($c_op1);
		}
		if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T') {
			if ($andEquals)
				return (string)$value >= (string)$c_op1;
				else
					return (string)$value > (string)$c_op1;
		}
		
		return $ifCannotValidate;
	}
	
	protected static function isValidForBetween($value, $colMetaType, $c_type, $c_op1, $c_op2, $ifCannotValidate) {
		if ($colMetaType == 'I' || $colMetaType == 'R') {
			return intval($value) >= intval($c_op1) && intval($value) <= intval($c_op2);
		}
		if ($colMetaType == 'N') {
			return floatval($value) >= floatval($c_op1) && floatval($value) <= floatval($c_op2);
		}
		if ($colMetaType == 'C' || $colMetaType == 'D' || $colMetaType == 'T') {
			return (string)$value >= (string)$c_op1 && (string)$value <= (string)$c_op2;
		}
		
		return $ifCannotValidate;
	}
	
	protected static function isValidForLike($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
		if ($colMetaType == 'C') {
			return strpos($value, $c_op1) !== false;
		}
		
		return $ifCannotValidate;
	}
	
	protected static function isValidForStartsWith($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
		if ($colMetaType == 'C') {
			return ET_StringCheck::startsWith($value, $c_op1);
		}
		
		return $ifCannotValidate;
	}
	
	protected static function isValidForEndsWith($value, $colMetaType, $c_type, $c_op1, $ifCannotValidate) {
		if ($colMetaType == 'C') {
			return ET_StringCheck::endsWith($value, $c_op1);
		}
		
		return $ifCannotValidate;
	}
	
	protected static function startsWith($haystack, $needle) {
		$length = strlen($needle);
		return (substr($haystack, 0, $length) === $needle);
	}
	
	protected static function endsWith($haystack, $needle) {
		$length = strlen($needle);
		if ($length == 0) {
			return true;
		}
		return (substr($haystack, -$length) === $needle);
	}
}

?>
