<?php
class ET_WebServiceConnection{
	
	/*CREATE SAMPLE XML FILE WITH AND WITHOUT BASE64 ENCODEDED PW*/
	
	protected $XMLStr;
	/**  @var Array */
	protected $connection;
	/** @var SoapClient */
	protected $client;
	protected $response;
	
	public function __construct($connNameWS) {
		
		$this->connection	= ET_ConnHelper::getConnectionArrayFromConnectionName($connNameWS);
		$wsdlLocation		= isset($this->connection[PHPGRID_WSDL_LOCATION]) ? $this->connection[PHPGRID_WSDL_LOCATION] : null;
		
		if (!is_null($wsdlLocation)) {
			$this->client = new SoapClient($wsdlLocation, array('encoding'=>'UTF-8', 'soap_version' => SOAP_1_2, 'trace' => 1, 'exceptions' =>1));			
		} else {
			throw new ET_NiotaException("Web service connection error! Check file 'connections.php'");
		}
			
	}
	
	public function doRequest($XMLStr) {
		$this->XMLStr = $XMLStr;		 
		
		$ret =  $this->client->__doRequest($this->XMLStr, $this->connection[PHPGRID_WS_ENDPOINT], '', SOAP_1_2);
		
		return $ret;		
	}
	
	public static function getSoapResponseFromXML ($soapResponse, $xmlTagName) {
		
		$ret 		= false;
		
		$xml		= new DOMDocument();
		$xml->loadXML($soapResponse);		
		$children 	= $xml->getElementsByTagName($xmlTagName);
		 
		if ($children->length === 0) {
			if ($xmlTagName == CO_SOAP_RESP_FAILURE) {
				return null;
			}
			return ET_DisplayHelper::localize("SOAP_RESP_EMPTY", null, PAGE_TYPE_GRID);
		}
		
		$response 	= $xml->getElementsByTagName($xmlTagName)->item(0)->nodeValue;		
		$ret 		= self::getSoapResponseFromXMLByType($response, $xmlTagName);		
		return $ret;
		
	}
	
	protected static function getSoapResponseFromXMLByType ($response, $xmlTagName) {
		
		$ret = false;
		
		if (empty($response)) {
			$ret = ET_DisplayHelper::localize("SOAP_RESP_EMPTY", null, PAGE_TYPE_GRID);
		}
		else if ($xmlTagName == CO_SOAP_RESP_SUCCESS) {
			$ret = ET_DisplayHelper::localize("SOAP_RESP_SUCC", array($response), PAGE_TYPE_GRID);
		}
		else if ($xmlTagName == CO_SOAP_RESP_FAILURE) {
			$ret = ET_DisplayHelper::localize("SOAP_RESP_FAIL", array($response), PAGE_TYPE_GRID);
		}
		
		return $ret;
	}
	
}


?>