<?php
	
	class ET_CallableObjectHelperAdmin {
		
		/***
		 * Loads the callable objects for an admin menu option
		 * @param string $optionKey
		 * @return boolean|array (ordered array with key-value pairs on the indexes)
		 */
		public static function loadCallableObjects ($optionKey) {
			
			$niotaUser = ET_NiotaUser::getNiotaUserFromSession();
			
			$pathCallableBinding 	=  NIOTA_ROOT_DIR . "/" . PROPERTY_FOLDER_PATH_CALLABLES_BINDING_ADMIN .  "/" . PROPERTY_FILE_CALLABLES_BINDING;			
			$callableBinding 		= new ET_Properties($pathCallableBinding);
			
			if (!$callableBinding)
				return;
				
			$callableNamesForPage 	= $callableBinding->getValue($optionKey, PROPERTY_VALUE_TYPE_ARRAY);			
			
			if ($callableNamesForPage !== false) {
				
				$adminFeature = new ET_FeatureAdmin($optionKey);
				
				for ($i = 0; $i < count($callableNamesForPage); $i++) {
					
					$callableFile 		= $callableNamesForPage[$i]  . ".prop";
					$pathCallableFile	= NIOTA_ROOT_DIR . "/" . PROPERTY_FOLDER_PATH_CALLABLES. "/" . $callableFile;
					$callableProperties = new ET_Properties($pathCallableFile);
					$callableObject 	= array();
					
					if (!$callableProperties)
						continue;
						
					$callableObject['conn_name'] 		= $callableProperties->getValue('conn_name', PROPERTY_VALUE_TYPE_STRING);					
					$callableObject['command'] 			= $callableProperties->getValue('command', PROPERTY_VALUE_TYPE_STRING);					
					$callableObject['description'] 		= $callableProperties->getValue('description', PROPERTY_VALUE_TYPE_STRING);
					$callableObject['callobject_type'] 	= $callableProperties->getValue('callobject_type', PROPERTY_VALUE_TYPE_STRING);
					$callableObject['messaging_active'] = $callableProperties->getValue('ind_messaging', PROPERTY_VALUE_TYPE_BOOLEAN);
					$callableObject['reload_grid'] 		= $callableProperties->getValue('ind_reload_grid', PROPERTY_VALUE_TYPE_BOOLEAN);
					$callableObject['name'] 			= $callableProperties->getValue('callable_object', PROPERTY_VALUE_TYPE_STRING);
					$callableObject['binding_level']	= $callableProperties->getValue('binding_level', PROPERTY_VALUE_TYPE_NUMERIC);
					$callableObject['sequence']			= $callableProperties->getValue('ind_seq', PROPERTY_VALUE_TYPE_BOOLEAN);
					
					if (is_null($callableObject['conn_name']) || empty($callableObject['conn_name'])) {
						$callableObject['conn_name'] = ET_METADATA_CONNECTION;
					}
					
					if ($callableObject['binding_level'] === BINDING_LEVEL_TABLE) {
						
						$adminFeature->addTableLevelCallable($callableObject);
					}
					else if ($callableObject['binding_level'] === BINDING_LEVEL_LINE) {
						$adminFeature->addLineLevelCallable($callableObject);
					}
				}
				
				$niotaUser->setAdminFeature($optionKey, $adminFeature);
				$niotaUser->flushNiotaUser();
				
			}
		}
		
		
	}
	
	
	
	