<?php
	
			
	class ET_DataGridAdmin extends ET_DataGrid {
		
		protected $detailDataGridReferences = array();		
		protected $mergedColumns 			= array();
		//protected $mergedColumnsByUser		= array();
		protected $fixedValues				= array();
		protected $checkboxColumns			= array();
		protected $hiddenColumns			= array();
		protected $optionKey				= '';
		
		public function __construct($catalogInstanceId, $tmpArr, $optionKey = '') {
			
			$this->detailDataGridReferences 	= $tmpArr['detail_datagrid_references'];
			$this->checkboxColumns				= $tmpArr['checkboxes'];
			$this->mergedColumnsByUser 			= $tmpArr['merged_columns'];
			$this->hiddenColumns				= $tmpArr['hidden_columns'];
			$this->crud							= $tmpArr['admin_crud'];
			$this->optionKey					= $optionKey;
			$this->fixedValues					= $tmpArr['fixedValues'];
			$tmpArr['admin_datagrid'] 			= 1;
			
			$subgridNumber = "";
			if (isset($tmpArr['subgrid_number']) && !empty($tmpArr['subgrid_number'])) {
				$subgridNumber = $tmpArr['subgrid_number'];
			}
						
			ET_GeneralHelperAdmin::initializeBrowsingState($catalogInstanceId, $this->subgrid_logical_link);
			
			$useTableRepresentation = $this->getAdminPredefinedInfo($catalogInstanceId, ADMIN_CATALOG_INFO_TYPE_IS_TABLE);
			
			if(!$useTableRepresentation) {
				//$tmpArr['primary_keys'] = $this->fillVirtualPK($catalogInstanceId);
				$tmpArr['primary_keys'] = $this->getAdminPredefinedInfo($catalogInstanceId, ADMIN_CATALOG_INFO_TYPE_PK);
				$tmpArr['view']= true;
			}
			
			parent::__construct($catalogInstanceId, $tmpArr);
			
			$this->setQueryPartsIntoSession($tmpArr);
			
			$this->userSettingsCatalog	= ET_GeneralHelperAdmin::fillUserSettingsForAdminPages($this->catalogInstanceId, $this->subgrid_logical_link, $this->optionKey)['catalog_level'];
			$this->userSettingsColumn	= ET_GeneralHelperAdmin::fillUserSettingsForAdminPages($this->catalogInstanceId, $this->subgrid_logical_link, $this->optionKey)['column_level'];
			
			if ($this->subgrid_number == '')
				ET_LoggingHelper::setLogInfo(ET_MetaDataConnector::getInstance()->getLoggingSettings(), true);
			
			$this->applyUserSettingsForDataGrid();
			
		}
		
		protected function initializeDataGrid($presetFormonly = false) {
			parent::initializeDataGrid();
			
			$this->setCheckboxes($this->checkboxColumns);
			
			if (!empty($this->hiddenColumns))
				$this->setColHiddens($this->hiddenColumns['column_names'], $this->hiddenColumns['editable']);				
				
			if (!empty($this->fixedValues)) {
				$this->setFixedValues();
			}
			
			$this->setAdminCRUD();
		}
		
		protected function setCRUD() {			
		}
		
		protected function setAdminCRUD() {
			if ($this->crud == "")
				$this->crud = "CRUD";
				
			$this-> dg -> enable_edit("FORM", $this->crud);
		}

		protected function applyCustomFormatting_old() {
			
		}
		
		protected function applyCustomFormatting() {
		
			if (empty($this->subgrid_number)) {
				$formatFolderPathCustom 	= __DIR__ . "/../../admin/formatting/";
				$formatFolderPathGeneral 	= __DIR__ . "/../../admin/formatting/";
				$this->applyAdminFormatting($formatFolderPathCustom, $formatFolderPathGeneral);
			}
		}
	
		protected function applyAdminFormatting($formatFolderPathCustom, $formatFolderPathGeneral) {
			
			$optionKey = isset($_GET['ok']) ? $_GET['ok'] : "";
			$filePrefix = ET_CatalogInstance::getTableNameFromFullyQualifiedForm($this->fullTableName);
			
			if (defined('CUSTOM_FORMAT_FILE_GENERAL_ADMIN')) {		
				
				$this->applyCustomGeneralFormatting($formatFolderPathGeneral, CUSTOM_FORMAT_FILE_GENERAL_ADMIN, $this->detailDataGrids);
			}

			$this->applyCustomFormattingFilePrefix($formatFolderPathCustom,  $filePrefix, false, $optionKey);
		}
		
		
		protected function applyFormatByMergedInfos() {
			
			if (!empty($this->mergedColumns)) {				
			
				for ($i = 0; $i < count($this->mergedColumns); $i++) {
					
					$settings 	= $this->mergedColumns[$i];
					$col1 		= $settings['column1'];
					$col2 		= $settings['column2'];
					$colTarget 	= $settings['columnTarget'];
					$alias		= $settings['alias'];
					
					$hidden	= $colTarget == $col1 ? $col2 : $col1;
					
					$this->setColHiddens(array($hidden), false);
					$this->dg->set_col_title($colTarget, $alias);
				}				
			}
		}
		
		protected function formatReadOnlyElement($element) {
			$ret = parent::formatReadOnlyElement($element);
			$isCapital = ET_GeneralHelperAdmin::isMetadataColumnNameCapital();
			return $isCapital ? strtoupper($ret) : $ret;
		}
		
		protected function setDetailGrids() {
			for ($i = 0; $i < count($this->detailDataGrids); $i++) {
				$detailDataGrid = $this->detailDataGrids[$i];
				$references = $this->detailDataGridReferences[$i];
				
				$sdg = $detailDataGrid->getCLSDataGrid();
				$this->dg->set_multiselect(false);
				$this->dg->set_masterdetail($sdg, $references[1], $references[0], $detailDataGrid->getSubgridNumber(),
						$detailDataGrid->getSubgridLogicalLink(), $references[2], $references[3]);
			}
		}
		
		protected function setLookups() {
			
			$connName = ET_METADATA_CONNECTION;
			$connType = ET_ConnHelper::getConnectionTypeByName(ET_METADATA_CONNECTION, true);
			//echo "default width: " . PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH;
			
			if (!empty($this->lookups)) {
				
				foreach ($this->lookups as $columnName => $val) {
									
					$sqlForLookup 	= $val['lookup_sql'];
					
					$projectionList = $val['lookup_projection_list'];
					$addNullItem	= isset($val['ind_add_null']) ? $val['ind_add_null'] : false;
										
					$this->dg->set_col_edittype($columnName, "autocomplete", $sqlForLookup, false, null, $connName,
							$connType, $projectionList, $addNullItem);
					/*
					$this->dg->set_col_edittype(strtolower($columnName), "autocomplete", $sqlForLookup, false, null, $connName,
							$connType, $projectionList, $addNullItem);
					$this->dg->set_col_edittype(strtoupper($columnName), "autocomplete", $sqlForLookup, false, null, $connName,
							$connType, $projectionList, $addNullItem);
					*/
					if (defined('PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH')) {						
						$this->dg->set_col_property(strtoupper($columnName), array("editoptions"=>array("style"=>"width:" . PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH . "px")));
						$this->dg->set_col_property(strtolower($columnName), array("editoptions"=>array("style"=>"width:" . PHPGRID_LOOKUP_COMBO_DEFAULT_WIDTH . "px")));
					}
		
					$this->dg->set_col_format($columnName, "select");
				}
			}
		}
				
		protected function getTheme () {
			if (defined('COLOR_THEME_ADMIN') && ET_DisplayHelper::validateGridThemeDef(COLOR_THEME_ADMIN)) {				
				return $this->getGridColorTheme(COLOR_THEME_ADMIN, PAGE_TYPE_SYSTEM);
			} else {				
				ET_DisplayHelper::addErrorLine("COLOR_THEME_NOT_DEFINED", "admin_footer.php");
				return "vega";
			}
			
		}
		
		public function displayGrid() {
			
			$this->printJavascript();
			
			try {				
				$this->dg->display();				
			} catch (Throwable $t) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_GRID_LOAD"), "admin");
			}				
		}
		
		/***
		 * 
		 * @param array() $columnNames - columns set to checkbox. Has to be an array()
		 */
		protected function setCheckboxes ($columnNames) {				
			if (!empty($columnNames)) {
				for ($i = 0; $i < count($columnNames); $i++) {
					$columnName = ET_GeneralHelperAdmin::isMetadataColumnNameCapital() ? strtoupper($columnNames[$i]) : $columnNames[$i];
					$this->dg -> set_col_edittype($columnName, "checkbox","1:0");
				}
			}
		}
		
		public function setColPassword ($columnNames) {
			
			for ($i = 0; $i < count($columnNames); $i++) {
				$columnName = ET_GeneralHelperAdmin::isMetadataColumnNameCapital() ? strtoupper($columnNames[$i]) : $columnNames[$i];
				$this->dg -> set_col_edittype($columnName, "password");
			}
		}
		
		/***
		 * 
		 * @param array() $columnNames
		 * @param boolean $editable
		 */
		protected function setColHiddens ($columnNames, $editable) {			
			
			if (!empty($columnNames)) {
				for ($i = 0; $i < count($columnNames); $i++) {
					$columnName = ET_GeneralHelperAdmin::isMetadataColumnNameCapital() ? strtoupper($columnNames[$i]) : $columnNames[$i];
					
					$this->dg ->set_col_hidden($columnName, $editable);
				}
			}
		}
		
		protected function correctColumnNameForReadonlyList($colName) {
			return ET_GeneralHelperAdmin::isMetadataColumnNameCapital() ? strtoupper($colName) : $colName;
		}
		
		protected function setFixedValues() {
			
			$browsingStore = ET_BrowsingStore::getBrowsingStore();
			$browsingStore->set_fixedValues($this->catalogInstanceId, $this->subgrid_logical_link, $this->fixedValues);
			$browsingStore->flushBrowsingStore();
		}
		
		/***
		 *
		 * @param string $catalogInstanceId
		 * @param string $infoType - ADMIN_CATALOG_INFO_TYPE_IS_TABLE, ADMIN_CATALOG_INFO_TPYE_PK
		 *
		 */
		protected function getAdminPredefinedInfo($catalogInstanceId, $infoType) {
			
			$ret 		= null;
			$tableName 	= ET_CatalogInstance::getTableNameFromFullyQualifiedForm($catalogInstanceId);
			
			if ($infoType == ADMIN_CATALOG_INFO_TYPE_PK) {
				$ret =  array();
			} else if ($infoType == ADMIN_CATALOG_INFO_TYPE_IS_TABLE) {
				$ret = true;
			}
			
			
			foreach (SYSTEM_TABLES as $key => $value) {
				
				if (in_array($tableName, $value)) {
					switch ($infoType) {
						case ADMIN_CATALOG_INFO_TYPE_IS_TABLE:
							$ret = $this->getIsTable($value, $tableName);
							break;
						case ADMIN_CATALOG_INFO_TYPE_PK:
							$ret = $value[2];
					}
					return $ret;
				}
				else {
					continue;
				}
			}
			
			foreach (SYSTEM_VIEWS as $key => $value) {
				
				if (in_array($tableName, $value)) {
					switch ($infoType) {
						case ADMIN_CATALOG_INFO_TYPE_IS_TABLE:
							$ret = false;
							break;
						case ADMIN_CATALOG_INFO_TYPE_PK:
							$ret = $value[1];
					}
				} else {
					continue;
				}
			}
			return $ret;
		}
		
		protected function 	getIsTable($systemTablePredefData, $talbeName) {
			
			if ($talbeName == $systemTablePredefData[0] || !in_array($talbeName, $systemTablePredefData))
				return true;
				else if ($talbeName == $systemTablePredefData[1])
					return false;
					
		}
		
		protected function setQueryPartsIntoSession($params) {
			
			
			$br 			= ET_BrowsingStore::getBrowsingStore();
			$sqlObj			= new ET_GridSql();
			//$gridIdentifier = $br->generateGridIdentifier($this->catalogInstanceId, $this->subgrid_logical_link);
			
			$fullTableName 	= $params['full_table_name'];
			$projection 	= !empty($params['projection_list']) ? $params['projection_list'] : "";
			$objFilter 		= !empty($params['filter']) ? $params['filter'] : "";
			$objectOrderBy	= !empty($params['order_by']) ? $params['order_by'] : "";
			
			$sqlObj->setFullTableName($fullTableName);
			$sqlObj->setCatalogInstanceId($this->catalogInstanceId);
			$sqlObj->setEtDataGridSql($this->SQLForGrid);
			
			$sqlObj->setProjectionList($projection);
			$sqlObj->setwhereObjectFilter($objFilter);
			$sqlObj->setObjectOrder($objectOrderBy);
			
			//master gird id is set into $br for sure
			//if the favourite grid has got detail grids those have to be initialized in the $br
			
			if (!empty($this->subgridNumber) && !isset($br->getBrowsingStates()[$this->catalogInstanceId])) {
				//$br->create_browsingState($this->catalogInstanceId);
				//$br->create_browsingState($gridIdentifier);
				$br->create_browsingState($this->catalogInstanceId);
				$br->flushBrowsingStore();
				$br = ET_BrowsingStore::getBrowsingStore();
			}
			$br->set_gridSqlObject($this->catalogInstanceId, $sqlObj);
			//$br->set_gridSqlObject($gridIdentifier, $sqlObj);
			$br->flushBrowsingStore();
			
		}
		
	}