<?php
	class ET_DisplayHelperAdmin {
		
		/***
		 * Prints menu bar contais admin menu items. Also returns the URL of the current page. 
		 * @param unknown $fileName
		 * @param unknown $optionKey
		 * @param unknown $catalogInstanceId
		 * @throws Exception
		 * @return string - URL of the current page
		 */
		public static function printAdminMenuItems($fileName, $optionKey, $catalogInstanceId) {
			
			$options 			= null; 
			$optionKeyGET		= isset($_GET['ok']) ? $_GET['ok'] : "";
			$groupGET			= isset($_GET['group']) ? $_GET['group'] : "";
			$superuser			= $_SESSION['username'] == "superuser" ? true : false;
			
			$highlightItem		= "";
			$linkCurrentPage	= "";
			
			if (defined("ADMIN_OPTIONS"))
				$options = ADMIN_OPTIONS;
			else {
				throw new Exception("Error! ADMIN_OPTIONS constant not defined in 'etixpert/admin/admin_options.php'");
			}
			
			
			
			for ($i = 0; $i < count ($options); $i++) {
			
				$menuGroupContainer = new HTMLDiv();				
				$group 				= $options[$i];
				$mainIcon 			= new HTMLImage();
				$groupName			= $group["group"];
				$mainImg			= $groupName . ".png";
				$mainTooltip		= ET_DisplayHelper::localize(strtoupper("tooltip_" . $groupName));
				
				
				$menuGroupContainer->set_class("height-7vh vertical-middle-content menu-group-container")->set_style("display: none")->set_id($groupName)->set_name("admin_option_group_container");
				$mainIcon->set_src("../images/admin_pages/$mainImg")->set_height("30px")->set_title($mainTooltip)->set_onclick('toggleAdminMenuGroup("' . $groupName. '");')->set_class("margin-left-20px pointer");
				
				
				for($k = 0; $k < count($group["actions"]); $k++) {
					$action		= $group["actions"][$k];
					$actionName = $action["action"];
					
					//if ($actionName == $optionKeyGET || $reversePageSource == $actionName) {
					if ($actionName == $optionKeyGET || $groupGET == $actionName) {
						$menuGroupContainer->reset_style("display: none");
						$highlightItem = $actionName;
						continue;
					}										
				}
				
				
				
				$mainIcon->printOpeningTag();
				$menuGroupContainer->printOpeningTag();
					
				for($j = 0; $j < count($group["actions"]); $j++) {
					
					$icon 				= new HTMLImage();
					$aMenuItem			= new HTMLa();
					$spanItemtext		= new HTMLSpan();
					
					$action				= $group["actions"][$j];						
					$file				= $action["page"];
					$actionName 		= $action["action"];
					$superuserOnly		= $action["superuser_only"];
					
					if (!$superuser && $superuserOnly)
						continue;
					
					$image			= $actionName. ".png";
					$displayText 	= ET_DisplayHelper::localize(strtoupper("display_text_" . $actionName));
					$target			= isset($action['target']) ? $action['target'] : "";
					$link			= !empty($target) ? $file . "?target=" . $target . "&ok=" . $actionName :  $file . "?ok=" . $actionName;					
					
					//$aMenuItem->set_href($link)->set_class("vertical-middle-content")->set_onclick("save_admin_menu_state(\"$link\")");
					$aMenuItem->set_href($link)->set_class("vertical-middle-content");
					//$icon->set_src("../images/admin_pages/$image")->set_title($tooltip)->set_class("margin-left-10px");
					$icon->set_src("../images/admin_pages/$image")->set_class("margin-left-10px");
					$spanItemtext->set_display_text($displayText)->set_class("margin-left-5px");						
					
					if ($optionKeyGET == $actionName || $actionName == $highlightItem) {
						$icon->set_style("border: 1px solid black; background-color: rgb(180,180,180)");
						$spanItemtext->set_style("text-decoration: underline;");
						$linkCurrentPage = $link;
					}
					
					$aMenuItem->printOpeningTag();
						$icon->printOpeningTag();
						
						$spanItemtext->printOpeningTag();
							$spanItemtext->printDisplayText();
						$spanItemtext->printClosingTag();							
					//	self::displayReverseIcon ($file, $optionKey, $catalogInstanceId);
					$aMenuItem->printClosingTag();
					
				}				
				$menuGroupContainer->printClosingTag();				
			}
			return $linkCurrentPage;
		}	
		
		public static function setAdminOptionsSidebar ($optionKey, $displayCallables) {
			
			$ret = array();
			
			$groupGET			= isset($_GET['group']) ? $_GET['group'] : "";
			
			if (defined("ADMIN_OPTIONS_SIDEBAR"))
				$options = ADMIN_OPTIONS_SIDEBAR;
				else {
					throw new Exception("Error! ADMIN_OPTIONS_SIDEBAR constant not defined in 'etixpert/admin/admin_options.php'");
				}
				
				for ($i = 0; $i < count ($options); $i++) {
					$group 				= $options[$i];
					
					$groupName			= $group["group"];
					if ($groupName == $optionKey || $groupName == $groupGET) {
						
						$j = 0;
						
						$actions 				= $group["actions"];
						
						for ($k = 0; $k < count ($actions); $k++) {
							
							$actionitem				= $actions[$k];
							$actionitemoptionkey 	= $actionitem["action"];
							
							$ret[$j]["groupName"] 	   = $groupName;
							$ret[$j]["targetPage"] 	   = $actionitem["page"];
							$ret[$j]["optionKey"] 	   = $actionitemoptionkey;
							$ret[$j]["title"] 		   = ET_DisplayHelper::localize(strtoupper("tooltip_" . $actionitemoptionkey));;
							$ret[$j]["icon"] 		   = $actionitemoptionkey . ".png";
							$ret[$j]["superuser_only"] = $actionitem["superuser_only"];
							
							$j=$j+1;
						}
					}
				}
				
				if ($displayCallables) {
					$ret["callableObjects"] = true;
				}
				
				return $ret;
		}
		
		public static function displayAdminOptionsSidebar ($sidebarContent, $optionKey, $catalogInstanceId) {
			
			$superuser		= $_SESSION['username'] == "superuser" ? true : false;
			
			$niotaUser 		= ET_NiotaUser::getNiotaUserFromSession();
			$userSettings 	= $niotaUser->get_userSettings();
			
			
			if (isset($sidebarContent['callableObjects'])) {
				
				ET_DisplayHelper::printCallableObjecstMenuItem($userSettings);
				
			}	
		
			if (isset($sidebarContent[0])) {
				
				for ($i = 0; $i < count($sidebarContent); $i++) {
					
					if (isset($sidebarContent[$i])) {
						
						$settings = $sidebarContent[$i];
						
						$superuserOnly		= $settings["superuser_only"];
						
						if (!$superuser && $superuserOnly)
							continue;
							
							
							$icon 		= new HTMLImage();
							$aReverse	= new HTMLa();
							$optionKeySetting = isset( $settings['optionKey']) ? $settings['optionKey'] : $optionKey;
							$optionGroup = isset( $settings['groupName']) ? "&group=".$settings['groupName'] : ' ';
							
							$link 		= $settings['targetPage'] . "?ok=" . $optionKeySetting . $optionGroup ;
							
							$icon->set_src("../images/admin_pages/" . $settings['icon'])->set_title($settings['title'])->set_class("margin-top-10px element-inline margin-left-10px");
							//$aReverse->set_href($settings['targetPage'] . "?ok=" . $optionKey)->set_onclick('save_reversable_direction("' . $optionKey . '", "' .  $catalogInstanceId . '")');
							
							$aReverse->set_href($link)->set_onclick("save_admin_menu_state(\"$link\")");
							
							$aReverse->printOpeningTag();
							$icon->printOpeningTag();
							$aReverse->printClosingTag();
					}
				}
			}
			
			
		}
			
		public static function setSidebarMenuItems ($fileName, $displayCallables) {
			
			$ret = array();
			
			for ($i = 0; $i < count(REVERSE_PAGE_PAIRS); $i++) {
				
				$element = REVERSE_PAGE_PAIRS[$i];
				
				if (key_exists(trim(strtolower($fileName . '.php')), $element)) {
					
					$keyLowerTrimmed 	= trim(strtolower($fileName . '.php'));
					
					$ret["reverseDirection"]["targetPage"] 	= $element[$keyLowerTrimmed]["target_page"];
					$ret["reverseDirection"]["optionKey"] 	= $element[$keyLowerTrimmed]["option_key"];
					$ret["reverseDirection"]["title"] 		= ET_DisplayHelper::localize($element[$keyLowerTrimmed]["title"]);
					$ret["reverseDirection"]["icon"] 		= $element[$keyLowerTrimmed]["icon"];				
				}			
			}
			
			if ($displayCallables) {
				$ret["callableObjects"] = true;
			}
			
			return $ret;
		}
		
		public static function displaySidebarItems ($sidebarContent, $optionKey, $catalogInstanceId) {
			
			$niotaUser 		= ET_NiotaUser::getNiotaUserFromSession();
			$userSettings 	= $niotaUser->get_userSettings();
			
			if (isset($sidebarContent['reverseDirection'])) {
				
				$settings = $sidebarContent['reverseDirection'];
				
				$icon 		= new HTMLImage();
				$aReverse	= new HTMLa();
				$optionKeySetting = isset( $settings['optionKey']) ? $settings['optionKey'] : $optionKey;
				$link 		= $settings['targetPage'] . "?ok=" . $optionKeySetting;
				
				$icon->set_src("../images/admin_pages/" . $settings['icon'])->set_title($settings['title'])->set_class("margin-top-10px element-inline margin-left-10px");
				//$aReverse->set_href($settings['targetPage'] . "?ok=" . $optionKey)->set_onclick('save_reversable_direction("' . $optionKey . '", "' .  $catalogInstanceId . '")');
				
				$aReverse->set_href($link)->set_onclick("save_admin_menu_state(\"$link\")");
				
				$aReverse->printOpeningTag();
				$icon->printOpeningTag();
				$aReverse->printClosingTag();
			}
			if (isset($sidebarContent['callableObjects'])) {
				
				ET_DisplayHelper::printCallableObjecstMenuItem($userSettings);
				
			}
		}
		
		protected static function getReversePageSource($actionName) {
			
			$targetPair = self::getPagePair($actionName);
			
			if (!empty($targetPair)) {
				
				foreach ($targetPair as $val) {
					if ($val['option_key'] != $actionName) {
						return $val['option_key'];
					}
						
				}
			} else {
				return false;
			}
			
		}
		
		protected static function getPagePair($actionName) {
			
			$ret = [];
			for ($i = 0; $i < count(REVERSE_PAGE_PAIRS); $i++) {
				
				$actualPair = REVERSE_PAGE_PAIRS[$i];				
				foreach ($actualPair as $value) {
					
					if ($value['option_key'] == $actionName) {
						$ret = $actualPair;
						break;
					}
					
				}
			}
			return $ret;
		}
		
	}
	
	
	
	
	
	
	
	