<?php
class ET_FeatureAdmin {
	
	protected $optionKey = "";
	protected $tableLevelCallables 	= array();
	protected $lineLevelCallables 	= array();
	
	
	
	public function __construct($optionKey) {
		$this->optionKey = $optionKey;
	}
			
	public function addTableLevelCallable($callableObject) {
		$this->tableLevelCallables[] = $callableObject;
	}
	
	public function addLineLevelCallable($callableObject) {
		$this->lineLevelCallables[] = $callableObject;
	}
	
	public function getTableLevelCallableProps() {
		$ret = array();
		for ($i = 0; $i < count($this->tableLevelCallables); $i++) {
			$tableLevelCallable = $this->tableLevelCallables[$i];
			$tmpArr = [];
			$tmpArr['name'] 	= $tableLevelCallable['name'];
			$tmpArr['description'] 		= $tableLevelCallable['description'];
			$ret[] = $tmpArr;
		}
		return $ret;
	}
	
	public function getLineLevelCallableProps() {
		$ret = array();
		for ($i = 0; $i < count($this->lineLevelCallables); $i++) {
			$tableLevelCallable = $this->lineLevelCallables[$i];
			$tmpArr = [];
			$tmpArr['name'] 	= $tableLevelCallable['name'];
			$tmpArr['description'] 		= $tableLevelCallable['description'];
			$ret[] = $tmpArr;
		}
		return $ret;
	}
	
	public function getCallableObject($callableObjectName) {
		for ($i = 0; $i < count($this->tableLevelCallables); $i++) {
			$tableLevelCallable = $this->tableLevelCallables[$i];
			if ($tableLevelCallable['name'] == $callableObjectName)
				return $tableLevelCallable;
		}
		for ($j = 0; $j < count($this->lineLevelCallables); $j++) {
			$lineLevelCallable = $this->lineLevelCallables[$j];
			if ($lineLevelCallable['name'] == $callableObjectName)
				return $lineLevelCallable;
		}
		return null;
	}
	
}