<?php
	class ET_GeneralHelperAdmin {
		
		public static function initializeBrowsingState($catalogInstanceId, $logicalLink) {
			$browsingStore = ET_BrowsingStore::getBrowsingStore();
			$browsingStore->create_browsingState($catalogInstanceId);
			$browsingStore->set_connName($catalogInstanceId, ET_METADATA_CONNECTION);
			$browsingStore->flushBrowsingStore();
		}
		
		private static function prepareLookups($lookups, &$lookupsToPass) {
			
			$optionKey 	= isset($_GET["ok"]) ? $_GET["ok"] : "";
			$page 		= self::getPageNameByOptionKey($optionKey);
			
			for ($i = 0; $i < count($lookups); $i++) {
				$lookupSetting 	= $lookups[$i];
				
				$check = self::checkLookupKeys($lookupSetting);
				
				if ($check) {
					$lookupName		= $lookupSetting["lookup_name"];
					$colTargetLkp 	= $lookupSetting["target_column"];
					$addNull		= isset($lookupSetting[PROPERTY_VALUE_LOOKUP_ADD_NULL]) ? $lookupSetting[PROPERTY_VALUE_LOOKUP_ADD_NULL] : false;
					
					$tmp = self::setLookup($lookupName, $colTargetLkp, $addNull, $lookupsToPass);
					
					if ($tmp === false) {
						ET_DisplayHelper::addErrorLine("Lookup setting: $lookupName not found!", $page);
					}
				} else {
					ET_DisplayHelper::addErrorLine("Lookup configuration error", $page);
				}
			}
		}
		
		/***
		 * @param string $lookupName - coniguration name
		 * @param string $colTargetLookup - column which owns the dropdown list 
		 * @param array $colTargetData - if it is a merged lookup the parts of the merged value
		 * @return boolean|array()
		 */
		public static function setLookup($lookupName, $colTargetLkp, $addNull, &$lookupsToPass) {
			
			
			$adminProperties 	= ET_PropertiesAdmin::getInstance();
			$lookupSettings 	= $adminProperties->getLookups();
			
			if (!isset($lookupSettings[$lookupName])) {
				return false;
			}
			
			$lookupToUse 			= $lookupSettings[$lookupName];
			$systemTable 			= $lookupToUse->getSystemtable();
			$systemTableCode		= constant($systemTable);
			
			$projectionList 		= $lookupToUse->getProjectionList();						
			$indUsetable			= $lookupToUse->getIndUseTable() === "true" ? true : false;			
			$objectFilter 			= $lookupToUse->getObjectFiler();
			//$systemLookupCategory = $lookupToUse->getSystemLookupCategory();
			$whereCondition			= "";
			$orderBySetting			= $lookupToUse->getOrderBy();
			$orderByClause			= "";
			
			$fullTableName 	= ET_SysTableHandler::getSpecificTableOrViewFullName($systemTableCode, ET_METADATA_CONNECTION, $indUsetable);
			$optionKey 		= isset($_GET["ok"]) ? $_GET["ok"] : "";
			
			$columnName 	= self::isMetadataColumnNameCapital() ? strtoupper($colTargetLkp) : $colTargetLkp;
			//$whereCondition = $systemLookupCategory != "" ? " WHERE lookup_name = '" . constant($systemLookupCategory) . "'" : "";
		
			if ($optionKey == "usergroup_assignment" && (strpos(strtolower($fullTableName), "et_user_group") !== false)) {				
				$whereCondition = "where usergroup_type = 2";
			}
			
			if (!empty($whereCondition) && !empty($objectFilter)) {
				$whereCondition .= " AND " . $objectFilter;
			} elseif (!empty($objectFilter)) {
				$whereCondition .= " WHERE " . $objectFilter;
			}
			
			if (!empty($orderBySetting))
				$orderByClause = "order by $orderBySetting";
				
			$details['lookup_sql'] 				= "select $projectionList from $fullTableName $whereCondition $orderByClause";				
			$details['lookup_projection_list'] 	= $projectionList;
			//$details['ind_add_null'] 			= $lookupToUse->getAddNullValue();
			$details['ind_add_null'] 			= $addNull;
			$details['column_target_lkp']		= $colTargetLkp;
			
			$lookupsToPass[$columnName] = $details;
			
		}
		
		public static function generateDefaultParams($fullTableName, $lookups = array(), $readOnlyList = '', $checkboxColumns = array(),
				$mergedColumns = array(), $hiddenColumns = array(), $CRUD = '', $subgridNumber = '', $logicalLink = '', $projectionList = '*', $filter = '', $objectJoin = '',
				$fixedValues = array(), $orderBy = "") {
			
			$conn 				= ET_ConnHelper::getConnection(ET_METADATA_CONNECTION);
			$connType 			= ET_ConnHelper::getConnectionTypeByName(ET_METADATA_CONNECTION, true);
			$columnInfo 		= ET_MetaDataConnector::getInstance()->getColumnInfo($conn, ET_METADATA_CONNECTION, $connType, $fullTableName);
			$lookupsToPass 		= array();
			$mergedColumns 		= array();
			$sqlForDatagrid 	= "";
			$projectionListResolved = "";			
			$thereIsMergedCol 	= false;
			
			$adminPagesProperties = ET_PropertiesAdmin::getInstance();
			$virtualColumnDefinitions = $adminPagesProperties->getOnTheFlyColumns();
			
			if (!empty($lookups))
				self::prepareLookups($lookups, $lookupsToPass);
		
			$projectionListResolved = \ET_PropertiesAdmin::getInstance()->resolveGeneratedColumns($projectionList);
			
			//put $gcol.{...} type into columnInfo manually:
			$tmpColInfo = self::checkAndResetResolvedOnTheFlyCols();
			if (!empty($tmpColInfo)) {
				foreach ($tmpColInfo as $key => $value) {
					$columnInfo[$key] = $value;
				}
			}
			
			//echo $projectionListResolved;
			$sqlForDatagrid 		= "select $projectionListResolved from " . $fullTableName . (!empty($filter) ? " where " . $filter : "");
			
			$params = array();
			
			$params['primary_keys'] 			= ET_MetaDataConnector::getInstance()->getPrimaryKeys($conn, $connType, $fullTableName);
			$params['column_info'] 				= $columnInfo;
			
			$params['filter_key_pairs'] 		= array();
			$params['sql_for_datagrid'] 		= $sqlForDatagrid;
			$params['full_table_name'] 			= $fullTableName;			
			$params['lookups'] 					= $lookupsToPass;
			$params['constraints'] 				= array();
			$params['user_rights'] 				= array();
			$params['super_user'] 				= 0;
			$params['conn_name'] 				= ET_METADATA_CONNECTION;
			$params['readonly_list']			= null;
			$params['filter_dialog'] 			= FALSE;
			$params['filter_mappings'] 			= array();
			$params['selection_table']			= FALSE;
			$params['filtered_instance_id'] 	= "";
			$params['format_file_prefix'] 		= "";
			$params['subgrid_number']			= "";
			$params['subgrid_logical_link']		= "";
			$params['detail_grid_infos']		= array();
			$params['detail_datagrids'] 		= array();
			$params['detail_datagrid_references'] = array();
			$params['object_join']				= null;
			$params['view']						= FALSE;
			$params['user_settings_for_catalog']['catalog_level'] =	array();
			$params['user_settings_for_catalog']['column_level']  =	array();
			
			$params['readonly_list']  			= $readOnlyList;
			$params['checkboxes']				= $checkboxColumns;
			$params['merged_columns']			= $mergedColumns;
			$params['hidden_columns'] 			= $hiddenColumns;
			$params['admin_crud']				= $CRUD;
			$params['subgrid_number'] 			= $subgridNumber;
			$params['subgrid_logical_link'] 	= $logicalLink;
			
			if (!empty($objectJoin)) {
				$params['object_join']			= $objectJoin;
			}
			
			$params['fixedValues']				= $fixedValues;
			$params['projection_list']			= $projectionListResolved;
			$params['filter']					= $filter;
			$params['order_by']					= $orderBy;
			
			return $params;
		}
		
		public static function replacePassword($sqlCrud) {
			
			$tableName 		= ET_SysTableHandler::getSpecificTableOrViewFullName(T_USER, ET_METADATA_CONNECTION, true);
			$colPassword 	= COLUMN_NAME_PASSWORD;
			
			//$i = strpos($sqlCrud, $tableName) || strpos($sqlCrud, $tableName);
			$i = strpos(strtolower($sqlCrud), strtolower($tableName));
			
			if ($i) {
				//update sql crud
				//$j = strpos($sqlCrud, "PASSWD='");
				
				$j 	= strpos(strtolower($sqlCrud), strtolower($colPassword) . "='");
				//$jj = strpos(strtolower($sqlCrud), strtolower($colPassword)) && strpos(strtolower($sqlCrud), "insert into ") ? true : false;
				
				if ($j) {					
					$startpwd = $j + strlen(COLUMN_NAME_PASSWORD) + 2;
					$endpwd = strpos($sqlCrud, "'", $startpwd);
					$pwd = substr($sqlCrud, $startpwd, $endpwd - $startpwd);
					$sqlCrud = substr($sqlCrud, 0, $startpwd) . password_hash($pwd, PASSWORD_BCRYPT) . substr($sqlCrud, $endpwd);					
				} else {
					//insert into sql crud
					$l = strpos($sqlCrud, "INTO");
					if ($l) {
						
						if (strpos(strtolower($sqlCrud), strtolower(COLUMN_NAME_PASSWORD))) {
							
							$sqlCrudLower 		= strtolower($sqlCrud);
							$colPasswordLower 	= strtolower(COLUMN_NAME_PASSWORD);							
							$colPasswordPos 	= strpos($sqlCrudLower, $colPasswordLower);							
							$colPasswordPlace	= substr_count($sqlCrudLower, ",", 0, $colPasswordPos) + 1;
							
							$valuesPos	= strpos($sqlCrudLower, "values");
							$firstComma = strpos($sqlCrudLower, ",", $valuesPos);							
							
							for ($k = 0; $k < $colPasswordPlace - 1; $k++) {								
								$posSingleQuote = strpos($sqlCrudLower, ",", $firstComma);								
								$firstComma = $posSingleQuote + 1;
							}
							
							$colPasswordValueStart 	= $posSingleQuote + 3; // 3 stands for: comma, space, singel quote
							$colPasswordValueEnd	= strpos($sqlCrudLower, "'", $colPasswordValueStart);						
							$passwordStr			= substr($sqlCrud, $colPasswordValueStart, (($colPasswordValueEnd) - $colPasswordValueStart));
							
							$passwordStrHashed		= password_hash($passwordStr, PASSWORD_BCRYPT);
						
							$sqlCrud = substr($sqlCrud, 0, $colPasswordValueStart) . $passwordStrHashed . substr($sqlCrud, $colPasswordValueEnd);
							
						}						
					}
				}
			}
			return $sqlCrud;
		}
		
		public static function createDetailGridAndFillMasterParams(&$masterParams, $detailParams, 
				$detailFullTableName, $referencingColMaster, $referencingColDetail, $optionKey) {
			$detailReference 			= array();
			$operations					= array();
					
			
			
			for ($i = 0; $i < count($referencingColMaster); $i++) {
				if (self::isMetadataColumnNameCapital()) {
					$referencingColMaster[$i] = strtoupper($referencingColMaster[$i]);
					$referencingColDetail[$i] = strtoupper($referencingColDetail[$i]);
				}
				array_push($operations, "1");
			}
			
			$datagridDetail = new ET_DataGridAdmin($detailFullTableName, $detailParams, $optionKey);
			
			array_push($detailReference, $referencingColMaster);	// master / detail referencing col.
			array_push($detailReference, $referencingColDetail);	// master / detail referencing col.
			array_push($detailReference, $operations);				// operation (1 = equals)
			array_push($detailReference, '');
						
			array_push($masterParams['detail_datagrids'], $datagridDetail);
			array_push($masterParams['detail_datagrid_references'], $detailReference);
						
		}
		
		public static function isMetadataColumnNameCapital() {
			
			return ET_ConnHelper::getConnectionTypeByName(ET_METADATA_CONNECTION, true) == DB_TYPE_OCI805;			
		}
		
		public static function createUserSettingArray($userName, $paramName, $paramValue, $paramFilter1 = null, $paramFilter2 = null, $paramFilter3 = null, 
									$paramFilter4 = null,  $paramFilter5 = null) {
			$userSetting = array();
			
			$userSetting['userName'] = $userName;		
			$userSetting['paramName'] = $paramName;		
			$userSetting['paramValue'] = $paramValue;
			$userSetting['paramFilter1'] = $paramFilter1;
			$userSetting['paramFilter2'] = $paramFilter2;
			$userSetting['paramFilter3'] = $paramFilter3;
			$userSetting['paramFilter4'] = $paramFilter4;
			$userSetting['paramFilter5'] = $paramFilter5;
			
			return $userSetting;
		}	
		
		public static function splitMergedValuesForMDFilter ($filterKeys, $filterValues, $mergeInfo) {
			
			for ($i = 0; $i < count($filterKeys); $i++) {
				
				$filterKey 		= strtolower($filterKeys[$i]);
				$filterValue 	= $filterValues[$i]; 
				
				for ($j = 0; $j < count($mergeInfo); $j++) {
					$settings 		= $mergeInfo[$j];
					$columnTarget 	= strtolower($settings['columnTarget']);
					$delimiter 		= $settings['delimiter'];
					
					if ($columnTarget == $filterKey) {		
						
						if ($filterKey == strtolower($settings['column1'])) {							
							$filterValue = substr($filterValue, 0, strpos($filterValue, $delimiter));							
						}
						else if ($filterKey == strtolower($settings['column2'])) {							
							$filterValue = substr($filterValue, strpos($filterValue, $delimiter) + 1);
						}
						$filterValues[$i] = $filterValue;
					}
				}				
			}
			return $filterValues; 
		}
		
		public static function fillUserSettingsForAdminPages ($catalogInstanceId, $logicaLink, $optionKey) {
			
			$ret 		= array();
			$userName 	= ET_NiotaUser::getNiotaUserFromSession()->get_username();
		
			$ret['catalog_level'] 	= self::getUserSettingsForAdminPages($userName, USER_PARAM_LEVEL_CATALOG, $catalogInstanceId, $logicaLink, $optionKey);
			$ret['column_level'] 	= self::getUserSettingsForAdminPages($userName, USER_PARAM_LEVEL_COLUMN, $catalogInstanceId, $logicaLink, $optionKey);			
			$ret['user_level']		= self::getUserSettingsForAdminPages($userName, USER_PARAM_LEVEL_USER);
			
			return $ret;
		}
		
		public static function isObjectTable($tableKey) {
			
			if (key_exists($tableKey, SYSTEM_TABLES)) {
				if (SYSTEM_TABLES[$tableKey][0] == "")
					return false;
					else
						return true;
			} else if (key_exists($tableKey, SYSTEM_VIEWS)) {
				return false;
			} else {
				return true;
			}
			
			
		}
		
		public static function clearBuggyAdminPageSetting($currentPage) {
			
			if (isset($_SESSION['username'])) {
				
				$adminPageDefault 	= ET_NiotaUser::getNiotaUserFromSession()->get_userSettings()[USER_PARAM_ADMIN_MENU_STATE];				
				
				if (strpos($adminPageDefault, $currentPage) !== false) {					
					$userName = $_SESSION['username'];
					ET_MetaDataConnector::getInstance()->clearUserSetting($userName, USER_PARAM_ADMIN_MENU_STATE);
				}
			}
			
		}
		
		protected static function getUserSettingsForAdminPages($userName, $paramLevel, $catalogInstanceId = "", $logicaLink = "", $optionKey = "") {
			
			$settingsAny 	= ET_MetaDataConnector::getInstance()->getUserSettings(QUERY_ANY, $paramLevel, $catalogInstanceId, $logicaLink, $optionKey);
			$settingsUser 	= ET_MetaDataConnector::getInstance()->getUserSettings($userName, $paramLevel, $catalogInstanceId, $logicaLink, $optionKey);
				
			return array_merge($settingsAny, $settingsUser);
		}
		
		
		protected static function setUpDataGridMergeSQL($fullTableName, $projectionList, $filter, $mergedColumns, $columnInfo) {
			
			$sql = "select $projectionList";			
			$counter = 0;
			$mergedColumnsMemberCount = count($mergedColumns);
			
			foreach ($mergedColumns as $key => $value) {
				
				$generatedColName 	= $key;								
				$colsToConcat 		= array();
				
				for ($i = 0; $i < count($value); $i++) {					
					$tmp 	= $value[$i];
					$col 	= $tmp['name'];
					$index 	= $tmp['index'];
					//$colsToConcat[$index] = $col;
					array_splice($colsToConcat, $index, 0, $col);
				}
			
				$concatStr = ", concat(";
				for ($j = 0; $j < count($colsToConcat); $j++) {
					$tmp 	= $value[$j];
					$col 	= $tmp['name'];
					$index 	= $tmp['index'];
					$type 	= $columnInfo[$col]['metaType'];
					// concat(convert(catalog_id_lookup, char), '.', instance_name_lookup) as merged
					if ($type == "I" || $type == "N" || $type == "R") {
						$concatStr .= "convert($col, char)";
					} else {
						$concatStr .= $col;
					}
					
					if ($j < count($colsToConcat) - 1) {
						//TODO - define delimiter constant
						$concatStr .= ", '.', ";
					}
					else {
						$concatStr .= ") ";
					}
				}
				$sql .= $concatStr . " as $generatedColName";
				
				if ($counter < $mergedColumnsMemberCount - 1) {
					$sql .= ", ";
				}
				$counter ++;
			}
			$sql .= " from $fullTableName where $filter";
			
			return $sql;			
		}
		
		protected static function generateMergedColumnSettings($mergeDefinition, $targetColName) {
			
			$mergedColumn					= new ET_MergedColumnAdmin();
			$prefixStop 					= strpos($mergeDefinition, '.');
			$mergedValueHolderNoPrefix 		= substr($mergeDefinition, $prefixStop + 1);
			$tmpSlitMerged 					= preg_split('/(\(#[0-9]+\))/', $mergedValueHolderNoPrefix, null, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);
			$mergedValueHolderCleaned 		= $tmpSlitMerged[0];
			$mergedValueOrderNumber 		= $tmpSlitMerged[1];
			$orderNumberClosePos 			= strrpos($mergedValueOrderNumber, ")");
			$mergedValueOrderNumberCleaned 	= substr($mergedValueOrderNumber, 2, $orderNumberClosePos - 2);
			
			if ($mergedValueHolderCleaned === false) {
				throw new Exception("Syntax error in merge column definition!");
			} else {
				
				$mergedColumn->setColName($targetColName);
				$mergedColumn->setColNameSource($mergedValueHolderCleaned);
				$mergedColumn->setValueOrderNumber($mergedValueOrderNumberCleaned);
				
				return $mergedColumn; 
			}
		}
		
		protected static function getPageNameByOptionKey($optionKey) {
			
			for ($i = 0; $i < count(ADMIN_OPTIONS); $i++) {
				
				$option = ADMIN_OPTIONS[$i];
				$actions = $option["actions"];
				
				for ($j = 0; $j < count($actions); $j++) {
					$action =  $actions[$j];
					
					if ($optionKey === $action["action"]) {
						return explode(".", $action["page"])[0];
					}
				}
			}
			return false;
			
		}
		
		private static function checkAndResetResolvedOnTheFlyCols() {
			
			$ret = array();
			
			$onTheFlyCols = ET_PropertiesAdmin::getInstance()->getOnTheFlyColumns();
			
			foreach ($onTheFlyCols as $key => $value) {
				
				$col = $onTheFlyCols[$key];
				
				if ($col->getResolved()) {
					$colName = strtolower($col->getColumnAlias());
					$ret[$colName]["metaType"] = $col->getColumnType();
					$ret[$colName]["originalColumnName"] = $col->getColumnName();
					$col->setResolved(false);
				}
			}
			
			return $ret;
			
		}
		
		
		private static function checkLookupKeys($lookupSetting) {
			
			if (!isset($lookupSetting["lookup_name"]) || empty($lookupSetting["lookup_name"])) {
				return false;
			} 
			if (!isset($lookupSetting["target_column"]) || empty($lookupSetting["target_column"])) {
				return false;
			}
			
			return true;
		}
		
		
		
		
	}