<?php
class ET_PropertiesAdmin {
	
	protected $lookups 			= array();	
	protected $onTheFlyColumns	= array();
	protected $virtualElements	= array();
	
	private static $instance	= null;
	
	public static function getInstance () {
		
		if (is_null(self::$instance)) {
			self::$instance = new ET_PropertiesAdmin();
		} 
		
		return self::$instance;
	}
	
	private function __construct() {
		$propertyFile = null;
		
		try {
			$propertyFile = $this->readAdminPropFile();
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
		
		$this->fillFeatureSections ($propertyFile);
		
	}
	
	protected function fillFeatureSections ($propertyFileContent) {
		
		$offset = 0;
		$counter = 0;
				
		while (strpos($propertyFileContent, "###", $offset) !== false || $counter < 10000) {
			
			$sectionStartBegin	= strpos($propertyFileContent, "###", $offset);
			$sectionStartClose 	= strpos($propertyFileContent, "###", $sectionStartBegin + 3) + 3;
			$sectionName		= substr($propertyFileContent, $sectionStartBegin, $sectionStartClose - $sectionStartBegin);
			$sectionName 		= trim($this->getFeatureName($sectionName));
			$sectionDataStart	= $sectionStartClose + 1;
			$sectionDataEnd		= strpos($propertyFileContent, "###", $sectionDataStart) == false ? strlen($propertyFileContent) : strpos($propertyFileContent, "###", $sectionDataStart);			
			$sectionDataStr		= substr($propertyFileContent, $sectionDataStart, $sectionDataEnd - $sectionDataStart);			
			$sectionDataStr		= trim($sectionDataStr);			
			$offset 			= $sectionDataEnd;			
			
			$this->addFeatureDefnition($sectionName, $sectionDataStr);
			$counter++;
		}
		
	}
	
	protected function addFeatureDefnition ($featureName, $featureDataStr) {
		
		//TODO - check ET_CallableObjectHelper line 54
		
		$sections 	= explode("===", $featureDataStr);
		
		for ($i = 0; $i < count($sections); $i++) {
			
			$section 	= $sections[$i];
			
			if ($section === "")
				continue;
			
			$lines		= preg_split( '/\r\n|\r|\n/', $section);			
			$settings = array();
			
			for ($j = 0; $j < count($lines); $j++) {
				
				$line = $lines[$j];
				$pos = strpos($line, ":");
				
				if ($pos === false)
					continue;
					
				$key 	= trim(substr($line, 0, $pos));
				$value 	= trim(substr($line, $pos + 1));
				
				$settings[$key] = $value;
				
								
			}
			
			switch ($featureName) {
				case PROPERTY_TYPE_LOOKUP:
					$lookupDefinition = $this->createLookupDefSetting($settings);
					$this->lookups[$lookupDefinition->getLookupName()] = $lookupDefinition;
					break;
				case PROPERTY_TYPE_VIRTUAL_COL :
					$onTheFlyColumn = $this->createOnTheFlyColumDefSetting($settings);
					$this->onTheFlyColumns[$onTheFlyColumn->getColumnName()] = $onTheFlyColumn;
					break;
				case PROPERTY_TYPE_VIRTUAL_ELEM:
					$virtElement = $this->createVirtualElementDefSettings($settings);
					$this->virtualElements[$virtElement->getName()] = $virtElement;
			}
		}
		
	}

	protected function createOnTheFlyColumDefSetting ($settings) {
		
		$onTheFlyColObj = new ET_OnTheFlyColumnAdmin();
		
		if (isset($settings[PROPERTY_VALUE_VIRTUAL_COL_NAME]))
			$onTheFlyColObj->setColumnName($settings[PROPERTY_VALUE_VIRTUAL_COL_NAME]);
		
		if (isset($settings[PROPERTY_VALUE_VIRTUAL_COL_VALUE]))
			$onTheFlyColObj->setColumnValue($settings[PROPERTY_VALUE_VIRTUAL_COL_VALUE]);
		
		if (isset($settings[PROPERTY_VALUE_VIRTUAL_COL_META_TYPE]))
			$onTheFlyColObj->setColumnType($settings[PROPERTY_VALUE_VIRTUAL_COL_META_TYPE]);

		if (isset($settings[PROPERTY_VALUE_VIRTUAL_COL_ALIAS]))
			$onTheFlyColObj->setColumnAlias($settings[PROPERTY_VALUE_VIRTUAL_COL_ALIAS]);
			
		return $onTheFlyColObj;
	}
	
	protected function createLookupDefSetting ($settings) {
		
		$lookupDefObj = new ET_LookupSettingAdmin();	
		
		if (isset($settings[PROPERTY_VALUE_LOOKUP_NAME]))
			$lookupDefObj->setLookupName($settings[PROPERTY_VALUE_LOOKUP_NAME]);		
		
		if (isset($settings[PROPERTY_VALUE_LOOKUP_SYS_TABLE]))
			$lookupDefObj->setSystemtable($settings[PROPERTY_VALUE_LOOKUP_SYS_TABLE]);		
		
		if (isset($settings[PROPERTY_VALUE_LOOKUP_USE_TABLE]))
			$lookupDefObj->setIndUseTable($settings[PROPERTY_VALUE_LOOKUP_USE_TABLE]);	
		
		if (isset($settings[PROPERTY_VALUE_LOOKUP_PROJ_LIST]))
			$lookupDefObj->setProjectionList($settings[PROPERTY_VALUE_LOOKUP_PROJ_LIST]);		
		
		if (isset($settings[PROPERTY_VALUE_LOOKUP_OBJ_FILTER]))
			$lookupDefObj->setObjectFiler($settings[PROPERTY_VALUE_LOOKUP_OBJ_FILTER]);
		
		if (isset($settings[PROPERTY_VALUE_LOOKUP_ADD_NULL]))
			$lookupDefObj->setAddNullValue($settings[PROPERTY_VALUE_LOOKUP_ADD_NULL]);
	
			if (isset($settings[PROPERTY_VALUE_LOOKUP_ORDER_BY]))
				$lookupDefObj->setOrderBy($settings[PROPERTY_VALUE_LOOKUP_ORDER_BY]);
		
		return $lookupDefObj;
	}
	
	protected function createVirtualElementDefSettings($settings) {
		
		$virtualElementObj = new ET_VirtualElementSettingAdmin();
		
		if (isset($settings[PROPERTY_VALUE_VIRTUAL_ELEM_NAME])) {
			$virtualElementObj->setName($settings[PROPERTY_VALUE_VIRTUAL_ELEM_NAME]);
		} else {
			throw new Exception("Virtual element setting error! Name not defined!");
		}
		
		if (isset($settings[PROPERTY_VALUE_VIRTUAL_ELEM_VALUE])) {
			$virtualElementObj->setValue($settings[PROPERTY_VALUE_VIRTUAL_ELEM_VALUE]);
		} else {
			throw new Exception("Virtual element setting error! Value not defined!");
		}
		return $virtualElementObj;
	}
	
	/***
	 *
	 * @param string $featureSectionDelimiter - ###feature-name###
	 */
	protected function getFeatureName($nameWithHashes) {
		
		$ret = substr($nameWithHashes, 3, strlen($nameWithHashes) - 6);
		
		if (!empty($ret))
			return $ret;
		else return false;
	}
	
	protected function readAdminPropFile() {
		
		$fileContent = "";
		//$adminPropPath = NIOTA_ROOT_DIR . ADMIN_PAGES_PROP_FOLDER . ADMIN_PAGES_PROP_FILE;
		$adminPropPath = __DIR__ . "/../../../" . ADMIN_PAGES_PROP_FOLDER . ADMIN_PAGES_PROP_FILE;
		
		if (file_exists($adminPropPath)) {	
			$fileContent = file_get_contents($adminPropPath);
			
			if (empty($fileContent)) {
				throw new Exception("Admin pages .prop file is empty!");
			}
		} else {
			throw new Exception("Admin pages .prop file not found!");
		}
		return $fileContent;
	}
	
	protected function resolve($prefix, $inputStr, $substitutionArray = null) {
		
		$names = $this->findSubstitutionNames($prefix, $inputStr);
		$ret = $inputStr;
		
		
		for ($i = 0; $i < count($names); $i++) {
			
			$name 	= $names[$i];
			$val 	= null;
			if ($prefix == PROPERTY_VALUE_PREFIX_GENERATED_COL) {
				if (isset($this->onTheFlyColumns[$name])) {
					$onTheFlyCol = $this->onTheFlyColumns[$name];
					
					$val 	= $onTheFlyCol->getColumnValue();
					$alias 	= $onTheFlyCol->getColumnAlias();
					if (empty($alias))
						$alias = $name;	
					$val .= " as " . $alias;
					$this->onTheFlyColumns[$name]->setResolved(true);
				}
			} else if ($prefix == PROPERTY_VALUE_PREFIX_VIRTUAL_ELEMENT) {
				if (isset($this->virtualElements[$name]))
					$val = $this->virtualElements[$name]->getValue();
			} else if ($prefix == PROPERTY_VALUE_PREFIX_COL) {
				if (isset($substitutionArray[$name]))
					$val = $substitutionArray[$name];
			}
		
			if (!is_null($val)) {
				$tmp = $prefix . ".{" . $name . "}";
				
				$ret = str_replace($tmp, $val, $ret);
			}
		}
		return $ret;
	}
	
	public function getGeneratedColumnNames($inputString) {
		$ret = array();
		$names = $this->findSubstitutionNames(PROPERTY_VALUE_PREFIX_GENERATED_COL, $inputString);
		
		for ($i = 0; $i < count($names); $i++) {
			$name = $names[$i];
			if (isset($this->onTheFlyColumns[$name])) {
				$onTheFlyCol = $this->onTheFlyColumns[$name];
				$alias = $onTheFlyCol->getColumnAlias();
				if (empty($alias))
					$alias =$name;
				array_push($ret, $alias);
			}
		}
		return $ret;
	}
	
	protected function findSubstitutionNames ($prefix, $string) {
		
		$ret = array();
		
		$index = 0;
		while (true) {
			$pos = strpos($string, $prefix . ".{", $index);
		
			if ($pos !== false) {
				
				$posBracketClosing 	= strpos($string, "}", $pos);
				$offset				= $pos + strlen($prefix) + 2;
				$name 				= substr($string, $offset, $posBracketClosing - $offset);
				
				array_push($ret, $name);
				$index = $posBracketClosing;
			} else {
				break;
			}
		}
		
		return $ret;
	}
	
	public function resolveVirtualElements ($inputStr) {
		$ret = $this->resolve(PROPERTY_VALUE_PREFIX_VIRTUAL_ELEMENT, $inputStr);
		return str_replace('$SPLITTERCHAR_SYS', "'" . SPLITTERCHAR_SYS . "'", $ret);
	}
	
	public function resolveGeneratedColumns ($inputStr) {
		$ret = $this->resolve(PROPERTY_VALUE_PREFIX_GENERATED_COL, $inputStr);
		return $this->resolveVirtualElements($ret);
	}
	
	public function resolveColumnValues($inputStr, $substitutionArray) {
		$ret = $this->resolve(PROPERTY_VALUE_PREFIX_COL, $inputStr, $substitutionArray);
		//return str_replace('$SPLITTERCHAR_SYS', "'" . SPLITTERCHAR_SYS . "'", $ret);
		return $ret;
	}
	
	
	/***
	 * 
	 * @param string $inputStr
	 * @return return of the given function 
	 */
	public function resolveAndCallFunction($inputStr) {
		
		$list = $this->getAvailableFunctionNames();
		
		$ret = $inputStr;
		
		for ($i = 0; $i < count($list); $i++) {
			$name = $list[$i];
			$pos = strpos($inputStr, "$" . $name . "(");
			
			if ($pos !== false) {
				
				$posClosing = strpos($inputStr, ")", $pos);
				if ($posClosing !== false) {
					
					$posStart = $pos + strlen($name) + 2;
					
					$paramPart = substr($inputStr, $posStart, $posClosing - $posStart);
					
					$params = explode(",", $paramPart);
					$params = array_map("trim", $params);
					$source = new ET_Functions();
					$reflector = new ReflectionClass($source);
					$val = $reflector->getMethod($name)->invoke($source, $params);
					
					$ret = str_replace("$" . $name . "(" . $paramPart . ")", $val, $ret);
					
					break;
				}
			}
		}
		return $ret;
	}
	
	public function getAvailableFunctionNames () {
		$ret = array();
		$source = new ET_Functions();
		$reflector = new ReflectionClass($source);
		$methods = $reflector->getMethods(ReflectionMethod::IS_PUBLIC);
		
		for ($i = 0; $i < count($methods); $i++) {
			$method = $methods[$i];
			array_push($ret, $method->getShortName());
		}
		return $ret;
	}
	
	
    /**
     * lookups
     * @return array
     */
    public function getLookups(){
        return $this->lookups;
    }

    /**
     * defaultValues
     * @return array
     */
    public function getDefaultValues(){
        return $this->defaultValues;
    }

    /**
     * onTheFlyColumns
     * @return array
     */
    public function getOnTheFlyColumns(){
        return $this->onTheFlyColumns;
    }

}