<?php 

class HTMLBase {
	
	protected $tagName 	= "";
	protected $attributes = [];
	protected $booleanAttributes = [];
	
	public function __construct($tagName, $class=""){
		$this->tagName = $tagName;
		$this->class = $class;
	}
	/***
	 * @param boolean $onlyReturn -> boolean. If true a string is returned and no print();	 	 
	 * @return -> echo the result or string
	 */
	function printOpeningTag($onlyReturn = false){
		
		$attributesStr = "";
	
		foreach($this->attributes as $key => $val){
			$attributesStr .= " " . $key . "='" . $val . "' ";
		}
	
		for ($i = 0; $i < count($this->booleanAttributes); $i++) {
			$attributesStr .= $this->booleanAttributes[$i] . " ";
		}
		
		$closing = ($this->tagName == "img") ? "/>" : ">";
		
		if(!$onlyReturn)
			echo "<" . $this->tagName . $attributesStr . $closing;
		
		return "<" . $this->tagName . $attributesStr . $closing;
	}
	
	/***
	 * 
	 * @param boolean $printOutResult  -> if set to false returns the tag as a strting
	 * @return -> echo the result or string
	 */
	function printClosingTag($onlyReturn = false){
		if(!$onlyReturn)
			echo "</$this->tagName>";
		
		return "</$this->tagName>";
	}
	
	function setAttribute($name, $value) {
		if($name !== "" && $value !== "")
			$this->attributes[$name] = $value;
		return $this;
	}
	
	public function getAttributeValue($attributeName) {
		
		if (isset($this->attributes[$attributeName]))
			return $this->attributes[$attributeName];
		else
			return false;
	}
	
	function setBooleanAttribute($name) {
		if ($name !== "" && !in_array($name, $this->booleanAttributes))
			array_push($this->booleanAttributes, $name);
		return $this;
	}
	
	public static function  printBr($onlyReturn = false){
		if(!$onlyReturn)
			echo "<br>";
		
			return "<br>";
	}
	
	public function set_id($value = ""){
		return $this->setAttribute("id", $value);
	}
	
	public function set_class($value = ""){
		return $this->setAttribute("class", $value);
	}
	
	public function set_name($value = ""){
		return $this->setAttribute("name", $value);
	}
	
	public function set_onclick($value = ""){
		return $this->setAttribute("onclick", $value);
	}
	
	public function set_ondrag($value = ""){
		return $this->setAttribute("ondrag", $value);
	}
	
	public function set_style($value = ""){
		
		$newValue = "";
		if (isset($this->attributes["style"]))
				$newValue = $this->attributes["style"] . "; " . $value;
		else 
			$newValue = $value;
		
		return $this->setAttribute("style", $newValue);	
	}
	
	
	/***
	 * Delet one given style definition from the style string.
	 * 
	 * @param string - the style you want to delete (paramName: value) 
	 * @return boolean
	 */
	public function reset_style ($value) {
		
		$temp = $value;
		
		if (strpos($this->attributes["style"], $value) !== false) {
			$this->attributes["style"] = str_replace($temp, "", $this->attributes["style"]);
			
			if (strpos($this->attributes["style"], ";") === 0) {	
				
				if (strlen(trim($this->attributes["style"])) < 2) {
					$this->attributes["style"] =  "";
				}
				else {					
					$x = 1; // you cannot pass a number directly in the function call below, so variable must be created
					$this->attributes["style"] = str_replace(";", "", $this->attributes["style"], $x);
				}
			}
			
			return true;
		}
		return false;
		
	}
			
	public function set_title($value = ""){
		return $this->setAttribute("title", $value);
	}

	public function getTagName(){
		return $this->tagName;
	}
}

?>