<?php
	class HTMLSelect extends HTMLBase{
		
		function __construct() {
			parent::__construct("select");
		}
		
		public function set_required(){
			return $this->setBooleanAttribute("required");
		}
		
		public function set_width($value = ""){
			return $this->setAttribute("width", $value);
		}
		
		public function set_onchange($value = ""){
			return $this->setAttribute("onchange", $value);
		}
		
		public function set_disabled(){
			return $this->setBooleanAttribute("disabled");
		}
		
/*		
		public function set_name($value){
			return $this->setAttribute("name", $value);
		}
	*/	
		/***
		 * 
		 * @param array $optionData
		 * @param string $firstLine -> display text of first line, eg: -- select object --
		 * @param array $customOptions -> string of additional options whihch not generated by input data 
		 * @param boolean $onlyReturn -> if true returns a string 
		 * @return -> sting or nothing (echo)
		 */
		function generateWholeSelect($optionData, $firstLine = "", $onlyReturn = false, $selectClass = "") {
		
			if ($selectClass !== "") $this->set_id($selectClass);
			
			$output = $this->printOpeningTag(true);
			
			if($firstLine !== ""){
				
				$firstOption = new HTMLOption("option");
				$firstOption->set_name('all')->set_value('all');
				$output .= $firstOption->printOpeningTag(true) . $firstLine . $firstOption->printClosingTag(true);
			}
			
			for($i = 0; $i < count($optionData); $i++){
					
				$currentOption 	= new HTMLOption();
				$displayText 	= "";
					
				foreach($optionData[$i] as $key => $value){
		
					switch ($key){
						case "name":
							$currentOption->set_name($value);
							break;
						case "value":
							$currentOption->set_value($value);
							break;
						case "class":
							$currentOption->set_class($value);
							break;
						case "id":
							$currentOption->set_id($value);
							break;
						case "displayText":
							$displayText = $value;
							break;
						case "selected":
							if (!empty($value)) {
								$currentOption->set_selected();
							}
							break;
					}
				}
				$output .= $currentOption->printOpeningTag(true) . $displayText . $currentOption->printClosingTag(true);
			}
			$output .= $this->printClosingTag(true);
			
			if (!$onlyReturn)
				echo $output;
		
			return $output;
		}
		
	}

?>