<?php
	class HTMLTable extends HTMLBase{
		
		function __construct(){
			parent::__construct("table");
		}
		
		
		/***
		 * 
		 * @param array $columnTitles
		 * @param array $rowData
		 * @param boolean $onlyReturn
		 * @colSpan array [$trIndex, $tdIndex, $NumberOfcolumns]
		 * @rowSpan array [$trIndex, $tdIndex, $NumberOfrows]
		 */
		function generateWholeTable($columnTitles, $rowData, $colSpan = array(), $rowspan = array(), $onlyReturn = false){
			
			
			$output = $this->printOpeningTag(true);
			
			if(!empty($columnTitles)){
				for ($i = 0; $i < count($columnTitles); $i++) {
					$th = new HTMLTh();
					$output .= $th->printOpeningTag(true) . $columnTitles[$i] . $th->printClosingTag(true);
				}
			}
			
			for ($i = 0; $i < count($rowData); $i++) {
				
				$tr 	= new HTMLTr();
				$counter = 1;
				$output .= $tr->printOpeningTag(true);
				$oneRow = $rowData[$i];			
				
				foreach ($oneRow as $key => $value) {
					$td 	= new HTMLTd();
					if(!empty($colSpan)){
						if(($colSpan[0] === $i+1) && ($colSpan[1] === $counter))
							$td->set_colspan($colSpan[2]);					
					}
					
					if(!empty($rowspan)){
						if(($rowspan[0] === $i+1) && ($rowspan[1] === $counter))
							$td->set_colspan($rowspan[2]);
					}
					
					$output .= $td->printClosingTag(true) . $value . $td->printClosingTag(true);  					
				}				
				$output .= $tr->printClosingTag(true);
			}
			$output .= $this->printClosingTag(true);
			
			if(!$onlyReturn)
				echo $output;
			
			return $output;
		}
				
	}