
<?php 

/*
 * ----------------------------------------------------------------
 * Here are the most of the constants. 
 * display related constants and which are accessable for the users 
 * can be found in conf/ folder.  
 * ----------------------------------------------------------------
 */

/* ===========+========+===== changelog ==============================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+-------------------------------------------------------------
 -- 2020.07.11   rre      add deployment-functions
 -- 2020.11.21   rre      moved some definition to system_defaults.php
 -- 2021.09.24	 nmz	  new constant: DB_TYPE_MSSQL
 -- 2022.08.05	 nmz	  move system table related constants to table_definitions.php 
 -- **********************************************************************************
 */

define('DB_TYPE_OCI805', 		'oci805');
define('DB_TYPE_MYSQLI', 		'mysqli');
define('DB_TYPE_MSSQL',			'mssqlnative');
define('DB_TYPE_ODBC_MSSQL',	'odbc_mssql');
define('DB_TYPE_ODBC_TERADATA',	'odbc_teradata');
		
//CONNECTION 
define('PHPGRID_DB_DISPLAY_NAME', 				'PHPGRID_DB_DISPLAY_NAME');
define('PHPGRID_DB_HOSTNAME', 					'PHPGRID_DB_HOSTNAME');
define('PHPGRID_DB_PORT',						'PHPGRID_DB_PORT');
define('PHPGRID_DB_USERNAME', 					'PHPGRID_DB_USERNAME');
define('PHPGRID_DB_PASSWORD', 					'PHPGRID_DB_PASSWORD');
define('PHPGRID_DB_NAME', 						'PHPGRID_DB_NAME');
define('PHPGRID_DB_TYPE', 						'PHPGRID_DB_TYPE');
define('PHPGRID_DB_DN', 						'PHPGRID_DB_DN');
define('PHPGRID_DB_OU', 						'PHPGRID_DB_OU');
define('PHPGRID_DB_CHARSET', 					'PHPGRID_DB_CHARSET');
define('PHPGRID_METADATA_DB_NAME', 				'PHPGRID_METADATA_DB_NAME');
define('PHPGRID_SOURCE_DATE_FORMAT', 			'PHPGRID_SOURCE_DATE_FORMAT');
define('PHPGRID_DISPLAY_DATE_FORMAT', 			'PHPGRID_DISPLAY_DATE_FORMAT');
define('PHPGRID_METADATA_DB_PREFIX', 			'PHPGRID_METADATA_DB_PREFIX');
define('PHPGRID_DISPLAY_NUMBER_DECIMALPOINT', 	'PHPGRID_DISPLAY_NUMBER_DECIMALPOINT');
define('PHPGRID_SOURCE_DATETIME_FORMAT', 		'PHPGRID_SOURCE_DATETIME_FORMAT');
define('PHPGRID_DISPLAY_DATETIME_FORMAT', 		'PHPGRID_DISPLAY_DATETIME_FORMAT');
define('PHPGRID_AUTH_MECHANISM', 				'PHPGRID_AUTH_MECHANISM');
define('PHPGRID_DB_SCHEMA', 					'PHPGRID_DB_SCHEMA');
define('PHPGRID_LDAP_SSL', 						'PHPGRID_LDAP_SSL');
define('PHPGRID_DB_PW_ENCRYPTED',				'PHPGRID_DB_PW_ENCRYPTED');
define('PHPGRID_WS_ENDPOINT', 					'PHPGRID_WS_ENDPOINT');
define('PHPGRID_WSDL_LOCATION', 				'PHPGRID_WSDL_LOCATION');
define('PHPGRID_WS_DISPLAY_NAME', 				'PHPGRID_WS_DISPLAY_NAME');
define('PHPGRID_WS_USERNAME',					'PHPGRID_WS_USERNAME');
define('PHPGRID_WS_PASSWORD', 					'PHPGRID_WS_PASSWORD');
define('PHPGRID_WS_PASSWORD_ENCRYPTED', 		'PHPGRID_WS_PASSWORD_ENCRYPTED');
define('PHPGRID_CONN_TYPE', 					'PHPGRID_CONN_TYPE');

define('CONN_TYPE_WEBSERVICE', 					'web_service');
define('CONN_TYPE_DATABASE', 					'database');

//SESSION VARIABLES
define('SESS_USERNAME', 						'username');
define('SESS_USEROBJECT', 						'userobject');
define('SESS_CATALOG_INSTANCE_ID_MASTER',		'catalog_instance_id_master');
define('SESS_CATALOG_INSTANCE_ID_DETAIL',		'catalog_instance_id_detail');

define('SESS_BROWSING_STORE', 					'browsing_store');
define('SESS_LOGGING_SETTINGS',					'logging_settings');
define('SESS_ADVANCED_FILTER_KEYPAIR',			'advanced_filter_keypair');
define('SESS_ADVANCED_FILTER_LAST_SELECTION_PREFIX',
												'advanced_filter_last_selection_');
define('SESS_ADVANCED_FILTER_FILTERMAPPINGS',	'advanced_filter_filtermappings');
define('SESS_ADVANCED_FILTER_FILTERED_INSTANCE_ID',	
												'advanced_filter_filtered_instance_id');
define('SESS_ADVANCED_FILTER_FILTERED_CATALOG_FIRST_LOAD', 
												'first_loading_filtered_catalog');
define('SESS_ADVANCED_FILTER_LOGICAL_LINK',		'advanced_filter_logical_link');


define('SESS_REPLAY_LAST_DYNAMIC_MENU_ITEM',	'replay_last_dynamic_menu_item');

define('SESS_CATALOG_INSTANCE_ID_MASTER_ADMIN', 'catalog_instance_id_master_admin');
define('SESS_CATALOG_INSTANCE_ID_DETAIL_ADMIN', 'catalog_instance_id_detail_admin');

define('SESS_INSTANCE_NAME_MASTER_ADMIN', 		'instance_name');
define('SESS_INSTANCE_NAME_DETAIL_ADMIN', 		'instance_name_1');

define('SESS_UPLOADED_FILE_NAME'				,'uploaded_file_name');
define('SESS_UPLOADED_FILE_PATH'				,'uploaded_file_full_path');
define('SESS_UPLOAD_FOLDER_PATH'				,'upload_folder_path');
define('SESS_UPLOAD_POPUP_PRINTED',				'upload_popup_printed');

define('SESS_VALIDATION_ROWCOUNT'				,'rowCount');
define('SESS_VALIDATION_FROM'					,'from');
define('SESS_VALIDATION_TO'						,'to');
define('SESS_VALIDATION_FINISHED'				,'finished');
define('SESS_VALIDATION_CHUNK_SIZE'				,'chunkSize');
define('SESS_VALIDATION_ERROR_COUNT_LKP',		'validation_error_count_lkp');
define('SESS_VALIDATION_ERROR_COUNT_CONST',		'validation_error_count_const');
define('SESS_VALIDATION_LOG_MESSAGES',			"log_messages");
define('SESS_VALIDATION_CHECKED_ROWS_COUNT',	"validated_rows_count");
define('SESS_VALIDATION_MAX_ERROR_AMOUNT',		"validate_max_error");
define('SESS_VALIDATION_MAX_MESSAGES_AMOUNT',	"validate_max_messages");
define('SESS_VALIDATION_CHUNK_COLLECTOR', 		'validation_chunk_collector');
define('SESS_VALIDATION_ERROR_LOG_COUNT', 		'validation_error_log_count');
define('SESS_VALIDATION_LOOKUP_VALUES', 		'validation_lookup_values');

define('SESS_CLIENT',							'client');
define('SESS_CLIENT_FOLDER_PATH', 				'client_folder_path');
define('SESS_CLIENT_FOLDER_NAME', 				'client_folder_name');
define('CLIENT_SYSTEM',							'system');
define('CLIENT_FOLDER_FORMATTING',				'formattings');
define('CLIENT_MAIN_CONF_FOLDER', 				'conf');

define('MIN_DATE',								'min_date');
define('MAX_DATE',								'max_date');
define('MIN_DATETIME',							'min_datetime');
define('MAX_DATETIME',							'max_datetime');

//FILTER CONSTANTS
define('FILTER_CONNECTION', 					'filter_connection');
define('FILTER_CATEGORY', 						'filter_category');
define('FILTER_ALL', 							'all');

//SUBGRID NUMBERS
define('SUBGRID_NUMBER_1', 						'1');
define('SUBGRID_NUMBER_2', 						'2');

define('TEMP_FOLDER', 							'temp/');

//from formatting.php
define('DEFAULT_FORMAT', 			array('combo', '300px'));
define('ALL_GROUP', 				'*ALL_GROUP');
define('ALL_ADMIN_GROUP', 			'*ALL_ADMIN_GROUP');
define('ALL_NON_ADMIN_GROUP', 		'*ALL_NON_ADMIN_GROUP');

define ('CONSTRAINTS_OPERATIONS', 	[array (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14), array('equals (=)', 'not equals (&lt;&gt;)', 'greater than (&gt;)', 'less than (&lt;)', 'greater than or equal to (&ge;)', 'less than or equal to (&le;)', 'between', 'not between', 'like', 'not like', 'starts with', 'not starts with', 'ends with', 'not ends with')]);

define('INFO_TYPE_SUCCESS',			1);
define('INFO_TYPE_WARNING',			2);
define('INFO_TYPE_ERROR', 			3);

define('SUBGRID_DISPLAY_LEVEL', 	[array(0,1,2), array("display always", "display only when -- is master table", "display only when -- is detail table")]);

define ('ACTIONS_FIRST', 			0);
define ('ACTIONS_LAST', 			-1);

define('FORMATTING_LINK_SEPARATOR', '::');

//from connection.php
define('SELECT_TYPE_CONN', 			0);
define('SELECT_TYPE_DB', 			1);
define('SELECT_TYPE_TABLE', 		2);
define('SELECT_TYPE_USER', 			3);

define('SUPERUSER', 				'superuser');

	//tranasction type
define('TRANSACTION_TYPE_FORM', 	'form');
define('TRANSACTION_TYPE_AJAX', 	'ajax');

	//icons container folder
//define('FOLDER_DYNAMIC_MENU_ICONS', 	'form');

//POST - Personal page
define('POST_PERSONAL_FIRSTNAME', 		'personal_firstname');
define('POST_PERSONAL_LASTNAME', 		'personal_lastname');
define('POST_PERSONAL_EMAIL', 			'personal_email');
define('POST_PERSONAL_PHONE', 			'personal_phone');
define('POST_PERSONAL_PASSWORD',		'personal_password');
define('POST_PERSONAL_PASSWORD_NEW', 	'personal_password_new');
define('POST_PERSONAL_PASSWORD_NEW_RE',	'personal_password_new_re');

define('PERSONAL_PAGE_RELOAD',			'reload');

//general setting for all the catalogs
define('VIRTUAL_COLUMN_POSITION',		'virtual_column_position');

define('SEPARATOR_HTML_GET', 			'$comma$');
define('SUBSTITUTION_HASHMARK_HTML_GET', 	'___HASHMARK___');
define('SUBSTITUTION_AMPERSAND_HTML_GET', 	'___AMPERSAND___');
define('SUBSTITUTION_DOT_JQUERY_SELECTOR', 	'___DOT___');

//ADODB stuff
define('ADODB_FORCE_TYPE', 3);

//SPLIT CHARACTER OF MERGED VALUES
define ('SPLITTERCHAR_SYS',		 		'.');

//ADMIN PAGE - column property
define('PROP_TARTGET_CONSTRAINT',		1);
define('PROP_TARTGET_LOOKUP',			2);
define('PROP_TARTGET_VIEW',				3);
define('PROP_TARTGET_EDIT',				4);

//ADMIN PAGES PROPERTY FILE AND CONTAINIG FOLDER
define('ADMIN_PAGES_PROP_FILE', 		'et_admin_pages.prop');
define('ADMIN_PAGES_PROP_FOLDER', 		'/etixpert/admin/config/');

//ADMIN PAGE - advaced filter
define('MD_TARTGET_ADVANCEDFILTER', 	1);
define('MD_TARTGET_MASTERDETAIL', 		2);

//ADMIN PAGE - define lookups
define('LOOKUP_KEY_MERGED', 						'merged_lookup');
define('LOOKUP_KEY_ADD_NULL_ITEM', 					'add_null_item');
define('LOOKUP_VALUE_INSTANCE_NAME', 				'instance_name');
define('LOOKUP_VALUE_INSTANCE_NAME_LOOKUP', 		'instance_name_lookup');
define('LOOKUP_VALUE_MERGED_CATALOG_INSTANCE_ID', 	'catalog_instance_id');

//ADMIN PAGE - lookup property file
define('LOOKUP_PROP_NAME', 							'lookup_name');
define('LOOKUP_PROP_SQL', 							'command_SQL');
define('LOOKUP_PROP_COL_LIST',						'projection_list_lookup');
define('LOOKUP_PROP_ADD_NULL',						'ind_add_nullitem');
define('LOOKUP_PROP_TABLE_NAME',					'table_name_lookup');
define('LOOKUP_PROP_IS_TABLE',						'ind_is_table');

//ADMIN PAGE - edit flags
define('EDIT_FLAG_FORCE_LINKTYPE_MD', 	1);
define('EDIT_FLAG_FORCE_LINKTYPE_AF', 	2);

//lookup types:
define('LOOKUP_TYPE_STANDARD',			'0');
define('LOOKUP_TYPE_CASCADING',			'1');
define('LOOKUP_TYPE_CONCATENATED',		'2');

//lookup null value:
define('LOOKUP_NULL_VALUE_DESCR', 		'null value');

// define formatting for all of the admin grids, this file is located in admin/formatting. Only filename needs to be set.
// if you wouldn't like to use this feture, just comment out the line below
define ('CUSTOM_FORMAT_FILE_GENERAL_ADMIN', 			'format_all_admin.php');


// root folder name of niota - in fact niota/app
define("NIOTA_ROOT_DIR",				getNiotaRootDir());
//must be relative to Apache's documnet root
define('NIOTA_ROOT_DIR_BASE',			getNiotaRootDirBase());

// CALLABLE OBJECT CONSTANTS:
define('CO_MESSAGE_ACTIVE',				'messaging_active');
define('CO_MESSAGE_TYPE', 				'message_type');
define('CO_MESSAGE_TEXT', 				'message_text');
define('CO_MESSAGE_GUID', 				'message_guid');
define('CO_MESSAGES',	 				'messages');
define('CO_MESSAGE_RECEIVED',			'message_received');
define('CO_MESSAGE_TYPE_INFO',			'inf');
define('CO_MESSAGE_TYPE_WARNING',		'wrn');
define('CO_MESSAGE_TYPE_ERROR',			'err');
//define('CO_MESSAGE_TYPE_MISC',			'err');

define('CO_MESSAGE_TYPE_SUCCESS',		'suc');
define('CO_MESSAGE_TYPE_FAILURE',		'fai');

define('CO_MESSAGE_TYPE_SUCCESS_SYSTEM','suc_sys');
define('CO_MESSAGE_TYPE_FAILURE_SYSTEM','fai_sys');
define('CO_MESSAGE_TYPE_WARNING_SYSTEM','wrn_sys');
define('CO_MESSAGE_TYPE_ERROR_SYSTEM',	'err_sys');

define('CO_MESSAGE_TYPE_ARRAY_SYSTEM',	array(CO_MESSAGE_TYPE_ERROR_SYSTEM, CO_MESSAGE_TYPE_FAILURE_SYSTEM, CO_MESSAGE_TYPE_SUCCESS_SYSTEM, CO_MESSAGE_TYPE_WARNING_SYSTEM));
define('CO_MESSAGE_TYPE_ARRAY_CUSTOM', 	array(CO_MESSAGE_TYPE_INFO, CO_MESSAGE_TYPE_WARNING, CO_MESSAGE_TYPE_ERROR));

define('CO_MESSAGE_CONN_NAME', 			'message_connection_name');
define('CO_MESSAGE_STOPPED', 			'message_stopped');

define('CO_CONN_NAME',		 			'callable_connection_name');
define('CO_LINE_LEVEL_PROCESSED_ROWS', 	'line_level_processed_rows');
define('CO_RELOAD_GRID',				'reload_grid');
define('CO_EXECUTION_ERROR',			'execution_error');
define('CO_SUBSTITUTION_VARS',			'substitution_vars');//object
define('CO_SUBSTITUTION_VARS_SYS', 		'substitution_vars_sys');//array
define('CO_ROWID_STRINGS',				'rowid_strings');
define('CO_SUBSTITUTION_VARS_SEQ',		'substitution_vars_sequence');	//array of objects
define('CO_DEBUG_SQL', 					'debug_sql');

define('CO_SQL_FILE_PATH_ADMIN',		'etixpert/admin/config/scripts/sqlscript');
define('CO_WS_FILE_PATH_ADMIN',			'etixpert/admin/config/scripts/webservice');

define('CO_TYPE_STORED_PROC', 			'0');
define('CO_TYPE_STORED_SIMPLE_SQL',		'1');
define('CO_TYPE_BATCH_COMMAND',			'2');
define('CO_TYPE_WEB_SERVICE_CALL',		'3');

define('CO_SOAP_USERNAME', 				'$PHPGRID_WS_USERNAME');
define('CO_SOAP_PASSWORD', 				'$PHPGRID_WS_PASSWORD');
define('CO_SOAP_PASSWORD_BASE64', 		'$PHPGRID_WS_PASSWORD_BASE64');
define('CO_SOAP_RESP_SUCCESS', 			'return');
define('CO_SOAP_RESP_FAILURE',			'faultstring');

define('CO_PROMPT_PAGE_NO_PROMPT', 		0);
define('CO_PROMPT_PAGE_FILE_UPLOAD', 	1);

define('CO_CALL_FROM_MENU', 			"menu");
define('CO_CALL_FROM_GRID', 			"grid");

// MESSAGING 
define('T_MESSAGE', 					'etx_message');
define('COL_ID', 						'id_log');
define('COL_TIMESTAMP', 				'ts_log');
define('COL_SESSION_ID', 				'id_session');
define('COL_MESSAGE_GUID', 				'guid_msg');
define('COL_MESSAGE_TYPE', 				'type_msg');
define('COL_MESSAGE', 					'text_msg');
define('COL_USERNAME', 					'username');
define('COL_POSSTER', 					'poster_be');
define('COL_POSTER_USERNAME', 			'username_be');
define('COL_STOP_MESSAGE', 				'ind_stop_msg');
define('COL_UI_TIMESTAMP', 				'ts_msg_ui');

define('SUBS_TYPE_SYS',					'subs_type_sys'); 
define('SUBS_TYPE_GRID',				'subs_type_grid');

// PROPERTY FILES
define('PROPERTY_FILE_KEY_VALUE_DELIMITER',	':');
define('PROPERTY_FILE_VALUES_DELIMITER',	',');
define('PROPERTY_VALUE_TYPE_STRING', 		1);
define('PROPERTY_VALUE_TYPE_ARRAY', 		2);
define('PROPERTY_VALUE_TYPE_BOOLEAN', 		3);
define('PROPERTY_VALUE_TYPE_NUMERIC', 		4);

//define('PROPERTY_FOLDER_PATH_CALLABLES_BINDING_ADMIN', 	'etixpert/admin/config/callables');
//define('PROPERTY_FILE_CALLABLES_BINDING',	'et_callable_object_binding.prop');
//define('PROPERTY_FILE_CALLABLES_BINDING',	'et_callable_object_binding_V400.prop');


define('PROPERTY_TYPE_LOOKUP',						"lookup");
define('PROPERTY_TYPE_VIRTUAL_COL',					"generatedcolumn");
define('PROPERTY_TYPE_VIRTUAL_ELEM'	,				"customelement");
define('PROPERTY_VALUE_LOOKUP_NAME',				"lookup_name");
define('PROPERTY_VALUE_LOOKUP_SYS_TABLE',			"systemtable");
define('PROPERTY_VALUE_LOOKUP_USE_TABLE',			"ind_use_table");
define('PROPERTY_VALUE_LOOKUP_PROJ_LIST',			"projection_list");
define('PROPERTY_VALUE_LOOKUP_OBJ_FILTER',			"object_filter");
define('PROPERTY_VALUE_LOOKUP_ADD_NULL',			"ind_add_null");
define('PROPERTY_VALUE_LOOKUP_ORDER_BY',			"order_by");
define('PROPERTY_VALUE_VIRTUAL_COL_NAME',			"name");
define('PROPERTY_VALUE_VIRTUAL_COL_VALUE',			"value");
define('PROPERTY_VALUE_VIRTUAL_COL_META_TYPE',		"meta_type");
define('PROPERTY_VALUE_VIRTUAL_COL_ALIAS',			"alias");
define('PROPERTY_VALUE_VIRTUAL_ELEM_NAME',			"name");
define('PROPERTY_VALUE_VIRTUAL_ELEM_VALUE',			"value");

define('PROPERTY_VALUE_PREFIX_GENERATED_COL',		'$gcol');
define('PROPERTY_VALUE_PREFIX_VIRTUAL_ELEMENT',		'$ce');
define('PROPERTY_VALUE_PREFIX_COL',					'$col');

//logging errors and debug info
define('LOG_TYPE_ERROR',                    "error");
define('LOG_TYPE_ERROR_SQL',                "error_sql");
define('LOG_TYPE_DEBUG',                    "debug");
define('LOG_TYPE_ERROR_WS',                	"error_ws");

// default page for admin surface (loaded after clicking 'admin area' icon)
define('ADMIN_DEFAULT_PAGE', 						'admin.php');

// folder definition for batch commands
define('PROPERTY_FOLDER_PATH_CALLABLES',	'etixpert/admin/config/callables');

//array for warnings which should not be displayed on screen
define("WARNINGS_TO_THROW_AWAY",            ["odbc_free_result() expects parameter 1 to be resource",
											"oci_free_statement() expects parameter 1 to be resource",
											"Connection reset by peer",
											"unlink("
											]
);

//HELP ICON SETTINGS - SYSTEM
define('HELP_SYSTEM_FOLDER_SPLIT_BY_LANGUAGE', 	false);
//define('HELP_SYSTEM_FILE_GRID',				'$documentRoot/niota-v4.0.0/doc/doku.php?id=start');
//define('HELP_SYSTEM_FILE_ADMIN',              '$documentRoot/niota-v4.0.0/doc/doku.php?id=start');
define('HELP_ICON_TYPE_USER_CUSTOM',            'user-custom');
define('HELP_ICON_TYPE_USER_SYSTEM',            'user-system');
define('HELP_ICON_TYPE_ADMIN_CUSTOM',           'admin-custom');
define('HELP_ICON_TYPE_ADMIN_SYSTEM',           'admin-system');


//GRID EDIT
define("ERROR_NOT_NULL_VIOLATION",			"__col_must_be_filled__");

//LANGUAGE
define('LANGUAGE_EN', 						'en');
define('LANGUAGE_DE', 						'de');
define('PAGE_TYPE_SYSTEM',					'admin-page');
define('PAGE_TYPE_GRID',					'grid-page');


//EXCEL IMPORT/UPDATE
define("EXCEL_UPLOAD_REPLACE",				"upload");
define("EXCEL_UPLOAD_REPLACE_PARTIAL",		"upload-partial");
define("EXCEL_UPLOAD_UPDATE", 				"upload-update");
define("EXCEL_NOLOG_UPLOAD",				"ind_nolog_upload");
//FILE IMPORT
define("FILE_UPLOAD",						"upload-file");

//etx_catalog_object_config
define('CFG_ID_MAXNUMBER_VALIDATIONROW', 	'max_number_validation_row');
define('CFG_ID_MAXNUMBER_VALIDATIONERR', 	'max_number_validation_err');
define('CFG_ID_MAXNUMBER_VALIDATIONMSG', 	'max_number_validation_msg');

//etx_message
define('ETX_MESSAGE_LOG_MSG_LENGTH', 		2000);
define('ETX_MESSAGE_TABLE', 				'etx_message');
define('ETX_MESSAGE_DETAIL_LOG_MSG_LENGTH',	2000);

//validation feature
define('VALIDATION_TYPE_EXCEL', 			'validation-excel');
define('VALIDATION_TYPE_GRID_DIRECTLY',		'validation-grid');

//OS type for path handling
define('OS_WIN',							'os-win');
define('OS_LINUX',							'os-linux');

define('APPLICATION_CODE_SYSTEM',			'niota');


/***
 * it used to retrieve the niota-root directory
 * because of the frequent directory strucutre redesign now it retrieves the 'niota/app/' folder
 * @return string
 */
function getNiotaRootDir() {
	
	$documentRoot 		=  $_SERVER['DOCUMENT_ROOT'];
	$fullPath 			= dirname(__FILE__);
	$NiotaRootDir 		= '';
	$osWin 				= (strpos(strtoupper(PHP_OS), "WIN") !== FALSE) ? true : false;
	$slashType 			= $osWin ? '\\' : '/';
	$docRootLastDirName = "";
	
	//$_SERVER['DOCUMENT_ROOT'] uses the same / in win and linux, but  dirname(__FILE__) uses differnet (win: \ linux: / )	
	$fullPathDirNum = $osWin ? substr_count($fullPath, '\\')  : substr_count($fullPath, '/');
	
	if (strrpos($documentRoot, '/') !== strlen($documentRoot) - 1) {
		$docRootLastDirName = substr($documentRoot, strrpos($documentRoot, '/') + 1 );
	}
	else {
		$lastSlashPos 		= strrpos($documentRoot, '/');
		$tempStr 			= substr($documentRoot, 0, $lastSlashPos);
		$docRootLastDirName = substr($tempStr, strrpos($tempStr, '/')+ 1 );
	}
	
	$posDocRootLast 	= strpos($fullPath, $docRootLastDirName);		
	$pathPrepare 		= substr($fullPath, $posDocRootLast);
	$firstSlashForPath 	= $osWin ? strpos($pathPrepare, "\\") : strpos($pathPrepare, "/");
	
	$lastSlashPos 		= strrpos($fullPath, $slashType);
	$NiotaRootDirPrep 	= substr($pathPrepare, $firstSlashForPath + 1, $lastSlashPos);
	$lastSlashPos		= strrpos($NiotaRootDirPrep, $slashType);
	$NiotaRootDir 		= substr($NiotaRootDirPrep,0, $lastSlashPos);
	
	$NiotaRootDir 		= empty($NiotaRootDir) ? $NiotaRootDir : "/" . $NiotaRootDir;
		
	return $NiotaRootDir;
}

/***
 * it retrieves the niota/ folder without the 'app' subfolder
 */
function getNiotaRootDirBase() {
	
	$documentRoot 		=  $_SERVER['DOCUMENT_ROOT'];
	$fullPath 			= dirname(__FILE__);
	$NiotaRootDir 		= '';
	$osWin 				= (strpos(strtoupper(PHP_OS), "WIN") !== FALSE) ? true : false;
	$slashType 			= $osWin ? '\\' : '/';
	$docRootLastDirName = "";	
	
	$pathFromServerRoot = substr($fullPath, strlen($documentRoot));
	$lastSlashPos   = strrpos($pathFromServerRoot, $slashType);
	$nextSlashPos   = strrpos($pathFromServerRoot, $slashType, ($lastSlashPos + 1) * - 1);
	
	$withoutLastDir         = substr($pathFromServerRoot, 0, $lastSlashPos);
	$baseDir =  str_replace("\\", "/", $withoutLastDir);
	$baseDir = $baseDir . "/../";	
	//$baseDir = substr($baseDir, 0, strlen($baseDir) - 3);
	return $baseDir;
	
}

//---
// from db_references.php
// start
//---

//callable objects binding level
define('BINDING_LEVEL_TABLE',			 	0);
define('BINDING_LEVEL_LINE', 				1);

//user parameter settings
// saved default catalog for user

// user settings:
define('USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID', 	'default_catalog_instance_id');

// you can override the DEFAULT_CATALOG_DISPLAY_TEXT_PATTERN for a particular user
define('USER_PARAM_CATALOG_DISPLAY_TEXT_PATTERN', 	'catalog_display_text_pattern');

// you can override the DEFAULT_CATALOG_ORDER_BY for a particular user
define('USER_PARAM_CATALOG_ORDER_BY',			 	'catalog_order_by');

// position of the excel import and callable object windows
define('USER_PARAM_POPUP_POSITION_UPLOAD', 			'popup_position_upload');
define('USER_PARAM_POPUP_POSITION_CALLABLES', 		'popup_position_callables');
define('USER_PARAM_POPUP_POSITION_UPLOADANDPROCESS','popup_position_upload_and_process');

// user catalog settings:
// grid dimensions, e.g.: w=703;h=375
define('USER_PARAM_GRID_DIMENSONS',					'grid_dimensions');

// this prefix needs a column name, like: col_width_COL_NAME
// value: e.g. 213
define('USER_PARAM_COL_WIDTH',						'col_width');

// catalog specific caption for advanced filter dialog. for all users, use: *ANY
define('USER_PARAM_FILTER_CAPTION',					'caption_dynamic_filter');

// the user can open and close the left menubar, which contains the grid related menu items
// values: opened / closed
define('USER_PARAM_SIDEBAR_STATE',					'sidebar_state');

// same as 'USER_PARAM_SIDEBAR_STATE' but on admin pages
define('USER_PARAM_SIDEBAR_STATE_ADMIN',			'sidebar_state_admin');

// the user can open and close the table selector and filtering menu secgtion
// values: opened / closed
define('USER_PARAM_TABLE_SELECTOR_STATE',			'table_selector_state');

// values for  USER_PARAM_SIDEBAR_STATE and USER_PARAM_TABLE_SELECTOR_STATE
define('USER_PARAM_OPENED',							'opened');
define('USER_PARAM_CLOSED',							'closed');

// values for user parameter level
define('USER_PARAM_LEVEL_COLUMN',					'column');
define('USER_PARAM_LEVEL_CATALOG',					'catalog');
define('USER_PARAM_LEVEL_USER',						'user');

// KEY column of the et_user_parameter table
define('USER_PARAM_COL_NAME_KEY',					'param_id');

// swap admin menu item if available
define('USER_PARAM_SWAP',							'swap_table');
// the menu item in the case of reverse direction menu items
define('USER_PARAM_REVERSE_PAGE_MENU_ITEM',			'reverse_page_menu_item');

// the default page in the case of reverse direction menu items
define('USER_PARAM_REVERSE_PAGE_TARGET',			'reverse_page_target');

// the selected admin menu item
define('USER_PARAM_ADMIN_MENU_STATE', 				'admin_menu_state');

// if admin logs out from admin are after next login he/she'll land there
define('USER_PARAM_LOAD_ADMIN_PAGE_AFTER_LOGIN', 	'load_admin_page_after_login');

// catalog level parameters array
define('USER_PARAM_NAME_ARRAY_CATALOG_LEVEL',		[USER_PARAM_GRID_DIMENSONS, USER_PARAM_FILTER_CAPTION]);

// column level parameters array
define('USER_PARAM_NAME_ARRAY_COLUMN_LEVEL',		[USER_PARAM_COL_WIDTH, "col_name"]);

//verify link feature
define('USER_PARAM_VERIFYGUID',						'verify_guid');

// user level parameters array (only popup_position is handled differently)
define('USER_PARAM_NAME_ARRAY_USER_LEVEL',			[USER_PARAM_TABLE_SELECTOR_STATE, USER_PARAM_SIDEBAR_STATE, USER_PARAM_CATALOG_ORDER_BY,
USER_PARAM_CATALOG_DISPLAY_TEXT_PATTERN, USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID,USER_PARAM_POPUP_POSITION_UPLOAD,
USER_PARAM_POPUP_POSITION_CALLABLES, USER_PARAM_ADMIN_MENU_STATE, USER_PARAM_LOAD_ADMIN_PAGE_AFTER_LOGIN,
USER_PARAM_POPUP_POSITION_UPLOADANDPROCESS]);

//USER CONFIG:
//-----------------
//grid debug true/false
define('USER_CONFIG_DEBUG_GRID', 					'debug_grid');
//grid sql loglevel - number, 0-4
define('USER_CONFIG_SQL_LOGLEVEL', 					'debug_sql_loglevel');

//SQL -- the SQL_ prefix is already reserved so QUERY is used
//QUERY_ANY is used to refer to all users logical group only!
define('QUERY_ANY', 								'*ALL_GROUP');
define('QUERY_NONE',								'*NONE');

//dynamic menu:
//target page constants, ET_TRANSACTION, TARGETPAGE column possible values
define('TARGET_PAGE_NIOTA',				 			'niota.php');
define('TARGET_PAGE_EXECUTE_CALLBALE', 				'execute_callable.php');

// ET_CALLABLE_OBJECT, callobject_type:
// 0: stored procedure call
// 1: sql call

// ET_MASTER_DETAIL, linktype:
// 0: master-detail link
// 1: advanced filter link

// ET_CATALOG_OBJECT_CALLABLE, binding_level
// 0: table level
// 1: line level

// ET_CATALOG_OBJECT_COLUMN_PROP ordinal_position_pkey NEEDS TO BE SET FOR VIEWS!!!!

// CONSTRAINT operations are listed in :  ET_LOOKUP_VALUE_SYSTEM

// catalog instance name for admin object instances
define('INSTANCE_NAME_ADMIN_OBJECTS',				"*ADMIN");

// password column in et_user table
define ('COLUMN_NAME_PASSWORD', 					"password");

//categories in et_lookup_value_system table. Used in admin pages as lookups.
define('SYSTEM_LOOKUP_CONSTRAINT',					"constraint");
define('SYSTEM_LOOKUP_COLUMN_TYPE',					"column_type");
define('SYSTEM_LOOKUP_CALLABLE_OBJECT_TYPE',		"callable_object_type");
define('SYSTEM_LOOKUP_TARGET_PAGE',					"target_page");
define('SYSTEM_LOOKUP_USERGROUP_TYPE', 				"usergroup_type");
define('SYSTEM_LOOKUP_TRANSACTION_PARAM_NAME',		"transaction_param_name");
define('SYSTEM_LOOKUP_USER_PARAMETER',				"user_parameter");
define('SYSTEM_LOOKUP_CALLABLE_BINDING_LEVEL',		"callable_binding_level");
define('SYSTEM_LOOKUP_CONN_TPYE',					"conn_type");

define('SYSTEM_LOOKUP_TRANSACTION_PARAM_VALUE_POPUP',			"popup_filter");
define('SYSTEM_LOOKUP_TRANSACTION_PARAM_VALUE_SELECTED_INST',	"selected_instance");
//---
// from db_references.php
// end
//---

//admin page
define('ADMIN_CATALOG_INFO_TYPE_PK', 				"pk");
define('ADMIN_CATALOG_INFO_TYPE_IS_TABLE',			"is-table");

//registration page
//define("TERMS_OF_USE_DOCUMENT", 					"docs/terms_of_use.txt");
define("USERNAME_NOT_LOGGED_IN", 					"user-not-logged-in");
define("ACTIVATION_TIMEOUT",						"ACTIVATION_TIMEOUT");
define("ACTIVATION_DB_ERROR",						"ACTIVATION_DB_ERROR");
define("ACTIVATION_SUCCESS",						"ACTIVATION_SUCCESS");
define("ACTIVATION_CONFIG_ERROR",					"ACTIVATION_CONFIG_ERROR");
define("ACTIVATION_GUID_NOT_VALID",					"ACTIVATION_GUID_NOT_VALID");
define("ACTIVATION_ALREADY_ACTIVATED",				"ACTIVATION_ALREADY_ACTIVATED");


// logical log levels
define('LOGLEVEL_MUTE', 				0);
define('LOGLEVEL_WHISPER', 				1);
define('LOGLEVEL_TALK', 				2);
define('LOGLEVEL_SHOUT', 				3);

// grid format option constants:
define('GFO_TYPE_DEBUG',			'autoformat');
define('GFO_GRID_CAPTION',			'set_caption');
define('GFO_GRID_PAGESIZE',			'set_pagesize');
define('GFO_FORM_DIMENSION',		'set_form_dimension');
define('GFO_MULTISELECT',			'set_multiselect');
define('GFO_CONDITIONAL_FORMAT',	'set_conditional_format');

define('GFO_ROWNUMBERS',			'enable_rownumbers');
define('GFO_ADVANCED_SEARCH',		'enable_advanced_search');


define('GFO_COL_TITLE',				'set_col_title');
define('GFO_COL_HEADERTOOLTIP',		'set_col_headerTooltip');
define('GFO_COL_DEFAULT',			'set_col_default');

define('GFO_COL_EDITTYPE',			'set_col_edittype');
define('GFO_COL_PROPERTY',			'set_col_property');

define('GFO_COL_READONLY',			'set_col_readonly');
define('GFO_COL_REQUIRED',			'set_col_required');
define('GFO_COL_HIDDEN',			'set_col_hidden');


define('GFO_CHECKBOX',				'checkbox');
define('GFO_TEXTAREA',				'textarea');
define('GFO_EDITOPTIONS',			'editoptions');
define('GFO_FORMOPTIONS',			'formoptions');

define('GFO_ROWS_PROPERTY',			'rows');
define('GFO_COLS_PROPERTY',			'cols'); 
define('GFO_SIZE_PROPERTY',			'size'); 
define('GFO_MAXLENGTH_PROPERTY',	'maxlength'); 
define('GFO_FORM_ROWPOS',			'rowpos');
define('GFO_FORM_COLPOS',			'colpos'); 

?>