<?php

	require_once __DIR__ . '/../conf/conf.php';

	if(!isset($_SESSION))
		session_start();

	if(isset($_SESSION['username'])){
		
		$username 			= $_SESSION[SESS_USERNAME];
		$connMetaName 		= ET_ConnHelper::getMetaDataConnectionName();
		$connMeta 			= ET_ConnHelper::getConnection($connMetaName);
		$connMetaType 		= ET_ConnHelper::getConnectionTypeByName($connMetaName);		
		$filterConnection 	= FILTER_ALL;
		$filterCategory 	= FILTER_ALL;
		
		if(isset($_POST['filter_type']) && !empty($_POST['filter_type'])){
			$selected 	= $_POST['selected'];
			$filter 	= $_POST['filter_type'];
			$catalogInstanceId = "";
			$metaConnector 			= ET_MetaDataConnector::getInstance();			
			$selectFilteredTables 	= new HTMLSelect();
			$niotaUser		 		= ET_NiotaUser::getNiotaUserFromSession();
			$ret		  			= "";
		
			$optionDataForFilteredTables 	= array();
			$visibleTablesFiltered			= array();
						
			if($filter == "connectionFilter" ) {
				$_SESSION[FILTER_CONNECTION] = $selected;
			} else if($filter == "categoryFilter" ){
				$_SESSION[FILTER_CATEGORY] = $selected;
			}
				
			if (isset($_SESSION[FILTER_CONNECTION]))
				$filterConnection = $_SESSION[FILTER_CONNECTION];
					
			if (isset($_SESSION[FILTER_CATEGORY]))
				$filterCategory = $_SESSION[FILTER_CATEGORY];
			
			$visibleTablesFiltered = $niotaUser->get_visibleCatalogInstances($filterConnection, $filterCategory);
			
			$selectFilteredTables->set_style('width: ' . WIDTH_TABLE_SELECTOR)->set_onchange("javascript:this.form.submit();")->set_id("instance_select")->set_name('selected_instance');
			
			$selectedCatalogInstanceId = "";
			if (isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]))
				$selectedCatalogInstanceId = $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
					
			$catalogPattern = ET_DisplayHelper::getCatalogPattern($niotaUser);
			$wasSelected = false;
			
			for($i = 0; $i < count($visibleTablesFiltered); $i++){
				$selectedString = '';
			
				$catalogInstanceId = $visibleTablesFiltered[$i]['catalog_id'] . "." . $visibleTablesFiltered[$i]['instance_name'];
				if ($catalogInstanceId == $selectedCatalogInstanceId && !isset($_POST['popup_filter'])) {
					$selectedString = 'selected';
					$wasSelected = true;
				}
					

				$displayText = ET_DisplayHelper::getCatalogItemDisplayText($visibleTablesFiltered[$i], $catalogPattern);
					
				$optionDataForFilteredTables[] = [
						"name"=>$catalogInstanceId, 
						"value"=>$catalogInstanceId,
						"displayText"=>$displayText,
						"selected"=>$selectedString
				];
			}
			
			$firstLine = (!$wasSelected) ? ET_DisplayHelper::localize("FILTER_TABLE", null, PAGE_TYPE_GRID) : "";
			
			if (isset($_POST['popup_filter']) && $_POST['popup_filter'] == "true") {				
				$firstLine = "** " . ET_DisplayHelper::localize("POPUP_FILTER", null, PAGE_TYPE_GRID) . " **";
			}
			
			$ret .= $selectFilteredTables->generateWholeSelect($optionDataForFilteredTables, $firstLine, true, 'instance_select');
				
			echo $ret;			
		}
		else
			return;
	}
	else {
		$location = ET_PathHelper::getLoginPathWithClientDef();
		header("Location: $location");
	}