<?php

	function getSessionVariable($variableName) {
		if (isset($_SESSION[$variableName]))
			return $_SESSION[$variableName];
		else return "";
	}
	
	function getUserInfoFromSession() {
		$ret = array();
		$ret['firstname'] = getSessionVariable('firstname');
		$ret['lastname'] = getSessionVariable('lastname');
		$ret['email'] = getSessionVariable('email');
		$ret['phone'] = getSessionVariable('phone');
		$ret['administrator'] = getSessionVariable('administrator');
		$ret['username'] = getSessionVariable('username');
		return $ret;
	}
	
	function saveUserInfoIntoSession($userInfo) {
		$_SESSION['firstname'] = $userInfo['firstname'];
		$_SESSION['lastname'] = $userInfo['lastname'];
		$_SESSION['email'] = $userInfo['email'];
		$_SESSION['phone'] = $userInfo['phone'];
	}
	
	function getUserInfoFromDatabase($userName, $con) {
		$ret = array();
		
		$ret['administrator'] 	= 'false';
		$ret['firstname'] 		= '';
		$ret['lastname'] 		= '';
		$ret['email'] 			= '';
		$ret['phone'] 			= '';
		$ret['allowLdap']		='';
		$ret['ldapUsername']	='';
		
		$table = getCorrectedTableName("et_users");
		
		$query = "SELECT administrator, email, firstname, lastname, phone, allow_ldap_auth, ldap_username FROM " . $table . " WHERE username = '$userName'";
		
		$result = $con->Execute($query);
		if ($result) {
			$administrator 	= $result->fields[0];
			$email 			= $result->fields[1];
			$firstname 		= $result->fields[2];
			$lastname 		= $result->fields[3];
			$phone 			= $result->fields[4];
			$allowLdap 		= $result->fields[5];
			$ldapUsername	= $result->fields[6];
	
			if ($administrator == 1)	$ret['administrator'] = 'true';
			if ($email != null) 		$ret['email'] = $email;
			if ($firstname != null) 	$ret['firstname'] = $firstname;
			if ($lastname != null) 		$ret['lastname'] = $lastname;
			if ($phone != null) 		$ret['phone'] = $phone;
			if ($allowLdap != null)		$ret['allowLdap'] = $allowLdap;
			if ($ldapUsername != null)	$ret['ldapUsername'] = $ldapUsername;
		} 
		
		return $ret;
	}
		
	function saveUserInfo($userInfo, $con) {
		$table = getCorrectedTableName("et_users");
		$firstName = $userInfo['firstname'];
		$lastName = $userInfo['lastname'];
		$email = $userInfo['email'];
		$phone = $userInfo['phone'];
		$userName = $userInfo['username'];
		
		$query = "update $table set firstname = '$firstName', lastname = '$lastName', email = '$email', phone = '$phone' where username = '$userName'";
		//print($query);
		$result = $con -> Execute($query);
		if ($result) {
			return true;
		} else {
			return false;
		}
	}

	function checkOldPassword($userName, $password, $con) {
		$ret = false;
		$table = getCorrectedTableName("et_users");
		
		$query = "select passwd from $table where username = '$userName'";
		//print($query);
		$result = $con -> Execute($query);
		if ($result) {
			$rows = $result->rowCount();
			if ($rows == 1) {
				
				$passwordHash = $result->fields[0];

				if (isPasswordCorrect($password, $passwordHash))
					return true;
			}
		} 
		return $ret;
	}
	
	function replacePassword($sqlCrud) {
		$i = strpos($sqlCrud, "et_users") || strpos($sqlCrud, "ET_USERS");
	
		if ($i) {
			//update sql crud
			$j = strpos($sqlCrud, "PASSWD='");
			if ($j) {
				$startpwd = $j + 8;
				$endpwd = strpos($sqlCrud, "'", $startpwd);
				$pwd = substr($sqlCrud, $startpwd, $endpwd - $startpwd);
	
				$sqlCrud = substr($sqlCrud, 0, $startpwd) . hashPassword($pwd) . substr($sqlCrud, $endpwd);
	
			} else {
				//insert into sql crud
				$l = strpos($sqlCrud, "INTO");
				if ($l) {
					$k = strpos($sqlCrud, "VALUES");
					$k = strpos($sqlCrud, "'", $k);
					$k = strpos($sqlCrud, "'", $k + 1);
					$k = strpos($sqlCrud, "'", $k + 1);
					if ($k) {
						$startpwd = $k + 1;
						$endpwd = strpos($sqlCrud, "'", $startpwd);
						$pwd = substr($sqlCrud, $startpwd, $endpwd - $startpwd);
						$sqlCrud = substr($sqlCrud, 0, $startpwd) . hashPassword($pwd) . substr($sqlCrud, $endpwd);
					}
				}
			}
		}
		return $sqlCrud;
	}
	
	function changePassword($userName, $password, $con) {
		$table = getCorrectedTableName("et_users");
		
		$passwordHash = hashPassword($password);
		
		$query = "update $table set passwd = '$passwordHash' where username = '$userName'";
		$result = $con -> Execute($query);
		if ($result) {
			return true;
		} else {
			return false;
		}
	}
	
	function getHelp($infoKey) {
		?>
		<img src="images/help.png" class="info_button_<?=$infoKey?>" id="info_button_id" height="30" title="Help"/>
		<?php
		$content = "Infobox text is not available for key: " . $infoKey;
			try {
				$dom = new DOMDocument();
				$newdoc = new DOMDocument();
				$dom->loadHTMLFile("info/infos.html");
				$cloned = $dom->getElementById($infoKey)->cloneNode(true);
				$newdoc->appendChild($newdoc->importNode($cloned,TRUE));
				$content = $newdoc->saveHTML();
			} catch (Throwable $e) {
				
			}
		?>

		<div id="modal_<?=$infoKey?>" style="display: none;" class="modal" >
			<?=$content?>
			<img src="images/close.png" class="close info_button_<?=$infoKey?>"/>
		</div>
		<script type="text/javascript">

			$('.info_button_<?=$infoKey?>').click(function (e) {
				var d = $("#modal_<?=$infoKey?>").css("display");
				if (d == 'none') {
				    var x =e.pageX -$(document).scrollLeft();
				    var y =e.pageY -$(document).scrollTop();
				    $('[class^="modal"]').css("display", "none");
					$("#modal_<?=$infoKey?>").css("display", "block");
					$("#modal_<?=$infoKey?>").css("top", "" + (y + 10) + "px");
					$("#modal_<?=$infoKey?>").css("left", "" + (x + 15) + "px");
				}
				else {
					$("#modal_<?=$infoKey?>").css("display", "none");
				}
			});
		</script>
		<?php 
	}
	
	 
?>