	
	
	function filterConnectionsAndCategory(isConnFilter, popupFilter){
		var container 	= $("#table_sel_wrapper");
		var selected 	= null;
		var filterType 	= "";
		
		if(isConnFilter){
			selected = $('#conn_filter').val();
			filterType = "connectionFilter";
		}
		else{
			selected = $('#category_filter').val();
			filterType = "categoryFilter";
		}
		
		
		if(selected !== "---"){
			$.ajax({
				method: 'post',
				url: "filter_option.php",
				data: {
					"filter_type" : filterType,
					"selected" : selected,
					"popup_filter" : popupFilter
				},
				success: function(data){					
					container.html(data);
					$('#instance_select').select2();
				}
			});
		}
		else
			return;
	}
	
	function handleLoginForm(){
		var container 	= $("#feedback_content");
		var username 	= $("#username").val();
		var password 	= $("#password").val();
	
		if(username !== "" || password !== ""){
			$.ajax({
				method: 'post',
				url: "etixpert/login_handler.php",
				data: {
					"username" : username,
					"password" : password	
				},
				success: function(data){				
					container.html(data);
				}
			});
		}
		else
			return;
	}
	
	
	function sendCallables(co_name, co_binding_level, selected_rows, optionKey) {
		
		var containerCell 	= $("#call_result_" + co_name);		
		var page			= (optionKey == "" || optionKey == null) ? "callableObjectHandler.php" : "../callableObjectHandler.php"
			
		$.ajax({
			method: 'post',
			url: page,
			data: {
				"co_source"  		: "grid",		
				"co_name" 			: co_name,
				"co_binding_level" 	: co_binding_level,
				"selected_rows" 	: selected_rows,	
				"option_key"		: optionKey
			},
			success: function(data){
				
				try {
					var ret 			= JSON.parse(data);
					var cellContent 	= ret.cell_content;
					
					$('[name="result_cell"]').html("");
					containerCell.html(cellContent);
					handleCallableMessageDislpay(data);
				} catch (e) {
					if (typeof(data) == "string" && data.substring("SOAP-ERROR")) {
						//JSON.parse fails because of some characters in the URL (in the error msg)
						//(handleCallableMessageDislpay() function)
						//so this not so nice solution is used
						alert(data);
					} else {
						alert(e);
					}
				}				
			}
		});
	
	}
	
	function dynamic_menu_transction_call (co_name, menu_label) {
		
		var hidden = $("#dynamic_menu_feedback");
		
		$.ajax({
			method: 'post',
			url: "callableObjectHandler.php",
			data: {					
				"co_source" : "menu",
				"callable_object" : co_name,
				"menu_label" : menu_label
			},
			success: function(data) {		
				handleCallableMessageDislpay(data);		
			}
		});
		
	}
	
	function handleCallableMessageDislpay (data) {
				
		var ret 			= null;
		try {
			ret = JSON.parse(data);
		} catch (e) {
			alert(e + " " + data);
		}
					
		var message 		= ret.message;			
		var messageHeader 	= ret.header;
		
		var containerMessage 		= $("#dynamic_menu_feedback_content");
		var containerMessageHeader 	= $("#dynamic_menu_feedback_header");
		var hiddenMessage			= $("#dynamic_menu_feedback");
		
		containerMessageHeader.html(messageHeader);
		
		if (message == false) {
			hiddenMessage.css('display', 'none');
		}
		
		if (message != '')
			containerMessage.html(message);
		else
			containerMessage.css('display', 'none');				
		
		if (messageHeader != "" || message != "") {
			hiddenMessage.css('display', 'block');
			
			if (message != "") {
				containerMessage.css('display', 'block');
			}
		}
	}
	
	
	function dynamic_menu_set_session(liId, form) {
		
		var containerReplay = $("#replay_container");
		lastExecuted 		= $("#" + liId).html();		
		id 					= liId.substring(3);
		
		$.ajax({		
			method: 'post',
			url: "callableObjectHandler.php",
			data: {					
				"replay_last" : "yes",
				"last_executed" : lastExecuted,
				"id" : id,
				"form" : form
			},
			success: function(data){				
				containerReplay.html(data);			
			}
		});
	}
	
	/***
	 * 
	 * @param personal_data - boolean
	 * @param fromAdminPage - boolean
	 * @returns
	 */
	function personal_post(personal_data, fromAdminPage, pageName) {
		
		var url 		= fromAdminPage ?  "../personal_handler.php" : "personal_handler.php";
		
		if (personal_data) {
			
			var firstname 	= $("#firstname").val();
			var lastname 	= $("#lastname").val();
			var email 		= $("#email").val();
			var phone 		= $("#phone").val();		
			var container 	= $("#personal_feedback_pers_container");
			var language	= $("#lang_grid").val();
			
			$.ajax({
				method: 'post',
				url: url,
				data: {					
					"data_update" : "yes",
					"page_name" : pageName,
					"firstname" : firstname,
					"lastname" : lastname,
					"email" : email,
					"phone" : phone,
					"lang_grid" : language
				},
				success: function(data){		
					
					if (data.trim() == 'reload') {					
						document.getElementById("personal_blank").submit();
					}else{					
						container.html(data);
					}			
				}
			});		
		}
		else{
				
			var password 		= $("#password").val();	
			var password_new 	= $("#password_new").val();
			var password_new_re = $("#password_new_re").val();
			var container 		= $("#personal_feedback_pw_container");
			
			$.ajax({
				method: 'post',
				url: url,
				data: {					
					"password_update" : "yes",
					"page_name" : pageName,
					"password" : password,
					"password_new" : password_new,
					"password_new_re" : password_new_re
				},
				success: function(data){
					
					if (data.trim() == "reload") {
						document.getElementById("personal_blank").submit();
					} else {
						container.html(data);
					}
				}
			});		
		}	
	}
	
	
	function save_reversable_direction (menuitem_key, current_page) {
		
		if (menuitem_key != '' && current_page != '') {		
			
			$.ajax({
				method: 'get',
				url: "../personal_handler.php",
				data: {					
					"swap_table" : "yes",
					"menu_item" : menuitem_key,
					"page" : current_page				
				}		
			});	
		}
	}
	
	function save_admin_menu_state (adminPageURL) {
				
		if (adminPageURL != "") {
			$.ajax({
				method: 'get',
				url: "../personal_handler.php",
				data: {					
					"admin_menu_state" : "yes",
					"admin_url" : adminPageURL				
				}		
			});			
		}			
	}
	
	function saveCurrentSurface(callFromGridArea) {
		
		var url 				= callFromGridArea ? "personal_handler.php" : "../personal_handler.php";
		var logoutFromAdminPage = callFromGridArea  ? true : false;
		
		$.ajax({
			method: 'get',
			url: url,
			data: {					
				"logoutFromAdminPage" : logoutFromAdminPage	
			}
		});	
	}
	
	function sendEncryptDecrypt (encrypt) {
		
		var string 		= $("#encrypt_input").val();
		var container 	= $("#encrypt_output");
		
		if (string == '') {
			return;
		}
		
		$.ajax({
			method: 'post',
			url: 'etixpert/toolsHandler.php',
			data: {					
				"string" : string,
				"encrypt" : encrypt
			},
			success: function (data) {
				
				container.val(data);
			}
		});
		
	}

	// TODO - edit to call function dynamic_menu_transaction_call()
	// if the source is that and file upload succeeded.
	// make this id a real id: var callableArray = $("#callable_to_pass");
	
	function handleCOFileProcess(optionKey) {
		
		var fileCheck = checkFileUpload('upload-file');
		
		if (!fileCheck) 
			return;
		
		var co_name 			= "";
		var co_binding_level 	= "";
		var selected_rows 		= null;
		var formData 			= new FormData();
		
		if (typeof(getSelRows) != "undefined") {
			selected_rows = getSelRows();
		}
		
		formData.append("file_to_upload", $("#test_file_upload")[0].files[0]);
		formData.append("upload_and_process", "yes");
		
		$.ajax ({
			method: 'post',
			url: 'file_upload_status.php',
			data: formData,
			processData: false,
			contentType: false,
			success: function (data) {
				
				if (data.trim() == "success") {
					
					var callableArray 	= $("#callable_to_pass");					
					var values 			= JSON.parse(callableArray[0].value);
					var callSource 		= "grid";
					var menu_label		= "";
					co_name 			= values.name;
					co_binding_level 	= values.binding_level;
										
					if (values.label != null || values.label != undefined) {
						menu_label = values.label;
						callSource = "menu";
					}
					
					if(callSource == "grid") {
						sendCallables(co_name, co_binding_level, selected_rows, optionKey);
					} else if (callSource == "menu") {						
						dynamic_menu_transction_call(co_name, menu_label); 
					}					
					
					closeDefault("uploadandruncallable");
					$("#test_file_upload")[0].value = "";
				} else if(data.trim() == "failure") {
					alert("File upload failed");
				} else {
					alert("Upload error");
				}
			}	
		});
	}

	function handleGridValidation(imgFolderPath) {
		
		var divContent 	= document.getElementById("main_content");
		var divModal	= document.createElement("div");
		var divMsg 		= document.createElement("div");
		var imgClose	= document.createElement("img");
		var divClose	= document.createElement("div");
		
		divModal.id = "validationModal";
		divModal.classList.add("modal_personal");		
		
		divContent.appendChild(divModal);
		divModal.style.display = "block";
		
		divClose.classList.add("float-right");
		
		imgClose.classList.add("pointer");
		imgClose.classList.add("float-right");
		
		imgClose.src = imgFolderPath + "close.png";
		imgClose.onclick = function(){ereaseModal("validationModal")};
		
		imgClose.style.display = "block";
		divClose.appendChild(imgClose);
		
		divMsg.id = "validationStatus";
		divMsg.classList.add("modal_personal_content");
				
		divModal.appendChild(divMsg);
		
		var msgContentP		 	= document.createElement("p");	
		msgContentP.id 			= "msgContentP";
		msgContentP.innerHTML 	= "<br>initializing...";
		
		divMsg.appendChild(divClose);
		divClose.style.display = "block";
		divClose.style.width = "100%";
		divMsg.appendChild(msgContentP);
		
		$.ajax ({
			method: 'post',
			url: 'validation_handler.php',
			data: {
				"validationRequest" : "yes"
			},
			
			success: function (data) {
				
				var ret 		= JSON.parse(data);
				var from 		= ret.from + 1;
				var rowCount 	= ret.rowCount;
				var to 			= parseInt(rowCount) === 1 ? 1 : parseInt(ret.to) + 1;								
				var error 		= ret.error;
				var msgGuid		= ret.msgGuid;
				
				if (error) {
					ereaseModal("validationModal");
					alert(ret.errorMsg);					
					return;
				} else if (rowCount == 0 ) {
					ereaseModal("validationModal");
					alert("Table is empty! Validation process is canceled.");					
					return;
				} else {
					divMsg.style.display = "block";
					
					//msgContentP.innerHTML = "All lines to process: " + rowCount + ".<br> Processing from line: " + from + " to line: " + to + 
					//"<br>log message id: " + msgGuid;
					msgContentP.innerHTML = ret.msg_process_status;
					sendChunkProcessingRequest(msgGuid, imgFolderPath);
				}
			}	
		});
		
	}

	function sendChunkProcessingRequest(msgGuid, imgFolderPath) {
				
		var divModal 	= document.getElementById("validationModal");
		var divMsg 		= document.getElementById("validationStatus");
		
		
		$.ajax ({
			method: 'post',
			url: 'validation_handler.php',
			data: {
				"chunkProcessRequest" : "yes",
				"msgGuid"	: msgGuid
			},
			success: function (data) {
				var ret 		= JSON.parse(data);
				var finished 	= ret.finished;
				var from 		= null;
				var to 			= null;
				var rowCount 	= null;
				var logError	= ret.error_logging;
				//displayes elements:
				var divClose	= document.createElement("div");
				var imgClose 	= document.createElement("img");
				var spanTitle	= document.createElement("span");
				/*because of explorer i have to make it in 2 lines instad of one*/
				imgClose.classList.add("pointer");
				imgClose.classList.add("float-right");				
				imgClose.src = imgFolderPath + "close.png";
				imgClose.onclick = function(){ereaseModal("validationModal")};
				
				if (logError  == true || logError == 'true') {
					
					var imgErr = document.createElement("img");
					imgErr.classList.add("float-left", "element-inline", "margin-right-5px");
					imgErr.src = imgFolderPath + "co_msg_err.png";
					
					divMsg.innerHTML = "";
					divMsg.appendChild(divClose);
					divClose.classList.add("float-right");
					divClose.style.display = "block";
					divClose.style.width = "100%";
					
					divClose.appendChild(imgClose);					
										
					spanTitle.classList.add("element-inline");
					spanTitle.innerHTML = ret.error_logging_msg;
					divMsg.appendChild(imgErr);
					divMsg.appendChild(spanTitle);
					
				} else {
					if (finished == true || finished == 'true') {						
						
						var divTitle 	= document.createElement("div");								
						
						divMsg.innerHTML = "";
						divTitle.classList.add("co-message-div", "vertical-middle-content", "co-summary");
						
						spanTitle.classList.add("element-inline");
						spanTitle.innerHTML = ret.init_msg;
						
						divMsg.appendChild(divClose);
						divClose.classList.add("float-right");
						divClose.style.display = "block";
						divClose.style.width = "100%";
						
						divClose.appendChild(imgClose);					
						divTitle.appendChild(spanTitle);
						divMsg.appendChild(divTitle);					
						
						setUpSummaryMsg(ret.summary, imgFolderPath);
						imgClose.style.display = "block";
						
						return;
						
					} else {
						var msgContentP =  document.getElementById("msgContentP");
						from	= ret.from + 1;
						
						if (ret.to != null) {
							to 		= ret.to + 1;
						}
							
						
						rowCount	= ret.rowCount;						
						//msgContentP.innerHTML = "All lines to process: " + rowCount + ".<br> Processing from line: " + from + " to line: " + to +" <br>log message id: " + msgGuid;
						msgContentP.innerHTML = ret.msg_process_status;
					
						sendChunkProcessingRequest(msgGuid, imgFolderPath);
					}
				}
					
			}
		});
	}
	
	function setUpSummaryMsg(summary, imgFolderPath) {
		//debugger;
		var summaryArr = summary.split("\n");
		var divDetails	= document.createElement("div");
		var divMsg =  document.getElementById("validationStatus");
		divDetails.classList.add("dynamic_menu_feedback_content");
		
		for (var i = 0; i < summaryArr.length; i++) {
			
			var divInf = document.createElement("div");
			var imgInf = document.createElement("img");
			var spanMsg  = document.createElement("span");
			
			divInf.classList.add("co-message-div", "vertical-middle-content");
			
			imgInf.classList.add("float-left", "element-inline", "margin-right-5px");
			imgInf.src = imgFolderPath + "co_msg_inf.png";
			
			spanMsg.classList.add("element-inline");
			spanMsg.innerHTML = summaryArr[i];
			
			divInf.appendChild(imgInf);
			divInf.appendChild(spanMsg);
			divDetails.appendChild(divInf);
		}
		
		divMsg.appendChild(divDetails);
		divDetails.style.display = "block";
	}

	function ereaseModal(id) {
		//debugger;
		var divContent 	= document.getElementById("main_content");
		var modal 		= document.getElementById(id);
		
		divContent.removeChild(modal);
	}