<?php
		
	function handleLoginPost(){
		
		if(isset($_POST['username'])){
			$username 				= $_POST['username'];
			
			$password 				= $_POST['password'];			
			$passwordFromDb			= "";
			$authenticationData 	= array();
			
			$isActive				= false;
			$isLdapActive			= false;
			$isPasswordCorrect		= false;
			$isLdapAuthenticated	= false;
				
			//checking wrong chars in username
			if(!empty($username) && !(ET_StringCheck::checkForSpecChars($username))){
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("WRONG_CHARACTERS_IN_USER", null, PAGE_TYPE_SYSTEM, true), "login");
				return;
			}
				
			// getting ldap and password and active data			
			try{
				$authenticationData = ET_MetaDataConnector::getInstance()->getBasicAuthenticationData($username);
			}
			catch (ET_NiotaException $e) {
				ET_DisplayHelper::addErrorLine($e->getMessage(), "login");
				return;
			}
			catch (Exception $ex) {				
				ET_DisplayHelper::addErrorLine($ex->getMessage(), "login");
				return;
			}
			if (is_null($authenticationData)) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_LOGIN_CONN", null, PAGE_TYPE_SYSTEM, true), "login");
				return;
			}
			else if (empty($authenticationData) || $authenticationData == false) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("INVALID_USER_CREDENTIALS", null, PAGE_TYPE_SYSTEM, true), "login");
				return;
			}
			$passwordFromDb		= $authenticationData['password'];
			$isActive			= $authenticationData['ind_active'];
			$isLdapActive		= $authenticationData['isLdapActive'];	
			$userNameFromDb		= $authenticationData['username'];
			
			if (!$isActive) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_INACTIVE_USER", null, PAGE_TYPE_SYSTEM, true), "login");
				return;
			}
			
			if ($isLdapActive) {
				$ldapAuthenticator 		= new ET_LDAPSAuthentication();
				
				if ($ldapAuthenticator->isConnectionError()) {
					return;
				}
				else {
					try {
						$isLdapAuthenticated 	= $ldapAuthenticator->makeLDAPSlogin($username, $password);
					} catch (Exception $e) {
						ET_DisplayHelper::addErrorLine($e->getMessage(), "login");
						return;
					}
				}
					
			}
			else{				
				$isPasswordCorrect = password_verify($password, $passwordFromDb);
			}
			
			if($isPasswordCorrect || $isLdapAuthenticated) {					
				
				$user 			= new ET_NiotaUser($username);
				$browsingStore	= new ET_BrowsingStore();
				
				//$_SESSION[SESS_USERNAME] = $username;
				$_SESSION[SESS_USERNAME] = $userNameFromDb;
				
				$user->flushNiotaUser();				
				$browsingStore->flushBrowsingStore();
				$_SESSION['first_login'] = true;
				
				$userSettings = $user->get_userSettings();
				
				if (isset ($userSettings[USER_PARAM_LOAD_ADMIN_PAGE_AFTER_LOGIN]) && $userSettings[USER_PARAM_LOAD_ADMIN_PAGE_AFTER_LOGIN] == "true") {
					
					$adminPage = isset($userSettings[USER_PARAM_ADMIN_MENU_STATE]) ? $userSettings[USER_PARAM_ADMIN_MENU_STATE] : null;
					if (!is_null($adminPage)) {
						header("Location: etixpert/admin/$adminPage");
					}
					else {
						header("Location: etixpert/admin/admin.php");
					}
				}
				else {
					header('Location: etixpert/niota.php');
				}
			}
			else{
				$errorMsg = $isLdapActive ? "INVALID_USER_CREDENTIALS_LDAP" : "INVALID_USER_CREDENTIALS_NIOTA";
				
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize($errorMsg, null, PAGE_TYPE_SYSTEM, true), "login");
			}			
		}
	}
	
	
	
	