<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
	
<?php 

	if(!isset($_SESSION))
		session_start();
		
	include("../conf/conf.php");
	include_once("niota_helper.php");
	
	function exception_handler($exception) {
		
		if (!isset($_SESSION["uncought_exception"]))
			$_SESSION["uncought_exception"] = "";
			
			if (!empty($exception)) {
				$_SESSION["uncought_exception"] .= $exception;
			}
			if (!is_null($exception->getPrevious()))
				$_SESSION["uncought_exception"] .= "<br>" . $exception->getPrevious();
				
			echo "<script>window.location = 'error.php';</script>";
			
	}
	
	function error_handler ($error, $errString) {
		
		$responseStr    = "";
		$systemLogger   = new ET_LoggingHelperSystem();
		
		if (!isset($_SESSION["uncought_error"]))
			$_SESSION["uncought_error"] = "";
			
			if (!empty($errString)) {
				$_SESSION["uncought_error"] .= $errString;
			}
			
			if ($error === E_WARNING || $error == E_NOTICE) {
				
				$errorType = $error == E_WARNING ? "Warning! " : "Notice! ";
				
				if ($error == E_WARNING && !shouldThrowAwayWarning ($errString)) {
					//$responseStr .= $errorType . " " . ET_DisplayHelper::localize("MISCONFIGURATION_GENERAL") . " " . $errString;
					$responseStr .= $errorType . " " . $errString;
					
					if (isset(debug_backtrace()[0]))
						$responseStr .= " Stack trace:";
						
					for ($i = count(debug_backtrace()) -1; $i >= 0; $i--) {
						
						$backTrace =  debug_backtrace()[$i];
						if (isset($backTrace["file"])) {
							$responseStr .=  "<br>" . $backTrace['file'] . " Line: " .  $backTrace['line'];
						}
					}

					$systemLogger->addSystemLogEntry(LOG_TYPE_ERROR, $responseStr);					
					$_SESSION["uncought_error"] = "";
				}
			}
			else {
				echo "<script>window.location = 'error.php';</script>";
			}
			
	}

	set_exception_handler("exception_handler");
	set_error_handler("error_handler");
	
	ET_CookieHandler::testCookieAccept();
	
	if(isset ($_SESSION['username'])){
		
		ini_set('max_execution_time', 3000);		
		$phpFileName 			= basename(__FILE__, ".php");
		
		//set log details which can be overwritten later
		ET_LoggingHelper::setLogInfo(ET_MetaDataConnector::getInstance()->getLoggingSettings());
		
		$htmlTag 				= new HTMLhtml();
		$headTag 				= new HTMLHead();
		
		$bodyTag 				= new HTMLBody();
		$divSidebarHeader		= new HTMLDiv();
		$divSidebar 			= new HTMLDiv();
		$divContent 			= new HTMLDiv();
		$divUpperLine 			= new HTMLDiv();
		$divLowerLine 			= new HTMLDiv();
		$divMain 				= new HTMLDiv();
		$divSelectWrap			= new HTMLDiv();
		$divNaviIconWrap		= new HTMLDiv();
		$divSelectTable			= new HTMLDiv();
		$divSelectConn			= new HTMLDiv();
		$divSelectCategory		= new HTMLDiv();
		$divGridContainer		= new HTMLDiv();
		$divOpenCloseMenu		= new HTMLDiv();
		$divReplayCallable		= new HTMLDiv();
		$divDynamicContainer	= new HTMLDiv();
		$divLogoAndTitleOuter	= new HTMLDiv();
		$divLogoAndTitleInner	= new HTMLDiv();
		
		$imgLogo				= new HTMLImage();
		$imgLogout 				= new HTMLImage();
		$imgPersonal			= new HTMLImage();
		$imgAdminPage			= new HTMLImage();
		$imgHelpCustom			= new HTMLImage();
		$imgHelpSystem			= new HTMLImage();
		$imgCloseSidebar		= new HTMLImage();		
		$imgOpenCloseTableSelector	
								= new HTMLImage();
		$imgArrowRight			= new HTMLImage();
		$imgArrowDown			= new HtmlImage();
		
		$spanProdName			= new HTMLSpan();
		$spanClaim				= new HTMLSpan();
		$spanName				= new HTMLSpan();
		
		$aLogout				= new HTMLa();
		$aPersonal				= new HTMLa();
		$aNiotaPage				= new HTMLa();
		$aOpenMenu				= new HTMLa();
		$aHelpCustom			= new HTMLa();
		$aHelpSystem			= new HTMLa();
		$selectTable			= new HTMLSelect();
		$selectFilterConnection	= new HTMLSelect();
		$selectFilterCategory	= new HTMLSelect();
		$formTableSelect 		= new HTMLForm();
		/*
		$divDynamicMenuFeedback 		= new HTMLDiv();
		$divDynamicMenuFeedbackContent 	= new HTMLDiv();
		$imgDynamicMenuClose			= new HTMLImage();
		*/
		$optionDataForTables 			= array();
		$optionDataForFilterConnection 	= array();
		$optionDataForFilterCategory 	= array();
		
		$username						= $_SESSION[SESS_USERNAME];
		$metaConnector					= ET_MetaDataConnector::getInstance();
		$niotaUser 						= null;
		$catalogInstance				= null;
		
		$filterConnection 				= FILTER_ALL;
		$filterCategory 				= FILTER_ALL;
		$selectedCatalogInstanceId		= "";
		$displayGrid 					= true;
		$popupFilter 					= false;
		$useAdvancedFiltering 			= false;
		
		$idsForJSSidebar				= array("sidebar_id", "sidebar_header_id");
		$IdForJSTableSelector			= array("select_wrap");
		
		try{
			handlePostsDefaultCatalogInstance($metaConnector, $username);
		}
		catch (ET_NiotaException $e) {}
		
		//initialize JS for feedback msg styling
		ET_DisplayHelper::generateNotifyStylingJS();
		
		// USER SETTINGS:
		$niotaUser 				= getAndResetNiotaUser();		
		$filterConnection 		= getConnectionFromSession();
		
		$filterCategory 		= getCategoryFromSession();
		
		$userSettings 			= $niotaUser->get_userSettings();
		$visibleTables 			= $niotaUser->get_visibleCatalogInstances($filterConnection, $filterCategory);
		$visibleConnections 	= $niotaUser->getFilterFromVisibleConnsOrCats(FILTER_CONNECTION);
		$visibleCategories	 	= $niotaUser->getFilterFromVisibleConnsOrCats(FILTER_CATEGORY);
		
		$adminMenuItem			= $niotaUser->getSelectedAdminMenuItem();
		
		// ----- CATALOG INSTACE SETTING:
		$previousCatalogInstanceId = '';
		
		$popupFilter = handlePostPopupFilter();
		try{
			$previousCatalogInstanceId = handlePostSelectedInstance();
		} 
		catch (ET_NiotaException $e) {}
		
		$useAdvancedFiltering 	= handleSessionAdvancedFilterng($previousCatalogInstanceId, $popupFilter);
		
		setUserDefaultCatalogInstaceIntoSession($userSettings);
		
		$resArr = array();
		try{
			$resArr = createInstace($niotaUser, $popupFilter, $useAdvancedFiltering, $metaConnector);
		} catch (ET_NiotaException $e){
			$displayGrid = $e->isGridDisplayable();
		} 	
		
		$selectedCatalogInstanceId 	= isset($resArr["selectedCatalogInstaceId"]) ? $resArr["selectedCatalogInstaceId"] : null;
		$catalogInstance 			= isset($resArr["catalogInstance"]) ? $resArr["catalogInstance"] : null;
		$error = null;
		
		if ($catalogInstance !== null)
			$error = $catalogInstance->getError();
				
		
		$wasErrorOnCatalog = !is_null($error);
		
		if (!$wasErrorOnCatalog) {
			handlePostExcelImport($catalogInstance, $displayGrid);
		}
		
		
		//----------------   HTML ATTRIBUTES SETTING STARTS HERE --------------------------
		$bodyTag->set_onload("callDrag(false);");
		if (defined('COMPANY_LOGO'))
			$imgLogo->set_src(ET_DisplayHelper::getLogoPath($phpFileName))->set_style("display: inline-block;")->set_height("60")->set_class("margin-left-20px margin-top-tiny margin-right-10px");
		else
			ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_COMPANY_LOGO_CONSTANT", null, PAGE_TYPE_GRID), "niota");	
			
		$imgLogout->set_src("images/logout.png")->set_title(ET_DisplayHelper::localize("LOGOUT", null, PAGE_TYPE_GRID))->set_class("margin-left-10px");
		$imgPersonal->set_src('images/user.png')->set_title(ET_DisplayHelper::localize('PERSONAL_PAGE', null, PAGE_TYPE_GRID))->set_class("margin-left-10px")->set_onclick("display_menu_features(\"modal_main\", \"\")");
		$imgAdminPage->set_src('images/admin_area.png')->set_onclick("saveCurrentSurface(true)");	
		$imgCloseSidebar->set_src("images/close.png")->set_class("float-right pointer")->set_style("margin: 0")->set_title(ET_DisplayHelper::localize("CLOSE", null, PAGE_TYPE_GRID))->set_id("close_sidebar")->set_onclick("openCloseMenuSection(\"sidebar\", \"" . USER_PARAM_CLOSED . "\", " . json_encode($idsForJSSidebar) . ", \"up\")");
		$imgArrowDown->set_src('images/expand_sidemenu.png')->set_title(ET_DisplayHelper::localize("OPEN_TABLE_MENU", null, PAGE_TYPE_GRID));
		$imgHelpCustom->set_src("images/help_custom.png")->set_title(ET_DisplayHelper::localize("HELP_CUSTOM", null, PAGE_TYPE_GRID))->set_class("margin-left-10px");
		$imgHelpSystem->set_src("images/help_system.png")->set_title(ET_DisplayHelper::localize("HELP_SYSTEM", null, PAGE_TYPE_GRID))->set_class("margin-left-10px");
		
		$spanName->set_class("float-right margin-left-10px font-xl")->set_display_text($niotaUser->get_fullName());		
		//$spanClaim->set_class("margin-left-5px");
		$spanProdName->set_class("font-xl");
		
		$aLogout->set_href("logout.php");
		$aPersonal->set_href("#");
		//TODO: unset link if path is not correct!
		$linkCustom = ET_DisplayHelper::setHelpLink(HELP_ICON_TYPE_USER_CUSTOM, $phpFileName);
		$linkSystem = ET_DisplayHelper::setHelpLink(HELP_ICON_TYPE_USER_SYSTEM, $phpFileName);
		
		if ($linkCustom !== false)
			$aHelpCustom->set_href($linkCustom)->set_target("_blank")->set_rel("noopener noreferrer");
		if ($linkSystem!== false)
			$aHelpSystem->set_href($linkSystem)->set_target("_blank")->set_rel("noopener noreferrer");
		
			$aNiotaPage->set_href("admin/$adminMenuItem")->set_title(ET_DisplayHelper::localize("ADMINISTRATION", null, PAGE_TYPE_GRID));
			$aOpenMenu->set_href("#")->set_id("sidebar_open")->set_display_text(ET_DisplayHelper::localize("OPEN_TABLE_MENU", null, PAGE_TYPE_GRID) . "&nbsp;");
		$divMain->set_class("niota-bg-image");		
		$divContent->set_class("width-100perc height-100perc")->set_id("main_content");
		$divUpperLine->set_class("bgcolor-deep height-7vh");
		$divLowerLine->set_class("bgcolor-mid height-7vh vertical-middle-content")->set_style("z-index: 1100");		
		$divLogoAndTitleOuter->set_class("vertical-middle-content-inline height-100perc");
		$divSelectWrap->set_class("margin-left-20px height-7vh vertical-middle-content")->set_id("select_wrap")->set_style(SHOW_TABLE_SELECTOR_BY_DEFAULT ? "" : "display: none");
		
		$divDynamicContainer->set_class("height-7vh vertical-middle-content margin-left-20px");
		
		$divNaviIconWrap->set_class("vertical-middle-content-inline float-right width-fit-content height-100perc margin-right-20px");
		$divSelectTable->set_class("width-fit-content element-inline-block");
		$divSelectConn->set_class("margin-left-10px width-fit-content element-inline-block");
		$divSelectCategory->set_class("margin-left-10px width-fit-content element-inline-block");
		$divReplayCallable->set_id("replay_container");		
		
		$divSidebarHeader->set_class("sidebar-header vertical-middle-content")->set_id("sidebar_header_id")->set_onclick("openCloseMenuSection(\"sidebar\", \"" . USER_PARAM_OPENED . "\", " . json_encode($idsForJSSidebar) . ", \"up\")");
		$divSidebar->set_class("sidebar")->set_id("sidebar_id");
		$divGridContainer->set_class("grid_container")->set_id("grid_container_id");
		
		$formTableSelect->set_name("form_table_select")->set_method("POST")->set_action("niota.php")->set_id("table_sel_wrapper");
		
		$selectTable->set_style('width: ' . WIDTH_TABLE_SELECTOR)->set_onchange("javascript:this.form.submit();")->set_id("instance_select")->set_name('selected_instance')->set_class("fancy_select");
		$selectFilterConnection->set_style('width: ' . WIDTH_FILTER_CONNECTION)->set_class("margin-left-20px fancy_select")->set_onchange("filterConnectionsAndCategory(true," . json_encode($popupFilter) . ");")->set_id("conn_filter");
		$selectFilterCategory->set_style('width: ' .  WIDTH_FILTER_CATEGORY)->set_class("margin-left-20px fancy_select")->set_onchange("filterConnectionsAndCategory(false, " . json_encode($popupFilter) . ");")->set_id("category_filter");		
		
		/*section to set sidebar state (opened / closed)*/
		$sidebarState = isset($niotaUser->get_userSettings()[USER_PARAM_SIDEBAR_STATE]) ? $niotaUser->get_userSettings()[USER_PARAM_SIDEBAR_STATE] : USER_PARAM_OPENED;
		
		if ($sidebarState == USER_PARAM_CLOSED) {
			$divSidebarHeader->set_style("display: block");
			$divSidebar->set_style("display: none");
		}
		else {
			$divSidebar->set_style("display: block");
			$divSidebarHeader->set_style("display: none");
		}
		/*set sidebar status ends*/
		
		/*set table selector state*/		
		$tableSelectorState = isset($niotaUser->get_userSettings()[USER_PARAM_TABLE_SELECTOR_STATE]) ? $niotaUser->get_userSettings()[USER_PARAM_TABLE_SELECTOR_STATE] : USER_PARAM_OPENED;
		
		$imgOpenCloseTableSelector->set_src("images/double_arrow.png")->set_id("div_menu_open_close")->set_title(ET_DisplayHelper::localize("OPEN_CLOSE_NAVBAR", null, PAGE_TYPE_GRID))
									->set_class("pointer")->set_onclick("makeToggle(\"select_wrap\", " . json_encode(true) .")");
		
		
		if ($tableSelectorState == USER_PARAM_CLOSED)
			$divSelectWrap->set_style("display: none");
		
		/*set table selector state ends*/			
			
		if ($_SESSION['first_login'] == true)
			$_SESSION['first_login'] = false;
			
		$htmlTag->printOpeningTag();
			/*head starts*/
			$headTag->printOpeningTag();
				ET_DisplayHelper::generateAndPrintTabIconTag("grid");
				echo "<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>";
				echo "<meta name='viewport' content='width=device-width, initial-scale=1'>";
				ET_DisplayHelper::getNiotaColorTheme();
				echo "<script type='text/javascript' src='" . SERVER_ROOT . "/js/jquery-2.1.4.min.js'></script>";
				echo "<script type='text/javascript' src='" . SERVER_ROOT . "/js/jquery-ui-1.11.2.min.js'></script>";
				echo "<script src='js/ajaxFunctions.js' type='text/javascript'></script>";
				echo "<script src='js/eventHandlers.js' type='text/javascript'></script>";
				echo "<script src='" . SERVER_ROOT . "/js/notify.min.js' type='text/javascript'></script>";
				echo "<script src='" . SERVER_ROOT . "/etixpert/js/notify-styling.js' type='text/javascript'></script>";
				
				echo "<script src='" . SERVER_ROOT . "/js/select2/select2.js' type='text/javascript'></script>";
				echo "<link rel=\"StyleSheet\" href='" . SERVER_ROOT . "/js/select2/select2.css'>";
				
				if ($catalogInstance !== null && !$wasErrorOnCatalog){					
					ET_DisplayHelper::printViewModeCorrector($catalogInstance->getFullTableName());
				}
				
				echo "<script>$(document).ready(function() {
					$('#instance_select').select2();
					$('#conn_filter').select2();
					$('#category_filter').select2();
				});</script>";
				
			$headTag->printClosingTag();
			/*body starts*/
			$bodyTag->printOpeningTag();
				$divContent->printOpeningTag();
				$niotaUser->printPersonalModal(false, $phpFileName);
				
				/*	********	UPPER MENUBARS START	********	*/				
					$divUpperLine->printOpeningTag();
						$divLogoAndTitleOuter->printOpeningTag();
						
							$imgLogo->printOpeningTag();
							$divLogoAndTitleInner->printOpeningTag();
								$spanProdName->printOpeningTag();
									if (defined('PRODUCT_NAME'))
										echo PRODUCT_NAME;
									else 
										ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("PRODUCT_NAME_NOT_DEFINED", null, PAGE_TYPE_GRID), "niota.php");
								$spanProdName->printClosingTag();
								$spanClaim->printOpeningTag();
								if (defined('CLAIM'))
									echo CLAIM;
								else
									ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("CLAIM_NOT_DEFINED", null, PAGE_TYPE_GRID), "niota.php");
								$spanClaim->printClosingTag();
							$divLogoAndTitleInner->printClosingTag();
						$divLogoAndTitleOuter->printClosingTag();
						$divNaviIconWrap->printOpeningTag();									
							if ($niotaUser->get_isAdmin()) {								
								$aNiotaPage->printOpeningTag();
									$imgAdminPage->printOpeningTag();
								$aNiotaPage->printClosingTag();
							}							
							$spanName->printOpeningTag();
								$spanName->printDisplayText();
							$spanName->printClosingTag();
							$aLogout->printOpeningTag();
								$imgLogout->printOpeningTag();
							$aLogout->printClosingTag();					
							$aPersonal->printOpeningTag();
								$imgPersonal->printOpeningTag();
							$aPersonal->printClosingTag();							
							$aHelpCustom->printOpeningTag();
								$imgHelpCustom->printOpeningTag();
							$aHelpCustom->printClosingTag();
							$aHelpSystem->printOpeningTag();
								$imgHelpSystem->printOpeningTag();
							$aHelpSystem->printClosingTag();
						$divNaviIconWrap->printClosingTag();
					$divUpperLine->printClosingTag();
					$divLowerLine->printOpeningTag();
						$divSelectWrap->printOpeningTag();
							$divSelectTable->printOpeningTag();	
							
								generateTableSelect($optionDataForTables, $formTableSelect, $selectTable, $visibleTables, $selectedCatalogInstanceId, $niotaUser, $useAdvancedFiltering);								
							$divSelectTable->printClosingTag();
							$divSelectConn->printOpeningTag();
								generateFilterSelect($selectFilterConnection, $visibleConnections, $filterConnection,  ET_DisplayHelper::localize("FILTER_CONNECTION", null, PAGE_TYPE_GRID));
							$divSelectConn->printClosingTag();
							$divSelectCategory->printOpeningTag();
								generateFilterSelect($selectFilterCategory, $visibleCategories, $filterCategory, ET_DisplayHelper::localize("FILTER_CATEGORY", null, PAGE_TYPE_GRID));
							$divSelectCategory->printClosingTag();
							
						$divSelectWrap->printClosingTag();
													
						$divDynamicContainer->printOpeningTag();						
							$imgOpenCloseTableSelector->printOpeningTag();						
							$niotaUser->printDynamicMenu();
							$divReplayCallable->printOpeningTag();
								if (isset($_SESSION[SESS_REPLAY_LAST_DYNAMIC_MENU_ITEM]))
									echo $_SESSION[SESS_REPLAY_LAST_DYNAMIC_MENU_ITEM];
							$divReplayCallable->printClosingTag();
						$divDynamicContainer->printClosingTag();
					$divLowerLine->printClosingTag();
					
					/*	********	UPPER MENUBARS END	********	*/
					
					$divMain->printOpeningTag();
					
					if(!is_null($catalogInstance) && !$wasErrorOnCatalog)	{						
						$catalogInstance->displayPopupWindows($phpFileName);
					}
					
					if (isset($_SESSION['SESS_PRINT_UPLOAD_POPUP']) && $_SESSION['SESS_PRINT_UPLOAD_POPUP']) {
						ET_DisplayHelper::printFileUploadAndProcessPopup();
					}
			
						ET_DisplayHelper::printtCallableObjectFeedbackWindow();
							
						if((!$popupFilter || !$catalogInstance->isSelectionTable()) && !$wasErrorOnCatalog && !is_null($catalogInstance)) {
							
							$divSidebarHeader->printOpeningTag();
								$aOpenMenu->printOpeningTag();
								//$aOpenMenu->printDisplayText();
								$imgArrowDown->printOpeningTag();								
								$aOpenMenu->printClosingTag();
							$divSidebarHeader->printClosingTag();
							$divSidebar->printOpeningTag();								
								$imgCloseSidebar->printOpeningTag();
								
								//if(!is_null($catalogInstance) && !$wasErrorOnCatalog)
								$catalogInstance->displayMenuItems();
									//ET_DisplayHelper::setAndPrintPinIcon($imgPinSidebar);
							$divSidebar->printClosingTag();
						}
						
						$divGridContainer->printOpeningTag();						
							if(!is_null($catalogInstance) && !$wasErrorOnCatalog){
								$catalogInstance->displayGrid();
							}						
							if(isset($_SESSION[$phpFileName])) {
								ET_DisplayHelper::printMessageBox($phpFileName);
								$_SESSION[$phpFileName] = "";
							}							
						$divGridContainer->printClosingTag();						
					$divMain->printClosingTag();			
					
				$divContent->printClosingTag();	
				
			$bodyTag->printClosingTag();
		$htmlTag->printClosingTag();
	}
	else{		
		$locationLogin = ET_PathHelper::getLoginPathWithClientDef();
		header("Location: $locationLogin");
	};
		
		
	
?>