<?php
	
	function handlePostsDefaultCatalogInstance ($metaConnector, $username) {
		
		if (isset($_POST["save_default_catalog_instance"])) {
			$instanceToSave = $_POST["save_default_catalog_instance"];
			$userSetting = ET_GeneralHelperAdmin::createUserSettingArray($username, USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID, $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]); 
			if (!$metaConnector->saveUserSetting($userSetting))
				throw new ET_NiotaException('ERROR_DEFAULT_TABLE_SAVE', true, 'niota');					
			else
				ET_DisplayHelper::addSuccessLine(ET_DisplayHelper::localize("DEFAULT_TABLE_SAVED", null, PAGE_TYPE_GRID), "niota");
		
		}
		if (isset($_POST["reset_default_catalog_instance"])) {
			$instanceToReset = $_POST["reset_default_catalog_instance"];
			$userParamId = $metaConnector->findDefaultCatalogInstanceParameterId($username);
			if (!$metaConnector->deleteUserSetting($userParamId))
				throw new ET_NiotaException("ERROR_DEFAULT_TABLE_RESET", true, "niota");				
			else
				ET_DisplayHelper::addSuccessLine(ET_DisplayHelper::localize("DEFAULT_TABLE_RESET", null, PAGE_TYPE_GRID), "niota");
		}
	}
	
	function getAndResetNiotaUser () {
		$niotaUser = ET_NiotaUser::getNiotaUserFromSession();
		$niotaUser->reset();
		$niotaUser->flushNiotaUser();
		$niotaUser = ET_NiotaUser::getNiotaUserFromSession();
		return $niotaUser;
	}
	
	function getConnectionFromSession() {
		if (isset($_SESSION[FILTER_CONNECTION]))
			return $_SESSION[FILTER_CONNECTION];
		else 
			return FILTER_ALL;
	}
	
	function getCategoryFromSession() {		
		if (isset($_SESSION[FILTER_CATEGORY]))
			return $_SESSION[FILTER_CATEGORY];
		else
			return FILTER_ALL;
	}
	
	function handlePostSelectedInstance() {
		$previousCatalogInstanceId = isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]) ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] : '';
		
		if(isset($_POST['selected_instance'])){
			$instanceStr = $_POST['selected_instance'];
			if ($instanceStr === 'all') {
				unset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]);
				return $previousCatalogInstanceId;
			}
				
			$_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] = $instanceStr;
		}
		return $previousCatalogInstanceId;
	}
	
	function handlePostPopupFilter () {
		
		if(isset($_POST['popup_filter'])){			
		/*
		 * we can switch on/off the advanced filter in the transaction definition
		 * if it is turned on,  $_POST['filter_instance'] is the instance to display => $_POST['selected_instance'] is overwritten
		 * because of that the left-grid-menu advanced filter button also sends the $_POST['filter_instance'] key 
		 * 
		 */
			$popupFilter 		= $_POST['popup_filter'];
			$filterInstance 	= isset($_POST['filter_instance']) ? $_POST['filter_instance'] : "";
			$selectedInstance	= isset($_POST['selected_instance']) ? $_POST['selected_instance'] : "";
			
			if ($popupFilter && !empty($filterInstance)) {
				$_POST['selected_instance'] = $filterInstance;
			} else if ($popupFilter && empty($filterInstance)) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_ADVANCED_FILTER_TRANSACTION_CONFIG", null, PAGE_TYPE_GRID), "niota");
			} else if ($popupFilter == false && empty($selectedInstance)) {
				ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("ERROR_ADVANCED_FILTER_TRANSACTION_MISSING_INSTANCE", null, PAGE_TYPE_GRID), "niota");
			}//else{ $popupfilter == false -> load the target table}
			return true;
		}
		return false;
	}
	
	function handleSessionAdvancedFilterng($previousCatalogInstanceId, $popupFilter) {
		$currentCatalogInstanceId = isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]) ? $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] : '';
		$differentCatalogInstanceId = $previousCatalogInstanceId !== $currentCatalogInstanceId && (!empty($currentCatalogInstanceId)); 
		
		$browsingStore = ET_BrowsingStore::getBrowsingStore();
		
		if (isset($_SESSION[SESS_ADVANCED_FILTER_FILTERED_INSTANCE_ID])) {			
			$targetTableCatalogInstanceId = $_SESSION[SESS_ADVANCED_FILTER_FILTERED_INSTANCE_ID];
			$browsingState = $browsingStore->get_browsingState($targetTableCatalogInstanceId);
			if (!is_null($browsingState)) {
				
				if (!empty($browsingStore->get_filterKeyPair($targetTableCatalogInstanceId))) {
		
					if (isset($_SESSION[SESS_ADVANCED_FILTER_FILTERED_CATALOG_FIRST_LOAD])) {
						$_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] = $_SESSION[SESS_ADVANCED_FILTER_FILTERED_INSTANCE_ID];
						$_SESSION[SESS_ADVANCED_FILTER_FILTERED_CATALOG_FIRST_LOAD] = null;
						return true;
					} else {
						if (!$differentCatalogInstanceId && !$popupFilter) return true;
					}
				}				
			}					
		}
		$browsingStore->clear_allFilterKeyPair();
		$browsingStore->flushBrowsingStore();
		return false;		
	}
	
	function setUserDefaultCatalogInstaceIntoSession($userSettings) {
		if (!isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]) && isset($userSettings[USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID])){
			
			$_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER] = $userSettings[USER_PARAM_DEFAULT_CATALOG_INSTANCE_ID];
			
		}
			
	}
	
	function createInstace($niotaUser, $popupFilter, $useAdvancedFiltering, $metaConnector){
		
		$ret 						= array();
		$selectedCatalogInstanceId	= "";
		$catalogInstance 			= null;
		$gridCustomDimensions		= null;
		$displayGrid				= true;
		
		if (isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER])) {
			$selectedCatalogInstanceId = $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
			
			if (!$niotaUser->isCatalogInstanceVisible($selectedCatalogInstanceId) && !$popupFilter) {
				
				throw new ET_NiotaException("GRID_NOT_VISIBLE", true, "niota", array($selectedCatalogInstanceId));
				//ET_DisplayHelper::addErrorLine(ET_DisplayHelper::localize("GRID_NOT_VISIBLE", array($selectedCatalogInstanceId)), "niota");
			} else {				
				$instanceArr = explode(".", $selectedCatalogInstanceId);
				
				$browsingStore = ET_BrowsingStore::getBrowsingStore();
				$browsingStore->create_browsingState($selectedCatalogInstanceId);		
				
				//this ugly solution is needed. We cannot fill conn. name in ET_CatalogInstance class, because lookup instance crashes at the constructor.
				$connName = ET_MetaDataConnector::getInstance()->getCatalogInstanceInfo($instanceArr[0],  $instanceArr[1])["conn_name"];
				$browsingStore->set_connName($selectedCatalogInstanceId, $connName);
				//ugly ends
				
				$browsingStore->flushBrowsingStore();
				
				try {
					$catalogInstance = new ET_CatalogInstance($instanceArr[0], $instanceArr[1], "", $popupFilter, $useAdvancedFiltering);
				} catch (Exception $e) {
					ET_DisplayHelper::addErrorLine($e->getMessage(), 'niota');
					return;
				}
				
				
				$lookups 		= $catalogInstance->getLookups();
				$constraitns 	= $catalogInstance->getConstraints();
				
				//if we do not get brwosingStore from $_SESSION again, it will be ereased
				$browsingStore = ET_BrowsingStore::getBrowsingStore();
				$browsingStore->set_lookupSettings($selectedCatalogInstanceId, $lookups);
				$browsingStore->set_constraintSettings($selectedCatalogInstanceId, $constraitns);
				$browsingStore->flushBrowsingStore();
				
				ET_LoggingHelper::setLogInfo($metaConnector->getLoggingSettings());
			}
			
			$ret["selectedCatalogInstaceId"] = $selectedCatalogInstanceId;
		}

		$ret["catalogInstance"] = $catalogInstance;		
		
		return $ret;
		
	}	
	
	function handlePostExcelImport ($catalogInstance, $displayGrid) {
		
		if (isset($_POST['import_xlsx'])) {
			if ($displayGrid) {
				$connName 		= $catalogInstance->getConnName();
				$fullTableName 	= $catalogInstance->getFullTableName();
				$lookups 		= $catalogInstance->getLookups();
				$constraints 	= $catalogInstance->getConstraints();
				$columnInfo 	= $catalogInstance->getColumnInfo();
				
				if (isset($_POST['import_type'])) {				
					$importType = $_POST['import_type'];					
					$excelHelper = new ET_ExcelHelper($importType, $fullTableName);					
					$excelHelper->handleExcelImport($connName, true, $fullTableName, $lookups, $constraints, $columnInfo);					
				} else {
					//error
				}				
			}
		}
	}
	
	function generateFilterSelect ($selectElement, $dataArray, $selectCompareValue, $firstLinetext) {
		
		$optionDataForFilter = array();	
		
		foreach ($dataArray as $key=>$value) {
			$selected = '';
			if ($dataArray[$key][0] == $selectCompareValue) {
				$selected = 'selected';
			}
		
			$optionDataForFilter[] = ["name"=>$dataArray[$key][0],
					"value"=>$dataArray[$key][0],
					"displayText"=>$dataArray[$key][1], "selected"=>$selected];
		}
		/*if (isset($_POST['popup_filter']))
			$selectElement->set_disabled();*/
		
		$selectElement->generateWholeSelect($optionDataForFilter, $firstLinetext);
		
	}
	
	function generateTableSelect ($optionDataForTables, $formTableSelect, $selectTable, $visibleTables, $selectedCatalogInstanceId, $niotaUser, $useAdvancedFilter = false) {
		
		$catalogPattern = ET_DisplayHelper::getCatalogPattern($niotaUser);
		$wasSelected = false;
		
		for($i = 0; $i < count($visibleTables); $i++) {
			$selectedString = '';
			$catalogInstanceId = $visibleTables[$i]['catalog_id'] . "." . $visibleTables[$i]['instance_name'];
			
			if ($catalogInstanceId == $selectedCatalogInstanceId) {
				if (!isset($_POST['popup_filter'])) {
					$selectedString = 'selected';
					$wasSelected = true;
				}
			}
				
			$displayText = ET_DisplayHelper::getCatalogItemDisplayText($visibleTables[$i], $catalogPattern);
	
			$optionDataForTables[] = ["name"=>$catalogInstanceId, "value"=>$catalogInstanceId,
					"displayText"=>$displayText,
					"selected"=>$selectedString
			];
		}
		
		$formTableSelect->printOpeningTag();
			//$firstLine = !isset($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]) ? "-- select niota object --" : "";
		$firstLine = (!$wasSelected) ? ET_DisplayHelper::localize("FILTER_TABLE", null, PAGE_TYPE_GRID) : "";
			
			if (isset($_POST['popup_filter']))
				$firstLine = "** " . ET_DisplayHelper::localize("POPUP_FILTER", null, PAGE_TYPE_GRID) . " **";
			else if ($useAdvancedFilter && $niotaUser->isCatalogInstanceHidden($selectedCatalogInstanceId)) {
				$firstLine = "** " . ET_DisplayHelper::localize("FILTER_RESULT", null, PAGE_TYPE_GRID) . " **";				
			}
			
			
			$selectTable->generateWholeSelect($optionDataForTables, $firstLine);
		$formTableSelect->printClosingTag();
		
	}
	
	function shouldThrowAwayWarning ($warningMsg) {
		
		for ($i = 0; $i < count(WARNINGS_TO_THROW_AWAY); $i++) {
			
			$actualJunkWarning = WARNINGS_TO_THROW_AWAY[$i];
			if (strpos($warningMsg, $actualJunkWarning) !== false) {
				return true;
			}
		}
		return false;
	}
	
	
	
	
	
	
	
	
	