<?php
	if(!isset($_SESSION))	
		session_start();
		
	require_once '../conf/conf.php';
		
	if(isset($_SESSION[SESS_USERNAME])){
		
		$userName 			= $_SESSION[SESS_USERNAME];
		$catalogInstanceId 	= isset($_POST['catalogInstanceId']) ? $_POST['catalogInstanceId'] : "";
		$metaConnector	 	= ET_MetaDataConnector::getInstance();
		
		if (isset($_POST["password_update"])) {
				
			$password 			= $_POST["password"];
			$passwordNew 		= $_POST["password_new"];
			$passwordNewRe 		= $_POST["password_new_re"];
			$passwordComparsion = comparePassword($passwordNew, $passwordNewRe);
			$pageName			= $_POST['page_name'];			
			$pageType 			= ET_DisplayHelper::detectPageType($pageName);
			$ret 				= false;
			
			if($passwordComparsion == 1) {
								 
				$tempArr 		= $metaConnector->getBasicAuthenticationData($userName);
				$passwordFromDb = $tempArr["password"];
				
				if (password_verify($password, $passwordFromDb)) {
					$passwordHashed = password_hash($passwordNew, PASSWORD_BCRYPT);
					
					if (APPLY_PW_POLICY === true) {
						
						$pwChecker 		= new ET_PwCheck($passwordNew);
						
						if($pwChecker->checkPW()) {
							$ret = $metaConnector->updateUserPassword($userName, $passwordHashed);
						} else {
							echo "<p style='color : red'>" . ET_DisplayHelper::localize("PW_POLICY_ERROR", array(PW_POLICY_MIN_LENGTH, PW_POLICY_LOWER_MATCH_COUNT,
									PW_POLICY_UPPER_MATCH_COUNT, PW_POLICY_DIGIT_MATCH_COUNT, PW_POLICY_SPECIAL_MATCH_COUNT), PAGE_TYPE_GRID) . "<p>";
									return;
						}
					} else {
						$ret = $metaConnector->updateUserPassword($userName, $passwordHashed);
					}
					
					
					//$ret = $metaConnector->updateUserPassword($userName, $passwordHashed);
					
					if($ret) {
						ET_DisplayHelper::addSuccessLine(ET_DisplayHelper::localize("PASSWORD_SAVED", null, $pageType), $pageName);
						echo PERSONAL_PAGE_RELOAD;
					}
					else{
						echo "<p style='color : red'>" . ET_DisplayHelper::localize("ERROR_PW_SAVING", null, $pageType) . "<p>";
						return;
					}					
				}
				else 
					echo "<p style='color : red'>" . ET_DisplayHelper::localize("INVALID_USER_CREDENTIALS", null, $pageType) . "<p>";				
			}
			elseif ($passwordComparsion == 2){
				echo "<p style='color : red'>" . ET_DisplayHelper::localize("ERROR_PW_MATCH", null, $pageType) . "<p>";
				return;
			}
			elseif ($passwordComparsion == 3){
				echo "<p style='color : red'>" . ET_DisplayHelper::localize("ERROR_PW_EMPTY", null, $pageType) . "<p>";
				return;
			}
		}
		elseif (isset($_POST['data_update'])) {
			
			$dataToUpdate 	= array();
			$updateValues 	= "";
			$pageName		= $_POST['page_name'];
			$pageType 		= ET_DisplayHelper::detectPageType($pageName);
			
			foreach ($_POST as $key => $val) {				
				if(isNotNullOrNotEmmpty($val) && $key != "data_update" && $key != "page_name"){
					$updateValues .= " " . $key . " = '" . $val . "',";
				}							
			}			
			$placeOfLastComma 	= strrpos($updateValues, ",");			
			$updateValues 		= substr($updateValues, 0, $placeOfLastComma);	
			$updateValues		= ET_StringCheck::convertToDbCharset($updateValues, ET_METADATA_CONNECTION);
			$ret 				= $metaConnector->updatePersonalData($userName, $updateValues);
			
			if ($ret) {
				ET_DisplayHelper::addSuccessLine(ET_DisplayHelper::localize("PERSONAL_DATA_UPDATED", null, $pageType), $pageName);
				echo PERSONAL_PAGE_RELOAD;
			}
			else {
				echo "<p style='color : red'>" . ET_DisplayHelper::localize("ERROR_PERSONAL_DATA_SAVING", null, $pageType) . "<p>";
				return;
			}
		}
		elseif (isset($_POST['save_grid_dimensions'])) {
			$width 			= $_POST['width'];
			$height 		= $_POST['height'];			
			$logicalLink 	= $_POST['logicalLink'];
			$optionKey 		= empty($_POST['optionKey']) || is_null(['optionKey']) ? "" :  $_POST['optionKey'];
			$logicalLinkPart = (!empty($logicalLink) ? "_" . $logicalLink : "");
			
			//$paramFilter1 	= !empty($logicalLink) ? $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $logicalLink : (!empty($optionKey) ? $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $optionKey : $catalogInstanceId);
			$paramFilter1 = ET_BrowsingStore::getBrowsingStore()->generateGridIdentifier($catalogInstanceId, $logicalLink, $optionKey);
			
			
			$paramName 		= USER_PARAM_GRID_DIMENSONS;
			$paramValue 	= "w=$width" . ";" . "h=$height";
			
			$userSetting 	= createUserSettingArray($userName, $paramName, $paramValue, $paramFilter1);			
			$ret			= $metaConnector->saveUserSetting($userSetting);
			
		}
		else if (isset($_POST['save_col_width'])) {
			
			$width 			= $_POST['width'];
			$colName		= $_POST['colName'];
			$logicalLink 	= isset($_POST['logicalLink']) ? $_POST['logicalLink'] : "";
			$adminDatagrid 	= isset($_POST['admin_datagrid']) ? $_POST['admin_datagrid'] : false;
			$optionKey		= isset($_POST['option_key']) ? $_POST['option_key'] : "";
			$paramFilter1	= "";
						
			//$paramFilter1 	= !empty($logicalLink) ? $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $logicalLink : (!empty($optionKey) ? $catalogInstanceId . FORMATTING_LINK_SEPARATOR . $optionKey : $catalogInstanceId);
			$paramFilter1 = ET_BrowsingStore::getBrowsingStore()->generateGridIdentifier($catalogInstanceId, $logicalLink, $optionKey);
			
			$paramFilter2 	= $colName;				
			$paramName 		= USER_PARAM_COL_WIDTH;			
			$userSetting 	= createUserSettingArray($userName, $paramName, $width, $paramFilter1, $paramFilter2);
			$ret = $metaConnector->saveUserSetting($userSetting);
			
		}
		else if (isset($_GET['menu_section_open_close'])) {			
			
			$status 		= $_GET['state'];			
			$menuSection 	= $_GET['menu_section'];
			$paramName 		= $menuSection == 'sidebar' ? USER_PARAM_SIDEBAR_STATE : USER_PARAM_TABLE_SELECTOR_STATE;
			
			$userSetting = createUserSettingArray($userName, $paramName, $status);
			$ret 		= $metaConnector->saveUserSetting($userSetting);			
		}
		else if (isset($_GET['save_window_position'])) {
			
			$popupName 	= $_GET['element_id'];
			$poupX 		= $_GET['window_x'];
			$poupY 		= $_GET['window_y'];
			$paramName	= "";
			
			if ($popupName == 'callables') {
				$paramName =  USER_PARAM_POPUP_POSITION_CALLABLES;
			}
			else if ($popupName == 'upload') {					
				$paramName = USER_PARAM_POPUP_POSITION_UPLOAD;
			} else if ($popupName == 'uploadandruncallable') {
				$paramName = USER_PARAM_POPUP_POSITION_UPLOADANDPROCESS;
			}
			
			$paramValue 	= "x=$poupX" . ";" . "y=$poupY";		
			$userSetting 	= createUserSettingArray($userName, $paramName, $paramValue);
			$ret 			= $metaConnector->saveUserSetting($userSetting);			
		}
		else if (isset($_GET[USER_PARAM_ADMIN_MENU_STATE])) {
			
			$paramName 	= USER_PARAM_ADMIN_MENU_STATE;
			$paramValue = $_GET['admin_url']; 
			
			$_SESSION[USER_PARAM_ADMIN_MENU_STATE] = $paramValue;
			
			$paramValue = substr($paramValue, strrpos($paramValue, "/"));
			
			$userSetting 	= createUserSettingArray($userName, $paramName, $paramValue);
			$ret 			= $metaConnector->saveUserSetting($userSetting);
		}
		else if (isset($_GET['logoutFromAdminPage'])) {
			
			$paramName 	= USER_PARAM_LOAD_ADMIN_PAGE_AFTER_LOGIN;
			$paramValue = $_GET['logoutFromAdminPage'];
			
			$userSetting 	= createUserSettingArray($userName, $paramName, $paramValue);
			$ret 			= $metaConnector->saveUserSetting($userSetting);
		}
		else if (isset($_GET[USER_PARAM_SWAP])) {
			
		} else if (isset($_POST['registration']) || isset($_POST['resend_verify_email'])) {
			$feedbackData['error'] = true;
			$feedbackData['message'] = ET_DisplayHelper::localize("REGISTRATION_LOG_OUT_MSG", array(), PAGE_TYPE_GRID, true);
			echo json_encode($feedbackData);
			return;
		}
	} else {
		
		if (isset($_POST['registration']) && $_POST['registration'] === "yes") {
			
			$regData 						= [];
			$feedbackData 					= [];
			$feedbackData["error"] 			= false;
			$feedbackData["message"] 		= "";
			$pwCheckPolicy					= false;
			$emailCheckBasic				= false;
			
			$username = ET_RegistrationHelper::generateUsername();
			
			if ($username === false) {
				
				$feedbackData["error"] = true;
				$feedbackData["message"] .= ET_DisplayHelper::localize("REGISTRAION_ERROR_GENERATE_USERNAME", array(), PAGE_TYPE_GRID, true) . "<br>";
			} else {
				$regData["username"] = $username;
				
				foreach ($_POST as $key => $val) {
					if(isNotNullOrNotEmmpty($val) && $key != "registration"){
						$regData[$key] = $val;
					}
				}
				
				$emailCheckBasic = ET_StringCheck::basicEmailCheck($regData["email"]);
				
				if (defined('APPLY_PW_POLICY')) {
					if (APPLY_PW_POLICY === true) {
						try {
							$pwCheckPolicy	= ET_RegistrationHelper::checkPwPolicy($regData["pw"]);
						} catch (Exception $ex) {
							
							$feedbackData["error"] 		= true;
							$feedbackData["message"] 	.= ET_DisplayHelper::localize($ex->getMessage(), array(), PAGE_TYPE_GRID, true) . "<br>";
							echo json_encode($feedbackData);
							return;
						}
					} else {
						$pwCheckPolicy = true;
					}
				} else {
					$feedbackData["error"] 		= true;
					$feedbackData["message"] 	.= ET_DisplayHelper::localize('PW_CONFIGURATION_ERROR', array(), PAGE_TYPE_GRID, true) . "<br>";
					$pwCheckPolicy = false;
					echo json_encode($feedbackData);
					return;
				}
				
				if ($emailCheckBasic === true && $pwCheckPolicy === true) {
					try {
						
						$message = ET_RegistrationHelper::makeRegistration($regData);
						if ($message == ET_RegistrationHelper::ERROR_WS_EMAIL || $message == ET_RegistrationHelper::ERROR_WS_REGISTRATION) {
							$feedbackData["error"] 		= true;
							
							$feedbackData["message"] 	= ET_DisplayHelper::localize($message);
						} else {
							
							$feedbackData["error"] 		= false;
							$feedbackData["message"] 	= ET_DisplayHelper::localize("REGISTRATION_SUCCESS", [VALIDATION_LINK_LIFETIME], PAGE_TYPE_GRID, true);
						}
					} catch (Exception $e) {
						$feedbackData["error"] 		= true;
						$feedbackData["message"] 	.= ET_DisplayHelper::localize($e->getMessage()) . "<br>";
					}
				} else {
					$feedbackData["error"] 		= true;
					if ($emailCheckBasic !== true) {
						$feedbackData["message"] 	.= "<br>" . ET_DisplayHelper::localize($emailCheckBasic, array(), PAGE_TYPE_GRID, true);
					}
					if (!$pwCheckPolicy) {
						$feedbackData["message"] 	.= "<br>" . ET_DisplayHelper::localize("PW_POLICY_ERROR", array(PW_POLICY_MIN_LENGTH, PW_POLICY_LOWER_MATCH_COUNT,
								PW_POLICY_UPPER_MATCH_COUNT, PW_POLICY_DIGIT_MATCH_COUNT, PW_POLICY_SPECIAL_MATCH_COUNT), PAGE_TYPE_GRID, true);
					}
				}
			}
			
			echo json_encode($feedbackData);
		} else if (isset($_POST["resend_verify_email"])) {
			
			if ($_POST["resend_verify_email"] == "yes") {
				
				$feedbackData 				= [];
				$feedbackData["error"] 		= false;
				$feedbackData["message"]	= "";
				$email 						= $_POST['email'];
				$pw							= $_POST['pw'];
				$company					= $_POST['company'];
				$emailCheckBasic 			= ET_StringCheck::basicEmailCheck($email, true);
				$linkResendResult			= null;
				
				if ($emailCheckBasic === true) {
					
					$emailExists = ET_MetaDataConnector::getInstance()->doesEmailExist($email);
					
					if ($emailExists) {
						try {
							$linkResendResult = ET_RegistrationHelper::resendVerificationEmail($email, $pw, $company);
							$feedbackData["error"] = $linkResendResult["error"];
							$feedbackData["message"] = $linkResendResult["message"];
						} catch (Exception $e) {
							$feedbackData["error"] = true;
							$feedbackData["message"] = $e->getMessage();
						}
					} else {
						$feedbackData["error"] = true;
						$feedbackData["message"] = ET_DisplayHelper::localize("EMAIL_NOT_REGISTERED", [$email], PAGE_TYPE_GRID, true);
					}
					
				} else {
					$feedbackData["error"] = true;
					$feedbackData["message"] = ET_DisplayHelper::localize(ET_StringCheck::EMAILERRORFORMAT, array(), PAGE_TYPE_GRID, true);
				}
				
				echo json_encode($feedbackData);
				
			}
		} else {
			header("Location: ../login.php");
		}
		
	}
	
	function createUserSettingArray($userName, $paramName, $paramValue, $paramFilter1 = null, $paramFilter2 = null, $paramFilter3 = null, 
									$paramFilter4 = null,  $paramFilter5 = null) {
		$userSetting = array();
		
		$userSetting['userName'] 	= $userName;		
		$userSetting['paramName'] 	= $paramName;		
		$userSetting['paramValue'] 	= $paramValue;
		$userSetting['paramFilter1'] = $paramFilter1;
		$userSetting['paramFilter2'] = $paramFilter2;
		$userSetting['paramFilter3'] = $paramFilter3;
		$userSetting['paramFilter4'] = $paramFilter4;
		$userSetting['paramFilter5'] = $paramFilter5;
		
		return $userSetting;
	}	
		
	function comparePassword ($password_new, $password_new_re) {
		$ret = false;
	
		if ($password_new != "" && $password_new_re != ""){
			if ($password_new == $password_new_re)
				$ret = 1;
			else
				$ret = 2;
		}
		else
			$ret = 3;
	
		return $ret;
	}
	
	function isNotNullOrNotEmmpty($string){
		if(is_null($string) || $string == "")
			return  false;
		else 
			return true;
	}
	
	
	
		